/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archiva.security;

import java.util.List;
import org.codehaus.plexus.redback.rbac.RBACManager;
import org.codehaus.plexus.redback.system.check.EnvironmentCheck;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArchivaStandardRolesCheck
implements EnvironmentCheck {
    private Logger log = LoggerFactory.getLogger(ArchivaStandardRolesCheck.class);
    private RBACManager rbacManager;
    private boolean checked = false;

    public void validateEnvironment(List<String> violations) {
        if (!this.checked) {
            String[] expectedRoles = new String[]{"System Administrator", "Global Repository Manager", "Global Repository Observer", "Guest", "Registered User", "User Administrator"};
            this.log.info("Checking the existance of required roles.");
            for (String roleName : expectedRoles) {
                if (this.rbacManager.roleExists(roleName)) continue;
                violations.add("Unable to validate the existances of the '" + roleName + "' role.");
            }
            String[] expectedOperations = new String[]{"archiva-manage-users", "archiva-manage-configuration", "archiva-regenerate-index", "archiva-run-indexer", "archiva-access-reports", "archiva-add-repository", "archiva-delete-repository", "archiva-read-repository", "archiva-edit-repository", "archiva-upload-repository", "archiva-read-repository", "archiva-guest"};
            this.log.info("Checking the existance of required operations.");
            for (String operation : expectedOperations) {
                if (this.rbacManager.operationExists(operation)) continue;
                violations.add("Unable to validate the existances of the '" + operation + "' operation.");
            }
            this.checked = true;
        }
    }
}

