/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archiva.security;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.archiva.configuration.ArchivaConfiguration;
import org.apache.maven.archiva.configuration.ManagedRepositoryConfiguration;
import org.apache.maven.archiva.security.AccessDeniedException;
import org.apache.maven.archiva.security.ArchivaSecurityException;
import org.apache.maven.archiva.security.PrincipalNotFoundException;
import org.apache.maven.archiva.security.UserRepositories;
import org.codehaus.plexus.redback.authentication.AuthenticationResult;
import org.codehaus.plexus.redback.authorization.AuthorizationException;
import org.codehaus.plexus.redback.role.RoleManager;
import org.codehaus.plexus.redback.role.RoleManagerException;
import org.codehaus.plexus.redback.system.DefaultSecuritySession;
import org.codehaus.plexus.redback.system.SecuritySession;
import org.codehaus.plexus.redback.system.SecuritySystem;
import org.codehaus.plexus.redback.users.User;
import org.codehaus.plexus.redback.users.UserNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultUserRepositories
implements UserRepositories {
    private SecuritySystem securitySystem;
    private RoleManager roleManager;
    private ArchivaConfiguration archivaConfiguration;
    private Logger log = LoggerFactory.getLogger(DefaultUserRepositories.class);

    @Override
    public List<String> getObservableRepositoryIds(String principal) throws PrincipalNotFoundException, AccessDeniedException, ArchivaSecurityException {
        String operation = "archiva-read-repository";
        return this.getAccessibleRepositoryIds(principal, operation);
    }

    @Override
    public List<String> getManagableRepositoryIds(String principal) throws PrincipalNotFoundException, AccessDeniedException, ArchivaSecurityException {
        String operation = "archiva-upload-repository";
        return this.getAccessibleRepositoryIds(principal, operation);
    }

    private List<String> getAccessibleRepositoryIds(String principal, String operation) throws ArchivaSecurityException, AccessDeniedException, PrincipalNotFoundException {
        SecuritySession securitySession = this.createSession(principal);
        ArrayList<String> repoIds = new ArrayList<String>();
        List repos = this.archivaConfiguration.getConfiguration().getManagedRepositories();
        for (ManagedRepositoryConfiguration repo : repos) {
            try {
                String repoId = repo.getId();
                if (!this.securitySystem.isAuthorized(securitySession, (Object)operation, (Object)repoId)) continue;
                repoIds.add(repoId);
            }
            catch (AuthorizationException e) {
                this.log.debug("Not authorizing '" + principal + "' for repository '" + repo.getId() + "': " + e.getMessage());
            }
        }
        return repoIds;
    }

    private SecuritySession createSession(String principal) throws ArchivaSecurityException, AccessDeniedException {
        User user;
        try {
            user = this.securitySystem.getUserManager().findUser(principal);
            if (user == null) {
                throw new ArchivaSecurityException("The security system had an internal error - please check your system logs");
            }
        }
        catch (UserNotFoundException e) {
            throw new PrincipalNotFoundException("Unable to find principal " + principal + "");
        }
        if (user.isLocked()) {
            throw new AccessDeniedException("User " + principal + "(" + user.getFullName() + ") is locked.");
        }
        AuthenticationResult authn = new AuthenticationResult(true, (Object)principal, null);
        return new DefaultSecuritySession(authn, user);
    }

    @Override
    public void createMissingRepositoryRoles(String repoId) throws ArchivaSecurityException {
        try {
            if (!this.roleManager.templatedRoleExists("archiva-repository-observer", repoId)) {
                this.roleManager.createTemplatedRole("archiva-repository-observer", repoId);
            }
            if (!this.roleManager.templatedRoleExists("archiva-repository-manager", repoId)) {
                this.roleManager.createTemplatedRole("archiva-repository-manager", repoId);
            }
        }
        catch (RoleManagerException e) {
            throw new ArchivaSecurityException("Unable to create roles for configured repositories: " + e.getMessage(), e);
        }
    }

    @Override
    public boolean isAuthorizedToUploadArtifacts(String principal, String repoId) throws PrincipalNotFoundException, ArchivaSecurityException {
        try {
            SecuritySession securitySession = this.createSession(principal);
            return this.securitySystem.isAuthorized(securitySession, (Object)"archiva-upload-repository", (Object)repoId);
        }
        catch (AuthorizationException e) {
            throw new ArchivaSecurityException(e.getMessage());
        }
    }

    @Override
    public boolean isAuthorizedToDeleteArtifacts(String principal, String repoId) throws AccessDeniedException, ArchivaSecurityException {
        try {
            SecuritySession securitySession = this.createSession(principal);
            return this.securitySystem.isAuthorized(securitySession, (Object)"archiva-delete-artifact", (Object)repoId);
        }
        catch (AuthorizationException e) {
            throw new ArchivaSecurityException(e.getMessage());
        }
    }
}

