/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.security;

import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.archiva.redback.rbac.RBACManager;
import org.apache.archiva.redback.rbac.RbacManagerException;
import org.apache.archiva.redback.system.check.EnvironmentCheck;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="environmentCheck#archiva-required-roles")
public class ArchivaStandardRolesCheck
implements EnvironmentCheck {
    private Logger log = LoggerFactory.getLogger(ArchivaStandardRolesCheck.class);
    @Inject
    @Named(value="rbacManager#cached")
    private RBACManager rbacManager;
    private boolean checked = false;

    public void validateEnvironment(List<String> violations) {
        if (!this.checked) {
            String[] expectedRoles = new String[]{"System Administrator", "Global Repository Manager", "Global Repository Observer", "Guest", "Registered User", "User Administrator"};
            this.log.info("Checking the existance of required roles.");
            for (String roleName : expectedRoles) {
                try {
                    if (this.rbacManager.roleExists(roleName)) continue;
                    violations.add("Unable to validate the existances of the '" + roleName + "' role.");
                }
                catch (RbacManagerException e) {
                    this.log.warn("fail to verify existence of role '{}'", (Object)roleName);
                    violations.add("Unable to validate the existances of the '" + roleName + "' role.");
                }
            }
            String[] expectedOperations = new String[]{"archiva-manage-users", "archiva-manage-configuration", "archiva-regenerate-index", "archiva-run-indexer", "archiva-access-reports", "archiva-add-repository", "archiva-delete-repository", "archiva-read-repository", "archiva-edit-repository", "archiva-upload-repository", "archiva-read-repository", "archiva-guest"};
            this.log.info("Checking the existance of required operations.");
            for (String operation : expectedOperations) {
                if (this.rbacManager.operationExists(operation)) continue;
                violations.add("Unable to validate the existances of the '" + operation + "' operation.");
            }
            this.checked = true;
        }
    }
}

