/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.security;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.apache.archiva.admin.model.RepositoryAdminException;
import org.apache.archiva.admin.model.beans.ManagedRepository;
import org.apache.archiva.admin.model.managed.ManagedRepositoryAdmin;
import org.apache.archiva.redback.authentication.AuthenticationResult;
import org.apache.archiva.redback.authorization.AuthorizationException;
import org.apache.archiva.redback.role.RoleManager;
import org.apache.archiva.redback.role.RoleManagerException;
import org.apache.archiva.redback.system.DefaultSecuritySession;
import org.apache.archiva.redback.system.SecuritySession;
import org.apache.archiva.redback.system.SecuritySystem;
import org.apache.archiva.redback.users.User;
import org.apache.archiva.redback.users.UserManagerException;
import org.apache.archiva.redback.users.UserNotFoundException;
import org.apache.archiva.security.AccessDeniedException;
import org.apache.archiva.security.ArchivaSecurityException;
import org.apache.archiva.security.PrincipalNotFoundException;
import org.apache.archiva.security.UserRepositories;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="userRepositories")
public class DefaultUserRepositories
implements UserRepositories {
    @Inject
    private SecuritySystem securitySystem;
    @Inject
    private RoleManager roleManager;
    @Inject
    private ManagedRepositoryAdmin managedRepositoryAdmin;
    private Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public List<String> getObservableRepositoryIds(String principal) throws PrincipalNotFoundException, AccessDeniedException, ArchivaSecurityException {
        String operation = "archiva-read-repository";
        return this.getAccessibleRepositoryIds(principal, operation);
    }

    @Override
    public List<String> getManagableRepositoryIds(String principal) throws PrincipalNotFoundException, AccessDeniedException, ArchivaSecurityException {
        String operation = "archiva-upload-repository";
        return this.getAccessibleRepositoryIds(principal, operation);
    }

    private List<String> getAccessibleRepositoryIds(String principal, String operation) throws ArchivaSecurityException, AccessDeniedException, PrincipalNotFoundException {
        List<ManagedRepository> managedRepositories = this.getAccessibleRepositories(principal, operation);
        ArrayList<String> repoIds = new ArrayList<String>(managedRepositories.size());
        for (ManagedRepository managedRepository : managedRepositories) {
            repoIds.add(managedRepository.getId());
        }
        return repoIds;
    }

    @Override
    public List<ManagedRepository> getAccessibleRepositories(String principal) throws ArchivaSecurityException, AccessDeniedException, PrincipalNotFoundException {
        return this.getAccessibleRepositories(principal, "archiva-read-repository");
    }

    private List<ManagedRepository> getAccessibleRepositories(String principal, String operation) throws ArchivaSecurityException, AccessDeniedException, PrincipalNotFoundException {
        SecuritySession securitySession = this.createSession(principal);
        ArrayList<ManagedRepository> managedRepositories = new ArrayList<ManagedRepository>();
        try {
            List repos = this.managedRepositoryAdmin.getManagedRepositories();
            for (ManagedRepository repo : repos) {
                try {
                    String repoId = repo.getId();
                    if (!this.securitySystem.isAuthorized(securitySession, operation, repoId)) continue;
                    managedRepositories.add(repo);
                }
                catch (AuthorizationException e) {
                    this.log.debug("Not authorizing '{}' for repository '{}': {}", new Object[]{principal, repo.getId(), e.getMessage()});
                }
            }
            return managedRepositories;
        }
        catch (RepositoryAdminException e) {
            throw new ArchivaSecurityException(e.getMessage(), e);
        }
    }

    private SecuritySession createSession(String principal) throws ArchivaSecurityException, AccessDeniedException {
        User user;
        try {
            user = this.securitySystem.getUserManager().findUser(principal);
            if (user == null) {
                throw new ArchivaSecurityException("The security system had an internal error - please check your system logs");
            }
        }
        catch (UserNotFoundException e) {
            throw new PrincipalNotFoundException("Unable to find principal " + principal + "", e);
        }
        catch (UserManagerException e) {
            throw new ArchivaSecurityException(e.getMessage(), e);
        }
        if (user.isLocked()) {
            throw new AccessDeniedException("User " + principal + "(" + user.getFullName() + ") is locked.");
        }
        AuthenticationResult authn = new AuthenticationResult(true, principal, null);
        authn.setUser(user);
        return new DefaultSecuritySession(authn, user);
    }

    @Override
    public void createMissingRepositoryRoles(String repoId) throws ArchivaSecurityException {
        try {
            if (!this.roleManager.templatedRoleExists("archiva-repository-observer", repoId)) {
                this.roleManager.createTemplatedRole("archiva-repository-observer", repoId);
            }
            if (!this.roleManager.templatedRoleExists("archiva-repository-manager", repoId)) {
                this.roleManager.createTemplatedRole("archiva-repository-manager", repoId);
            }
        }
        catch (RoleManagerException e) {
            throw new ArchivaSecurityException("Unable to create roles for configured repositories: " + e.getMessage(), e);
        }
    }

    @Override
    public boolean isAuthorizedToUploadArtifacts(String principal, String repoId) throws PrincipalNotFoundException, ArchivaSecurityException {
        try {
            SecuritySession securitySession = this.createSession(principal);
            return this.securitySystem.isAuthorized(securitySession, "archiva-upload-repository", repoId);
        }
        catch (AuthorizationException e) {
            throw new ArchivaSecurityException(e.getMessage(), e);
        }
    }

    @Override
    public boolean isAuthorizedToDeleteArtifacts(String principal, String repoId) throws ArchivaSecurityException {
        try {
            SecuritySession securitySession = this.createSession(principal);
            return this.securitySystem.isAuthorized(securitySession, "archiva-delete-artifact", repoId);
        }
        catch (AuthorizationException e) {
            throw new ArchivaSecurityException(e.getMessage(), e);
        }
    }

    public SecuritySystem getSecuritySystem() {
        return this.securitySystem;
    }

    public void setSecuritySystem(SecuritySystem securitySystem) {
        this.securitySystem = securitySystem;
    }

    public RoleManager getRoleManager() {
        return this.roleManager;
    }

    public void setRoleManager(RoleManager roleManager) {
        this.roleManager = roleManager;
    }
}

