/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.metadata.repository.cassandra;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.persistence.PersistenceException;
import me.prettyprint.cassandra.serializers.LongSerializer;
import me.prettyprint.cassandra.serializers.StringSerializer;
import me.prettyprint.cassandra.service.template.ColumnFamilyResult;
import me.prettyprint.cassandra.service.template.ColumnFamilyTemplate;
import me.prettyprint.cassandra.service.template.ColumnFamilyUpdater;
import me.prettyprint.cassandra.service.template.ThriftColumnFamilyTemplate;
import me.prettyprint.hector.api.Keyspace;
import me.prettyprint.hector.api.Serializer;
import me.prettyprint.hector.api.beans.ColumnSlice;
import me.prettyprint.hector.api.beans.OrderedRows;
import me.prettyprint.hector.api.beans.Row;
import me.prettyprint.hector.api.exceptions.HInvalidRequestException;
import me.prettyprint.hector.api.factory.HFactory;
import me.prettyprint.hector.api.mutation.MutationResult;
import me.prettyprint.hector.api.mutation.Mutator;
import me.prettyprint.hector.api.query.QueryResult;
import me.prettyprint.hector.api.query.RangeSlicesQuery;
import org.apache.archiva.configuration.ArchivaConfiguration;
import org.apache.archiva.metadata.model.ArtifactMetadata;
import org.apache.archiva.metadata.model.CiManagement;
import org.apache.archiva.metadata.model.Dependency;
import org.apache.archiva.metadata.model.FacetedMetadata;
import org.apache.archiva.metadata.model.IssueManagement;
import org.apache.archiva.metadata.model.License;
import org.apache.archiva.metadata.model.MailingList;
import org.apache.archiva.metadata.model.MetadataFacet;
import org.apache.archiva.metadata.model.MetadataFacetFactory;
import org.apache.archiva.metadata.model.Organization;
import org.apache.archiva.metadata.model.ProjectMetadata;
import org.apache.archiva.metadata.model.ProjectVersionMetadata;
import org.apache.archiva.metadata.model.ProjectVersionReference;
import org.apache.archiva.metadata.model.Scm;
import org.apache.archiva.metadata.repository.MetadataRepository;
import org.apache.archiva.metadata.repository.MetadataRepositoryException;
import org.apache.archiva.metadata.repository.MetadataResolutionException;
import org.apache.archiva.metadata.repository.cassandra.CassandraArchivaManager;
import org.apache.archiva.metadata.repository.cassandra.CassandraUtils;
import org.apache.archiva.metadata.repository.cassandra.model.ArtifactMetadataModel;
import org.apache.archiva.metadata.repository.cassandra.model.MetadataFacetModel;
import org.apache.archiva.metadata.repository.cassandra.model.Namespace;
import org.apache.archiva.metadata.repository.cassandra.model.Project;
import org.apache.archiva.metadata.repository.cassandra.model.ProjectVersionMetadataModel;
import org.apache.archiva.metadata.repository.cassandra.model.Repository;
import org.apache.commons.lang.StringUtils;
import org.modelmapper.ModelMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraMetadataRepository
implements MetadataRepository {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private ArchivaConfiguration configuration;
    private final Map<String, MetadataFacetFactory> metadataFacetFactories;
    private final CassandraArchivaManager cassandraArchivaManager;
    private final ColumnFamilyTemplate<String, String> projectVersionMetadataTemplate;
    private final ColumnFamilyTemplate<String, String> projectTemplate;
    private final ColumnFamilyTemplate<String, String> artifactMetadataTemplate;
    private final ColumnFamilyTemplate<String, String> metadataFacetTemplate;
    private final ColumnFamilyTemplate<String, String> mailingListTemplate;
    private final ColumnFamilyTemplate<String, String> licenseTemplate;
    private final ColumnFamilyTemplate<String, String> dependencyTemplate;
    private final Keyspace keyspace;
    private final StringSerializer ss = StringSerializer.get();

    public CassandraMetadataRepository(Map<String, MetadataFacetFactory> metadataFacetFactories, ArchivaConfiguration configuration, CassandraArchivaManager cassandraArchivaManager) {
        this.metadataFacetFactories = metadataFacetFactories;
        this.configuration = configuration;
        this.cassandraArchivaManager = cassandraArchivaManager;
        this.keyspace = cassandraArchivaManager.getKeyspace();
        this.projectVersionMetadataTemplate = new ThriftColumnFamilyTemplate(cassandraArchivaManager.getKeyspace(), cassandraArchivaManager.getProjectVersionMetadataFamilyName(), (Serializer)StringSerializer.get(), (Serializer)StringSerializer.get());
        this.projectTemplate = new ThriftColumnFamilyTemplate(cassandraArchivaManager.getKeyspace(), cassandraArchivaManager.getProjectFamilyName(), (Serializer)StringSerializer.get(), (Serializer)StringSerializer.get());
        this.artifactMetadataTemplate = new ThriftColumnFamilyTemplate(cassandraArchivaManager.getKeyspace(), cassandraArchivaManager.getArtifactMetadataFamilyName(), (Serializer)StringSerializer.get(), (Serializer)StringSerializer.get());
        this.metadataFacetTemplate = new ThriftColumnFamilyTemplate(cassandraArchivaManager.getKeyspace(), cassandraArchivaManager.getMetadataFacetFamilyName(), (Serializer)StringSerializer.get(), (Serializer)StringSerializer.get());
        this.mailingListTemplate = new ThriftColumnFamilyTemplate(cassandraArchivaManager.getKeyspace(), cassandraArchivaManager.getMailingListFamilyName(), (Serializer)StringSerializer.get(), (Serializer)StringSerializer.get());
        this.licenseTemplate = new ThriftColumnFamilyTemplate(cassandraArchivaManager.getKeyspace(), cassandraArchivaManager.getLicenseFamilyName(), (Serializer)StringSerializer.get(), (Serializer)StringSerializer.get());
        this.dependencyTemplate = new ThriftColumnFamilyTemplate(cassandraArchivaManager.getKeyspace(), cassandraArchivaManager.getDependencyFamilyName(), (Serializer)StringSerializer.get(), (Serializer)StringSerializer.get());
    }

    public Repository getOrCreateRepository(String repositoryId) throws MetadataRepositoryException {
        String cf = this.cassandraArchivaManager.getRepositoryFamilyName();
        QueryResult result = HFactory.createRangeSlicesQuery((Keyspace)this.keyspace, (Serializer)StringSerializer.get(), (Serializer)StringSerializer.get(), (Serializer)StringSerializer.get()).setColumnFamily(cf).setColumnNames((Object[])new String[]{"repositoryName"}).addEqualsExpression((Object)"repositoryName", (Object)repositoryId).execute();
        if (((OrderedRows)result.get()).getCount() < 1) {
            Repository repository = new Repository(repositoryId);
            try {
                MutationResult mutationResult = HFactory.createMutator((Keyspace)this.keyspace, (Serializer)StringSerializer.get()).addInsertion((Object)repositoryId, cf, CassandraUtils.column("repositoryName", repository.getName())).execute();
                return repository;
            }
            catch (HInvalidRequestException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
                throw new MetadataRepositoryException(e.getMessage(), (Throwable)e);
            }
        }
        return new Repository((String)((Row)((OrderedRows)result.get()).getList().get(0)).getColumnSlice().getColumnByName((Object)"repositoryName").getValue());
    }

    protected Repository getRepository(String repositoryId) throws MetadataRepositoryException {
        QueryResult result = HFactory.createRangeSlicesQuery((Keyspace)this.keyspace, (Serializer)StringSerializer.get(), (Serializer)StringSerializer.get(), (Serializer)StringSerializer.get()).setColumnFamily(this.cassandraArchivaManager.getRepositoryFamilyName()).setColumnNames((Object[])new String[]{"repositoryName"}).addEqualsExpression((Object)"repositoryName", (Object)repositoryId).execute();
        return ((OrderedRows)result.get()).getCount() > 0 ? new Repository(repositoryId) : null;
    }

    public void updateNamespace(String repositoryId, String namespaceId) throws MetadataRepositoryException {
        this.updateOrAddNamespace(repositoryId, namespaceId);
    }

    private Namespace updateOrAddNamespace(String repositoryId, String namespaceId) throws MetadataRepositoryException {
        try {
            Repository repository = this.getOrCreateRepository(repositoryId);
            String key = new Namespace.KeyBuilder().withNamespace(namespaceId).withRepositoryId(repositoryId).build();
            Namespace namespace = this.getNamespace(repositoryId, namespaceId);
            if (namespace == null) {
                String cf = this.cassandraArchivaManager.getNamespaceFamilyName();
                namespace = new Namespace(namespaceId, repository);
                HFactory.createMutator((Keyspace)this.keyspace, (Serializer)StringSerializer.get()).addInsertion((Object)key, cf, CassandraUtils.column("name", namespace.getName())).addInsertion((Object)key, cf, CassandraUtils.column("repositoryName", repository.getName())).execute();
            }
            return namespace;
        }
        catch (HInvalidRequestException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new MetadataRepositoryException(e.getMessage(), (Throwable)e);
        }
    }

    protected Namespace getNamespace(String repositoryId, String namespaceId) {
        QueryResult result = HFactory.createRangeSlicesQuery((Keyspace)this.keyspace, (Serializer)this.ss, (Serializer)this.ss, (Serializer)this.ss).setColumnFamily(this.cassandraArchivaManager.getNamespaceFamilyName()).setColumnNames((Object[])new String[]{"repositoryName", "name"}).addEqualsExpression((Object)"repositoryName", (Object)repositoryId).addEqualsExpression((Object)"name", (Object)namespaceId).execute();
        if (((OrderedRows)result.get()).getCount() > 0) {
            ColumnSlice columnSlice = ((Row)((OrderedRows)result.get()).getList().get(0)).getColumnSlice();
            return new Namespace(CassandraUtils.getStringValue((ColumnSlice<String, String>)columnSlice, "name"), new Repository(CassandraUtils.getStringValue((ColumnSlice<String, String>)columnSlice, "repositoryName")));
        }
        return null;
    }

    public void removeNamespace(String repositoryId, String namespaceId) throws MetadataRepositoryException {
        try {
            String key = new Namespace.KeyBuilder().withNamespace(namespaceId).withRepositoryId(repositoryId).build();
            HFactory.createMutator((Keyspace)this.cassandraArchivaManager.getKeyspace(), (Serializer)new StringSerializer()).addDeletion((Object)key, this.cassandraArchivaManager.getNamespaceFamilyName()).execute();
            QueryResult result = HFactory.createRangeSlicesQuery((Keyspace)this.keyspace, (Serializer)this.ss, (Serializer)this.ss, (Serializer)this.ss).setColumnFamily(this.cassandraArchivaManager.getProjectFamilyName()).setColumnNames((Object[])new String[]{"repositoryName"}).addEqualsExpression((Object)"repositoryName", (Object)repositoryId).addEqualsExpression((Object)"namespaceId", (Object)namespaceId).execute();
            for (Row row : (OrderedRows)result.get()) {
                this.projectTemplate.deleteRow(row.getKey());
            }
            result = HFactory.createRangeSlicesQuery((Keyspace)this.keyspace, (Serializer)this.ss, (Serializer)this.ss, (Serializer)this.ss).setColumnFamily(this.cassandraArchivaManager.getProjectVersionMetadataFamilyName()).setColumnNames((Object[])new String[]{"repositoryName"}).addEqualsExpression((Object)"repositoryName", (Object)repositoryId).addEqualsExpression((Object)"namespaceId", (Object)namespaceId).execute();
            for (Row row : (OrderedRows)result.get()) {
                this.projectVersionMetadataTemplate.deleteRow(row.getKey());
                this.removeMailingList((String)row.getKey());
            }
            result = HFactory.createRangeSlicesQuery((Keyspace)this.keyspace, (Serializer)this.ss, (Serializer)this.ss, (Serializer)this.ss).setColumnFamily(this.cassandraArchivaManager.getArtifactMetadataFamilyName()).setColumnNames((Object[])new String[]{"repositoryName"}).addEqualsExpression((Object)"repositoryName", (Object)repositoryId).addEqualsExpression((Object)"namespaceId", (Object)namespaceId).execute();
            for (Row row : (OrderedRows)result.get()) {
                this.artifactMetadataTemplate.deleteRow(row.getKey());
            }
            result = HFactory.createRangeSlicesQuery((Keyspace)this.keyspace, (Serializer)this.ss, (Serializer)this.ss, (Serializer)this.ss).setColumnFamily(this.cassandraArchivaManager.getMetadataFacetFamilyName()).setColumnNames((Object[])new String[]{"repositoryName"}).addEqualsExpression((Object)"repositoryName", (Object)repositoryId).addEqualsExpression((Object)"namespaceId", (Object)namespaceId).execute();
            for (Row row : (OrderedRows)result.get()) {
                this.metadataFacetTemplate.deleteRow(row.getKey());
            }
        }
        catch (HInvalidRequestException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new MetadataRepositoryException(e.getMessage(), (Throwable)e);
        }
    }

    public void removeRepository(String repositoryId) throws MetadataRepositoryException {
        ArrayList<Object> namespacesKey = new ArrayList<Object>();
        QueryResult result = HFactory.createRangeSlicesQuery((Keyspace)this.keyspace, (Serializer)this.ss, (Serializer)this.ss, (Serializer)this.ss).setColumnFamily(this.cassandraArchivaManager.getNamespaceFamilyName()).setColumnNames((Object[])new String[]{"repositoryName"}).addEqualsExpression((Object)"repositoryName", (Object)repositoryId).execute();
        for (Row row : ((OrderedRows)result.get()).getList()) {
            namespacesKey.add(row.getKey());
        }
        HFactory.createMutator((Keyspace)this.cassandraArchivaManager.getKeyspace(), (Serializer)this.ss).addDeletion(namespacesKey, this.cassandraArchivaManager.getNamespaceFamilyName()).execute();
        HFactory.createMutator((Keyspace)this.cassandraArchivaManager.getKeyspace(), (Serializer)this.ss).addDeletion((Object)repositoryId, this.cassandraArchivaManager.getRepositoryFamilyName()).execute();
        result = HFactory.createRangeSlicesQuery((Keyspace)this.keyspace, (Serializer)this.ss, (Serializer)this.ss, (Serializer)this.ss).setColumnFamily(this.cassandraArchivaManager.getProjectFamilyName()).setColumnNames((Object[])new String[]{"repositoryName"}).addEqualsExpression((Object)"repositoryName", (Object)repositoryId).execute();
        for (Row row : (OrderedRows)result.get()) {
            this.projectTemplate.deleteRow(row.getKey());
        }
        result = HFactory.createRangeSlicesQuery((Keyspace)this.keyspace, (Serializer)this.ss, (Serializer)this.ss, (Serializer)this.ss).setColumnFamily(this.cassandraArchivaManager.getProjectVersionMetadataFamilyName()).setColumnNames((Object[])new String[]{"repositoryName"}).addEqualsExpression((Object)"repositoryName", (Object)repositoryId).execute();
        for (Row row : (OrderedRows)result.get()) {
            this.projectVersionMetadataTemplate.deleteRow(row.getKey());
            this.removeMailingList((String)row.getKey());
        }
        result = HFactory.createRangeSlicesQuery((Keyspace)this.keyspace, (Serializer)this.ss, (Serializer)this.ss, (Serializer)this.ss).setColumnFamily(this.cassandraArchivaManager.getArtifactMetadataFamilyName()).setColumnNames((Object[])new String[]{"repositoryName"}).addEqualsExpression((Object)"repositoryName", (Object)repositoryId).execute();
        for (Row row : (OrderedRows)result.get()) {
            this.artifactMetadataTemplate.deleteRow(row.getKey());
        }
        result = HFactory.createRangeSlicesQuery((Keyspace)this.keyspace, (Serializer)this.ss, (Serializer)this.ss, (Serializer)this.ss).setColumnFamily(this.cassandraArchivaManager.getMetadataFacetFamilyName()).setColumnNames((Object[])new String[]{"repositoryName"}).addEqualsExpression((Object)"repositoryName", (Object)repositoryId).execute();
        for (Row row : (OrderedRows)result.get()) {
            this.metadataFacetTemplate.deleteRow(row.getKey());
        }
    }

    public Collection<String> getRepositories() throws MetadataRepositoryException {
        try {
            this.logger.debug("getRepositories");
            QueryResult cResult = HFactory.createRangeSlicesQuery((Keyspace)this.cassandraArchivaManager.getKeyspace(), (Serializer)this.ss, (Serializer)this.ss, (Serializer)this.ss).setColumnFamily(this.cassandraArchivaManager.getRepositoryFamilyName()).setColumnNames((Object[])new String[]{"repositoryName"}).setRange(null, null, false, Integer.MAX_VALUE).execute();
            ArrayList<String> repoIds = new ArrayList<String>(((OrderedRows)cResult.get()).getCount());
            for (Row row : (OrderedRows)cResult.get()) {
                repoIds.add(CassandraUtils.getStringValue((ColumnSlice<String, String>)row.getColumnSlice(), "repositoryName"));
            }
            return repoIds;
        }
        catch (PersistenceException e) {
            throw new MetadataRepositoryException(e.getMessage(), (Throwable)e);
        }
    }

    public Collection<String> getRootNamespaces(String repoId) throws MetadataResolutionException {
        QueryResult result = HFactory.createRangeSlicesQuery((Keyspace)this.keyspace, (Serializer)this.ss, (Serializer)this.ss, (Serializer)this.ss).setColumnFamily(this.cassandraArchivaManager.getNamespaceFamilyName()).setColumnNames((Object[])new String[]{"name"}).addEqualsExpression((Object)"repositoryName", (Object)repoId).execute();
        HashSet<String> namespaces = new HashSet<String>(((OrderedRows)result.get()).getCount());
        for (Row row : (OrderedRows)result.get()) {
            namespaces.add(StringUtils.substringBefore((String)CassandraUtils.getStringValue((ColumnSlice<String, String>)row.getColumnSlice(), "name"), (String)"."));
        }
        return namespaces;
    }

    public Collection<String> getNamespaces(String repoId, String namespaceId) throws MetadataResolutionException {
        QueryResult result = HFactory.createRangeSlicesQuery((Keyspace)this.keyspace, (Serializer)this.ss, (Serializer)this.ss, (Serializer)this.ss).setColumnFamily(this.cassandraArchivaManager.getNamespaceFamilyName()).setColumnNames((Object[])new String[]{"name"}).addEqualsExpression((Object)"repositoryName", (Object)repoId).execute();
        ArrayList<String> namespaces = new ArrayList<String>(((OrderedRows)result.get()).getCount());
        for (Row row : (OrderedRows)result.get()) {
            String currentNamespace = CassandraUtils.getStringValue((ColumnSlice<String, String>)row.getColumnSlice(), "name");
            if (!StringUtils.startsWith((String)currentNamespace, (String)namespaceId) || StringUtils.length((String)currentNamespace) <= StringUtils.length((String)namespaceId)) continue;
            String calledNamespace = StringUtils.endsWith((String)namespaceId, (String)".") ? namespaceId : namespaceId + ".";
            String storedNamespace = StringUtils.substringAfter((String)currentNamespace, (String)calledNamespace);
            storedNamespace = StringUtils.substringBefore((String)storedNamespace, (String)".");
            namespaces.add(storedNamespace);
        }
        return namespaces;
    }

    protected List<String> getNamespaces(String repoId) throws MetadataResolutionException {
        QueryResult result = HFactory.createRangeSlicesQuery((Keyspace)this.keyspace, (Serializer)this.ss, (Serializer)this.ss, (Serializer)this.ss).setColumnFamily(this.cassandraArchivaManager.getNamespaceFamilyName()).setColumnNames((Object[])new String[]{"name"}).addEqualsExpression((Object)"repositoryName", (Object)repoId).execute();
        ArrayList<String> namespaces = new ArrayList<String>(((OrderedRows)result.get()).getCount());
        for (Row row : (OrderedRows)result.get()) {
            namespaces.add(CassandraUtils.getStringValue((ColumnSlice<String, String>)row.getColumnSlice(), "name"));
        }
        return namespaces;
    }

    public void updateProject(String repositoryId, ProjectMetadata projectMetadata) throws MetadataRepositoryException {
        QueryResult result = HFactory.createRangeSlicesQuery((Keyspace)this.keyspace, (Serializer)this.ss, (Serializer)this.ss, (Serializer)this.ss).setColumnFamily(this.cassandraArchivaManager.getProjectFamilyName()).setColumnNames((Object[])new String[]{"projectId"}).addEqualsExpression((Object)"repositoryName", (Object)repositoryId).addEqualsExpression((Object)"namespaceId", (Object)projectMetadata.getNamespace()).addEqualsExpression((Object)"projectId", (Object)projectMetadata.getId()).execute();
        if (((OrderedRows)result.get()).getCount() > 0) {
            return;
        }
        Namespace namespace = this.updateOrAddNamespace(repositoryId, projectMetadata.getNamespace());
        String key = new Project.KeyBuilder().withProjectId(projectMetadata.getId()).withNamespace(namespace).build();
        String cf = this.cassandraArchivaManager.getProjectFamilyName();
        this.projectTemplate.createMutator().addInsertion((Object)key, cf, CassandraUtils.column("projectId", projectMetadata.getId())).addInsertion((Object)key, cf, CassandraUtils.column("repositoryName", repositoryId)).addInsertion((Object)key, cf, CassandraUtils.column("namespaceId", projectMetadata.getNamespace())).execute();
    }

    public Collection<String> getProjects(String repoId, String namespace) throws MetadataResolutionException {
        QueryResult result = HFactory.createRangeSlicesQuery((Keyspace)this.keyspace, (Serializer)this.ss, (Serializer)this.ss, (Serializer)this.ss).setColumnFamily(this.cassandraArchivaManager.getProjectFamilyName()).setColumnNames((Object[])new String[]{"projectId"}).addEqualsExpression((Object)"repositoryName", (Object)repoId).addEqualsExpression((Object)"namespaceId", (Object)namespace).execute();
        HashSet<String> projects = new HashSet<String>(((OrderedRows)result.get()).getCount());
        for (Row row : (OrderedRows)result.get()) {
            projects.add(CassandraUtils.getStringValue((ColumnSlice<String, String>)row.getColumnSlice(), "projectId"));
        }
        return projects;
    }

    public void removeProject(String repositoryId, String namespaceId, String projectId) throws MetadataRepositoryException {
        String key = new Project.KeyBuilder().withProjectId(projectId).withNamespace(new Namespace(namespaceId, new Repository(repositoryId))).build();
        this.projectTemplate.deleteRow((Object)key);
        QueryResult result = HFactory.createRangeSlicesQuery((Keyspace)this.keyspace, (Serializer)this.ss, (Serializer)this.ss, (Serializer)this.ss).setColumnFamily(this.cassandraArchivaManager.getProjectVersionMetadataFamilyName()).setColumnNames((Object[])new String[]{"id"}).addEqualsExpression((Object)"repositoryName", (Object)repositoryId).addEqualsExpression((Object)"namespaceId", (Object)namespaceId).addEqualsExpression((Object)"projectId", (Object)projectId).execute();
        for (Row row : (OrderedRows)result.get()) {
            this.projectVersionMetadataTemplate.deleteRow(row.getKey());
            this.removeMailingList((String)row.getKey());
        }
        result = HFactory.createRangeSlicesQuery((Keyspace)this.keyspace, (Serializer)this.ss, (Serializer)this.ss, (Serializer)this.ss).setColumnFamily(this.cassandraArchivaManager.getArtifactMetadataFamilyName()).setColumnNames((Object[])new String[]{"projectId"}).addEqualsExpression((Object)"repositoryName", (Object)repositoryId).addEqualsExpression((Object)"namespaceId", (Object)namespaceId).addEqualsExpression((Object)"projectId", (Object)projectId).execute();
        for (Row row : (OrderedRows)result.get()) {
            this.artifactMetadataTemplate.deleteRow(row.getKey());
        }
    }

    public Collection<String> getProjectVersions(String repoId, String namespace, String projectId) throws MetadataResolutionException {
        QueryResult result = HFactory.createRangeSlicesQuery((Keyspace)this.keyspace, (Serializer)this.ss, (Serializer)this.ss, (Serializer)this.ss).setColumnFamily(this.cassandraArchivaManager.getProjectVersionMetadataFamilyName()).setColumnNames((Object[])new String[]{"projectVersion"}).addEqualsExpression((Object)"repositoryName", (Object)repoId).addEqualsExpression((Object)"namespaceId", (Object)namespace).addEqualsExpression((Object)"projectId", (Object)projectId).execute();
        int count = ((OrderedRows)result.get()).getCount();
        if (count < 1) {
            return Collections.emptyList();
        }
        HashSet<String> versions = new HashSet<String>(count);
        for (Row orderedRows : (OrderedRows)result.get()) {
            versions.add(CassandraUtils.getStringValue((ColumnSlice<String, String>)orderedRows.getColumnSlice(), "projectVersion"));
        }
        return versions;
    }

    public ProjectMetadata getProject(String repoId, String namespace, String id) throws MetadataResolutionException {
        QueryResult result = HFactory.createRangeSlicesQuery((Keyspace)this.keyspace, (Serializer)this.ss, (Serializer)this.ss, (Serializer)this.ss).setColumnFamily(this.cassandraArchivaManager.getProjectFamilyName()).setColumnNames((Object[])new String[]{"projectId"}).addEqualsExpression((Object)"repositoryName", (Object)repoId).addEqualsExpression((Object)"namespaceId", (Object)namespace).addEqualsExpression((Object)"projectId", (Object)id).execute();
        int count = ((OrderedRows)result.get()).getCount();
        if (count < 1) {
            return null;
        }
        ProjectMetadata projectMetadata = new ProjectMetadata();
        projectMetadata.setId(id);
        projectMetadata.setNamespace(namespace);
        this.logger.debug("getProject repoId: {}, namespace: {}, projectId: {} -> {}", new Object[]{repoId, namespace, id, projectMetadata});
        return projectMetadata;
    }

    protected ProjectVersionMetadataModel mapProjectVersionMetadataModel(ColumnSlice<String, String> columnSlice) {
        ProjectVersionMetadataModel projectVersionMetadataModel = new ProjectVersionMetadataModel();
        projectVersionMetadataModel.setId(CassandraUtils.getStringValue(columnSlice, "id"));
        projectVersionMetadataModel.setDescription(CassandraUtils.getStringValue(columnSlice, "description"));
        projectVersionMetadataModel.setName(CassandraUtils.getStringValue(columnSlice, "name"));
        Namespace namespace = new Namespace(CassandraUtils.getStringValue(columnSlice, "namespaceId"), new Repository(CassandraUtils.getStringValue(columnSlice, "repositoryName")));
        projectVersionMetadataModel.setNamespace(namespace);
        projectVersionMetadataModel.setIncomplete(Boolean.parseBoolean(CassandraUtils.getStringValue(columnSlice, "incomplete")));
        projectVersionMetadataModel.setProjectId(CassandraUtils.getStringValue(columnSlice, "projectId"));
        projectVersionMetadataModel.setUrl(CassandraUtils.getStringValue(columnSlice, "url"));
        return projectVersionMetadataModel;
    }

    public void updateProjectVersion(String repositoryId, String namespaceId, String projectId, ProjectVersionMetadata versionMetadata) throws MetadataRepositoryException {
        try {
            Namespace namespace = this.getNamespace(repositoryId, namespaceId);
            if (namespace == null) {
                this.updateOrAddNamespace(repositoryId, namespaceId);
            }
            if (this.getProject(repositoryId, namespaceId, projectId) == null) {
                ProjectMetadata projectMetadata = new ProjectMetadata();
                projectMetadata.setNamespace(namespaceId);
                projectMetadata.setId(projectId);
                this.updateProject(repositoryId, projectMetadata);
            }
        }
        catch (MetadataResolutionException e) {
            throw new MetadataRepositoryException(e.getMessage(), (Throwable)e);
        }
        QueryResult result = HFactory.createRangeSlicesQuery((Keyspace)this.keyspace, (Serializer)this.ss, (Serializer)this.ss, (Serializer)this.ss).setColumnFamily(this.cassandraArchivaManager.getProjectVersionMetadataFamilyName()).setColumnNames((Object[])new String[]{"projectVersion"}).addEqualsExpression((Object)"repositoryName", (Object)repositoryId).addEqualsExpression((Object)"namespaceId", (Object)namespaceId).addEqualsExpression((Object)"projectId", (Object)projectId).addEqualsExpression((Object)"projectVersion", (Object)versionMetadata.getId()).execute();
        ProjectVersionMetadataModel projectVersionMetadataModel = null;
        boolean creation = true;
        if (((OrderedRows)result.get()).getCount() > 0) {
            projectVersionMetadataModel = this.mapProjectVersionMetadataModel((ColumnSlice<String, String>)((Row)((OrderedRows)result.get()).getList().get(0)).getColumnSlice());
            creation = false;
        } else {
            projectVersionMetadataModel = (ProjectVersionMetadataModel)this.getModelMapper().map((Object)versionMetadata, ProjectVersionMetadataModel.class);
        }
        projectVersionMetadataModel.setProjectId(projectId);
        projectVersionMetadataModel.setNamespace(new Namespace(namespaceId, new Repository(repositoryId)));
        projectVersionMetadataModel.setCiManagement(versionMetadata.getCiManagement());
        projectVersionMetadataModel.setIssueManagement(versionMetadata.getIssueManagement());
        projectVersionMetadataModel.setOrganization(versionMetadata.getOrganization());
        projectVersionMetadataModel.setScm(versionMetadata.getScm());
        projectVersionMetadataModel.setMailingLists(versionMetadata.getMailingLists());
        projectVersionMetadataModel.setDependencies(versionMetadata.getDependencies());
        projectVersionMetadataModel.setLicenses(versionMetadata.getLicenses());
        String key = new ProjectVersionMetadataModel.KeyBuilder().withRepository(repositoryId).withNamespace(namespaceId).withProjectId(projectId).withProjectVersion(versionMetadata.getVersion()).withId(versionMetadata.getId()).build();
        if (creation) {
            Scm scm;
            Organization organization;
            IssueManagement issueManagement;
            String cf = this.cassandraArchivaManager.getProjectVersionMetadataFamilyName();
            Mutator mutator = this.projectVersionMetadataTemplate.createMutator().addInsertion((Object)key, cf, CassandraUtils.column("projectId", projectId)).addInsertion((Object)key, cf, CassandraUtils.column("repositoryName", repositoryId)).addInsertion((Object)key, cf, CassandraUtils.column("namespaceId", namespaceId)).addInsertion((Object)key, cf, CassandraUtils.column("projectVersion", versionMetadata.getVersion()));
            CassandraUtils.addInsertion((Mutator<String>)mutator, key, cf, "description", versionMetadata.getDescription());
            CassandraUtils.addInsertion((Mutator<String>)mutator, key, cf, "name", versionMetadata.getName());
            CassandraUtils.addInsertion((Mutator<String>)mutator, key, cf, "incomplete", Boolean.toString(versionMetadata.isIncomplete()));
            CassandraUtils.addInsertion((Mutator<String>)mutator, key, cf, "url", versionMetadata.getUrl());
            CiManagement ci = versionMetadata.getCiManagement();
            if (ci != null) {
                CassandraUtils.addInsertion((Mutator<String>)mutator, key, cf, "ciManagement.system", ci.getSystem());
                CassandraUtils.addInsertion((Mutator<String>)mutator, key, cf, "ciManagement.url", ci.getUrl());
            }
            if ((issueManagement = versionMetadata.getIssueManagement()) != null) {
                CassandraUtils.addInsertion((Mutator<String>)mutator, key, cf, "issueManagement.system", issueManagement.getSystem());
                CassandraUtils.addInsertion((Mutator<String>)mutator, key, cf, "issueManagement.url", issueManagement.getUrl());
            }
            if ((organization = versionMetadata.getOrganization()) != null) {
                CassandraUtils.addInsertion((Mutator<String>)mutator, key, cf, "organization.name", organization.getName());
                CassandraUtils.addInsertion((Mutator<String>)mutator, key, cf, "organization.url", organization.getUrl());
            }
            if ((scm = versionMetadata.getScm()) != null) {
                CassandraUtils.addInsertion((Mutator<String>)mutator, key, cf, "scm.url", scm.getUrl());
                CassandraUtils.addInsertion((Mutator<String>)mutator, key, cf, "scm.connection", scm.getConnection());
                CassandraUtils.addInsertion((Mutator<String>)mutator, key, cf, "scm.developerConnection", scm.getDeveloperConnection());
            }
            this.recordMailingList(key, versionMetadata.getMailingLists());
            this.recordLicenses(key, versionMetadata.getLicenses());
            this.recordDependencies(key, versionMetadata.getDependencies(), repositoryId);
            MutationResult mutationResult = mutator.execute();
        } else {
            Scm scm;
            Organization organization;
            IssueManagement issueManagement;
            ColumnFamilyUpdater updater = this.projectVersionMetadataTemplate.createUpdater((Object)key);
            CassandraUtils.addUpdateStringValue((ColumnFamilyUpdater<String, String>)updater, "projectId", projectId);
            CassandraUtils.addUpdateStringValue((ColumnFamilyUpdater<String, String>)updater, "repositoryName", repositoryId);
            CassandraUtils.addUpdateStringValue((ColumnFamilyUpdater<String, String>)updater, "namespaceId", namespaceId);
            CassandraUtils.addUpdateStringValue((ColumnFamilyUpdater<String, String>)updater, "projectVersion", versionMetadata.getVersion());
            CassandraUtils.addUpdateStringValue((ColumnFamilyUpdater<String, String>)updater, "description", versionMetadata.getDescription());
            CassandraUtils.addUpdateStringValue((ColumnFamilyUpdater<String, String>)updater, "name", versionMetadata.getName());
            updater.setString((Object)"incomplete", Boolean.toString(versionMetadata.isIncomplete()));
            CassandraUtils.addUpdateStringValue((ColumnFamilyUpdater<String, String>)updater, "url", versionMetadata.getUrl());
            CiManagement ci = versionMetadata.getCiManagement();
            if (ci != null) {
                CassandraUtils.addUpdateStringValue((ColumnFamilyUpdater<String, String>)updater, "ciManagement.system", ci.getSystem());
                CassandraUtils.addUpdateStringValue((ColumnFamilyUpdater<String, String>)updater, "ciManagement.url", ci.getUrl());
            }
            if ((issueManagement = versionMetadata.getIssueManagement()) != null) {
                CassandraUtils.addUpdateStringValue((ColumnFamilyUpdater<String, String>)updater, "issueManagement.system", issueManagement.getSystem());
                CassandraUtils.addUpdateStringValue((ColumnFamilyUpdater<String, String>)updater, "issueManagement.url", issueManagement.getUrl());
            }
            if ((organization = versionMetadata.getOrganization()) != null) {
                CassandraUtils.addUpdateStringValue((ColumnFamilyUpdater<String, String>)updater, "organization.name", organization.getName());
                CassandraUtils.addUpdateStringValue((ColumnFamilyUpdater<String, String>)updater, "organization.url", organization.getUrl());
            }
            if ((scm = versionMetadata.getScm()) != null) {
                CassandraUtils.addUpdateStringValue((ColumnFamilyUpdater<String, String>)updater, "scm.url", scm.getUrl());
                CassandraUtils.addUpdateStringValue((ColumnFamilyUpdater<String, String>)updater, "scm.connection", scm.getConnection());
                CassandraUtils.addUpdateStringValue((ColumnFamilyUpdater<String, String>)updater, "scm.developerConnection", scm.getDeveloperConnection());
            }
            this.removeMailingList(key);
            this.recordMailingList(key, versionMetadata.getMailingLists());
            this.removeLicenses(key);
            this.recordLicenses(key, versionMetadata.getLicenses());
            this.removeDependencies(key);
            this.recordDependencies(key, versionMetadata.getDependencies(), repositoryId);
            this.projectVersionMetadataTemplate.update(updater);
        }
        ArtifactMetadataModel artifactMetadataModel = new ArtifactMetadataModel();
        artifactMetadataModel.setRepositoryId(repositoryId);
        artifactMetadataModel.setNamespace(namespaceId);
        artifactMetadataModel.setProject(projectId);
        artifactMetadataModel.setProjectVersion(versionMetadata.getVersion());
        artifactMetadataModel.setVersion(versionMetadata.getVersion());
        this.updateFacets((FacetedMetadata)versionMetadata, artifactMetadataModel);
    }

    public ProjectVersionMetadata getProjectVersion(String repoId, String namespace, String projectId, String projectVersion) throws MetadataResolutionException {
        QueryResult result = HFactory.createRangeSlicesQuery((Keyspace)this.keyspace, (Serializer)this.ss, (Serializer)this.ss, (Serializer)this.ss).setColumnFamily(this.cassandraArchivaManager.getProjectVersionMetadataFamilyName()).setColumnNames((Object[])new String[]{"projectVersion"}).addEqualsExpression((Object)"repositoryName", (Object)repoId).addEqualsExpression((Object)"namespaceId", (Object)namespace).addEqualsExpression((Object)"projectId", (Object)projectId).addEqualsExpression((Object)"projectVersion", (Object)projectVersion).execute();
        if (((OrderedRows)result.get()).getCount() < 1) {
            return null;
        }
        String key = (String)((Row)((OrderedRows)result.get()).iterator().next()).getKey();
        ColumnFamilyResult columnFamilyResult = this.projectVersionMetadataTemplate.queryColumns((Object)key);
        if (!columnFamilyResult.hasResults()) {
            return null;
        }
        ProjectVersionMetadata projectVersionMetadata = new ProjectVersionMetadata();
        projectVersionMetadata.setId(columnFamilyResult.getString((Object)"projectVersion"));
        projectVersionMetadata.setDescription(columnFamilyResult.getString((Object)"description"));
        projectVersionMetadata.setName(columnFamilyResult.getString((Object)"name"));
        projectVersionMetadata.setIncomplete(Boolean.parseBoolean(columnFamilyResult.getString((Object)"incomplete")));
        projectVersionMetadata.setUrl(columnFamilyResult.getString((Object)"url"));
        String ciUrl = columnFamilyResult.getString((Object)"ciManagement.url");
        String ciSystem = columnFamilyResult.getString((Object)"ciManagement.system");
        if (StringUtils.isNotEmpty((String)ciSystem) || StringUtils.isNotEmpty((String)ciUrl)) {
            projectVersionMetadata.setCiManagement(new CiManagement(ciSystem, ciUrl));
        }
        String issueUrl = columnFamilyResult.getString((Object)"issueManagement.url");
        String issueSystem = columnFamilyResult.getString((Object)"issueManagement.system");
        if (StringUtils.isNotEmpty((String)issueSystem) || StringUtils.isNotEmpty((String)issueUrl)) {
            projectVersionMetadata.setIssueManagement(new IssueManagement(issueSystem, issueUrl));
        }
        String organizationUrl = columnFamilyResult.getString((Object)"organization.url");
        String organizationName = columnFamilyResult.getString((Object)"organization.name");
        if (StringUtils.isNotEmpty((String)organizationUrl) || StringUtils.isNotEmpty((String)organizationName)) {
            projectVersionMetadata.setOrganization(new Organization(organizationName, organizationUrl));
        }
        String devConn = columnFamilyResult.getString((Object)"scm.developerConnection");
        String conn = columnFamilyResult.getString((Object)"scm.connection");
        String url = columnFamilyResult.getString((Object)"scm.url");
        if (StringUtils.isNotEmpty((String)devConn) || StringUtils.isNotEmpty((String)conn) || StringUtils.isNotEmpty((String)url)) {
            projectVersionMetadata.setScm(new Scm(conn, devConn, url));
        }
        projectVersionMetadata.setMailingLists(this.getMailingLists(key));
        projectVersionMetadata.setLicenses(this.getLicenses(key));
        projectVersionMetadata.setDependencies(this.getDependencies(key));
        result = HFactory.createRangeSlicesQuery((Keyspace)this.keyspace, (Serializer)this.ss, (Serializer)this.ss, (Serializer)this.ss).setColumnFamily(this.cassandraArchivaManager.getMetadataFacetFamilyName()).setColumnNames((Object[])new String[]{"facetId", "key", "value", "name"}).addEqualsExpression((Object)"repositoryName", (Object)repoId).addEqualsExpression((Object)"namespaceId", (Object)namespace).addEqualsExpression((Object)"projectId", (Object)projectId).addEqualsExpression((Object)"projectVersion", (Object)projectVersion).execute();
        HashMap<String, HashMap<String, String>> metadataFacetsPerFacetIds = new HashMap<String, HashMap<String, String>>();
        for (Row row : (OrderedRows)result.get()) {
            ColumnSlice columnSlice = row.getColumnSlice();
            String facetId = CassandraUtils.getStringValue((ColumnSlice<String, String>)columnSlice, "facetId");
            HashMap<String, String> metaValues = (HashMap<String, String>)metadataFacetsPerFacetIds.get(facetId);
            if (metaValues == null) {
                metaValues = new HashMap<String, String>();
                metadataFacetsPerFacetIds.put(facetId, metaValues);
            }
            metaValues.put(CassandraUtils.getStringValue((ColumnSlice<String, String>)columnSlice, "key"), CassandraUtils.getStringValue((ColumnSlice<String, String>)columnSlice, "value"));
        }
        if (!metadataFacetsPerFacetIds.isEmpty()) {
            for (Map.Entry entry : metadataFacetsPerFacetIds.entrySet()) {
                MetadataFacetFactory metadataFacetFactory = this.metadataFacetFactories.get(entry.getKey());
                if (metadataFacetFactory == null) continue;
                MetadataFacet metadataFacet = metadataFacetFactory.createMetadataFacet();
                metadataFacet.fromProperties((Map)entry.getValue());
                projectVersionMetadata.addFacet(metadataFacet);
            }
        }
        return projectVersionMetadata;
    }

    protected void recordMailingList(String projectVersionMetadataKey, List<MailingList> mailingLists) {
        if (mailingLists == null || mailingLists.isEmpty()) {
            return;
        }
        Mutator mailingMutator = this.mailingListTemplate.createMutator();
        for (MailingList mailingList : mailingLists) {
            String keyMailingList = UUID.randomUUID().toString();
            String cfMailingList = this.cassandraArchivaManager.getMailingListFamilyName();
            CassandraUtils.addInsertion((Mutator<String>)mailingMutator, keyMailingList, cfMailingList, "projectVersionMetadataModel.key", projectVersionMetadataKey);
            CassandraUtils.addInsertion((Mutator<String>)mailingMutator, keyMailingList, cfMailingList, "name", mailingList.getName());
            CassandraUtils.addInsertion((Mutator<String>)mailingMutator, keyMailingList, cfMailingList, "mainArchiveUrl", mailingList.getMainArchiveUrl());
            CassandraUtils.addInsertion((Mutator<String>)mailingMutator, keyMailingList, cfMailingList, "postAddress", mailingList.getPostAddress());
            CassandraUtils.addInsertion((Mutator<String>)mailingMutator, keyMailingList, cfMailingList, "subscribeAddress", mailingList.getSubscribeAddress());
            CassandraUtils.addInsertion((Mutator<String>)mailingMutator, keyMailingList, cfMailingList, "unsubscribeAddress", mailingList.getUnsubscribeAddress());
            int idx = 0;
            for (String otherArchive : mailingList.getOtherArchives()) {
                CassandraUtils.addInsertion((Mutator<String>)mailingMutator, keyMailingList, cfMailingList, "otherArchive." + idx, otherArchive);
                ++idx;
            }
        }
        mailingMutator.execute();
    }

    protected void removeMailingList(String projectVersionMetadataKey) {
        QueryResult result = HFactory.createRangeSlicesQuery((Keyspace)this.cassandraArchivaManager.getKeyspace(), (Serializer)this.ss, (Serializer)this.ss, (Serializer)this.ss).setColumnFamily(this.cassandraArchivaManager.getMailingListFamilyName()).setColumnNames((Object[])new String[]{"name"}).setRowCount(Integer.MAX_VALUE).addEqualsExpression((Object)"projectVersionMetadataModel.key", (Object)projectVersionMetadataKey).execute();
        if (((OrderedRows)result.get()).getCount() < 1) {
            return;
        }
        for (Row row : (OrderedRows)result.get()) {
            this.mailingListTemplate.deleteRow(row.getKey());
        }
    }

    protected List<MailingList> getMailingLists(String projectVersionMetadataKey) {
        ArrayList<MailingList> mailingLists = new ArrayList<MailingList>();
        QueryResult result = HFactory.createRangeSlicesQuery((Keyspace)this.cassandraArchivaManager.getKeyspace(), (Serializer)this.ss, (Serializer)this.ss, (Serializer)this.ss).setColumnFamily(this.cassandraArchivaManager.getMailingListFamilyName()).setColumnNames((Object[])new String[]{"name"}).setRowCount(Integer.MAX_VALUE).addEqualsExpression((Object)"projectVersionMetadataModel.key", (Object)projectVersionMetadataKey).execute();
        for (Row row : (OrderedRows)result.get()) {
            ColumnFamilyResult columnFamilyResult = this.mailingListTemplate.queryColumns(row.getKey());
            MailingList mailingList = new MailingList();
            mailingList.setName(columnFamilyResult.getString((Object)"name"));
            mailingList.setMainArchiveUrl(columnFamilyResult.getString((Object)"mainArchiveUrl"));
            mailingList.setPostAddress(columnFamilyResult.getString((Object)"postAddress"));
            mailingList.setSubscribeAddress(columnFamilyResult.getString((Object)"subscribeAddress"));
            mailingList.setUnsubscribeAddress(columnFamilyResult.getString((Object)"unsubscribeAddress"));
            ArrayList<String> otherArchives = new ArrayList<String>();
            for (String columnName : columnFamilyResult.getColumnNames()) {
                if (!StringUtils.startsWith((String)columnName, (String)"otherArchive.")) continue;
                otherArchives.add(columnFamilyResult.getString((Object)columnName));
            }
            mailingList.setOtherArchives(otherArchives);
            mailingLists.add(mailingList);
        }
        return mailingLists;
    }

    protected void recordLicenses(String projectVersionMetadataKey, List<License> licenses) {
        if (licenses == null || licenses.isEmpty()) {
            return;
        }
        Mutator licenseMutator = this.licenseTemplate.createMutator();
        for (License license : licenses) {
            String keyLicense = UUID.randomUUID().toString();
            String cfLicense = this.cassandraArchivaManager.getLicenseFamilyName();
            CassandraUtils.addInsertion((Mutator<String>)licenseMutator, keyLicense, cfLicense, "projectVersionMetadataModel.key", projectVersionMetadataKey);
            CassandraUtils.addInsertion((Mutator<String>)licenseMutator, keyLicense, cfLicense, "name", license.getName());
            CassandraUtils.addInsertion((Mutator<String>)licenseMutator, keyLicense, cfLicense, "url", license.getUrl());
        }
        licenseMutator.execute();
    }

    protected void removeLicenses(String projectVersionMetadataKey) {
        QueryResult result = HFactory.createRangeSlicesQuery((Keyspace)this.cassandraArchivaManager.getKeyspace(), (Serializer)this.ss, (Serializer)this.ss, (Serializer)this.ss).setColumnFamily(this.cassandraArchivaManager.getLicenseFamilyName()).setColumnNames((Object[])new String[]{"name"}).setRowCount(Integer.MAX_VALUE).addEqualsExpression((Object)"projectVersionMetadataModel.key", (Object)projectVersionMetadataKey).execute();
        for (Row row : (OrderedRows)result.get()) {
            this.licenseTemplate.deleteRow(row.getKey());
        }
    }

    protected List<License> getLicenses(String projectVersionMetadataKey) {
        ArrayList<License> licenses = new ArrayList<License>();
        QueryResult result = HFactory.createRangeSlicesQuery((Keyspace)this.cassandraArchivaManager.getKeyspace(), (Serializer)this.ss, (Serializer)this.ss, (Serializer)this.ss).setColumnFamily(this.cassandraArchivaManager.getLicenseFamilyName()).setColumnNames((Object[])new String[]{"projectVersionMetadataModel.key"}).setRowCount(Integer.MAX_VALUE).addEqualsExpression((Object)"projectVersionMetadataModel.key", (Object)projectVersionMetadataKey).execute();
        for (Row row : (OrderedRows)result.get()) {
            ColumnFamilyResult columnFamilyResult = this.licenseTemplate.queryColumns(row.getKey());
            licenses.add(new License(columnFamilyResult.getString((Object)"name"), columnFamilyResult.getString((Object)"url")));
        }
        return licenses;
    }

    protected void recordDependencies(String projectVersionMetadataKey, List<Dependency> dependencies, String repositoryId) {
        if (dependencies == null || dependencies.isEmpty()) {
            return;
        }
        Mutator dependencyMutator = this.dependencyTemplate.createMutator();
        for (Dependency dependency : dependencies) {
            String keyDependency = UUID.randomUUID().toString();
            String cfDependency = this.cassandraArchivaManager.getDependencyFamilyName();
            CassandraUtils.addInsertion((Mutator<String>)dependencyMutator, keyDependency, cfDependency, "projectVersionMetadataModel.key", projectVersionMetadataKey);
            CassandraUtils.addInsertion((Mutator<String>)dependencyMutator, keyDependency, cfDependency, "repositoryName", repositoryId);
            CassandraUtils.addInsertion((Mutator<String>)dependencyMutator, keyDependency, cfDependency, "classifier", dependency.getClassifier());
            CassandraUtils.addInsertion((Mutator<String>)dependencyMutator, keyDependency, cfDependency, "optional", Boolean.toString(dependency.isOptional()));
            CassandraUtils.addInsertion((Mutator<String>)dependencyMutator, keyDependency, cfDependency, "scope", dependency.getScope());
            CassandraUtils.addInsertion((Mutator<String>)dependencyMutator, keyDependency, cfDependency, "systemPath", dependency.getSystemPath());
            CassandraUtils.addInsertion((Mutator<String>)dependencyMutator, keyDependency, cfDependency, "type", dependency.getType());
            CassandraUtils.addInsertion((Mutator<String>)dependencyMutator, keyDependency, cfDependency, "artifactId", dependency.getArtifactId());
            CassandraUtils.addInsertion((Mutator<String>)dependencyMutator, keyDependency, cfDependency, "groupId", dependency.getGroupId());
            CassandraUtils.addInsertion((Mutator<String>)dependencyMutator, keyDependency, cfDependency, "version", dependency.getVersion());
        }
        dependencyMutator.execute();
    }

    protected void removeDependencies(String projectVersionMetadataKey) {
        QueryResult result = HFactory.createRangeSlicesQuery((Keyspace)this.cassandraArchivaManager.getKeyspace(), (Serializer)this.ss, (Serializer)this.ss, (Serializer)this.ss).setColumnFamily(this.cassandraArchivaManager.getDependencyFamilyName()).setColumnNames((Object[])new String[]{"groupId"}).setRowCount(Integer.MAX_VALUE).addEqualsExpression((Object)"projectVersionMetadataModel.key", (Object)projectVersionMetadataKey).execute();
        for (Row row : (OrderedRows)result.get()) {
            this.dependencyTemplate.deleteRow(row.getKey());
        }
    }

    protected List<Dependency> getDependencies(String projectVersionMetadataKey) {
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
        QueryResult result = HFactory.createRangeSlicesQuery((Keyspace)this.cassandraArchivaManager.getKeyspace(), (Serializer)this.ss, (Serializer)this.ss, (Serializer)this.ss).setColumnFamily(this.cassandraArchivaManager.getDependencyFamilyName()).setColumnNames((Object[])new String[]{"projectVersionMetadataModel.key"}).setRowCount(Integer.MAX_VALUE).addEqualsExpression((Object)"projectVersionMetadataModel.key", (Object)projectVersionMetadataKey).execute();
        for (Row row : (OrderedRows)result.get()) {
            ColumnFamilyResult columnFamilyResult = this.dependencyTemplate.queryColumns(row.getKey());
            Dependency dependency = new Dependency();
            dependency.setClassifier(columnFamilyResult.getString((Object)"classifier"));
            dependency.setOptional(Boolean.parseBoolean(columnFamilyResult.getString((Object)"optional")));
            dependency.setScope(columnFamilyResult.getString((Object)"scope"));
            dependency.setSystemPath(columnFamilyResult.getString((Object)"systemPath"));
            dependency.setType(columnFamilyResult.getString((Object)"type"));
            dependency.setArtifactId(columnFamilyResult.getString((Object)"artifactId"));
            dependency.setGroupId(columnFamilyResult.getString((Object)"groupId"));
            dependency.setVersion(columnFamilyResult.getString((Object)"version"));
            dependencies.add(dependency);
        }
        return dependencies;
    }

    public void updateArtifact(String repositoryId, String namespaceId, String projectId, String projectVersion, ArtifactMetadata artifactMeta) throws MetadataRepositoryException {
        Namespace namespace = this.getNamespace(repositoryId, namespaceId);
        if (namespace == null) {
            namespace = this.updateOrAddNamespace(repositoryId, namespaceId);
        }
        ProjectMetadata projectMetadata = new ProjectMetadata();
        projectMetadata.setId(projectId);
        projectMetadata.setNamespace(namespaceId);
        this.updateProject(repositoryId, projectMetadata);
        String key = new ArtifactMetadataModel.KeyBuilder().withNamespace(namespace).withProject(projectId).withId(artifactMeta.getId()).withProjectVersion(projectVersion).build();
        boolean exists = this.artifactMetadataTemplate.isColumnsExist((Object)key);
        if (exists) {
            ColumnFamilyUpdater updater = this.artifactMetadataTemplate.createUpdater((Object)key);
            updater.setLong((Object)"fileLastModified", Long.valueOf(artifactMeta.getFileLastModified().getTime()));
            updater.setLong((Object)"whenGathered", Long.valueOf(artifactMeta.getWhenGathered().getTime()));
            updater.setLong((Object)"size", Long.valueOf(artifactMeta.getSize()));
            CassandraUtils.addUpdateStringValue((ColumnFamilyUpdater<String, String>)updater, "md5", artifactMeta.getMd5());
            CassandraUtils.addUpdateStringValue((ColumnFamilyUpdater<String, String>)updater, "sha1", artifactMeta.getSha1());
            CassandraUtils.addUpdateStringValue((ColumnFamilyUpdater<String, String>)updater, "version", artifactMeta.getVersion());
            this.artifactMetadataTemplate.update(updater);
        } else {
            String cf = this.cassandraArchivaManager.getArtifactMetadataFamilyName();
            this.artifactMetadataTemplate.createMutator().addInsertion((Object)key, cf, CassandraUtils.column("id", artifactMeta.getId())).addInsertion((Object)key, cf, CassandraUtils.column("repositoryName", repositoryId)).addInsertion((Object)key, cf, CassandraUtils.column("namespaceId", namespaceId)).addInsertion((Object)key, cf, CassandraUtils.column("project", artifactMeta.getProject())).addInsertion((Object)key, cf, CassandraUtils.column("projectVersion", projectVersion)).addInsertion((Object)key, cf, CassandraUtils.column("version", artifactMeta.getVersion())).addInsertion((Object)key, cf, CassandraUtils.column("fileLastModified", artifactMeta.getFileLastModified().getTime())).addInsertion((Object)key, cf, CassandraUtils.column("size", artifactMeta.getSize())).addInsertion((Object)key, cf, CassandraUtils.column("md5", artifactMeta.getMd5())).addInsertion((Object)key, cf, CassandraUtils.column("sha1", artifactMeta.getSha1())).addInsertion((Object)key, cf, CassandraUtils.column("whenGathered", artifactMeta.getWhenGathered().getTime())).execute();
        }
        key = new ProjectVersionMetadataModel.KeyBuilder().withRepository(repositoryId).withNamespace(namespace).withProjectId(projectId).withProjectVersion(projectVersion).withId(artifactMeta.getId()).build();
        QueryResult result = HFactory.createRangeSlicesQuery((Keyspace)this.keyspace, (Serializer)this.ss, (Serializer)this.ss, (Serializer)this.ss).setColumnFamily(this.cassandraArchivaManager.getProjectVersionMetadataFamilyName()).setColumnNames((Object[])new String[]{"version"}).addEqualsExpression((Object)"repositoryName", (Object)repositoryId).addEqualsExpression((Object)"namespaceId", (Object)namespaceId).addEqualsExpression((Object)"projectId", (Object)projectId).addEqualsExpression((Object)"projectVersion", (Object)projectVersion).addEqualsExpression((Object)"version", (Object)artifactMeta.getVersion()).execute();
        boolean bl = exists = ((OrderedRows)result.get()).getCount() > 0;
        if (!exists) {
            String cf = this.cassandraArchivaManager.getProjectVersionMetadataFamilyName();
            this.projectVersionMetadataTemplate.createMutator().addInsertion((Object)key, cf, CassandraUtils.column("namespaceId", namespace.getName())).addInsertion((Object)key, cf, CassandraUtils.column("repositoryName", repositoryId)).addInsertion((Object)key, cf, CassandraUtils.column("projectVersion", projectVersion)).addInsertion((Object)key, cf, CassandraUtils.column("projectId", projectId)).addInsertion((Object)key, cf, CassandraUtils.column("version", artifactMeta.getVersion())).execute();
        }
        ArtifactMetadataModel artifactMetadataModel = new ArtifactMetadataModel();
        artifactMetadataModel.setRepositoryId(repositoryId);
        artifactMetadataModel.setNamespace(namespaceId);
        artifactMetadataModel.setProject(projectId);
        artifactMetadataModel.setProjectVersion(projectVersion);
        artifactMetadataModel.setVersion(artifactMeta.getVersion());
        artifactMetadataModel.setFileLastModified(artifactMeta.getFileLastModified() == null ? new Date().getTime() : artifactMeta.getFileLastModified().getTime());
        this.updateFacets((FacetedMetadata)artifactMeta, artifactMetadataModel);
    }

    public Collection<String> getArtifactVersions(String repoId, String namespace, String projectId, String projectVersion) throws MetadataResolutionException {
        QueryResult result = HFactory.createRangeSlicesQuery((Keyspace)this.keyspace, (Serializer)this.ss, (Serializer)this.ss, (Serializer)this.ss).setColumnFamily(this.cassandraArchivaManager.getProjectVersionMetadataFamilyName()).setColumnNames((Object[])new String[]{"version"}).addEqualsExpression((Object)"repositoryName", (Object)repoId).addEqualsExpression((Object)"namespaceId", (Object)namespace).addEqualsExpression((Object)"projectId", (Object)projectId).addEqualsExpression((Object)"projectVersion", (Object)projectVersion).execute();
        HashSet<String> versions = new HashSet<String>();
        for (Row row : (OrderedRows)result.get()) {
            versions.add(CassandraUtils.getStringValue((ColumnSlice<String, String>)row.getColumnSlice(), "version"));
        }
        return versions;
    }

    private void updateFacets(FacetedMetadata facetedMetadata, ArtifactMetadataModel artifactMetadataModel) {
        String cf = this.cassandraArchivaManager.getMetadataFacetFamilyName();
        for (String facetId : this.metadataFacetFactories.keySet()) {
            MetadataFacet metadataFacet = facetedMetadata.getFacet(facetId);
            if (metadataFacet == null) continue;
            QueryResult result = HFactory.createRangeSlicesQuery((Keyspace)this.keyspace, (Serializer)this.ss, (Serializer)this.ss, (Serializer)this.ss).setColumnFamily(cf).setColumnNames((Object[])new String[]{"repositoryName"}).addEqualsExpression((Object)"repositoryName", (Object)artifactMetadataModel.getRepositoryId()).addEqualsExpression((Object)"namespaceId", (Object)artifactMetadataModel.getNamespace()).addEqualsExpression((Object)"projectId", (Object)artifactMetadataModel.getProject()).addEqualsExpression((Object)"projectVersion", (Object)artifactMetadataModel.getProjectVersion()).addEqualsExpression((Object)"facetId", (Object)facetId).execute();
            for (Row row : ((OrderedRows)result.get()).getList()) {
                this.metadataFacetTemplate.deleteRow(row.getKey());
            }
            Map properties = metadataFacet.toProperties();
            for (Map.Entry entry : properties.entrySet()) {
                String key = new MetadataFacetModel.KeyBuilder().withKey((String)entry.getKey()).withArtifactMetadataModel(artifactMetadataModel).withFacetId(facetId).withName(metadataFacet.getName()).build();
                Mutator mutator = this.metadataFacetTemplate.createMutator().addInsertion((Object)key, cf, CassandraUtils.column("repositoryName", artifactMetadataModel.getRepositoryId())).addInsertion((Object)key, cf, CassandraUtils.column("namespaceId", artifactMetadataModel.getNamespace())).addInsertion((Object)key, cf, CassandraUtils.column("projectId", artifactMetadataModel.getProject())).addInsertion((Object)key, cf, CassandraUtils.column("projectVersion", artifactMetadataModel.getProjectVersion())).addInsertion((Object)key, cf, CassandraUtils.column("facetId", facetId)).addInsertion((Object)key, cf, CassandraUtils.column("key", entry.getKey())).addInsertion((Object)key, cf, CassandraUtils.column("value", entry.getValue()));
                if (metadataFacet.getName() != null) {
                    mutator.addInsertion((Object)key, cf, CassandraUtils.column("name", metadataFacet.getName()));
                }
                mutator.execute();
            }
        }
    }

    public List<String> getMetadataFacets(String repositoryId, String facetId) throws MetadataRepositoryException {
        QueryResult result = HFactory.createRangeSlicesQuery((Keyspace)this.keyspace, (Serializer)this.ss, (Serializer)this.ss, (Serializer)this.ss).setColumnFamily(this.cassandraArchivaManager.getMetadataFacetFamilyName()).setColumnNames((Object[])new String[]{"name"}).addEqualsExpression((Object)"repositoryName", (Object)repositoryId).addEqualsExpression((Object)"facetId", (Object)facetId).execute();
        ArrayList<String> facets = new ArrayList<String>();
        for (Row row : (OrderedRows)result.get()) {
            facets.add(CassandraUtils.getStringValue((ColumnSlice<String, String>)row.getColumnSlice(), "name"));
        }
        return facets;
    }

    public boolean hasMetadataFacet(String repositoryId, String facetId) throws MetadataRepositoryException {
        return !this.getMetadataFacets(repositoryId, facetId).isEmpty();
    }

    public MetadataFacet getMetadataFacet(String repositoryId, String facetId, String name) throws MetadataRepositoryException {
        MetadataFacetFactory metadataFacetFactory = this.metadataFacetFactories.get(facetId);
        if (metadataFacetFactory == null) {
            return null;
        }
        QueryResult result = HFactory.createRangeSlicesQuery((Keyspace)this.keyspace, (Serializer)this.ss, (Serializer)this.ss, (Serializer)this.ss).setColumnFamily(this.cassandraArchivaManager.getMetadataFacetFamilyName()).setColumnNames((Object[])new String[]{"key", "value"}).addEqualsExpression((Object)"repositoryName", (Object)repositoryId).addEqualsExpression((Object)"facetId", (Object)facetId).addEqualsExpression((Object)"name", (Object)name).execute();
        MetadataFacet metadataFacet = metadataFacetFactory.createMetadataFacet(repositoryId, name);
        int size = ((OrderedRows)result.get()).getCount();
        if (size < 1) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>(size);
        for (Row row : (OrderedRows)result.get()) {
            ColumnSlice columnSlice = row.getColumnSlice();
            map.put(CassandraUtils.getStringValue((ColumnSlice<String, String>)columnSlice, "key"), CassandraUtils.getStringValue((ColumnSlice<String, String>)columnSlice, "value"));
        }
        metadataFacet.fromProperties(map);
        return metadataFacet;
    }

    public void addMetadataFacet(String repositoryId, MetadataFacet metadataFacet) throws MetadataRepositoryException {
        if (metadataFacet == null) {
            return;
        }
        if (metadataFacet.toProperties().isEmpty()) {
            String key = new MetadataFacetModel.KeyBuilder().withRepositoryId(repositoryId).withFacetId(metadataFacet.getFacetId()).withName(metadataFacet.getName()).build();
            boolean exists = this.metadataFacetTemplate.isColumnsExist((Object)key);
            if (exists) {
                ColumnFamilyUpdater updater = this.metadataFacetTemplate.createUpdater((Object)key);
                CassandraUtils.addUpdateStringValue((ColumnFamilyUpdater<String, String>)updater, "facetId", metadataFacet.getFacetId());
                CassandraUtils.addUpdateStringValue((ColumnFamilyUpdater<String, String>)updater, "name", metadataFacet.getName());
                this.metadataFacetTemplate.update(updater);
            } else {
                String cf = this.cassandraArchivaManager.getMetadataFacetFamilyName();
                this.metadataFacetTemplate.createMutator().addInsertion((Object)key, cf, CassandraUtils.column("repositoryName", repositoryId)).addInsertion((Object)key, cf, CassandraUtils.column("facetId", metadataFacet.getFacetId())).addInsertion((Object)key, cf, CassandraUtils.column("name", metadataFacet.getName())).execute();
            }
        } else {
            for (Map.Entry entry : metadataFacet.toProperties().entrySet()) {
                String key = new MetadataFacetModel.KeyBuilder().withRepositoryId(repositoryId).withFacetId(metadataFacet.getFacetId()).withName(metadataFacet.getName()).withKey((String)entry.getKey()).build();
                boolean exists = this.metadataFacetTemplate.isColumnsExist((Object)key);
                if (!exists) {
                    String cf = this.cassandraArchivaManager.getMetadataFacetFamilyName();
                    this.metadataFacetTemplate.createMutator().addInsertion((Object)key, cf, CassandraUtils.column("repositoryName", repositoryId)).addInsertion((Object)key, cf, CassandraUtils.column("facetId", metadataFacet.getFacetId())).addInsertion((Object)key, cf, CassandraUtils.column("name", metadataFacet.getName())).addInsertion((Object)key, cf, CassandraUtils.column("key", entry.getKey())).addInsertion((Object)key, cf, CassandraUtils.column("value", entry.getValue())).execute();
                    continue;
                }
                ColumnFamilyUpdater updater = this.metadataFacetTemplate.createUpdater((Object)key);
                CassandraUtils.addUpdateStringValue((ColumnFamilyUpdater<String, String>)updater, "value", (String)entry.getValue());
                this.metadataFacetTemplate.update(updater);
            }
        }
    }

    public void removeMetadataFacets(String repositoryId, String facetId) throws MetadataRepositoryException {
        QueryResult result = HFactory.createRangeSlicesQuery((Keyspace)this.keyspace, (Serializer)this.ss, (Serializer)this.ss, (Serializer)this.ss).setColumnFamily(this.cassandraArchivaManager.getMetadataFacetFamilyName()).setColumnNames((Object[])new String[]{"key", "value"}).addEqualsExpression((Object)"repositoryName", (Object)repositoryId).addEqualsExpression((Object)"facetId", (Object)facetId).execute();
        for (Row row : (OrderedRows)result.get()) {
            this.metadataFacetTemplate.deleteRow(row.getKey());
        }
    }

    public void removeMetadataFacet(String repositoryId, String facetId, String name) throws MetadataRepositoryException {
        QueryResult result = HFactory.createRangeSlicesQuery((Keyspace)this.keyspace, (Serializer)this.ss, (Serializer)this.ss, (Serializer)this.ss).setColumnFamily(this.cassandraArchivaManager.getMetadataFacetFamilyName()).setColumnNames((Object[])new String[]{"key", "value"}).addEqualsExpression((Object)"repositoryName", (Object)repositoryId).addEqualsExpression((Object)"facetId", (Object)facetId).addEqualsExpression((Object)"name", (Object)name).execute();
        for (Row row : (OrderedRows)result.get()) {
            this.metadataFacetTemplate.deleteRow(row.getKey());
        }
    }

    public List<ArtifactMetadata> getArtifactsByDateRange(String repositoryId, Date startTime, Date endTime) throws MetadataRepositoryException {
        LongSerializer ls = LongSerializer.get();
        RangeSlicesQuery query = HFactory.createRangeSlicesQuery((Keyspace)this.keyspace, (Serializer)this.ss, (Serializer)this.ss, (Serializer)ls).setColumnFamily(this.cassandraArchivaManager.getArtifactMetadataFamilyName()).setColumnNames((Object[])new String[]{"namespaceId", "size", "id", "fileLastModified", "md5", "project", "projectVersion", "repositoryName", "version", "whenGathered", "sha1"});
        if (startTime != null) {
            query = query.addGteExpression((Object)"whenGathered", (Object)startTime.getTime());
        }
        if (endTime != null) {
            query = query.addLteExpression((Object)"whenGathered", (Object)endTime.getTime());
        }
        QueryResult result = query.execute();
        ArrayList<ArtifactMetadata> artifactMetadatas = new ArrayList<ArtifactMetadata>(((OrderedRows)result.get()).getCount());
        for (Row row : (OrderedRows)result.get()) {
            ColumnSlice columnSlice = row.getColumnSlice();
            String repositoryName = CassandraUtils.getAsStringValue((ColumnSlice<String, Long>)columnSlice, "repositoryName");
            if (!StringUtils.equals((String)repositoryName, (String)repositoryId)) continue;
            artifactMetadatas.add(this.mapArtifactMetadataLongColumnSlice((ColumnSlice<String, Long>)columnSlice));
        }
        return artifactMetadatas;
    }

    protected ArtifactMetadata mapArtifactMetadataLongColumnSlice(ColumnSlice<String, Long> columnSlice) {
        ArtifactMetadata artifactMetadata = new ArtifactMetadata();
        artifactMetadata.setNamespace(CassandraUtils.getAsStringValue(columnSlice, "namespaceId"));
        artifactMetadata.setSize(CassandraUtils.getLongValue(columnSlice, "size").longValue());
        artifactMetadata.setId(CassandraUtils.getAsStringValue(columnSlice, "id"));
        artifactMetadata.setFileLastModified(CassandraUtils.getLongValue(columnSlice, "fileLastModified").longValue());
        artifactMetadata.setMd5(CassandraUtils.getAsStringValue(columnSlice, "md5"));
        artifactMetadata.setProject(CassandraUtils.getAsStringValue(columnSlice, "project"));
        artifactMetadata.setProjectVersion(CassandraUtils.getAsStringValue(columnSlice, "projectVersion"));
        artifactMetadata.setRepositoryId(CassandraUtils.getAsStringValue(columnSlice, "repositoryName"));
        artifactMetadata.setSha1(CassandraUtils.getAsStringValue(columnSlice, "sha1"));
        artifactMetadata.setVersion(CassandraUtils.getAsStringValue(columnSlice, "version"));
        Long whenGathered = CassandraUtils.getLongValue(columnSlice, "whenGathered");
        if (whenGathered != null) {
            artifactMetadata.setWhenGathered(new Date(whenGathered));
        }
        return artifactMetadata;
    }

    protected ArtifactMetadata mapArtifactMetadataStringColumnSlice(ColumnSlice<String, String> columnSlice) {
        ArtifactMetadata artifactMetadata = new ArtifactMetadata();
        artifactMetadata.setNamespace(CassandraUtils.getStringValue(columnSlice, "namespaceId"));
        artifactMetadata.setSize(CassandraUtils.getAsLongValue(columnSlice, "size").longValue());
        artifactMetadata.setId(CassandraUtils.getStringValue(columnSlice, "id"));
        artifactMetadata.setFileLastModified(CassandraUtils.getAsLongValue(columnSlice, "fileLastModified").longValue());
        artifactMetadata.setMd5(CassandraUtils.getStringValue(columnSlice, "md5"));
        artifactMetadata.setProject(CassandraUtils.getStringValue(columnSlice, "project"));
        artifactMetadata.setProjectVersion(CassandraUtils.getStringValue(columnSlice, "projectVersion"));
        artifactMetadata.setRepositoryId(CassandraUtils.getStringValue(columnSlice, "repositoryName"));
        artifactMetadata.setSha1(CassandraUtils.getStringValue(columnSlice, "sha1"));
        artifactMetadata.setVersion(CassandraUtils.getStringValue(columnSlice, "version"));
        Long whenGathered = CassandraUtils.getAsLongValue(columnSlice, "whenGathered");
        if (whenGathered != null) {
            artifactMetadata.setWhenGathered(new Date(whenGathered));
        }
        return artifactMetadata;
    }

    public Collection<ArtifactMetadata> getArtifactsByChecksum(String repositoryId, String checksum) throws MetadataRepositoryException {
        ColumnSlice columnSlice;
        HashMap<Object, ArtifactMetadata> artifactMetadataMap = new HashMap<Object, ArtifactMetadata>();
        RangeSlicesQuery query = HFactory.createRangeSlicesQuery((Keyspace)this.keyspace, (Serializer)this.ss, (Serializer)this.ss, (Serializer)this.ss).setColumnFamily(this.cassandraArchivaManager.getArtifactMetadataFamilyName()).setColumnNames((Object[])new String[]{"namespaceId", "size", "id", "fileLastModified", "md5", "project", "projectVersion", "repositoryName", "version", "whenGathered", "sha1"});
        query = query.addEqualsExpression((Object)"sha1", (Object)checksum).addEqualsExpression((Object)"repositoryName", (Object)repositoryId);
        QueryResult result = query.execute();
        for (Row row : (OrderedRows)result.get()) {
            columnSlice = row.getColumnSlice();
            artifactMetadataMap.put(row.getKey(), this.mapArtifactMetadataStringColumnSlice((ColumnSlice<String, String>)columnSlice));
        }
        query = HFactory.createRangeSlicesQuery((Keyspace)this.keyspace, (Serializer)this.ss, (Serializer)this.ss, (Serializer)this.ss).setColumnFamily(this.cassandraArchivaManager.getArtifactMetadataFamilyName()).setColumnNames((Object[])new String[]{"namespaceId", "size", "id", "fileLastModified", "md5", "project", "projectVersion", "repositoryName", "version", "whenGathered", "sha1"});
        query = query.addEqualsExpression((Object)"md5", (Object)checksum).addEqualsExpression((Object)"repositoryName", (Object)repositoryId);
        result = query.execute();
        for (Row row : (OrderedRows)result.get()) {
            columnSlice = row.getColumnSlice();
            artifactMetadataMap.put(row.getKey(), this.mapArtifactMetadataStringColumnSlice((ColumnSlice<String, String>)columnSlice));
        }
        return artifactMetadataMap.values();
    }

    public void removeArtifact(String repositoryId, String namespace, String project, String version, String id) throws MetadataRepositoryException {
        this.logger.debug("removeArtifact repositoryId: '{}', namespace: '{}', project: '{}', version: '{}', id: '{}'", new Object[]{repositoryId, namespace, project, version, id});
        String key = new ArtifactMetadataModel.KeyBuilder().withRepositoryId(repositoryId).withNamespace(namespace).withId(id).withProjectVersion(version).withProject(project).build();
        this.artifactMetadataTemplate.deleteRow((Object)key);
        key = new ProjectVersionMetadataModel.KeyBuilder().withRepository(repositoryId).withNamespace(namespace).withProjectId(project).withProjectVersion(version).withId(id).build();
        this.projectVersionMetadataTemplate.deleteRow((Object)key);
    }

    public void removeArtifact(ArtifactMetadata artifactMetadata, String baseVersion) throws MetadataRepositoryException {
        this.logger.debug("removeArtifact repositoryId: '{}', namespace: '{}', project: '{}', version: '{}', id: '{}'", new Object[]{artifactMetadata.getRepositoryId(), artifactMetadata.getNamespace(), artifactMetadata.getProject(), baseVersion, artifactMetadata.getId()});
        String key = new ArtifactMetadataModel.KeyBuilder().withRepositoryId(artifactMetadata.getRepositoryId()).withNamespace(artifactMetadata.getNamespace()).withId(artifactMetadata.getId()).withProjectVersion(baseVersion).withProject(artifactMetadata.getProject()).build();
        this.artifactMetadataTemplate.deleteRow((Object)key);
    }

    public void removeArtifact(String repositoryId, String namespace, String project, String version, MetadataFacet metadataFacet) throws MetadataRepositoryException {
        RangeSlicesQuery query = HFactory.createRangeSlicesQuery((Keyspace)this.keyspace, (Serializer)this.ss, (Serializer)this.ss, (Serializer)this.ss).setColumnFamily(this.cassandraArchivaManager.getArtifactMetadataFamilyName()).setColumnNames((Object[])new String[]{"namespaceId"});
        query = query.addEqualsExpression((Object)"repositoryName", (Object)repositoryId).addEqualsExpression((Object)"namespaceId", (Object)namespace).addEqualsExpression((Object)"project", (Object)project).addEqualsExpression((Object)"version", (Object)version);
        QueryResult result = query.execute();
        for (Row row : (OrderedRows)result.get()) {
            this.artifactMetadataTemplate.deleteRow(row.getKey());
        }
    }

    public List<ArtifactMetadata> getArtifacts(String repositoryId) throws MetadataRepositoryException {
        RangeSlicesQuery query = HFactory.createRangeSlicesQuery((Keyspace)this.keyspace, (Serializer)this.ss, (Serializer)this.ss, (Serializer)this.ss).setColumnFamily(this.cassandraArchivaManager.getArtifactMetadataFamilyName()).setColumnNames((Object[])new String[]{"namespaceId", "size", "id", "fileLastModified", "md5", "project", "projectVersion", "repositoryName", "version", "whenGathered", "sha1"});
        query = query.addEqualsExpression((Object)"repositoryName", (Object)repositoryId);
        QueryResult result = query.execute();
        ArrayList<ArtifactMetadata> artifactMetadatas = new ArrayList<ArtifactMetadata>(((OrderedRows)result.get()).getCount());
        for (Row row : (OrderedRows)result.get()) {
            ColumnSlice columnSlice = row.getColumnSlice();
            artifactMetadatas.add(this.mapArtifactMetadataStringColumnSlice((ColumnSlice<String, String>)columnSlice));
        }
        return artifactMetadatas;
    }

    public Collection<ProjectVersionReference> getProjectReferences(String repoId, String namespace, String projectId, String projectVersion) throws MetadataResolutionException {
        QueryResult result = HFactory.createRangeSlicesQuery((Keyspace)this.keyspace, (Serializer)this.ss, (Serializer)this.ss, (Serializer)this.ss).setColumnFamily(this.cassandraArchivaManager.getDependencyFamilyName()).setColumnNames((Object[])new String[]{"projectVersionMetadataModel.key"}).addEqualsExpression((Object)"repositoryName", (Object)repoId).addEqualsExpression((Object)"groupId", (Object)namespace).addEqualsExpression((Object)"artifactId", (Object)projectId).addEqualsExpression((Object)"version", (Object)projectVersion).execute();
        ArrayList<String> dependenciesIds = new ArrayList<String>(((OrderedRows)result.get()).getCount());
        for (Row row : ((OrderedRows)result.get()).getList()) {
            dependenciesIds.add(CassandraUtils.getStringValue((ColumnSlice<String, String>)row.getColumnSlice(), "projectVersionMetadataModel.key"));
        }
        ArrayList<ProjectVersionReference> references = new ArrayList<ProjectVersionReference>(((OrderedRows)result.get()).getCount());
        for (String key : dependenciesIds) {
            ColumnFamilyResult columnFamilyResult = this.projectVersionMetadataTemplate.queryColumns((Object)key);
            references.add(new ProjectVersionReference(ProjectVersionReference.ReferenceType.DEPENDENCY, columnFamilyResult.getString((Object)"projectId"), columnFamilyResult.getString((Object)"namespaceId"), columnFamilyResult.getString((Object)"projectVersion")));
        }
        return references;
    }

    public void removeProjectVersion(String repoId, String namespace, String projectId, String projectVersion) throws MetadataRepositoryException {
        QueryResult result = HFactory.createRangeSlicesQuery((Keyspace)this.keyspace, (Serializer)this.ss, (Serializer)this.ss, (Serializer)this.ss).setColumnFamily(this.cassandraArchivaManager.getProjectVersionMetadataFamilyName()).setColumnNames((Object[])new String[]{"version"}).addEqualsExpression((Object)"repositoryName", (Object)repoId).addEqualsExpression((Object)"namespaceId", (Object)namespace).addEqualsExpression((Object)"projectId", (Object)projectId).addEqualsExpression((Object)"projectVersion", (Object)projectVersion).execute();
        for (Row row : ((OrderedRows)result.get()).getList()) {
            this.projectVersionMetadataTemplate.deleteRow(row.getKey());
            this.removeMailingList((String)row.getKey());
            this.removeLicenses((String)row.getKey());
            this.removeDependencies((String)row.getKey());
        }
        RangeSlicesQuery query = HFactory.createRangeSlicesQuery((Keyspace)this.keyspace, (Serializer)this.ss, (Serializer)this.ss, (Serializer)this.ss).setColumnFamily(this.cassandraArchivaManager.getArtifactMetadataFamilyName()).setColumnNames((Object[])new String[]{"namespaceId"});
        query = query.addEqualsExpression((Object)"repositoryName", (Object)repoId).addEqualsExpression((Object)"namespaceId", (Object)namespace).addEqualsExpression((Object)"project", (Object)projectId).addEqualsExpression((Object)"projectVersion", (Object)projectVersion);
        result = query.execute();
        for (Row row : (OrderedRows)result.get()) {
            this.artifactMetadataTemplate.deleteRow(row.getKey());
        }
    }

    public Collection<ArtifactMetadata> getArtifacts(String repoId, String namespace, String projectId, String projectVersion) throws MetadataResolutionException {
        QueryResult result = HFactory.createRangeSlicesQuery((Keyspace)this.keyspace, (Serializer)this.ss, (Serializer)this.ss, (Serializer)this.ss).setColumnFamily(this.cassandraArchivaManager.getArtifactMetadataFamilyName()).setColumnNames((Object[])new String[]{"id", "repositoryName", "namespaceId", "project", "projectVersion", "version", "fileLastModified", "size", "md5", "sha1", "whenGathered"}).setRowCount(Integer.MAX_VALUE).addEqualsExpression((Object)"repositoryName", (Object)repoId).addEqualsExpression((Object)"namespaceId", (Object)namespace).addEqualsExpression((Object)"project", (Object)projectId).addEqualsExpression((Object)"projectVersion", (Object)projectVersion).execute();
        if (result.get() == null || ((OrderedRows)result.get()).getCount() < 1) {
            return Collections.emptyList();
        }
        ArrayList<ArtifactMetadata> artifactMetadatas = new ArrayList<ArtifactMetadata>(((OrderedRows)result.get()).getCount());
        for (Row row : (OrderedRows)result.get()) {
            ColumnSlice columnSlice = row.getColumnSlice();
            ArtifactMetadata artifactMetadata = new ArtifactMetadata();
            artifactMetadata.setNamespace(CassandraUtils.getStringValue((ColumnSlice<String, String>)columnSlice, "namespaceId"));
            artifactMetadata.setSize(CassandraUtils.getAsLongValue((ColumnSlice<String, String>)columnSlice, "size").longValue());
            artifactMetadata.setId(CassandraUtils.getStringValue((ColumnSlice<String, String>)columnSlice, "id"));
            artifactMetadata.setFileLastModified(CassandraUtils.getAsLongValue((ColumnSlice<String, String>)columnSlice, "fileLastModified").longValue());
            artifactMetadata.setMd5(CassandraUtils.getStringValue((ColumnSlice<String, String>)columnSlice, "md5"));
            artifactMetadata.setProject(CassandraUtils.getStringValue((ColumnSlice<String, String>)columnSlice, "project"));
            artifactMetadata.setProjectVersion(CassandraUtils.getStringValue((ColumnSlice<String, String>)columnSlice, "projectVersion"));
            artifactMetadata.setRepositoryId(repoId);
            artifactMetadata.setSha1(CassandraUtils.getStringValue((ColumnSlice<String, String>)columnSlice, "sha1"));
            artifactMetadata.setVersion(CassandraUtils.getStringValue((ColumnSlice<String, String>)columnSlice, "version"));
            Long whenGathered = CassandraUtils.getAsLongValue((ColumnSlice<String, String>)columnSlice, "whenGathered");
            if (whenGathered != null) {
                artifactMetadata.setWhenGathered(new Date(whenGathered));
            }
            artifactMetadatas.add(artifactMetadata);
        }
        result = HFactory.createRangeSlicesQuery((Keyspace)this.keyspace, (Serializer)this.ss, (Serializer)this.ss, (Serializer)this.ss).setColumnFamily(this.cassandraArchivaManager.getMetadataFacetFamilyName()).setColumnNames((Object[])new String[]{"facetId", "name", "value", "key", "projectVersion"}).setRowCount(Integer.MAX_VALUE).addEqualsExpression((Object)"repositoryName", (Object)repoId).addEqualsExpression((Object)"namespaceId", (Object)namespace).addEqualsExpression((Object)"projectId", (Object)projectId).addEqualsExpression((Object)"projectVersion", (Object)projectVersion).execute();
        if (result.get() == null || ((OrderedRows)result.get()).getCount() < 1) {
            return artifactMetadatas;
        }
        ArrayList<MetadataFacetModel> metadataFacetModels = new ArrayList<MetadataFacetModel>(((OrderedRows)result.get()).getCount());
        for (Row row : (OrderedRows)result.get()) {
            ColumnSlice columnSlice = row.getColumnSlice();
            MetadataFacetModel metadataFacetModel = new MetadataFacetModel();
            metadataFacetModel.setFacetId(CassandraUtils.getStringValue((ColumnSlice<String, String>)columnSlice, "facetId"));
            metadataFacetModel.setName(CassandraUtils.getStringValue((ColumnSlice<String, String>)columnSlice, "name"));
            metadataFacetModel.setValue(CassandraUtils.getStringValue((ColumnSlice<String, String>)columnSlice, "value"));
            metadataFacetModel.setKey(CassandraUtils.getStringValue((ColumnSlice<String, String>)columnSlice, "key"));
            metadataFacetModel.setProjectVersion(CassandraUtils.getStringValue((ColumnSlice<String, String>)columnSlice, "projectVersion"));
            metadataFacetModels.add(metadataFacetModel);
        }
        for (final ArtifactMetadata artifactMetadata : artifactMetadatas) {
            Iterable metadataFacetModelIterable = Iterables.filter(metadataFacetModels, (Predicate)new Predicate<MetadataFacetModel>(){

                public boolean apply(MetadataFacetModel metadataFacetModel) {
                    if (metadataFacetModel != null) {
                        return StringUtils.equals((String)artifactMetadata.getVersion(), (String)metadataFacetModel.getProjectVersion());
                    }
                    return false;
                }
            });
            Iterator iterator = metadataFacetModelIterable.iterator();
            HashMap<String, ArrayList<MetadataFacetModel>> metadataFacetValuesPerFacetId = new HashMap<String, ArrayList<MetadataFacetModel>>();
            while (iterator.hasNext()) {
                MetadataFacetModel metadataFacetModel = (MetadataFacetModel)iterator.next();
                ArrayList<MetadataFacetModel> values = (ArrayList<MetadataFacetModel>)metadataFacetValuesPerFacetId.get(metadataFacetModel.getName());
                if (values == null) {
                    values = new ArrayList<MetadataFacetModel>();
                    metadataFacetValuesPerFacetId.put(metadataFacetModel.getFacetId(), values);
                }
                values.add(metadataFacetModel);
            }
            for (Map.Entry entry : metadataFacetValuesPerFacetId.entrySet()) {
                List facetModels;
                MetadataFacetFactory metadataFacetFactory = this.metadataFacetFactories.get(entry.getKey());
                if (metadataFacetFactory == null || (facetModels = (List)entry.getValue()).isEmpty()) continue;
                MetadataFacet metadataFacet = metadataFacetFactory.createMetadataFacet();
                HashMap<String, String> props = new HashMap<String, String>(facetModels.size());
                for (MetadataFacetModel metadataFacetModel : facetModels) {
                    props.put(metadataFacetModel.getKey(), metadataFacetModel.getValue());
                }
                metadataFacet.fromProperties(props);
                artifactMetadata.addFacet(metadataFacet);
            }
        }
        return artifactMetadatas;
    }

    public void save() {
        this.logger.trace("save");
    }

    public void close() throws MetadataRepositoryException {
        this.logger.trace("close");
    }

    public void revert() {
        this.logger.warn("CassandraMetadataRepository cannot revert");
    }

    public boolean canObtainAccess(Class<?> aClass) {
        return false;
    }

    public <T> T obtainAccess(Class<T> aClass) throws MetadataRepositoryException {
        throw new IllegalArgumentException("Access using " + aClass + " is not supported on the cassandra metadata storage");
    }

    protected ModelMapper getModelMapper() {
        return ModelMapperHolder.MODEL_MAPPER;
    }

    private static class ModelMapperHolder {
        private static ModelMapper MODEL_MAPPER = new ModelMapper();

        private ModelMapperHolder() {
        }
    }
}

