/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.metadata.repository.cassandra;

import java.util.ArrayList;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import me.prettyprint.cassandra.model.BasicColumnDefinition;
import me.prettyprint.cassandra.model.ConfigurableConsistencyLevel;
import me.prettyprint.cassandra.serializers.StringSerializer;
import me.prettyprint.cassandra.service.CassandraHostConfigurator;
import me.prettyprint.hector.api.Cluster;
import me.prettyprint.hector.api.ConsistencyLevelPolicy;
import me.prettyprint.hector.api.HConsistencyLevel;
import me.prettyprint.hector.api.Keyspace;
import me.prettyprint.hector.api.ddl.ColumnDefinition;
import me.prettyprint.hector.api.ddl.ColumnFamilyDefinition;
import me.prettyprint.hector.api.ddl.ColumnIndexType;
import me.prettyprint.hector.api.ddl.ComparatorType;
import me.prettyprint.hector.api.factory.HFactory;
import org.apache.archiva.metadata.repository.RepositorySessionFactoryBean;
import org.apache.archiva.metadata.repository.cassandra.CassandraArchivaManager;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service(value="archivaEntityManagerFactory#cassandra")
public class DefaultCassandraArchivaManager
implements CassandraArchivaManager {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Inject
    private ApplicationContext applicationContext;
    private static final String CLUSTER_NAME = "archiva";
    private static final String KEYSPACE_NAME = "ArchivaKeySpace";
    private boolean started;
    private Cluster cluster;
    private Keyspace keyspace;
    private String repositoryFamilyName = "repository";
    private String namespaceFamilyName = "namespace";
    private String projectFamilyName = "project";
    private String projectVersionMetadataFamilyName = "projectversionmetadata";
    private String artifactMetadataFamilyName = "artifactmetadata";
    private String metadataFacetFamilyName = "metadatafacet";
    private String mailingListFamilyName = "mailinglist";
    private String licenseFamilyName = "license";
    private String dependencyFamilyName = "dependency";
    @Value(value="${cassandra.host}")
    private String cassandraHost;
    @Value(value="${cassandra.port}")
    private String cassandraPort;
    @Value(value="${cassandra.maxActive}")
    private int maxActive;
    @Value(value="${cassandra.readConsistencyLevel}")
    private String readConsistencyLevel;
    @Value(value="${cassandra.writeConsistencyLevel}")
    private String writeConsistencyLevel;
    @Value(value="${cassandra.replicationFactor}")
    private int replicationFactor;
    @Value(value="${cassandra.keyspace.name}")
    private String keyspaceName;
    @Value(value="${cassandra.cluster.name}")
    private String clusterName;
    @Inject
    private RepositorySessionFactoryBean repositorySessionFactoryBean;

    @PostConstruct
    public void initialize() {
        if (!StringUtils.equals((String)this.repositorySessionFactoryBean.getId(), (String)"cassandra")) {
            return;
        }
        CassandraHostConfigurator configurator = new CassandraHostConfigurator(this.cassandraHost + ":" + this.cassandraPort);
        configurator.setMaxActive(this.maxActive);
        this.cluster = HFactory.getOrCreateCluster((String)this.clusterName, (CassandraHostConfigurator)configurator);
        ConfigurableConsistencyLevel consistencyLevelPolicy = new ConfigurableConsistencyLevel();
        consistencyLevelPolicy.setDefaultReadConsistencyLevel(HConsistencyLevel.valueOf((String)this.readConsistencyLevel));
        consistencyLevelPolicy.setDefaultWriteConsistencyLevel(HConsistencyLevel.valueOf((String)this.writeConsistencyLevel));
        this.keyspace = HFactory.createKeyspace((String)this.keyspaceName, (Cluster)this.cluster, (ConsistencyLevelPolicy)consistencyLevelPolicy);
        ArrayList<ColumnFamilyDefinition> cfds = new ArrayList<ColumnFamilyDefinition>();
        ColumnFamilyDefinition namespace = HFactory.createColumnFamilyDefinition((String)this.keyspace.getKeyspaceName(), (String)this.getNamespaceFamilyName(), (ComparatorType)ComparatorType.UTF8TYPE);
        cfds.add(namespace);
        BasicColumnDefinition nameColumn = new BasicColumnDefinition();
        nameColumn.setName(StringSerializer.get().toByteBuffer("name"));
        nameColumn.setIndexName("name");
        nameColumn.setIndexType(ColumnIndexType.KEYS);
        nameColumn.setValidationClass(ComparatorType.UTF8TYPE.getClassName());
        namespace.addColumnDefinition((ColumnDefinition)nameColumn);
        BasicColumnDefinition repositoryIdColumn = new BasicColumnDefinition();
        repositoryIdColumn.setName(StringSerializer.get().toByteBuffer("repositoryName"));
        repositoryIdColumn.setIndexName("repositoryName");
        repositoryIdColumn.setIndexType(ColumnIndexType.KEYS);
        repositoryIdColumn.setValidationClass(ComparatorType.UTF8TYPE.getClassName());
        namespace.addColumnDefinition((ColumnDefinition)repositoryIdColumn);
        ColumnFamilyDefinition repository = HFactory.createColumnFamilyDefinition((String)this.keyspace.getKeyspaceName(), (String)this.getRepositoryFamilyName(), (ComparatorType)ComparatorType.UTF8TYPE);
        cfds.add(repository);
        nameColumn = new BasicColumnDefinition();
        nameColumn.setName(StringSerializer.get().toByteBuffer("repositoryName"));
        nameColumn.setIndexName("repositoryName");
        nameColumn.setIndexType(ColumnIndexType.KEYS);
        nameColumn.setValidationClass(ComparatorType.UTF8TYPE.getClassName());
        repository.addColumnDefinition((ColumnDefinition)nameColumn);
        ColumnFamilyDefinition project = HFactory.createColumnFamilyDefinition((String)this.keyspace.getKeyspaceName(), (String)this.getProjectFamilyName(), (ComparatorType)ComparatorType.UTF8TYPE);
        cfds.add(project);
        BasicColumnDefinition projectIdColumn = new BasicColumnDefinition();
        projectIdColumn.setName(StringSerializer.get().toByteBuffer("projectId"));
        projectIdColumn.setIndexName("projectId");
        projectIdColumn.setIndexType(ColumnIndexType.KEYS);
        projectIdColumn.setValidationClass(ComparatorType.UTF8TYPE.getClassName());
        project.addColumnDefinition((ColumnDefinition)projectIdColumn);
        repositoryIdColumn = new BasicColumnDefinition();
        repositoryIdColumn.setName(StringSerializer.get().toByteBuffer("repositoryName"));
        repositoryIdColumn.setIndexName("repositoryName");
        repositoryIdColumn.setIndexType(ColumnIndexType.KEYS);
        repositoryIdColumn.setValidationClass(ComparatorType.UTF8TYPE.getClassName());
        project.addColumnDefinition((ColumnDefinition)repositoryIdColumn);
        BasicColumnDefinition namespaceIdColumn = new BasicColumnDefinition();
        namespaceIdColumn.setName(StringSerializer.get().toByteBuffer("namespaceId"));
        namespaceIdColumn.setIndexName("namespaceId");
        namespaceIdColumn.setIndexType(ColumnIndexType.KEYS);
        namespaceIdColumn.setValidationClass(ComparatorType.UTF8TYPE.getClassName());
        project.addColumnDefinition((ColumnDefinition)namespaceIdColumn);
        ColumnFamilyDefinition projectVersionMetadataModel = HFactory.createColumnFamilyDefinition((String)this.keyspace.getKeyspaceName(), (String)this.getProjectVersionMetadataFamilyName(), (ComparatorType)ComparatorType.UTF8TYPE);
        cfds.add(projectVersionMetadataModel);
        BasicColumnDefinition namespaceIdColumn2 = new BasicColumnDefinition();
        namespaceIdColumn2.setName(StringSerializer.get().toByteBuffer("namespaceId"));
        namespaceIdColumn2.setIndexName("namespaceId");
        namespaceIdColumn2.setIndexType(ColumnIndexType.KEYS);
        namespaceIdColumn2.setValidationClass(ComparatorType.UTF8TYPE.getClassName());
        projectVersionMetadataModel.addColumnDefinition((ColumnDefinition)namespaceIdColumn2);
        BasicColumnDefinition repositoryNameColumn = new BasicColumnDefinition();
        repositoryNameColumn.setName(StringSerializer.get().toByteBuffer("repositoryName"));
        repositoryNameColumn.setIndexName("repositoryName");
        repositoryNameColumn.setIndexType(ColumnIndexType.KEYS);
        repositoryNameColumn.setValidationClass(ComparatorType.UTF8TYPE.getClassName());
        projectVersionMetadataModel.addColumnDefinition((ColumnDefinition)repositoryNameColumn);
        BasicColumnDefinition idColumn = new BasicColumnDefinition();
        idColumn.setName(StringSerializer.get().toByteBuffer("id"));
        idColumn.setIndexName("id");
        idColumn.setIndexType(ColumnIndexType.KEYS);
        idColumn.setValidationClass(ComparatorType.UTF8TYPE.getClassName());
        projectVersionMetadataModel.addColumnDefinition((ColumnDefinition)idColumn);
        BasicColumnDefinition projectIdColumn2 = new BasicColumnDefinition();
        projectIdColumn2.setName(StringSerializer.get().toByteBuffer("projectId"));
        projectIdColumn2.setIndexName("projectId");
        projectIdColumn2.setIndexType(ColumnIndexType.KEYS);
        projectIdColumn2.setValidationClass(ComparatorType.UTF8TYPE.getClassName());
        projectVersionMetadataModel.addColumnDefinition((ColumnDefinition)projectIdColumn2);
        ColumnFamilyDefinition artifactMetadataModel = HFactory.createColumnFamilyDefinition((String)this.keyspace.getKeyspaceName(), (String)this.getArtifactMetadataFamilyName(), (ComparatorType)ComparatorType.UTF8TYPE);
        cfds.add(artifactMetadataModel);
        BasicColumnDefinition idColumn2 = new BasicColumnDefinition();
        idColumn2.setName(StringSerializer.get().toByteBuffer("id"));
        idColumn2.setIndexName("id");
        idColumn2.setIndexType(ColumnIndexType.KEYS);
        idColumn2.setValidationClass(ComparatorType.UTF8TYPE.getClassName());
        artifactMetadataModel.addColumnDefinition((ColumnDefinition)idColumn2);
        repositoryNameColumn = new BasicColumnDefinition();
        repositoryNameColumn.setName(StringSerializer.get().toByteBuffer("repositoryName"));
        repositoryNameColumn.setIndexName("repositoryName");
        repositoryNameColumn.setIndexType(ColumnIndexType.KEYS);
        repositoryNameColumn.setValidationClass(ComparatorType.UTF8TYPE.getClassName());
        artifactMetadataModel.addColumnDefinition((ColumnDefinition)repositoryNameColumn);
        namespaceIdColumn = new BasicColumnDefinition();
        namespaceIdColumn.setName(StringSerializer.get().toByteBuffer("namespaceId"));
        namespaceIdColumn.setIndexName("namespaceId");
        namespaceIdColumn.setIndexType(ColumnIndexType.KEYS);
        namespaceIdColumn.setValidationClass(ComparatorType.UTF8TYPE.getClassName());
        artifactMetadataModel.addColumnDefinition((ColumnDefinition)namespaceIdColumn);
        BasicColumnDefinition projectColumn = new BasicColumnDefinition();
        projectColumn.setName(StringSerializer.get().toByteBuffer("project"));
        projectColumn.setIndexName("project");
        projectColumn.setIndexType(ColumnIndexType.KEYS);
        projectColumn.setValidationClass(ComparatorType.UTF8TYPE.getClassName());
        artifactMetadataModel.addColumnDefinition((ColumnDefinition)projectColumn);
        BasicColumnDefinition projectVersionColumn = new BasicColumnDefinition();
        projectVersionColumn.setName(StringSerializer.get().toByteBuffer("projectVersion"));
        projectVersionColumn.setIndexName("projectVersion");
        projectVersionColumn.setIndexType(ColumnIndexType.KEYS);
        projectVersionColumn.setValidationClass(ComparatorType.UTF8TYPE.getClassName());
        artifactMetadataModel.addColumnDefinition((ColumnDefinition)projectVersionColumn);
        BasicColumnDefinition versionColumn = new BasicColumnDefinition();
        versionColumn.setName(StringSerializer.get().toByteBuffer("version"));
        versionColumn.setIndexName("version");
        versionColumn.setIndexType(ColumnIndexType.KEYS);
        versionColumn.setValidationClass(ComparatorType.UTF8TYPE.getClassName());
        artifactMetadataModel.addColumnDefinition((ColumnDefinition)versionColumn);
        BasicColumnDefinition whenGatheredColumn = new BasicColumnDefinition();
        whenGatheredColumn.setName(StringSerializer.get().toByteBuffer("whenGathered"));
        whenGatheredColumn.setIndexName("whenGathered");
        whenGatheredColumn.setIndexType(ColumnIndexType.KEYS);
        whenGatheredColumn.setValidationClass(ComparatorType.LONGTYPE.getClassName());
        artifactMetadataModel.addColumnDefinition((ColumnDefinition)whenGatheredColumn);
        BasicColumnDefinition sha1Column = new BasicColumnDefinition();
        sha1Column.setName(StringSerializer.get().toByteBuffer("sha1"));
        sha1Column.setIndexName("sha1");
        sha1Column.setIndexType(ColumnIndexType.KEYS);
        sha1Column.setValidationClass(ComparatorType.UTF8TYPE.getClassName());
        artifactMetadataModel.addColumnDefinition((ColumnDefinition)sha1Column);
        BasicColumnDefinition md5Column = new BasicColumnDefinition();
        md5Column.setName(StringSerializer.get().toByteBuffer("md5"));
        md5Column.setIndexName("md5");
        md5Column.setIndexType(ColumnIndexType.KEYS);
        md5Column.setValidationClass(ComparatorType.UTF8TYPE.getClassName());
        artifactMetadataModel.addColumnDefinition((ColumnDefinition)md5Column);
        ColumnFamilyDefinition metadataFacetModel = HFactory.createColumnFamilyDefinition((String)this.keyspace.getKeyspaceName(), (String)this.getMetadataFacetFamilyName(), (ComparatorType)ComparatorType.UTF8TYPE);
        cfds.add(metadataFacetModel);
        BasicColumnDefinition facetIdColumn = new BasicColumnDefinition();
        facetIdColumn.setName(StringSerializer.get().toByteBuffer("facetId"));
        facetIdColumn.setIndexName("facetId");
        facetIdColumn.setIndexType(ColumnIndexType.KEYS);
        facetIdColumn.setValidationClass(ComparatorType.UTF8TYPE.getClassName());
        metadataFacetModel.addColumnDefinition((ColumnDefinition)facetIdColumn);
        repositoryNameColumn = new BasicColumnDefinition();
        repositoryNameColumn.setName(StringSerializer.get().toByteBuffer("repositoryName"));
        repositoryNameColumn.setIndexName("repositoryName");
        repositoryNameColumn.setIndexType(ColumnIndexType.KEYS);
        repositoryNameColumn.setValidationClass(ComparatorType.UTF8TYPE.getClassName());
        metadataFacetModel.addColumnDefinition((ColumnDefinition)repositoryNameColumn);
        BasicColumnDefinition nameColumn2 = new BasicColumnDefinition();
        nameColumn2.setName(StringSerializer.get().toByteBuffer("name"));
        nameColumn2.setIndexName("name");
        nameColumn2.setIndexType(ColumnIndexType.KEYS);
        nameColumn2.setValidationClass(ComparatorType.UTF8TYPE.getClassName());
        metadataFacetModel.addColumnDefinition((ColumnDefinition)nameColumn2);
        BasicColumnDefinition namespaceColumn = new BasicColumnDefinition();
        namespaceColumn.setName(StringSerializer.get().toByteBuffer("namespaceId"));
        namespaceColumn.setIndexName("namespaceId");
        namespaceColumn.setIndexType(ColumnIndexType.KEYS);
        namespaceColumn.setValidationClass(ComparatorType.UTF8TYPE.getClassName());
        metadataFacetModel.addColumnDefinition((ColumnDefinition)namespaceColumn);
        BasicColumnDefinition projectIdColumn3 = new BasicColumnDefinition();
        projectIdColumn3.setName(StringSerializer.get().toByteBuffer("projectId"));
        projectIdColumn3.setIndexName("projectId");
        projectIdColumn3.setIndexType(ColumnIndexType.KEYS);
        projectIdColumn3.setValidationClass(ComparatorType.UTF8TYPE.getClassName());
        metadataFacetModel.addColumnDefinition((ColumnDefinition)projectIdColumn3);
        BasicColumnDefinition projectVersionColumn2 = new BasicColumnDefinition();
        projectVersionColumn2.setName(StringSerializer.get().toByteBuffer("projectVersion"));
        projectVersionColumn2.setIndexName("projectVersion");
        projectVersionColumn2.setIndexType(ColumnIndexType.KEYS);
        projectVersionColumn2.setValidationClass(ComparatorType.UTF8TYPE.getClassName());
        metadataFacetModel.addColumnDefinition((ColumnDefinition)projectVersionColumn2);
        ColumnFamilyDefinition mailingListCf = HFactory.createColumnFamilyDefinition((String)this.keyspace.getKeyspaceName(), (String)this.getMailingListFamilyName(), (ComparatorType)ComparatorType.UTF8TYPE);
        BasicColumnDefinition projectVersionMetadataModel_key = new BasicColumnDefinition();
        projectVersionMetadataModel_key.setName(StringSerializer.get().toByteBuffer("projectVersionMetadataModel.key"));
        projectVersionMetadataModel_key.setIndexName("projectVersionMetadataModel_key");
        projectVersionMetadataModel_key.setIndexType(ColumnIndexType.KEYS);
        projectVersionMetadataModel_key.setValidationClass(ComparatorType.UTF8TYPE.getClassName());
        mailingListCf.addColumnDefinition((ColumnDefinition)projectVersionMetadataModel_key);
        cfds.add(mailingListCf);
        ColumnFamilyDefinition licenseCf = HFactory.createColumnFamilyDefinition((String)this.keyspace.getKeyspaceName(), (String)this.getLicenseFamilyName(), (ComparatorType)ComparatorType.UTF8TYPE);
        projectVersionMetadataModel_key = new BasicColumnDefinition();
        projectVersionMetadataModel_key.setName(StringSerializer.get().toByteBuffer("projectVersionMetadataModel.key"));
        projectVersionMetadataModel_key.setIndexName("projectVersionMetadataModel_key");
        projectVersionMetadataModel_key.setIndexType(ColumnIndexType.KEYS);
        projectVersionMetadataModel_key.setValidationClass(ComparatorType.UTF8TYPE.getClassName());
        licenseCf.addColumnDefinition((ColumnDefinition)projectVersionMetadataModel_key);
        cfds.add(licenseCf);
        ColumnFamilyDefinition dependencyCf = HFactory.createColumnFamilyDefinition((String)this.keyspace.getKeyspaceName(), (String)this.getDependencyFamilyName(), (ComparatorType)ComparatorType.UTF8TYPE);
        cfds.add(dependencyCf);
        BasicColumnDefinition groupIdColumn = new BasicColumnDefinition();
        groupIdColumn.setName(StringSerializer.get().toByteBuffer("groupId"));
        groupIdColumn.setIndexName("groupIdIdx");
        groupIdColumn.setIndexType(ColumnIndexType.KEYS);
        groupIdColumn.setValidationClass(ComparatorType.UTF8TYPE.getClassName());
        dependencyCf.addColumnDefinition((ColumnDefinition)groupIdColumn);
        BasicColumnDefinition projectVersionMetadataModel_key2 = new BasicColumnDefinition();
        projectVersionMetadataModel_key2.setName(StringSerializer.get().toByteBuffer("projectVersionMetadataModel.key"));
        projectVersionMetadataModel_key2.setIndexName("projectVersionMetadataModel_key");
        projectVersionMetadataModel_key2.setIndexType(ColumnIndexType.KEYS);
        projectVersionMetadataModel_key2.setValidationClass(ComparatorType.UTF8TYPE.getClassName());
        dependencyCf.addColumnDefinition((ColumnDefinition)projectVersionMetadataModel_key2);
        if (this.cluster.describeKeyspace(this.keyspaceName) == null) {
            this.logger.info("Creating Archiva Cassandra '" + this.keyspaceName + "' keyspace.");
            this.cluster.addKeyspace(HFactory.createKeyspaceDefinition((String)this.keyspaceName, (String)"org.apache.cassandra.locator.SimpleStrategy", (int)this.replicationFactor, cfds));
        }
    }

    @Override
    public void start() {
    }

    @Override
    @PreDestroy
    public void shutdown() {
    }

    @Override
    public boolean started() {
        return this.started;
    }

    @Override
    public Keyspace getKeyspace() {
        return this.keyspace;
    }

    @Override
    public Cluster getCluster() {
        return this.cluster;
    }

    @Override
    public String getRepositoryFamilyName() {
        return this.repositoryFamilyName;
    }

    @Override
    public String getNamespaceFamilyName() {
        return this.namespaceFamilyName;
    }

    @Override
    public String getProjectFamilyName() {
        return this.projectFamilyName;
    }

    @Override
    public String getProjectVersionMetadataFamilyName() {
        return this.projectVersionMetadataFamilyName;
    }

    @Override
    public String getArtifactMetadataFamilyName() {
        return this.artifactMetadataFamilyName;
    }

    @Override
    public String getMetadataFacetFamilyName() {
        return this.metadataFacetFamilyName;
    }

    @Override
    public String getMailingListFamilyName() {
        return this.mailingListFamilyName;
    }

    @Override
    public String getLicenseFamilyName() {
        return this.licenseFamilyName;
    }

    @Override
    public String getDependencyFamilyName() {
        return this.dependencyFamilyName;
    }
}

