/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.metadata.repository.cassandra.model;

import java.io.Serializable;
import java.util.Date;
import org.apache.archiva.metadata.repository.cassandra.CassandraUtils;
import org.apache.archiva.metadata.repository.cassandra.model.Namespace;

public class ArtifactMetadataModel
implements Serializable {
    private String id;
    private String repositoryId;
    private String namespace;
    private String project;
    private String projectVersion;
    private String version;
    private long fileLastModified;
    private long size;
    private String md5;
    private String sha1;
    private long whenGathered;

    public ArtifactMetadataModel() {
    }

    public ArtifactMetadataModel(String id, String repositoryId, String namespace, String project, String projectVersion, String version, Date fileLastModified, long size, String md5, String sha1, Date whenGathered) {
        this.id = id;
        this.repositoryId = repositoryId;
        this.namespace = namespace;
        this.project = project;
        this.projectVersion = projectVersion;
        this.version = version;
        this.fileLastModified = fileLastModified != null ? fileLastModified.getTime() : 0L;
        this.size = size;
        this.md5 = md5;
        this.sha1 = sha1;
        this.whenGathered = whenGathered != null ? whenGathered.getTime() : new Date().getTime();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getRepositoryId() {
        return this.repositoryId;
    }

    public void setRepositoryId(String repositoryId) {
        this.repositoryId = repositoryId;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getProject() {
        return this.project;
    }

    public void setProject(String project) {
        this.project = project;
    }

    public String getProjectVersion() {
        return this.projectVersion;
    }

    public void setProjectVersion(String projectVersion) {
        this.projectVersion = projectVersion;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public long getFileLastModified() {
        return this.fileLastModified;
    }

    public void setFileLastModified(long fileLastModified) {
        this.fileLastModified = fileLastModified;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public String getMd5() {
        return this.md5;
    }

    public void setMd5(String md5) {
        this.md5 = md5;
    }

    public String getSha1() {
        return this.sha1;
    }

    public void setSha1(String sha1) {
        this.sha1 = sha1;
    }

    public Date getWhenGathered() {
        return new Date(this.whenGathered);
    }

    public void setWhenGathered(long whenGathered) {
        this.whenGathered = whenGathered;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ArtifactMetadataModel{");
        sb.append(", id='").append(this.id).append('\'');
        sb.append(", repositoryId='").append(this.repositoryId).append('\'');
        sb.append(", namespace='").append(this.namespace).append('\'');
        sb.append(", project='").append(this.project).append('\'');
        sb.append(", projectVersion='").append(this.projectVersion).append('\'');
        sb.append(", version='").append(this.version).append('\'');
        sb.append(", fileLastModified=").append(this.fileLastModified);
        sb.append(", size=").append(this.size);
        sb.append(", md5='").append(this.md5).append('\'');
        sb.append(", sha1='").append(this.sha1).append('\'');
        sb.append(", whenGathered=").append(this.whenGathered);
        sb.append('}');
        return sb.toString();
    }

    public static class KeyBuilder {
        private String project;
        private String id;
        private String namespaceId;
        private String repositoryId;
        private String projectVersion;

        public KeyBuilder withId(String id) {
            this.id = id;
            return this;
        }

        public KeyBuilder withNamespace(Namespace namespace) {
            this.namespaceId = namespace.getName();
            this.repositoryId = namespace.getRepository().getName();
            return this;
        }

        public KeyBuilder withNamespace(String namespaceId) {
            this.namespaceId = namespaceId;
            return this;
        }

        public KeyBuilder withProject(String project) {
            this.project = project;
            return this;
        }

        public KeyBuilder withProjectVersion(String projectVersion) {
            this.projectVersion = projectVersion;
            return this;
        }

        public KeyBuilder withRepositoryId(String repositoryId) {
            this.repositoryId = repositoryId;
            return this;
        }

        public String build() {
            String str = CassandraUtils.generateKey(this.repositoryId, this.namespaceId, this.project, this.projectVersion, this.id);
            return str;
        }
    }
}

