/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.metadata.repository.cassandra.model;

import org.apache.archiva.metadata.repository.cassandra.CassandraUtils;
import org.apache.archiva.metadata.repository.cassandra.model.ArtifactMetadataModel;

public class MetadataFacetModel {
    private String facetId;
    private String key;
    private String name;
    private String value;
    private String projectVersion;

    public MetadataFacetModel() {
    }

    public MetadataFacetModel(String facetId, String key, String value, String name, String projectVersion) {
        this.key = key;
        this.value = value;
        this.name = name;
        this.facetId = facetId;
        this.projectVersion = projectVersion;
    }

    public String getFacetId() {
        return this.facetId;
    }

    public void setFacetId(String facetId) {
        this.facetId = facetId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getProjectVersion() {
        return this.projectVersion;
    }

    public void setProjectVersion(String projectVersion) {
        this.projectVersion = projectVersion;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("MetadataFacetModel{");
        sb.append(", key='").append(this.key).append('\'');
        sb.append(", value='").append(this.value).append('\'');
        sb.append('}');
        return sb.toString();
    }

    public static class KeyBuilder {
        private ArtifactMetadataModel artifactMetadataModel;
        private String key;
        private String name;
        private String facetId;
        private String repositoryId;

        public KeyBuilder withArtifactMetadataModel(ArtifactMetadataModel artifactMetadataModel) {
            this.artifactMetadataModel = artifactMetadataModel;
            return this;
        }

        public KeyBuilder withKey(String key) {
            this.key = key;
            return this;
        }

        public KeyBuilder withName(String name) {
            this.name = name;
            return this;
        }

        public KeyBuilder withFacetId(String facetId) {
            this.facetId = facetId;
            return this;
        }

        public KeyBuilder withRepositoryId(String repositoryId) {
            this.repositoryId = repositoryId;
            return this;
        }

        public String build() {
            String str = CassandraUtils.generateKey(this.artifactMetadataModel == null ? this.repositoryId : new ArtifactMetadataModel.KeyBuilder().withNamespace(this.artifactMetadataModel.getNamespace()).withProject(this.artifactMetadataModel.getProject()).withProjectVersion(this.artifactMetadataModel.getProjectVersion()).withRepositoryId(this.artifactMetadataModel.getRepositoryId()).withId(this.artifactMetadataModel.getId()).build(), this.facetId, this.name, this.key);
            return str;
        }
    }
}

