/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.metadata.repository.cassandra.model;

import java.util.ArrayList;
import java.util.List;
import org.apache.archiva.metadata.model.CiManagement;
import org.apache.archiva.metadata.model.Dependency;
import org.apache.archiva.metadata.model.IssueManagement;
import org.apache.archiva.metadata.model.License;
import org.apache.archiva.metadata.model.MailingList;
import org.apache.archiva.metadata.model.Organization;
import org.apache.archiva.metadata.model.Scm;
import org.apache.archiva.metadata.repository.cassandra.CassandraUtils;
import org.apache.archiva.metadata.repository.cassandra.model.Namespace;

public class ProjectVersionMetadataModel {
    private Namespace namespace;
    private String id;
    private String projectId;
    private String url;
    private String name;
    private String description;
    private Organization organization;
    private IssueManagement issueManagement;
    private Scm scm;
    private CiManagement ciManagement;
    private List<License> licenses = new ArrayList<License>();
    private List<MailingList> mailingLists = new ArrayList<MailingList>();
    private List<Dependency> dependencies = new ArrayList<Dependency>();
    private boolean incomplete;

    public String getProjectId() {
        return this.projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Organization getOrganization() {
        return this.organization;
    }

    public void setOrganization(Organization organization) {
        this.organization = organization;
    }

    public IssueManagement getIssueManagement() {
        return this.issueManagement;
    }

    public void setIssueManagement(IssueManagement issueManagement) {
        this.issueManagement = issueManagement;
    }

    public Scm getScm() {
        return this.scm;
    }

    public void setScm(Scm scm) {
        this.scm = scm;
    }

    public CiManagement getCiManagement() {
        return this.ciManagement;
    }

    public void setCiManagement(CiManagement ciManagement) {
        this.ciManagement = ciManagement;
    }

    public boolean isIncomplete() {
        return this.incomplete;
    }

    public void setIncomplete(boolean incomplete) {
        this.incomplete = incomplete;
    }

    public Namespace getNamespace() {
        return this.namespace;
    }

    public void setNamespace(Namespace namespace) {
        this.namespace = namespace;
    }

    public List<License> getLicenses() {
        return this.licenses;
    }

    public void setLicenses(List<License> licenses) {
        this.licenses = licenses;
    }

    public List<MailingList> getMailingLists() {
        return this.mailingLists;
    }

    public void setMailingLists(List<MailingList> mailingLists) {
        this.mailingLists = mailingLists;
    }

    public List<Dependency> getDependencies() {
        return this.dependencies;
    }

    public void setDependencies(List<Dependency> dependencies) {
        this.dependencies = dependencies;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ProjectVersionMetadataModel{");
        sb.append(", namespace=").append(this.namespace);
        sb.append(", id='").append(this.id).append('\'');
        sb.append(", projectId='").append(this.projectId).append('\'');
        sb.append(", url='").append(this.url).append('\'');
        sb.append(", name='").append(this.name).append('\'');
        sb.append(", description='").append(this.description).append('\'');
        sb.append(", organization=").append(this.organization);
        sb.append(", issueManagement=").append(this.issueManagement);
        sb.append(", scm=").append(this.scm);
        sb.append(", ciManagement=").append(this.ciManagement);
        sb.append(", incomplete=").append(this.incomplete);
        sb.append('}');
        return sb.toString();
    }

    public static class KeyBuilder {
        private String namespace;
        private String repositoryName;
        private String projectId;
        private String projectVersion;
        private String id;

        public KeyBuilder withNamespace(Namespace namespace) {
            this.namespace = namespace.getName();
            this.repositoryName = namespace.getRepository().getName();
            return this;
        }

        public KeyBuilder withNamespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public KeyBuilder withRepository(String repositoryId) {
            this.repositoryName = repositoryId;
            return this;
        }

        public KeyBuilder withProjectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public KeyBuilder withProjectVersion(String projectVersion) {
            this.projectVersion = projectVersion;
            return this;
        }

        public KeyBuilder withId(String id) {
            this.id = id;
            return this;
        }

        public String build() {
            return CassandraUtils.generateKey(this.repositoryName, this.namespace, this.projectId, this.projectVersion, this.id);
        }
    }
}

