/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.metadata.repository.cassandra;

import me.prettyprint.cassandra.serializers.LongSerializer;
import me.prettyprint.cassandra.serializers.SerializerTypeInferer;
import me.prettyprint.cassandra.serializers.StringSerializer;
import me.prettyprint.cassandra.service.template.ColumnFamilyUpdater;
import me.prettyprint.hector.api.Serializer;
import me.prettyprint.hector.api.beans.ColumnSlice;
import me.prettyprint.hector.api.beans.HColumn;
import me.prettyprint.hector.api.factory.HFactory;
import me.prettyprint.hector.api.mutation.Mutator;
import org.apache.archiva.metadata.repository.cassandra.model.ColumnNames;
import org.apache.commons.lang.StringUtils;

public class CassandraUtils {
    private static final String EMPTY_VALUE = "";
    public static final String SEPARATOR = "->";

    public static String generateKey(String ... bases) {
        StringBuilder builder = new StringBuilder();
        if (bases == null || bases.length == 0) {
            return builder.toString();
        }
        for (String s : bases) {
            if (s != null) {
                builder.append(s);
            } else {
                builder.append(EMPTY_VALUE);
            }
            builder.append(SEPARATOR);
        }
        if (builder.length() > 0) {
            builder.setLength(builder.length() - SEPARATOR.length());
        }
        return builder.toString();
    }

    public static <A, B> HColumn<A, B> column(A name, B value) {
        return HFactory.createColumn(name, value, (Serializer)SerializerTypeInferer.getSerializer(name), (Serializer)SerializerTypeInferer.getSerializer(value));
    }

    public static String getStringValue(ColumnSlice<String, String> columnSlice, ColumnNames columnName) {
        return CassandraUtils.getStringValue(columnSlice, columnName.toString());
    }

    public static String getStringValue(ColumnSlice<String, String> columnSlice, String columnName) {
        if (StringUtils.isEmpty((String)columnName)) {
            return null;
        }
        HColumn hColumn = columnSlice.getColumnByName((Object)columnName);
        return hColumn == null ? null : (String)hColumn.getValue();
    }

    public static Long getLongValue(ColumnSlice<String, ?> columnSlice, String columnName) {
        if (StringUtils.isEmpty((String)columnName)) {
            return null;
        }
        HColumn hColumn = columnSlice.getColumnByName((Object)columnName);
        return hColumn == null ? null : (Long)hColumn.getValue();
    }

    public static <T> String getAsStringValue(ColumnSlice<String, T> columnSlice, String columnName) {
        StringSerializer ss = StringSerializer.get();
        if (StringUtils.isEmpty((String)columnName)) {
            return null;
        }
        HColumn hColumn = columnSlice.getColumnByName((Object)columnName);
        return hColumn == null ? null : ss.fromByteBuffer(hColumn.getValueBytes());
    }

    public static Long getAsLongValue(ColumnSlice<String, String> columnSlice, String columnName) {
        LongSerializer ls = LongSerializer.get();
        if (StringUtils.isEmpty((String)columnName)) {
            return null;
        }
        HColumn hColumn = columnSlice.getColumnByName((Object)columnName);
        return hColumn == null ? null : ls.fromByteBuffer(hColumn.getValueBytes());
    }

    public static void addInsertion(Mutator<String> mutator, String key, String columnFamily, String columnName, String value) {
        if (value != null) {
            mutator.addInsertion((Object)key, columnFamily, CassandraUtils.column(columnName, value));
        }
    }

    public static void addUpdateStringValue(ColumnFamilyUpdater<String, String> updater, String columnName, String value) {
        if (value == null) {
            return;
        }
        updater.setString((Object)columnName, value);
    }

    private CassandraUtils() {
    }
}

