/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.metadata.repository.file;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.archiva.configuration.ArchivaConfiguration;
import org.apache.archiva.metadata.model.MetadataFacetFactory;
import org.apache.archiva.metadata.repository.MetadataRepository;
import org.apache.archiva.metadata.repository.MetadataResolver;
import org.apache.archiva.metadata.repository.RepositorySession;
import org.apache.archiva.metadata.repository.RepositorySessionFactory;
import org.apache.archiva.metadata.repository.file.FileMetadataRepository;
import org.apache.commons.lang.StringUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service(value="repositorySessionFactory#file")
public class FileRepositorySessionFactory
implements RepositorySessionFactory {
    private Map<String, MetadataFacetFactory> metadataFacetFactories;
    @Inject
    @Named(value="archivaConfiguration#default")
    private ArchivaConfiguration configuration;
    @Inject
    private MetadataResolver metadataResolver;
    @Inject
    private ApplicationContext applicationContext;

    @PostConstruct
    public void initialize() {
        Map tmpMetadataFacetFactories = this.applicationContext.getBeansOfType(MetadataFacetFactory.class);
        this.metadataFacetFactories = new HashMap<String, MetadataFacetFactory>(tmpMetadataFacetFactories.size());
        for (Map.Entry entry : tmpMetadataFacetFactories.entrySet()) {
            this.metadataFacetFactories.put(StringUtils.substringAfterLast((String)((String)entry.getKey()), (String)"#"), (MetadataFacetFactory)entry.getValue());
        }
    }

    public RepositorySession createSession() {
        FileMetadataRepository metadataRepository = new FileMetadataRepository(this.metadataFacetFactories, this.configuration);
        return new RepositorySession((MetadataRepository)metadataRepository, this.metadataResolver);
    }
}

