/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.redback.common.ldap.connection;

import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.naming.spi.NamingManager;
import org.apache.archiva.redback.common.ldap.connection.LdapConnection;
import org.apache.archiva.redback.common.ldap.connection.LdapConnectionConfiguration;
import org.apache.archiva.redback.common.ldap.connection.LdapException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultLdapConnection
implements LdapConnection {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private LdapConnectionConfiguration config;
    private DirContext context;
    private List<Rdn> baseDnRdns;

    public DefaultLdapConnection(LdapConnectionConfiguration config, Rdn subRdn) throws LdapException {
        this.config = config;
        LdapName baseDn = new LdapName(config.getBaseDn().getRdns());
        if (subRdn != null) {
            baseDn.add(subRdn);
        }
        this.log.debug("baseDn: {}", (Object)baseDn);
        this.baseDnRdns = Collections.unmodifiableList(baseDn.getRdns());
        if (this.context != null) {
            throw new LdapException("Already connected.");
        }
        this.log.debug("baseDnRdns: {}", this.baseDnRdns);
        Hashtable<Object, Object> e = this.getEnvironment();
        try {
            this.context = (DirContext)NamingManager.getInitialContext(e);
        }
        catch (NamingException ex) {
            throw new LdapException("Could not connect to the server.", ex);
        }
    }

    public DefaultLdapConnection(LdapConnectionConfiguration config, String bindDn, String password) throws LdapException {
        this.config = config;
        Hashtable<Object, Object> e = this.getEnvironment();
        e.put("java.naming.security.principal", bindDn);
        e.put("java.naming.security.credentials", password);
        try {
            this.context = (DirContext)NamingManager.getInitialContext(e);
        }
        catch (NamingException ex) {
            throw new LdapException("Could not connect to the server.", ex);
        }
    }

    @Override
    public Hashtable<Object, Object> getEnvironment() throws LdapException {
        Properties env = new Properties();
        env.putAll((Map<?, ?>)this.config.getExtraProperties());
        this.config.check();
        env.put("java.naming.factory.initial", this.config.getContextFactory());
        if (this.config.getContextFactory().equals("com.sun.jndi.ldap.LdapCtxFactory")) {
            env.put("com.sun.jndi.ldap.connect.pool", "true");
            env.put("com.sun.jndi.ldap.connect.pool.timeout", "3600");
        }
        if (this.config.getHostname() != null) {
            String protocol = "ldap";
            if (this.config.getPort() != 0) {
                env.put("java.naming.provider.url", protocol + "://" + this.config.getHostname() + ":" + this.config.getPort() + "/");
            } else {
                env.put("java.naming.provider.url", protocol + "://" + this.config.getHostname() + "/");
            }
        }
        if (this.config.isSsl()) {
            env.put("java.naming.security.protocol", "ssl");
        }
        if (this.config.getAuthenticationMethod() != null) {
            env.put("java.naming.security.authentication", this.config.getAuthenticationMethod());
        }
        if (this.config.getBindDn() != null) {
            env.put("java.naming.security.principal", this.config.getBindDn().toString());
        }
        if (this.config.getPassword() != null) {
            env.put("java.naming.security.credentials", this.config.getPassword());
        }
        String objectFactories = null;
        for (Class<?> objectFactoryClass : this.config.getObjectFactories()) {
            if (objectFactories == null) {
                objectFactories = objectFactoryClass.getName();
                continue;
            }
            objectFactories = objectFactories + ":" + objectFactoryClass.getName();
        }
        if (objectFactories != null) {
            env.setProperty("java.naming.factory.object", objectFactories);
        }
        String stateFactories = null;
        for (Class<?> stateFactoryClass : this.config.getStateFactories()) {
            if (stateFactories == null) {
                stateFactories = stateFactoryClass.getName();
                continue;
            }
            stateFactories = stateFactories + ":" + stateFactoryClass.getName();
        }
        if (stateFactories != null) {
            env.setProperty("java.naming.factory.state", stateFactories);
        }
        this.log.debug("env properties: {}", (Object)env);
        return env;
    }

    @Override
    public void close() {
        try {
            if (this.context != null) {
                this.context.close();
            }
        }
        catch (NamingException ex) {
            this.log.info("skip error closing ldap connection {}", (Object)ex.getMessage());
        }
        finally {
            this.context = null;
        }
    }

    @Override
    public LdapConnectionConfiguration getConfiguration() {
        return this.config;
    }

    @Override
    public List<Rdn> getBaseDnRdns() {
        return this.baseDnRdns;
    }

    @Override
    public DirContext getDirContext() {
        return this.context;
    }
}

