/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.redback.rbac.cached;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.archiva.redback.components.cache.Cache;
import org.apache.archiva.redback.rbac.Operation;
import org.apache.archiva.redback.rbac.Permission;
import org.apache.archiva.redback.rbac.RBACManager;
import org.apache.archiva.redback.rbac.RBACManagerListener;
import org.apache.archiva.redback.rbac.RbacManagerException;
import org.apache.archiva.redback.rbac.RbacObjectInvalidException;
import org.apache.archiva.redback.rbac.RbacObjectNotFoundException;
import org.apache.archiva.redback.rbac.Resource;
import org.apache.archiva.redback.rbac.Role;
import org.apache.archiva.redback.rbac.UserAssignment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(value="rBACManager#cached")
public class CachedRbacManager
implements RBACManager,
RBACManagerListener {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    @Inject
    @Named(value="rBACManager#jdo")
    private RBACManager rbacImpl;
    @Inject
    @Named(value="cache#operations")
    private Cache operationsCache;
    @Inject
    @Named(value="cache#permissions")
    private Cache permissionsCache;
    @Inject
    @Named(value="cache#resources")
    private Cache resourcesCache;
    @Inject
    @Named(value="cache#roles")
    private Cache rolesCache;
    @Inject
    @Named(value="cache#userAssignments")
    private Cache userAssignmentsCache;
    @Inject
    @Named(value="cache#userPermissions")
    private Cache userPermissionsCache;
    @Inject
    @Named(value="cache#effectiveRoleSet")
    private Cache effectiveRoleSetCache;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChildRole(Role role, Role childRole) throws RbacObjectInvalidException, RbacManagerException {
        try {
            this.rbacImpl.addChildRole(role, childRole);
        }
        finally {
            this.invalidateCachedRole(role);
            this.invalidateCachedRole(childRole);
        }
    }

    public void addListener(RBACManagerListener listener) {
        this.rbacImpl.addListener(listener);
    }

    public Operation createOperation(String name) throws RbacManagerException {
        this.operationsCache.remove((Object)name);
        return this.rbacImpl.createOperation(name);
    }

    public Permission createPermission(String name) throws RbacManagerException {
        this.permissionsCache.remove((Object)name);
        return this.rbacImpl.createPermission(name);
    }

    public Permission createPermission(String name, String operationName, String resourceIdentifier) throws RbacManagerException {
        this.permissionsCache.remove((Object)name);
        return this.rbacImpl.createPermission(name, operationName, resourceIdentifier);
    }

    public Resource createResource(String identifier) throws RbacManagerException {
        this.resourcesCache.remove((Object)identifier);
        return this.rbacImpl.createResource(identifier);
    }

    public Role createRole(String name) {
        this.rolesCache.remove((Object)name);
        return this.rbacImpl.createRole(name);
    }

    public UserAssignment createUserAssignment(String principal) throws RbacManagerException {
        this.invalidateCachedUserAssignment(principal);
        return this.rbacImpl.createUserAssignment(principal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void eraseDatabase() {
        this.rbacImpl.eraseDatabase();
    }

    public List<Role> getAllAssignableRoles() throws RbacManagerException, RbacObjectNotFoundException {
        this.log.debug("NOT CACHED - .getAllAssignableRoles()");
        return this.rbacImpl.getAllAssignableRoles();
    }

    public List<Operation> getAllOperations() throws RbacManagerException {
        this.log.debug("NOT CACHED - .getAllOperations()");
        return this.rbacImpl.getAllOperations();
    }

    public List<Permission> getAllPermissions() throws RbacManagerException {
        this.log.debug("NOT CACHED - .getAllPermissions()");
        return this.rbacImpl.getAllPermissions();
    }

    public List<Resource> getAllResources() throws RbacManagerException {
        this.log.debug("NOT CACHED - .getAllResources()");
        return this.rbacImpl.getAllResources();
    }

    public List<Role> getAllRoles() throws RbacManagerException {
        this.log.debug("NOT CACHED - .getAllRoles()");
        return this.rbacImpl.getAllRoles();
    }

    public List<UserAssignment> getAllUserAssignments() throws RbacManagerException {
        this.log.debug("NOT CACHED - .getAllUserAssignments()");
        return this.rbacImpl.getAllUserAssignments();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, List<Permission>> getAssignedPermissionMap(String principal) throws RbacObjectNotFoundException, RbacManagerException {
        Map el = (Map)this.userPermissionsCache.get((Object)principal);
        if (el != null) {
            this.log.debug("using cached user permission map");
            return el;
        }
        Cache cache = this.userPermissionsCache;
        synchronized (cache) {
            this.log.debug("building user permission map");
            Map userPermMap = this.rbacImpl.getAssignedPermissionMap(principal);
            this.userPermissionsCache.put((Object)principal, (Object)userPermMap);
            return userPermMap;
        }
    }

    public Set<Permission> getAssignedPermissions(String principal) throws RbacObjectNotFoundException, RbacManagerException {
        this.log.debug("NOT CACHED - .getAssignedPermissions(String)");
        return this.rbacImpl.getAssignedPermissions(principal);
    }

    public Collection<Role> getAssignedRoles(String principal) throws RbacObjectNotFoundException, RbacManagerException {
        this.log.debug("NOT CACHED - .getAssignedRoles(String)");
        return this.rbacImpl.getAssignedRoles(principal);
    }

    public Collection<Role> getAssignedRoles(UserAssignment userAssignment) throws RbacObjectNotFoundException, RbacManagerException {
        this.log.debug("NOT CACHED - .getAssignedRoles(UserAssignment)");
        return this.rbacImpl.getAssignedRoles(userAssignment);
    }

    public Map<String, Role> getChildRoles(Role role) throws RbacManagerException {
        this.log.debug("NOT CACHED - .getChildRoles(Role)");
        return this.rbacImpl.getChildRoles(role);
    }

    public Map<String, Role> getParentRoles(Role role) throws RbacManagerException {
        this.log.debug("NOT CACHED - .getParentRoles(Role)");
        return this.rbacImpl.getParentRoles(role);
    }

    public Collection<Role> getEffectivelyAssignedRoles(String principal) throws RbacObjectNotFoundException, RbacManagerException {
        this.log.debug("NOT CACHED - .getEffectivelyAssignedRoles(String)");
        return this.rbacImpl.getEffectivelyAssignedRoles(principal);
    }

    public Collection<Role> getEffectivelyUnassignedRoles(String principal) throws RbacManagerException, RbacObjectNotFoundException {
        this.log.debug("NOT CACHED - .getEffectivelyUnassignedRoles(String)");
        return this.rbacImpl.getEffectivelyUnassignedRoles(principal);
    }

    public Set<Role> getEffectiveRoles(Role role) throws RbacObjectNotFoundException, RbacManagerException {
        Set el = (Set)this.effectiveRoleSetCache.get((Object)role.getName());
        if (el != null) {
            this.log.debug("using cached effective role set");
            return el;
        }
        this.log.debug("building effective role set");
        Set effectiveRoleSet = this.rbacImpl.getEffectiveRoles(role);
        this.effectiveRoleSetCache.put((Object)role.getName(), (Object)effectiveRoleSet);
        return effectiveRoleSet;
    }

    public Resource getGlobalResource() throws RbacManagerException {
        this.log.debug("NOT CACHED - .getGlobalResource()");
        return this.rbacImpl.getGlobalResource();
    }

    public Operation getOperation(String operationName) throws RbacObjectNotFoundException, RbacManagerException {
        Object el = this.operationsCache.get((Object)operationName);
        if (el != null) {
            return (Operation)el;
        }
        Operation operation = this.rbacImpl.getOperation(operationName);
        this.operationsCache.put((Object)operationName, (Object)operation);
        return operation;
    }

    public Permission getPermission(String permissionName) throws RbacObjectNotFoundException, RbacManagerException {
        Object el = this.permissionsCache.get((Object)permissionName);
        if (el != null) {
            return (Permission)el;
        }
        Permission permission = this.rbacImpl.getPermission(permissionName);
        this.permissionsCache.put((Object)permissionName, (Object)permission);
        return permission;
    }

    public Resource getResource(String resourceIdentifier) throws RbacObjectNotFoundException, RbacManagerException {
        Object el = this.resourcesCache.get((Object)resourceIdentifier);
        if (el != null) {
            return (Resource)el;
        }
        Resource resource = this.rbacImpl.getResource(resourceIdentifier);
        this.resourcesCache.put((Object)resourceIdentifier, (Object)resource);
        return resource;
    }

    public Role getRole(String roleName) throws RbacObjectNotFoundException, RbacManagerException {
        Object el = this.rolesCache.get((Object)roleName);
        if (el != null) {
            return (Role)el;
        }
        Role role = this.rbacImpl.getRole(roleName);
        this.rolesCache.put((Object)roleName, (Object)role);
        return role;
    }

    public Map<String, Role> getRoles(Collection<String> roleNames) throws RbacObjectNotFoundException, RbacManagerException {
        this.log.debug("NOT CACHED - .getRoles(Collection)");
        return this.rbacImpl.getRoles(roleNames);
    }

    public Collection<Role> getUnassignedRoles(String principal) throws RbacManagerException, RbacObjectNotFoundException {
        this.log.debug("NOT CACHED - .getUnassignedRoles(String)");
        return this.rbacImpl.getUnassignedRoles(principal);
    }

    public UserAssignment getUserAssignment(String principal) throws RbacObjectNotFoundException, RbacManagerException {
        Object el = this.userAssignmentsCache.get((Object)principal);
        if (el != null) {
            return (UserAssignment)el;
        }
        UserAssignment userAssignment = this.rbacImpl.getUserAssignment(principal);
        this.userAssignmentsCache.put((Object)principal, (Object)userAssignment);
        return userAssignment;
    }

    public List<UserAssignment> getUserAssignmentsForRoles(Collection<String> roleNames) throws RbacManagerException {
        this.log.debug("NOT CACHED - .getUserAssignmentsForRoles(Collection)");
        return this.rbacImpl.getUserAssignmentsForRoles(roleNames);
    }

    public boolean operationExists(Operation operation) {
        if (operation == null) {
            return false;
        }
        if (this.operationsCache.hasKey((Object)operation.getName())) {
            return true;
        }
        return this.rbacImpl.operationExists(operation);
    }

    public boolean operationExists(String name) {
        if (this.operationsCache.hasKey((Object)name)) {
            return true;
        }
        return this.rbacImpl.operationExists(name);
    }

    public boolean permissionExists(Permission permission) {
        if (permission == null) {
            return false;
        }
        if (this.permissionsCache.hasKey((Object)permission.getName())) {
            return true;
        }
        return this.rbacImpl.permissionExists(permission);
    }

    public boolean permissionExists(String name) {
        if (this.permissionsCache.hasKey((Object)name)) {
            return true;
        }
        return this.rbacImpl.permissionExists(name);
    }

    public void rbacInit(boolean freshdb) {
        if (this.rbacImpl instanceof RBACManagerListener) {
            ((RBACManagerListener)this.rbacImpl).rbacInit(freshdb);
        }
        this.resourcesCache.clear();
        this.operationsCache.clear();
        this.permissionsCache.clear();
        this.rolesCache.clear();
        this.userAssignmentsCache.clear();
        this.userPermissionsCache.clear();
    }

    public void rbacPermissionRemoved(Permission permission) {
        if (this.rbacImpl instanceof RBACManagerListener) {
            ((RBACManagerListener)this.rbacImpl).rbacPermissionRemoved(permission);
        }
        this.invalidateCachedPermission(permission);
    }

    public void rbacPermissionSaved(Permission permission) {
        if (this.rbacImpl instanceof RBACManagerListener) {
            ((RBACManagerListener)this.rbacImpl).rbacPermissionSaved(permission);
        }
        this.invalidateCachedPermission(permission);
    }

    public void rbacRoleRemoved(Role role) {
        if (this.rbacImpl instanceof RBACManagerListener) {
            ((RBACManagerListener)this.rbacImpl).rbacRoleRemoved(role);
        }
        this.invalidateCachedRole(role);
    }

    public void rbacRoleSaved(Role role) {
        if (this.rbacImpl instanceof RBACManagerListener) {
            ((RBACManagerListener)this.rbacImpl).rbacRoleSaved(role);
        }
        this.invalidateCachedRole(role);
    }

    public void rbacUserAssignmentRemoved(UserAssignment userAssignment) {
        if (this.rbacImpl instanceof RBACManagerListener) {
            ((RBACManagerListener)this.rbacImpl).rbacUserAssignmentRemoved(userAssignment);
        }
        this.invalidateCachedUserAssignment(userAssignment);
    }

    public void rbacUserAssignmentSaved(UserAssignment userAssignment) {
        if (this.rbacImpl instanceof RBACManagerListener) {
            ((RBACManagerListener)this.rbacImpl).rbacUserAssignmentSaved(userAssignment);
        }
        this.invalidateCachedUserAssignment(userAssignment);
    }

    public void removeListener(RBACManagerListener listener) {
        this.rbacImpl.removeListener(listener);
    }

    public void removeOperation(Operation operation) throws RbacObjectNotFoundException, RbacObjectInvalidException, RbacManagerException {
        this.invalidateCachedOperation(operation);
        this.rbacImpl.removeOperation(operation);
    }

    public void removeOperation(String operationName) throws RbacObjectNotFoundException, RbacObjectInvalidException, RbacManagerException {
        this.operationsCache.remove((Object)operationName);
        this.rbacImpl.removeOperation(operationName);
    }

    public void removePermission(Permission permission) throws RbacObjectNotFoundException, RbacObjectInvalidException, RbacManagerException {
        this.invalidateCachedPermission(permission);
        this.rbacImpl.removePermission(permission);
    }

    public void removePermission(String permissionName) throws RbacObjectNotFoundException, RbacObjectInvalidException, RbacManagerException {
        this.permissionsCache.remove((Object)permissionName);
        this.rbacImpl.removePermission(permissionName);
    }

    public void removeResource(Resource resource) throws RbacObjectNotFoundException, RbacObjectInvalidException, RbacManagerException {
        this.invalidateCachedResource(resource);
        this.rbacImpl.removeResource(resource);
    }

    public void removeResource(String resourceIdentifier) throws RbacObjectNotFoundException, RbacObjectInvalidException, RbacManagerException {
        this.resourcesCache.remove((Object)resourceIdentifier);
        this.rbacImpl.removeResource(resourceIdentifier);
    }

    public void removeRole(Role role) throws RbacObjectNotFoundException, RbacObjectInvalidException, RbacManagerException {
        this.invalidateCachedRole(role);
        this.rbacImpl.removeRole(role);
    }

    public void removeRole(String roleName) throws RbacObjectNotFoundException, RbacObjectInvalidException, RbacManagerException {
        this.rolesCache.remove((Object)roleName);
        this.rbacImpl.removeRole(roleName);
    }

    public void removeUserAssignment(String principal) throws RbacObjectNotFoundException, RbacObjectInvalidException, RbacManagerException {
        this.invalidateCachedUserAssignment(principal);
        this.rbacImpl.removeUserAssignment(principal);
    }

    public void removeUserAssignment(UserAssignment userAssignment) throws RbacObjectNotFoundException, RbacObjectInvalidException, RbacManagerException {
        this.invalidateCachedUserAssignment(userAssignment);
        this.rbacImpl.removeUserAssignment(userAssignment);
    }

    public boolean resourceExists(Resource resource) {
        if (this.resourcesCache.hasKey((Object)resource.getIdentifier())) {
            return true;
        }
        return this.rbacImpl.resourceExists(resource);
    }

    public boolean resourceExists(String identifier) {
        if (this.resourcesCache.hasKey((Object)identifier)) {
            return true;
        }
        return this.rbacImpl.resourceExists(identifier);
    }

    public boolean roleExists(Role role) {
        if (this.rolesCache.hasKey((Object)role.getName())) {
            return true;
        }
        return this.rbacImpl.roleExists(role);
    }

    public boolean roleExists(String name) {
        if (this.rolesCache.hasKey((Object)name)) {
            return true;
        }
        return this.rbacImpl.roleExists(name);
    }

    public Operation saveOperation(Operation operation) throws RbacObjectInvalidException, RbacManagerException {
        this.invalidateCachedOperation(operation);
        return this.rbacImpl.saveOperation(operation);
    }

    public Permission savePermission(Permission permission) throws RbacObjectInvalidException, RbacManagerException {
        this.invalidateCachedPermission(permission);
        return this.rbacImpl.savePermission(permission);
    }

    public Resource saveResource(Resource resource) throws RbacObjectInvalidException, RbacManagerException {
        this.invalidateCachedResource(resource);
        return this.rbacImpl.saveResource(resource);
    }

    public synchronized Role saveRole(Role role) throws RbacObjectInvalidException, RbacManagerException {
        this.invalidateAllCachedUserAssignments();
        this.invalidateCachedRole(role);
        return this.rbacImpl.saveRole(role);
    }

    public synchronized void saveRoles(Collection<Role> roles) throws RbacObjectInvalidException, RbacManagerException {
        for (Role role : roles) {
            this.invalidateCachedRole(role);
        }
        this.invalidateAllCachedUserAssignments();
        this.rbacImpl.saveRoles(roles);
    }

    public UserAssignment saveUserAssignment(UserAssignment userAssignment) throws RbacObjectInvalidException, RbacManagerException {
        this.invalidateCachedUserAssignment(userAssignment);
        return this.rbacImpl.saveUserAssignment(userAssignment);
    }

    public boolean userAssignmentExists(String principal) {
        if (this.userAssignmentsCache.hasKey((Object)principal)) {
            return true;
        }
        return this.rbacImpl.userAssignmentExists(principal);
    }

    public boolean userAssignmentExists(UserAssignment assignment) {
        if (this.userAssignmentsCache.hasKey((Object)assignment.getPrincipal())) {
            return true;
        }
        return this.rbacImpl.userAssignmentExists(assignment);
    }

    private void invalidateCachedRole(Role role) {
        if (role != null) {
            this.rolesCache.remove((Object)role.getName());
            this.effectiveRoleSetCache.clear();
        }
    }

    private void invalidateCachedOperation(Operation operation) {
        if (operation != null) {
            this.operationsCache.remove((Object)operation.getName());
        }
    }

    private void invalidateCachedPermission(Permission permission) {
        if (permission != null) {
            this.permissionsCache.remove((Object)permission.getName());
        }
    }

    private void invalidateCachedResource(Resource resource) {
        if (resource != null) {
            this.resourcesCache.remove((Object)resource.getIdentifier());
        }
    }

    private void invalidateCachedUserAssignment(UserAssignment userAssignment) {
        if (userAssignment != null) {
            this.userAssignmentsCache.remove((Object)userAssignment.getPrincipal());
            this.userPermissionsCache.remove((Object)userAssignment.getPrincipal());
        }
    }

    private void invalidateCachedUserAssignment(String principal) {
        this.userAssignmentsCache.remove((Object)principal);
        this.userPermissionsCache.remove((Object)principal);
    }

    private void invalidateAllCachedUserAssignments() {
        this.userAssignmentsCache.clear();
        this.userPermissionsCache.clear();
    }

    public Cache getOperationsCache() {
        return this.operationsCache;
    }

    public void setOperationsCache(Cache operationsCache) {
        this.operationsCache = operationsCache;
    }

    public Cache getPermissionsCache() {
        return this.permissionsCache;
    }

    public void setPermissionsCache(Cache permissionsCache) {
        this.permissionsCache = permissionsCache;
    }

    public Cache getResourcesCache() {
        return this.resourcesCache;
    }

    public void setResourcesCache(Cache resourcesCache) {
        this.resourcesCache = resourcesCache;
    }

    public Cache getRolesCache() {
        return this.rolesCache;
    }

    public void setRolesCache(Cache rolesCache) {
        this.rolesCache = rolesCache;
    }

    public Cache getUserAssignmentsCache() {
        return this.userAssignmentsCache;
    }

    public void setUserAssignmentsCache(Cache userAssignmentsCache) {
        this.userAssignmentsCache = userAssignmentsCache;
    }

    public Cache getUserPermissionsCache() {
        return this.userPermissionsCache;
    }

    public void setUserPermissionsCache(Cache userPermissionsCache) {
        this.userPermissionsCache = userPermissionsCache;
    }

    public Cache getEffectiveRoleSetCache() {
        return this.effectiveRoleSetCache;
    }

    public void setEffectiveRoleSetCache(Cache effectiveRoleSetCache) {
        this.effectiveRoleSetCache = effectiveRoleSetCache;
    }

    public RBACManager getRbacImpl() {
        return this.rbacImpl;
    }

    public void setRbacImpl(RBACManager rbacImpl) {
        this.rbacImpl = rbacImpl;
    }
}

