/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.redback.rbac.jdo;

import java.util.Collection;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.jdo.JDOHelper;
import javax.jdo.PersistenceManager;
import javax.jdo.Transaction;
import org.apache.archiva.redback.rbac.AbstractRBACManager;
import org.apache.archiva.redback.rbac.Operation;
import org.apache.archiva.redback.rbac.Permission;
import org.apache.archiva.redback.rbac.RBACManagerListener;
import org.apache.archiva.redback.rbac.RBACObjectAssertions;
import org.apache.archiva.redback.rbac.RbacManagerException;
import org.apache.archiva.redback.rbac.RbacObjectInvalidException;
import org.apache.archiva.redback.rbac.RbacObjectNotFoundException;
import org.apache.archiva.redback.rbac.RbacPermanentException;
import org.apache.archiva.redback.rbac.Resource;
import org.apache.archiva.redback.rbac.Role;
import org.apache.archiva.redback.rbac.UserAssignment;
import org.apache.archiva.redback.rbac.jdo.JdoOperation;
import org.apache.archiva.redback.rbac.jdo.JdoPermission;
import org.apache.archiva.redback.rbac.jdo.JdoResource;
import org.apache.archiva.redback.rbac.jdo.JdoRole;
import org.apache.archiva.redback.rbac.jdo.JdoTool;
import org.apache.archiva.redback.rbac.jdo.JdoUserAssignment;
import org.apache.archiva.redback.rbac.jdo.RbacJdoModelModelloMetadata;
import org.springframework.stereotype.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(value="rBACManager#jdo")
public class JdoRbacManager
extends AbstractRBACManager
implements RBACManagerListener {
    @Inject
    private JdoTool jdo;
    private boolean enableCache = true;
    private static final String ROLE_DETAIL = null;

    public Role createRole(String name) {
        Role role;
        try {
            role = this.getRole(name);
        }
        catch (RbacManagerException e) {
            role = new JdoRole();
            role.setName(name);
        }
        return role;
    }

    public Role saveRole(Role role) throws RbacObjectInvalidException, RbacManagerException {
        RBACObjectAssertions.assertValid((Role)role);
        return (Role)this.jdo.saveObject(role, new String[]{ROLE_DETAIL});
    }

    public boolean roleExists(Role role) {
        return this.jdo.objectExists(role);
    }

    public boolean roleExists(String name) {
        try {
            return this.jdo.objectExistsById(JdoRole.class, name);
        }
        catch (RbacManagerException e) {
            return false;
        }
    }

    public Role getRole(String roleName) throws RbacObjectNotFoundException, RbacManagerException {
        return (Role)this.jdo.getObjectById(JdoRole.class, roleName, ROLE_DETAIL);
    }

    public List<Role> getAllRoles() throws RbacManagerException {
        return this.jdo.getAllObjects(JdoRole.class);
    }

    public void removeRole(Role role) throws RbacObjectNotFoundException, RbacObjectInvalidException, RbacManagerException {
        RBACObjectAssertions.assertValid((Role)role);
        if (role.isPermanent()) {
            throw new RbacPermanentException("Unable to delete permanent role [" + role.getName() + "]");
        }
        this.jdo.removeObject(role);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveRoles(Collection<Role> roles) throws RbacObjectInvalidException, RbacManagerException {
        if (roles == null) {
            return;
        }
        PersistenceManager pm = this.jdo.getPersistenceManager();
        Transaction tx = pm.currentTransaction();
        try {
            tx.begin();
            for (Role role : roles) {
                if (JDOHelper.getObjectId((Object)role) != null && !JDOHelper.isDetached((Object)role)) {
                    throw new RbacManagerException("Existing Role is not detached: " + role);
                }
                RBACObjectAssertions.assertValid((Role)role);
                pm.makePersistent((Object)role);
            }
            tx.commit();
        }
        finally {
            this.jdo.rollbackIfActive(tx);
        }
    }

    public Permission createPermission(String name) throws RbacManagerException {
        Permission permission;
        try {
            permission = this.getPermission(name);
            this.log.debug("Create Permission [{}] Returning Existing.", (Object)name);
        }
        catch (RbacObjectNotFoundException e) {
            permission = new JdoPermission();
            permission.setName(name);
            this.log.debug("Create Permission [{}] New JdoPermission.", (Object)name);
        }
        return permission;
    }

    public Permission createPermission(String name, String operationName, String resourceIdentifier) throws RbacManagerException {
        Resource resource;
        Operation operation;
        JdoPermission permission = new JdoPermission();
        permission.setName(name);
        try {
            operation = this.getOperation(operationName);
        }
        catch (RbacObjectNotFoundException e) {
            operation = new JdoOperation();
            operation.setName(operationName);
        }
        permission.setOperation(operation);
        try {
            resource = this.getResource(resourceIdentifier);
        }
        catch (RbacObjectNotFoundException e) {
            resource = new JdoResource();
            resource.setIdentifier(resourceIdentifier);
        }
        permission.setResource(resource);
        return permission;
    }

    public Permission savePermission(Permission permission) throws RbacObjectInvalidException, RbacManagerException {
        RBACObjectAssertions.assertValid((Permission)permission);
        return (Permission)this.jdo.saveObject(permission, null);
    }

    public boolean permissionExists(Permission permission) {
        return this.jdo.objectExists(permission);
    }

    public boolean permissionExists(String name) {
        try {
            return this.jdo.objectExistsById(JdoPermission.class, name);
        }
        catch (RbacManagerException e) {
            return false;
        }
    }

    public Permission getPermission(String permissionName) throws RbacObjectNotFoundException, RbacManagerException {
        return (Permission)this.jdo.getObjectById(JdoPermission.class, permissionName, null);
    }

    public List<Permission> getAllPermissions() throws RbacManagerException {
        return this.jdo.getAllObjects(JdoPermission.class);
    }

    public void removePermission(Permission permission) throws RbacObjectNotFoundException, RbacObjectInvalidException, RbacManagerException {
        RBACObjectAssertions.assertValid((Permission)permission);
        if (permission.isPermanent()) {
            throw new RbacPermanentException("Unable to delete permanent permission [" + permission.getName() + "]");
        }
        this.jdo.removeObject(permission);
    }

    public Operation createOperation(String name) throws RbacManagerException {
        Operation operation;
        try {
            operation = this.getOperation(name);
        }
        catch (RbacObjectNotFoundException e) {
            operation = new JdoOperation();
            operation.setName(name);
        }
        return operation;
    }

    public Operation saveOperation(Operation operation) throws RbacObjectInvalidException, RbacManagerException {
        RBACObjectAssertions.assertValid((Operation)operation);
        return (Operation)this.jdo.saveObject(operation, null);
    }

    public boolean operationExists(Operation operation) {
        return this.jdo.objectExists(operation);
    }

    public boolean operationExists(String name) {
        try {
            return this.jdo.objectExistsById(JdoOperation.class, name);
        }
        catch (RbacManagerException e) {
            return false;
        }
    }

    public Operation getOperation(String operationName) throws RbacObjectNotFoundException, RbacManagerException {
        return (Operation)this.jdo.getObjectById(JdoOperation.class, operationName, null);
    }

    public List<Operation> getAllOperations() throws RbacManagerException {
        return this.jdo.getAllObjects(JdoOperation.class);
    }

    public void removeOperation(Operation operation) throws RbacObjectNotFoundException, RbacObjectInvalidException, RbacManagerException {
        RBACObjectAssertions.assertValid((Operation)operation);
        if (operation.isPermanent()) {
            throw new RbacPermanentException("Unable to delete permanent operation [" + operation.getName() + "]");
        }
        this.jdo.removeObject(operation);
    }

    public Resource createResource(String identifier) throws RbacManagerException {
        Resource resource;
        try {
            resource = this.getResource(identifier);
            this.log.debug("Create Resource [ {} ] Returning Existing.", (Object)identifier);
        }
        catch (RbacObjectNotFoundException e) {
            resource = new JdoResource();
            resource.setIdentifier(identifier);
            this.log.debug("Create Resource [ {} ] New JdoResource.", (Object)identifier);
        }
        return resource;
    }

    public Resource saveResource(Resource resource) throws RbacObjectInvalidException, RbacManagerException {
        RBACObjectAssertions.assertValid((Resource)resource);
        return (Resource)this.jdo.saveObject(resource, null);
    }

    public boolean resourceExists(Resource resource) {
        return this.jdo.objectExists(resource);
    }

    public boolean resourceExists(String identifier) {
        try {
            return this.jdo.objectExistsById(JdoResource.class, identifier);
        }
        catch (RbacManagerException e) {
            return false;
        }
    }

    public Resource getResource(String resourceIdentifier) throws RbacObjectNotFoundException, RbacManagerException {
        return (Resource)this.jdo.getObjectById(JdoResource.class, resourceIdentifier, null);
    }

    public List<Resource> getAllResources() throws RbacManagerException {
        return this.jdo.getAllObjects(JdoResource.class);
    }

    public void removeResource(Resource resource) throws RbacObjectNotFoundException, RbacObjectInvalidException, RbacManagerException {
        RBACObjectAssertions.assertValid((Resource)resource);
        if (resource.isPermanent()) {
            throw new RbacPermanentException("Unable to delete permanent resource [" + resource.getIdentifier() + "]");
        }
        this.jdo.removeObject(resource);
    }

    public UserAssignment createUserAssignment(String principal) {
        UserAssignment ua;
        try {
            ua = this.getUserAssignment(principal);
        }
        catch (RbacManagerException e) {
            ua = new JdoUserAssignment();
            ua.setPrincipal(principal);
        }
        return ua;
    }

    public UserAssignment saveUserAssignment(UserAssignment userAssignment) throws RbacObjectInvalidException, RbacManagerException {
        RBACObjectAssertions.assertValid((String)"Save User Assignment", (UserAssignment)userAssignment);
        this.fireRbacUserAssignmentSaved(userAssignment);
        return (UserAssignment)this.jdo.saveObject(userAssignment, new String[]{ROLE_DETAIL});
    }

    public boolean userAssignmentExists(String principal) {
        try {
            return this.jdo.objectExistsById(JdoUserAssignment.class, principal);
        }
        catch (RbacManagerException e) {
            return false;
        }
    }

    public boolean userAssignmentExists(UserAssignment assignment) {
        return this.jdo.objectExists(assignment);
    }

    public UserAssignment getUserAssignment(String principal) throws RbacObjectNotFoundException, RbacManagerException {
        return (UserAssignment)this.jdo.getObjectById(JdoUserAssignment.class, principal, ROLE_DETAIL);
    }

    public List<UserAssignment> getAllUserAssignments() throws RbacManagerException {
        return this.jdo.getAllObjects(JdoUserAssignment.class);
    }

    public List<UserAssignment> getUserAssignmentsForRoles(Collection<String> roleNames) throws RbacManagerException {
        return this.jdo.getUserAssignmentsForRoles(JdoUserAssignment.class, null, roleNames);
    }

    public void removeUserAssignment(UserAssignment userAssignment) throws RbacObjectNotFoundException, RbacObjectInvalidException, RbacManagerException {
        RBACObjectAssertions.assertValid((UserAssignment)userAssignment);
        if (userAssignment.isPermanent()) {
            throw new RbacPermanentException("Unable to delete permanent user assignment [" + userAssignment.getPrincipal() + "]");
        }
        this.fireRbacUserAssignmentRemoved(userAssignment);
        this.jdo.removeObject(userAssignment);
    }

    public void eraseDatabase() {
        this.jdo.removeAll(JdoRole.class);
        this.jdo.removeAll(JdoPermission.class);
        this.jdo.removeAll(JdoOperation.class);
        this.jdo.removeAll(JdoResource.class);
        this.jdo.removeAll(JdoUserAssignment.class);
        this.jdo.removeAll(RbacJdoModelModelloMetadata.class);
    }

    @PostConstruct
    public void initialize() {
        super.initialize();
        this.jdo.setListener(this);
        if (this.enableCache) {
            this.jdo.enableCache(JdoRole.class);
            this.jdo.enableCache(JdoOperation.class);
            this.jdo.enableCache(JdoResource.class);
            this.jdo.enableCache(JdoUserAssignment.class);
            this.jdo.enableCache(JdoPermission.class);
        }
    }

    public void rbacInit(boolean freshdb) {
        this.fireRbacInit(freshdb);
    }

    public void rbacPermissionRemoved(Permission permission) {
        this.fireRbacPermissionRemoved(permission);
    }

    public void rbacPermissionSaved(Permission permission) {
        this.fireRbacPermissionSaved(permission);
    }

    public void rbacRoleRemoved(Role role) {
        this.fireRbacRoleRemoved(role);
    }

    public void rbacRoleSaved(Role role) {
        this.fireRbacRoleSaved(role);
    }

    public void rbacUserAssignmentSaved(UserAssignment userAssignment) {
        this.fireRbacUserAssignmentSaved(userAssignment);
    }

    public void rbacUserAssignmentRemoved(UserAssignment userAssignment) {
        this.fireRbacUserAssignmentRemoved(userAssignment);
    }

    public JdoTool getJdo() {
        return this.jdo;
    }

    public void setJdo(JdoTool jdo) {
        this.jdo = jdo;
    }

    public boolean isEnableCache() {
        return this.enableCache;
    }

    public void setEnableCache(boolean enableCache) {
        this.enableCache = enableCache;
    }
}

