/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.redback.rbac.jdo;

import java.io.PrintStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.jdo.Extent;
import javax.jdo.JDOException;
import javax.jdo.JDOHelper;
import javax.jdo.JDOObjectNotFoundException;
import javax.jdo.JDOUserException;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.jdo.Query;
import javax.jdo.Transaction;
import javax.jdo.datastore.DataStoreCache;
import javax.jdo.listener.DeleteLifecycleListener;
import javax.jdo.listener.InstanceLifecycleEvent;
import javax.jdo.listener.InstanceLifecycleListener;
import javax.jdo.listener.StoreLifecycleListener;
import javax.jdo.spi.Detachable;
import javax.jdo.spi.PersistenceCapable;
import org.apache.archiva.redback.components.jdo.JdoFactory;
import org.apache.archiva.redback.rbac.Permission;
import org.apache.archiva.redback.rbac.RBACManagerListener;
import org.apache.archiva.redback.rbac.RbacManagerException;
import org.apache.archiva.redback.rbac.RbacObjectNotFoundException;
import org.apache.archiva.redback.rbac.Role;
import org.apache.archiva.redback.rbac.jdo.JdoRole;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service(value="jdoTool")
public class JdoTool
implements DeleteLifecycleListener,
StoreLifecycleListener {
    @Resource(name="jdoFactory#users")
    private JdoFactory jdoFactory;
    private PersistenceManagerFactory pmf;
    private RBACManagerListener listener;
    private boolean hasTriggeredInit = false;

    @PostConstruct
    public void initialize() {
        this.pmf = this.jdoFactory.getPersistenceManagerFactory();
        this.pmf.addInstanceLifecycleListener((InstanceLifecycleListener)this, null);
    }

    public static void dumpObjectState(PrintStream out, Object o) {
        String STATE = "[STATE] ";
        String INDENT = "        ";
        if (o == null) {
            out.println("[STATE] Object is null.");
            return;
        }
        out.println("[STATE] Object " + o.getClass().getName());
        if (!(o instanceof PersistenceCapable)) {
            out.println("        is NOT PersistenceCapable (not a jdo object?)");
            return;
        }
        out.println("        is PersistenceCapable.");
        if (o instanceof Detachable) {
            out.println("        is Detachable");
        }
        out.println("        is new : " + Boolean.toString(JDOHelper.isNew((Object)o)));
        out.println("        is transactional : " + Boolean.toString(JDOHelper.isTransactional((Object)o)));
        out.println("        is deleted : " + Boolean.toString(JDOHelper.isDeleted((Object)o)));
        out.println("        is detached : " + Boolean.toString(JDOHelper.isDetached((Object)o)));
        out.println("        is dirty : " + Boolean.toString(JDOHelper.isDirty((Object)o)));
        out.println("        is persistent : " + Boolean.toString(JDOHelper.isPersistent((Object)o)));
        out.println("        object id : " + JDOHelper.getObjectId((Object)o));
    }

    public PersistenceManager getPersistenceManager() {
        PersistenceManager pm = this.pmf.getPersistenceManager();
        pm.getFetchPlan().setMaxFetchDepth(-1);
        this.triggerInit();
        return pm;
    }

    public void triggerInit() {
        if (!this.hasTriggeredInit) {
            this.hasTriggeredInit = true;
            List<?> roles = this.getAllObjects(JdoRole.class);
            this.listener.rbacInit(roles.isEmpty());
        }
    }

    public void enableCache(Class<?> clazz) {
        DataStoreCache cache = this.pmf.getDataStoreCache();
        if (cache.getClass().getName().equals("org.jpox.cache.EhcacheClassBasedLevel2Cache") || cache.getClass().getName().equals("org.jpox.cache.EhcacheLevel2Cache")) {
            return;
        }
        cache.pinAll(clazz, false);
    }

    public <T> T saveObject(T object) {
        return this.saveObject(object, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T saveObject(T object, String[] fetchGroups) {
        PersistenceManager pm = this.getPersistenceManager();
        Transaction tx = pm.currentTransaction();
        try {
            tx.begin();
            if (JDOHelper.getObjectId(object) != null && !JDOHelper.isDetached(object)) {
                throw new JDOUserException("Existing object is not detached: " + object, object);
            }
            if (fetchGroups != null) {
                for (int i = 0; i >= fetchGroups.length; ++i) {
                    pm.getFetchPlan().addGroup(fetchGroups[i]);
                }
            }
            pm.makePersistent(object);
            object = pm.detachCopy(object);
            tx.commit();
            Object object2 = object;
            return object2;
        }
        finally {
            this.rollbackIfActive(tx);
        }
    }

    public List<?> getAllObjects(Class<?> clazz) {
        return this.getAllObjects(clazz, null, null);
    }

    public List<?> getAllObjects(Class<?> clazz, String ordering) {
        return this.getAllObjects(clazz, ordering, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<?> getAllObjects(Class<?> clazz, String ordering, String fetchGroup) {
        PersistenceManager pm = this.getPersistenceManager();
        Transaction tx = pm.currentTransaction();
        try {
            tx.begin();
            Extent extent = pm.getExtent(clazz, true);
            Query query = pm.newQuery(extent);
            if (ordering != null) {
                query.setOrdering(ordering);
            }
            if (fetchGroup != null) {
                pm.getFetchPlan().addGroup(fetchGroup);
            }
            List result = (List)query.execute();
            result = (List)pm.detachCopyAll((Collection)result);
            tx.commit();
            List list = result;
            return list;
        }
        finally {
            this.rollbackIfActive(tx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<?> getUserAssignmentsForRoles(Class<?> clazz, String ordering, Collection<String> roleNames) {
        PersistenceManager pm = this.getPersistenceManager();
        Transaction tx = pm.currentTransaction();
        try {
            tx.begin();
            Extent extent = pm.getExtent(clazz, true);
            Query query = pm.newQuery(extent);
            if (ordering != null) {
                query.setOrdering(ordering);
            }
            query.declareImports("import java.lang.String");
            StringBuilder filter = new StringBuilder();
            if (roleNames.size() > 0) {
                Iterator<String> i = roleNames.iterator();
                filter.append("this.roleNames.contains(\"").append(i.next()).append("\")");
                while (i.hasNext()) {
                    filter.append(" || this.roleNames.contains(\"").append(i.next()).append("\")");
                }
                query.setFilter(filter.toString());
            }
            List result = (List)query.execute();
            result = (List)pm.detachCopyAll((Collection)result);
            tx.commit();
            List list = result;
            return list;
        }
        finally {
            this.rollbackIfActive(tx);
        }
    }

    public <T> T getObjectById(Class<T> clazz, String id, String fetchGroup) throws RbacObjectNotFoundException, RbacManagerException {
        if (StringUtils.isEmpty((String)id)) {
            throw new RbacObjectNotFoundException("Unable to get object '" + clazz.getName() + "' from jdo using null/empty id.");
        }
        PersistenceManager pm = this.getPersistenceManager();
        Transaction tx = pm.currentTransaction();
        try {
            tx.begin();
            if (fetchGroup != null) {
                pm.getFetchPlan().addGroup(fetchGroup);
            }
            Object objectId = pm.newObjectIdInstance(clazz, (Object)id);
            Object object = pm.getObjectById(objectId);
            object = pm.detachCopy(object);
            tx.commit();
            Object object2 = object;
            return (T)object2;
        }
        catch (JDOObjectNotFoundException e) {
            throw new RbacObjectNotFoundException("Unable to find RBAC Object '" + id + "' of type " + clazz.getName() + " using fetch-group '" + fetchGroup + "'", (Throwable)e, (Object)id);
        }
        catch (JDOException e) {
            throw new RbacManagerException("Error in JDO during get of RBAC object id '" + id + "' of type " + clazz.getName() + " using fetch-group '" + fetchGroup + "'", (Throwable)e);
        }
        finally {
            this.rollbackIfActive(tx);
        }
    }

    public boolean objectExists(Object object) {
        return JDOHelper.getObjectId((Object)object) != null;
    }

    public boolean objectExistsById(Class<?> clazz, String id) throws RbacManagerException {
        try {
            Object o = this.getObjectById(clazz, id, null);
            return o != null;
        }
        catch (RbacObjectNotFoundException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T removeObject(T o) throws RbacManagerException {
        if (o == null) {
            throw new RbacManagerException("Unable to remove null object");
        }
        PersistenceManager pm = this.getPersistenceManager();
        Transaction tx = pm.currentTransaction();
        try {
            tx.begin();
            o = pm.getObjectById(pm.getObjectId(o));
            pm.deletePersistent(o);
            tx.commit();
            Object object = o;
            return object;
        }
        finally {
            this.rollbackIfActive(tx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollbackIfActive(Transaction tx) {
        PersistenceManager pm = tx.getPersistenceManager();
        try {
            if (tx.isActive()) {
                tx.rollback();
            }
        }
        finally {
            this.closePersistenceManager(pm);
        }
    }

    public void closePersistenceManager(PersistenceManager pm) {
        try {
            pm.close();
        }
        catch (JDOUserException jDOUserException) {
            // empty catch block
        }
    }

    public RBACManagerListener getListener() {
        return this.listener;
    }

    public void setListener(RBACManagerListener listener) {
        this.listener = listener;
    }

    public void postDelete(InstanceLifecycleEvent evt) {
        PersistenceCapable obj = (PersistenceCapable)evt.getSource();
        if (obj == null) {
            return;
        }
        if (obj instanceof Role) {
            this.listener.rbacRoleRemoved((Role)obj);
        } else if (obj instanceof Permission) {
            this.listener.rbacPermissionRemoved((Permission)obj);
        }
    }

    public void preDelete(InstanceLifecycleEvent evt) {
    }

    public void postStore(InstanceLifecycleEvent evt) {
        PersistenceCapable obj = (PersistenceCapable)evt.getSource();
        if (obj instanceof Role) {
            this.listener.rbacRoleSaved((Role)obj);
        } else if (obj instanceof Permission) {
            this.listener.rbacPermissionSaved((Permission)obj);
        }
    }

    public void preStore(InstanceLifecycleEvent evt) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll(Class<?> aClass) {
        PersistenceManager pm = this.getPersistenceManager();
        Transaction tx = pm.currentTransaction();
        try {
            tx.begin();
            Query query = pm.newQuery(aClass);
            query.deletePersistentAll();
            tx.commit();
        }
        finally {
            this.rollbackIfActive(tx);
        }
    }

    public JdoFactory getJdoFactory() {
        return this.jdoFactory;
    }

    public void setJdoFactory(JdoFactory jdoFactory) {
        this.jdoFactory = jdoFactory;
    }
}

