/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.redback.rbac.jdo.io.stax;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.jdo.spi.PersistenceCapable;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.archiva.redback.rbac.Operation;
import org.apache.archiva.redback.rbac.Resource;
import org.apache.archiva.redback.rbac.jdo.JdoOperation;
import org.apache.archiva.redback.rbac.jdo.JdoPermission;
import org.apache.archiva.redback.rbac.jdo.JdoResource;
import org.apache.archiva.redback.rbac.jdo.JdoRole;
import org.apache.archiva.redback.rbac.jdo.JdoUserAssignment;
import org.apache.archiva.redback.rbac.jdo.RbacDatabase;

public class RbacJdoModelStaxReader {
    private Map jdoPermissionReferences;
    private Map jdoPermissionInstances;
    private Map jdoOperationReferences;
    private Map jdoResourceReferences;
    private Map jdoOperationInstances;
    private Map jdoResourceInstances;

    public RbacDatabase read(Reader reader, boolean strict) throws IOException, XMLStreamException {
        XMLStreamReader xmlStreamReader = XMLInputFactory.newInstance().createXMLStreamReader(reader);
        return this.read(xmlStreamReader, strict);
    }

    public RbacDatabase read(Reader reader) throws IOException, XMLStreamException {
        return this.read(reader, true);
    }

    public RbacDatabase read(InputStream stream, boolean strict) throws IOException, XMLStreamException {
        XMLStreamReader xmlStreamReader = XMLInputFactory.newInstance().createXMLStreamReader(stream);
        return this.read(xmlStreamReader, strict);
    }

    public RbacDatabase read(InputStream stream) throws IOException, XMLStreamException {
        return this.read(stream, true);
    }

    public RbacDatabase read(String filePath, boolean strict) throws IOException, XMLStreamException {
        File file = new File(filePath);
        XMLStreamReader xmlStreamReader = XMLInputFactory.newInstance().createXMLStreamReader(file.toURI().toURL().toExternalForm(), new FileInputStream(file));
        return this.read(xmlStreamReader, strict);
    }

    public RbacDatabase read(String filePath) throws IOException, XMLStreamException {
        return this.read(filePath, true);
    }

    private boolean checkFieldWithDuplicate(XMLStreamReader xmlStreamReader, String tagName, String alias, Set parsed) throws XMLStreamException {
        if (!xmlStreamReader.getLocalName().equals(tagName) && !xmlStreamReader.getLocalName().equals(alias)) {
            return false;
        }
        if (!parsed.add(tagName)) {
            throw new XMLStreamException("Duplicated tag: '" + tagName + "'", xmlStreamReader.getLocation());
        }
        return true;
    }

    private void checkUnknownElement(XMLStreamReader xmlStreamReader, boolean strict) throws XMLStreamException {
        if (strict) {
            throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
        }
        int unrecognizedTagCount = 1;
        while (unrecognizedTagCount != 0) {
            xmlStreamReader.next();
            if (xmlStreamReader.getEventType() == 1) {
                ++unrecognizedTagCount;
                continue;
            }
            if (xmlStreamReader.getEventType() != 2) continue;
            --unrecognizedTagCount;
        }
    }

    private boolean getBooleanValue(String s, String attribute, XMLStreamReader xmlStreamReader) throws XMLStreamException {
        if (s != null) {
            return Boolean.valueOf(s);
        }
        return false;
    }

    private byte getByteValue(String s, String attribute, XMLStreamReader xmlStreamReader, boolean strict) throws XMLStreamException {
        block3: {
            if (s != null) {
                try {
                    return Byte.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XMLStreamException("Unable to parse element '" + attribute + "', must be a byte but was '" + s + "'", xmlStreamReader.getLocation(), nfe);
                }
            }
        }
        return 0;
    }

    private char getCharacterValue(String s, String attribute, XMLStreamReader xmlStreamReader) throws XMLStreamException {
        if (s != null) {
            return s.charAt(0);
        }
        return '\u0000';
    }

    private Date getDateValue(String s, String attribute, String dateFormat, XMLStreamReader xmlStreamReader) throws XMLStreamException {
        if (s != null) {
            String effectiveDateFormat = dateFormat;
            if (dateFormat == null) {
                effectiveDateFormat = "yyyy-MM-dd'T'HH:mm:ss.SSS";
            }
            if ("long".equals(effectiveDateFormat)) {
                try {
                    return new Date(Long.parseLong(s));
                }
                catch (NumberFormatException e) {
                    throw new XMLStreamException(e.getMessage(), xmlStreamReader.getLocation(), e);
                }
            }
            try {
                SimpleDateFormat dateParser = new SimpleDateFormat(effectiveDateFormat, Locale.US);
                return dateParser.parse(s);
            }
            catch (ParseException e) {
                throw new XMLStreamException(e.getMessage(), xmlStreamReader.getLocation(), e);
            }
        }
        return null;
    }

    private String getDefaultValue(String s, String v) {
        if (s == null) {
            s = v;
        }
        return s;
    }

    private double getDoubleValue(String s, String attribute, XMLStreamReader xmlStreamReader, boolean strict) throws XMLStreamException {
        block3: {
            if (s != null) {
                try {
                    return Double.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XMLStreamException("Unable to parse element '" + attribute + "', must be a floating point number but was '" + s + "'", xmlStreamReader.getLocation(), nfe);
                }
            }
        }
        return 0.0;
    }

    private float getFloatValue(String s, String attribute, XMLStreamReader xmlStreamReader, boolean strict) throws XMLStreamException {
        block3: {
            if (s != null) {
                try {
                    return Float.valueOf(s).floatValue();
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XMLStreamException("Unable to parse element '" + attribute + "', must be a floating point number but was '" + s + "'", xmlStreamReader.getLocation(), nfe);
                }
            }
        }
        return 0.0f;
    }

    private int getIntegerValue(String s, String attribute, XMLStreamReader xmlStreamReader, boolean strict) throws XMLStreamException {
        block3: {
            if (s != null) {
                try {
                    return Integer.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XMLStreamException("Unable to parse element '" + attribute + "', must be an integer but was '" + s + "'", xmlStreamReader.getLocation(), nfe);
                }
            }
        }
        return 0;
    }

    private long getLongValue(String s, String attribute, XMLStreamReader xmlStreamReader, boolean strict) throws XMLStreamException {
        block3: {
            if (s != null) {
                try {
                    return Long.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XMLStreamException("Unable to parse element '" + attribute + "', must be a long integer but was '" + s + "'", xmlStreamReader.getLocation(), nfe);
                }
            }
        }
        return 0L;
    }

    private String getRequiredAttributeValue(String s, String attribute, XMLStreamReader xmlStreamReader, boolean strict) throws XMLStreamException {
        if (s == null && strict) {
            throw new XMLStreamException("Missing required value for attribute '" + attribute + "'", xmlStreamReader.getLocation());
        }
        return s;
    }

    private short getShortValue(String s, String attribute, XMLStreamReader xmlStreamReader, boolean strict) throws XMLStreamException {
        block3: {
            if (s != null) {
                try {
                    return Short.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XMLStreamException("Unable to parse element '" + attribute + "', must be a short integer but was '" + s + "'", xmlStreamReader.getLocation(), nfe);
                }
            }
        }
        return 0;
    }

    private String getTrimmedValue(String s) {
        if (s != null) {
            s = s.trim();
        }
        return s;
    }

    private int nextTag(XMLStreamReader xmlStreamReader) throws XMLStreamException {
        block4: while (true) {
            int eventType = xmlStreamReader.next();
            switch (eventType) {
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 12: {
                    continue block4;
                }
                case 1: 
                case 2: {
                    return eventType;
                }
            }
            break;
        }
        throw new XMLStreamException("expected start or end tag", xmlStreamReader.getLocation());
    }

    private JdoOperation parseJdoOperation(XMLStreamReader xmlStreamReader, boolean strict) throws IOException, XMLStreamException {
        String v;
        JdoOperation jdoOperation = new JdoOperation();
        HashSet parsed = new HashSet();
        if (this.jdoOperationInstances == null) {
            this.jdoOperationInstances = new HashMap();
        }
        if ((v = xmlStreamReader.getAttributeValue(null, "modello.id")) != null) {
            this.jdoOperationInstances.put(v, jdoOperation);
        }
        while ((strict ? xmlStreamReader.nextTag() : this.nextTag(xmlStreamReader)) == 1) {
            if (this.checkFieldWithDuplicate(xmlStreamReader, "name", null, parsed)) {
                jdoOperation.setName(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(xmlStreamReader, "description", null, parsed)) {
                jdoOperation.setDescription(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(xmlStreamReader, "permanent", null, parsed)) {
                jdoOperation.setPermanent(this.getBooleanValue(this.getTrimmedValue(this.getDefaultValue(xmlStreamReader.getElementText(), "false")), "permanent", xmlStreamReader));
                continue;
            }
            if (this.checkFieldWithDuplicate(xmlStreamReader, "resourceRequired", null, parsed)) {
                jdoOperation.setResourceRequired(this.getBooleanValue(this.getTrimmedValue(this.getDefaultValue(xmlStreamReader.getElementText(), "false")), "resourceRequired", xmlStreamReader));
                continue;
            }
            this.checkUnknownElement(xmlStreamReader, strict);
        }
        this.jdoOperationInstances.put(jdoOperation.getName(), jdoOperation);
        return jdoOperation;
    }

    private JdoPermission parseJdoPermission(XMLStreamReader xmlStreamReader, boolean strict) throws IOException, XMLStreamException {
        String v;
        JdoPermission jdoPermission = new JdoPermission();
        HashSet parsed = new HashSet();
        if (this.jdoPermissionInstances == null) {
            this.jdoPermissionInstances = new HashMap();
        }
        if ((v = xmlStreamReader.getAttributeValue(null, "modello.id")) != null) {
            this.jdoPermissionInstances.put(v, jdoPermission);
        }
        while ((strict ? xmlStreamReader.nextTag() : this.nextTag(xmlStreamReader)) == 1) {
            Map<String, String> refs;
            String value;
            if (this.checkFieldWithDuplicate(xmlStreamReader, "name", null, parsed)) {
                jdoPermission.setName(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(xmlStreamReader, "description", null, parsed)) {
                jdoPermission.setDescription(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(xmlStreamReader, "permanent", null, parsed)) {
                jdoPermission.setPermanent(this.getBooleanValue(this.getTrimmedValue(this.getDefaultValue(xmlStreamReader.getElementText(), "false")), "permanent", xmlStreamReader));
                continue;
            }
            if (this.checkFieldWithDuplicate(xmlStreamReader, "operation", null, parsed)) {
                value = xmlStreamReader.getAttributeValue(null, "name");
                if (value != null) {
                    if (this.jdoOperationReferences == null) {
                        this.jdoOperationReferences = new HashMap();
                    }
                    if ((refs = (HashMap<String, String>)this.jdoOperationReferences.get(jdoPermission)) == null) {
                        refs = new HashMap<String, String>();
                        this.jdoOperationReferences.put(jdoPermission, refs);
                    }
                    refs.put("operation", value);
                }
                while (xmlStreamReader.getEventType() != 2) {
                    xmlStreamReader.next();
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(xmlStreamReader, "resource", null, parsed)) {
                value = xmlStreamReader.getAttributeValue(null, "identifier");
                if (value != null) {
                    if (this.jdoResourceReferences == null) {
                        this.jdoResourceReferences = new HashMap();
                    }
                    if ((refs = (Map)this.jdoResourceReferences.get(jdoPermission)) == null) {
                        refs = new HashMap();
                        this.jdoResourceReferences.put(jdoPermission, refs);
                    }
                    refs.put("resource", value);
                }
                while (xmlStreamReader.getEventType() != 2) {
                    xmlStreamReader.next();
                }
                continue;
            }
            this.checkUnknownElement(xmlStreamReader, strict);
        }
        this.jdoPermissionInstances.put(jdoPermission.getName(), jdoPermission);
        return jdoPermission;
    }

    private JdoResource parseJdoResource(XMLStreamReader xmlStreamReader, boolean strict) throws IOException, XMLStreamException {
        String v;
        JdoResource jdoResource = new JdoResource();
        HashSet parsed = new HashSet();
        if (this.jdoResourceInstances == null) {
            this.jdoResourceInstances = new HashMap();
        }
        if ((v = xmlStreamReader.getAttributeValue(null, "modello.id")) != null) {
            this.jdoResourceInstances.put(v, jdoResource);
        }
        while ((strict ? xmlStreamReader.nextTag() : this.nextTag(xmlStreamReader)) == 1) {
            if (this.checkFieldWithDuplicate(xmlStreamReader, "identifier", null, parsed)) {
                jdoResource.setIdentifier(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(xmlStreamReader, "pattern", null, parsed)) {
                jdoResource.setPattern(this.getBooleanValue(this.getTrimmedValue(this.getDefaultValue(xmlStreamReader.getElementText(), "false")), "pattern", xmlStreamReader));
                continue;
            }
            if (this.checkFieldWithDuplicate(xmlStreamReader, "permanent", null, parsed)) {
                jdoResource.setPermanent(this.getBooleanValue(this.getTrimmedValue(this.getDefaultValue(xmlStreamReader.getElementText(), "false")), "permanent", xmlStreamReader));
                continue;
            }
            this.checkUnknownElement(xmlStreamReader, strict);
        }
        this.jdoResourceInstances.put(jdoResource.getIdentifier(), jdoResource);
        return jdoResource;
    }

    private JdoRole parseJdoRole(XMLStreamReader xmlStreamReader, boolean strict) throws IOException, XMLStreamException {
        JdoRole jdoRole = new JdoRole();
        HashSet parsed = new HashSet();
        while ((strict ? xmlStreamReader.nextTag() : this.nextTag(xmlStreamReader)) == 1) {
            if (this.checkFieldWithDuplicate(xmlStreamReader, "name", null, parsed)) {
                jdoRole.setName(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(xmlStreamReader, "description", null, parsed)) {
                jdoRole.setDescription(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(xmlStreamReader, "assignable", null, parsed)) {
                jdoRole.setAssignable(this.getBooleanValue(this.getTrimmedValue(this.getDefaultValue(xmlStreamReader.getElementText(), "false")), "assignable", xmlStreamReader));
                continue;
            }
            if (this.checkFieldWithDuplicate(xmlStreamReader, "permanent", null, parsed)) {
                jdoRole.setPermanent(this.getBooleanValue(this.getTrimmedValue(this.getDefaultValue(xmlStreamReader.getElementText(), "false")), "permanent", xmlStreamReader));
                continue;
            }
            if (this.checkFieldWithDuplicate(xmlStreamReader, "childRoleNames", null, parsed)) {
                ArrayList<String> childRoleNames = new ArrayList<String>();
                jdoRole.setChildRoleNames(childRoleNames);
                while (xmlStreamReader.nextTag() == 1) {
                    if ("childRoleName".equals(xmlStreamReader.getLocalName())) {
                        childRoleNames.add(this.getTrimmedValue(this.getDefaultValue(xmlStreamReader.getElementText(), "new java.util.ArrayList/*<String>*/()")));
                        continue;
                    }
                    throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(xmlStreamReader, "permissions", null, parsed)) {
                ArrayList permissions = new ArrayList();
                jdoRole.setPermissions(permissions);
                while (xmlStreamReader.nextTag() == 1) {
                    if ("permission".equals(xmlStreamReader.getLocalName())) {
                        String value = xmlStreamReader.getAttributeValue(null, "name");
                        if (value != null) {
                            HashMap<String, String> refs;
                            if (this.jdoPermissionReferences == null) {
                                this.jdoPermissionReferences = new HashMap();
                            }
                            if ((refs = (HashMap<String, String>)this.jdoPermissionReferences.get(jdoRole)) == null) {
                                refs = new HashMap<String, String>();
                                this.jdoPermissionReferences.put(jdoRole, refs);
                            }
                            refs.put("permissions." + permissions.size(), value);
                        }
                        jdoRole.addPermission(this.parseJdoPermission(xmlStreamReader, strict));
                        continue;
                    }
                    throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                continue;
            }
            this.checkUnknownElement(xmlStreamReader, strict);
        }
        return jdoRole;
    }

    private JdoUserAssignment parseJdoUserAssignment(XMLStreamReader xmlStreamReader, boolean strict) throws IOException, XMLStreamException {
        JdoUserAssignment jdoUserAssignment = new JdoUserAssignment();
        HashSet parsed = new HashSet();
        while ((strict ? xmlStreamReader.nextTag() : this.nextTag(xmlStreamReader)) == 1) {
            if (this.checkFieldWithDuplicate(xmlStreamReader, "principal", null, parsed)) {
                jdoUserAssignment.setPrincipal(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(xmlStreamReader, "timestamp", null, parsed)) {
                String dateFormat = "long";
                jdoUserAssignment.setTimestamp(this.getDateValue(this.getTrimmedValue(xmlStreamReader.getElementText()), "timestamp", dateFormat, xmlStreamReader));
                continue;
            }
            if (this.checkFieldWithDuplicate(xmlStreamReader, "permanent", null, parsed)) {
                jdoUserAssignment.setPermanent(this.getBooleanValue(this.getTrimmedValue(this.getDefaultValue(xmlStreamReader.getElementText(), "false")), "permanent", xmlStreamReader));
                continue;
            }
            if (this.checkFieldWithDuplicate(xmlStreamReader, "roleNames", null, parsed)) {
                ArrayList<String> roleNames = new ArrayList<String>();
                jdoUserAssignment.setRoleNames(roleNames);
                while (xmlStreamReader.nextTag() == 1) {
                    if ("roleName".equals(xmlStreamReader.getLocalName())) {
                        roleNames.add(this.getTrimmedValue(this.getDefaultValue(xmlStreamReader.getElementText(), "new java.util.ArrayList/*<String>*/()")));
                        continue;
                    }
                    throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                continue;
            }
            this.checkUnknownElement(xmlStreamReader, strict);
        }
        return jdoUserAssignment;
    }

    private RbacDatabase parseRbacDatabase(XMLStreamReader xmlStreamReader, boolean strict) throws IOException, XMLStreamException {
        RbacDatabase rbacDatabase = new RbacDatabase();
        HashSet parsed = new HashSet();
        while ((strict ? xmlStreamReader.nextTag() : this.nextTag(xmlStreamReader)) == 1) {
            if (this.checkFieldWithDuplicate(xmlStreamReader, "roles", null, parsed)) {
                ArrayList roles = new ArrayList();
                rbacDatabase.setRoles(roles);
                while (xmlStreamReader.nextTag() == 1) {
                    if ("role".equals(xmlStreamReader.getLocalName())) {
                        rbacDatabase.addRole(this.parseJdoRole(xmlStreamReader, strict));
                        continue;
                    }
                    throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(xmlStreamReader, "permissions", null, parsed)) {
                ArrayList permissions = new ArrayList();
                rbacDatabase.setPermissions(permissions);
                while (xmlStreamReader.nextTag() == 1) {
                    if ("permission".equals(xmlStreamReader.getLocalName())) {
                        rbacDatabase.addPermission(this.parseJdoPermission(xmlStreamReader, strict));
                        continue;
                    }
                    throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(xmlStreamReader, "operations", null, parsed)) {
                ArrayList operations = new ArrayList();
                rbacDatabase.setOperations(operations);
                while (xmlStreamReader.nextTag() == 1) {
                    if ("operation".equals(xmlStreamReader.getLocalName())) {
                        rbacDatabase.addOperation(this.parseJdoOperation(xmlStreamReader, strict));
                        continue;
                    }
                    throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(xmlStreamReader, "resources", null, parsed)) {
                ArrayList resources = new ArrayList();
                rbacDatabase.setResources(resources);
                while (xmlStreamReader.nextTag() == 1) {
                    if ("resource".equals(xmlStreamReader.getLocalName())) {
                        rbacDatabase.addResource(this.parseJdoResource(xmlStreamReader, strict));
                        continue;
                    }
                    throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(xmlStreamReader, "userAssignments", null, parsed)) {
                ArrayList userAssignments = new ArrayList();
                rbacDatabase.setUserAssignments(userAssignments);
                while (xmlStreamReader.nextTag() == 1) {
                    if ("userAssignment".equals(xmlStreamReader.getLocalName())) {
                        rbacDatabase.addUserAssignment(this.parseJdoUserAssignment(xmlStreamReader, strict));
                        continue;
                    }
                    throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                continue;
            }
            this.checkUnknownElement(xmlStreamReader, strict);
        }
        return rbacDatabase;
    }

    private RbacDatabase read(XMLStreamReader xmlStreamReader, boolean strict) throws IOException, XMLStreamException {
        int eventType = xmlStreamReader.getEventType();
        String encoding = null;
        while (eventType != 8) {
            if (eventType == 7) {
                encoding = xmlStreamReader.getCharacterEncodingScheme();
            }
            if (eventType == 1) {
                if (strict && !"rbacDatabase".equals(xmlStreamReader.getLocalName())) {
                    throw new XMLStreamException("Expected root element 'rbacDatabase' but found '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation(), null);
                }
                RbacDatabase rbacDatabase = this.parseRbacDatabase(xmlStreamReader, strict);
                rbacDatabase.setModelEncoding(encoding);
                this.resolveReferences(rbacDatabase);
                return rbacDatabase;
            }
            eventType = xmlStreamReader.next();
        }
        throw new XMLStreamException("Expected root element 'rbacDatabase' but found no element at all: invalid XML document", xmlStreamReader.getLocation(), null);
    }

    private void resolveReferences(RbacDatabase value) {
        Iterator i = value.getRoles().iterator();
        while (i.hasNext()) {
            this.resolveReferences((JdoRole)i.next());
        }
        i = value.getPermissions().iterator();
        while (i.hasNext()) {
            this.resolveReferences((JdoPermission)i.next());
        }
    }

    private void resolveReferences(JdoRole value) {
        Map refs;
        if (this.jdoPermissionReferences != null && (refs = (Map)this.jdoPermissionReferences.get(value)) != null) {
            for (int i = 0; i < value.getPermissions().size(); ++i) {
                String id = (String)refs.get("permissions." + i);
                JdoPermission ref = (JdoPermission)this.jdoPermissionInstances.get(id);
                if (ref == null) continue;
                value.getPermissions().set(i, ref);
            }
        }
    }

    private void resolveReferences(JdoPermission value) {
        String id;
        PersistenceCapable ref;
        Map refs;
        if (this.jdoOperationReferences != null && (refs = (Map)this.jdoOperationReferences.get(value)) != null && (ref = (JdoOperation)this.jdoOperationInstances.get(id = (String)refs.get("operation"))) != null && !ref.equals(value.getOperation())) {
            value.setOperation((Operation)ref);
        }
        if (this.jdoResourceReferences != null && (refs = (Map)this.jdoResourceReferences.get(value)) != null && (ref = (JdoResource)this.jdoResourceInstances.get(id = (String)refs.get("resource"))) != null && !ref.equals(value.getResource())) {
            value.setResource((Resource)ref);
        }
    }
}

