/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.redback.rbac.jdo.io.stax;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.jdo.spi.PersistenceCapable;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.archiva.redback.rbac.jdo.JdoOperation;
import org.apache.archiva.redback.rbac.jdo.JdoPermission;
import org.apache.archiva.redback.rbac.jdo.JdoResource;
import org.apache.archiva.redback.rbac.jdo.JdoRole;
import org.apache.archiva.redback.rbac.jdo.JdoUserAssignment;
import org.apache.archiva.redback.rbac.jdo.RbacDatabase;
import org.apache.archiva.redback.rbac.jdo.io.stax.IndentingXMLStreamWriter;

public class RbacJdoModelStaxWriter {
    private int curId;
    private Map idMap = new HashMap();

    public void write(Writer writer, RbacDatabase rbacDatabase) throws IOException, XMLStreamException {
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        boolean supportWindowsLineEndings = false;
        if (factory.isPropertySupported("com.ctc.wstx.outputEscapeCr")) {
            factory.setProperty("com.ctc.wstx.outputEscapeCr", Boolean.FALSE);
            supportWindowsLineEndings = true;
        }
        if (factory.isPropertySupported("org.codehaus.stax2.automaticEmptyElements")) {
            factory.setProperty("org.codehaus.stax2.automaticEmptyElements", Boolean.FALSE);
        }
        IndentingXMLStreamWriter serializer = new IndentingXMLStreamWriter(factory.createXMLStreamWriter(writer));
        if (supportWindowsLineEndings) {
            serializer.setNewLine(serializer.getLineSeparator());
        }
        serializer.writeStartDocument(rbacDatabase.getModelEncoding(), "1.0");
        this.writeRbacDatabase(rbacDatabase, "rbacDatabase", serializer);
        serializer.writeEndDocument();
    }

    public void write(OutputStream stream, RbacDatabase rbacDatabase) throws IOException, XMLStreamException {
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        boolean supportWindowsLineEndings = false;
        if (factory.isPropertySupported("com.ctc.wstx.outputEscapeCr")) {
            factory.setProperty("com.ctc.wstx.outputEscapeCr", Boolean.FALSE);
            supportWindowsLineEndings = true;
        }
        if (factory.isPropertySupported("org.codehaus.stax2.automaticEmptyElements")) {
            factory.setProperty("org.codehaus.stax2.automaticEmptyElements", Boolean.FALSE);
        }
        IndentingXMLStreamWriter serializer = new IndentingXMLStreamWriter(factory.createXMLStreamWriter(stream, rbacDatabase.getModelEncoding()));
        if (supportWindowsLineEndings) {
            serializer.setNewLine(serializer.getLineSeparator());
        }
        serializer.writeStartDocument(rbacDatabase.getModelEncoding(), "1.0");
        this.writeRbacDatabase(rbacDatabase, "rbacDatabase", serializer);
        serializer.writeEndDocument();
    }

    private void writeJdoOperation(JdoOperation jdoOperation, String tagName, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (jdoOperation != null) {
            serializer.writeStartElement(tagName);
            if (jdoOperation.getName() != null) {
                serializer.writeStartElement("name");
                serializer.writeCharacters(jdoOperation.getName());
                serializer.writeEndElement();
            }
            if (jdoOperation.getDescription() != null) {
                serializer.writeStartElement("description");
                serializer.writeCharacters(jdoOperation.getDescription());
                serializer.writeEndElement();
            }
            if (jdoOperation.isPermanent()) {
                serializer.writeStartElement("permanent");
                serializer.writeCharacters(String.valueOf(jdoOperation.isPermanent()));
                serializer.writeEndElement();
            }
            if (jdoOperation.isResourceRequired()) {
                serializer.writeStartElement("resourceRequired");
                serializer.writeCharacters(String.valueOf(jdoOperation.isResourceRequired()));
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
        }
    }

    private void writeJdoPermission(JdoPermission jdoPermission, String tagName, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (jdoPermission != null) {
            serializer.writeStartElement(tagName);
            if (jdoPermission.getName() != null) {
                serializer.writeStartElement("name");
                serializer.writeCharacters(jdoPermission.getName());
                serializer.writeEndElement();
            }
            if (jdoPermission.getDescription() != null) {
                serializer.writeStartElement("description");
                serializer.writeCharacters(jdoPermission.getDescription());
                serializer.writeEndElement();
            }
            if (jdoPermission.isPermanent()) {
                serializer.writeStartElement("permanent");
                serializer.writeCharacters(String.valueOf(jdoPermission.isPermanent()));
                serializer.writeEndElement();
            }
            if (jdoPermission.getOperation() != null) {
                serializer.writeStartElement("operation");
                serializer.writeAttribute("name", jdoPermission.getOperation().getName());
                serializer.writeEndElement();
            }
            if (jdoPermission.getResource() != null) {
                serializer.writeStartElement("resource");
                serializer.writeAttribute("identifier", jdoPermission.getResource().getIdentifier());
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
        }
    }

    private void writeJdoResource(JdoResource jdoResource, String tagName, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (jdoResource != null) {
            serializer.writeStartElement(tagName);
            if (jdoResource.getIdentifier() != null) {
                serializer.writeStartElement("identifier");
                serializer.writeCharacters(jdoResource.getIdentifier());
                serializer.writeEndElement();
            }
            if (jdoResource.isPattern()) {
                serializer.writeStartElement("pattern");
                serializer.writeCharacters(String.valueOf(jdoResource.isPattern()));
                serializer.writeEndElement();
            }
            if (jdoResource.isPermanent()) {
                serializer.writeStartElement("permanent");
                serializer.writeCharacters(String.valueOf(jdoResource.isPermanent()));
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
        }
    }

    private void writeJdoRole(JdoRole jdoRole, String tagName, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (jdoRole != null) {
            serializer.writeStartElement(tagName);
            if (jdoRole.getName() != null) {
                serializer.writeStartElement("name");
                serializer.writeCharacters(jdoRole.getName());
                serializer.writeEndElement();
            }
            if (jdoRole.getDescription() != null) {
                serializer.writeStartElement("description");
                serializer.writeCharacters(jdoRole.getDescription());
                serializer.writeEndElement();
            }
            if (jdoRole.isAssignable()) {
                serializer.writeStartElement("assignable");
                serializer.writeCharacters(String.valueOf(jdoRole.isAssignable()));
                serializer.writeEndElement();
            }
            if (jdoRole.isPermanent()) {
                serializer.writeStartElement("permanent");
                serializer.writeCharacters(String.valueOf(jdoRole.isPermanent()));
                serializer.writeEndElement();
            }
            if (jdoRole.getChildRoleNames() != null && jdoRole.getChildRoleNames().size() > 0) {
                serializer.writeStartElement("childRoleNames");
                for (String childRoleName : jdoRole.getChildRoleNames()) {
                    serializer.writeStartElement("childRoleName");
                    serializer.writeCharacters(childRoleName);
                    serializer.writeEndElement();
                }
                serializer.writeEndElement();
            }
            if (jdoRole.getPermissions() != null && jdoRole.getPermissions().size() > 0) {
                serializer.writeStartElement("permissions");
                for (JdoPermission o : jdoRole.getPermissions()) {
                    serializer.writeStartElement("permission");
                    serializer.writeAttribute("name", o.getName());
                    serializer.writeEndElement();
                }
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
        }
    }

    private void writeJdoUserAssignment(JdoUserAssignment jdoUserAssignment, String tagName, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (jdoUserAssignment != null) {
            serializer.writeStartElement(tagName);
            if (jdoUserAssignment.getPrincipal() != null) {
                serializer.writeStartElement("principal");
                serializer.writeCharacters(jdoUserAssignment.getPrincipal());
                serializer.writeEndElement();
            }
            if (jdoUserAssignment.getTimestamp() != null) {
                serializer.writeStartElement("timestamp");
                serializer.writeCharacters(String.valueOf(jdoUserAssignment.getTimestamp().getTime()));
                serializer.writeEndElement();
            }
            if (jdoUserAssignment.isPermanent()) {
                serializer.writeStartElement("permanent");
                serializer.writeCharacters(String.valueOf(jdoUserAssignment.isPermanent()));
                serializer.writeEndElement();
            }
            if (jdoUserAssignment.getRoleNames() != null && jdoUserAssignment.getRoleNames().size() > 0) {
                serializer.writeStartElement("roleNames");
                for (String roleName : jdoUserAssignment.getRoleNames()) {
                    serializer.writeStartElement("roleName");
                    serializer.writeCharacters(roleName);
                    serializer.writeEndElement();
                }
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
        }
    }

    private void writeRbacDatabase(RbacDatabase rbacDatabase, String tagName, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (rbacDatabase != null) {
            serializer.writeStartElement(tagName);
            if (rbacDatabase.getRoles() != null && rbacDatabase.getRoles().size() > 0) {
                serializer.writeStartElement("roles");
                for (PersistenceCapable o : rbacDatabase.getRoles()) {
                    this.writeJdoRole((JdoRole)o, "role", serializer);
                }
                serializer.writeEndElement();
            }
            if (rbacDatabase.getPermissions() != null && rbacDatabase.getPermissions().size() > 0) {
                serializer.writeStartElement("permissions");
                for (PersistenceCapable o : rbacDatabase.getPermissions()) {
                    this.writeJdoPermission((JdoPermission)o, "permission", serializer);
                }
                serializer.writeEndElement();
            }
            if (rbacDatabase.getOperations() != null && rbacDatabase.getOperations().size() > 0) {
                serializer.writeStartElement("operations");
                for (PersistenceCapable o : rbacDatabase.getOperations()) {
                    this.writeJdoOperation((JdoOperation)o, "operation", serializer);
                }
                serializer.writeEndElement();
            }
            if (rbacDatabase.getResources() != null && rbacDatabase.getResources().size() > 0) {
                serializer.writeStartElement("resources");
                for (PersistenceCapable o : rbacDatabase.getResources()) {
                    this.writeJdoResource((JdoResource)o, "resource", serializer);
                }
                serializer.writeEndElement();
            }
            if (rbacDatabase.getUserAssignments() != null && rbacDatabase.getUserAssignments().size() > 0) {
                serializer.writeStartElement("userAssignments");
                for (PersistenceCapable o : rbacDatabase.getUserAssignments()) {
                    this.writeJdoUserAssignment((JdoUserAssignment)o, "userAssignment", serializer);
                }
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
        }
    }
}

