/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.redback.rest.api.services;

import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.archiva.redback.authorization.RedbackAuthorization;
import org.apache.archiva.redback.rest.api.model.Application;
import org.apache.archiva.redback.rest.api.model.ApplicationRoles;
import org.apache.archiva.redback.rest.api.model.Role;
import org.apache.archiva.redback.rest.api.model.User;
import org.apache.archiva.redback.rest.api.services.RedbackServiceException;

@Path(value="/roleManagementService/")
public interface RoleManagementService {
    @Path(value="createTemplatedRole")
    @GET
    @Produces(value={"application/json", "application/xml", "text/plain"})
    @RedbackAuthorization(permissions={"user-management-rbac-admin"})
    public Boolean createTemplatedRole(@QueryParam(value="templateId") String var1, @QueryParam(value="resource") String var2) throws RedbackServiceException;

    @Path(value="removeTemplatedRole")
    @GET
    @Produces(value={"application/json", "application/xml", "text/plain"})
    @RedbackAuthorization(permissions={"user-management-rbac-admin"})
    public Boolean removeTemplatedRole(@QueryParam(value="templateId") String var1, @QueryParam(value="resource") String var2) throws RedbackServiceException;

    @Path(value="updateRole")
    @GET
    @Produces(value={"application/json", "application/xml", "text/plain"})
    @RedbackAuthorization(permissions={"user-management-rbac-admin"})
    public Boolean updateRole(@QueryParam(value="templateId") String var1, @QueryParam(value="oldResource") String var2, @QueryParam(value="newResource") String var3) throws RedbackServiceException;

    @Path(value="assignRole")
    @GET
    @Produces(value={"application/json", "application/xml", "text/plain"})
    @RedbackAuthorization(permissions={"user-management-rbac-admin"})
    public Boolean assignRole(@QueryParam(value="roleId") String var1, @QueryParam(value="principal") String var2) throws RedbackServiceException;

    @Path(value="assignRoleByName")
    @GET
    @Produces(value={"application/json", "application/xml", "text/plain"})
    @RedbackAuthorization(permissions={"user-management-rbac-admin"})
    public Boolean assignRoleByName(@QueryParam(value="roleName") String var1, @QueryParam(value="principal") String var2) throws RedbackServiceException;

    @Path(value="assignTemplatedRole")
    @GET
    @Produces(value={"application/json", "application/xml", "text/plain"})
    @RedbackAuthorization(permissions={"user-management-rbac-admin"})
    public Boolean assignTemplatedRole(@QueryParam(value="templateId") String var1, @QueryParam(value="resource") String var2, @QueryParam(value="principal") String var3) throws RedbackServiceException;

    @Path(value="unassignRole")
    @GET
    @Produces(value={"application/json", "application/xml", "text/plain"})
    @RedbackAuthorization(permissions={"user-management-rbac-admin"})
    public Boolean unassignRole(@QueryParam(value="roleId") String var1, @QueryParam(value="principal") String var2) throws RedbackServiceException;

    @Path(value="unassignRoleByName")
    @GET
    @Produces(value={"application/json", "application/xml", "text/plain"})
    @RedbackAuthorization(permissions={"user-management-rbac-admin"})
    public Boolean unassignRoleByName(@QueryParam(value="roleName") String var1, @QueryParam(value="principal") String var2) throws RedbackServiceException;

    @Path(value="roleExists")
    @GET
    @Produces(value={"application/json", "application/xml", "text/plain"})
    @RedbackAuthorization(permissions={"user-management-rbac-admin"})
    public Boolean roleExists(@QueryParam(value="roleId") String var1) throws RedbackServiceException;

    @Path(value="templatedRoleExists")
    @GET
    @Produces(value={"application/json", "application/xml", "text/plain"})
    @RedbackAuthorization(permissions={"user-management-rbac-admin"})
    public Boolean templatedRoleExists(@QueryParam(value="templateId") String var1, @QueryParam(value="resource") String var2) throws RedbackServiceException;

    @Path(value="verifyTemplatedRole")
    @GET
    @Produces(value={"application/json", "application/xml", "text/plain"})
    @RedbackAuthorization(permissions={"user-management-rbac-admin"})
    public Boolean verifyTemplatedRole(@QueryParam(value="templateId") String var1, @QueryParam(value="resource") String var2) throws RedbackServiceException;

    @Path(value="getEffectivelyAssignedRoles/{username}")
    @GET
    @Produces(value={"application/json", "application/xml", "text/plain"})
    @RedbackAuthorization(permissions={"user-management-rbac-admin"})
    public List<Role> getEffectivelyAssignedRoles(@PathParam(value="username") String var1) throws RedbackServiceException;

    @Path(value="allRoles")
    @GET
    @Produces(value={"application/json", "application/xml", "text/plain"})
    @RedbackAuthorization(permissions={"user-management-rbac-admin"})
    public List<Role> getAllRoles() throws RedbackServiceException;

    @Path(value="detailledAllRoles")
    @GET
    @Produces(value={"application/json", "application/xml", "text/plain"})
    @RedbackAuthorization(permissions={"user-management-rbac-admin"})
    public List<Role> getDetailedAllRoles() throws RedbackServiceException;

    @Path(value="getApplications/{username}")
    @GET
    @Produces(value={"application/json", "application/xml", "text/plain"})
    @RedbackAuthorization(permissions={"user-management-rbac-admin"})
    public List<Application> getApplications(@PathParam(value="username") String var1) throws RedbackServiceException;

    @Path(value="getRole/{roleName}")
    @GET
    @Produces(value={"application/json", "application/xml", "text/plain"})
    @RedbackAuthorization(permissions={"user-management-rbac-admin"})
    public Role getRole(@PathParam(value="roleName") String var1) throws RedbackServiceException;

    @Path(value="updateRoleDescription")
    @GET
    @Produces(value={"application/json", "application/xml", "text/plain"})
    @RedbackAuthorization(permissions={"user-management-rbac-admin"})
    public Boolean updateRoleDescription(@QueryParam(value="roleName") String var1, @QueryParam(value="roleDescription") String var2) throws RedbackServiceException;

    @Path(value="updateRoleUsers")
    @POST
    @Produces(value={"application/json", "application/xml"})
    @Consumes(value={"application/json", "application/xml"})
    @RedbackAuthorization(permissions={"user-management-rbac-admin"})
    public Boolean updateRoleUsers(Role var1) throws RedbackServiceException;

    @Path(value="getApplicationRoles/{username}")
    @GET
    @Produces(value={"application/json", "application/xml"})
    @RedbackAuthorization(permissions={"user-management-rbac-admin"})
    public List<ApplicationRoles> getApplicationRoles(@PathParam(value="username") String var1) throws RedbackServiceException;

    @Path(value="updateUserRoles")
    @POST
    @Produces(value={"application/json", "application/xml"})
    @Consumes(value={"application/json", "application/xml"})
    @RedbackAuthorization(permissions={"user-management-rbac-admin"})
    public Boolean updateUserRoles(User var1) throws RedbackServiceException;
}

