/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.redback.system;

import java.io.Serializable;
import org.apache.archiva.redback.authentication.AuthenticationResult;
import org.apache.archiva.redback.system.SecuritySession;
import org.apache.archiva.redback.users.User;
import org.springframework.stereotype.Service;

@Service(value="securitySession")
public class DefaultSecuritySession
implements SecuritySession,
Serializable {
    private AuthenticationResult authenticationResult;
    private User user;
    private boolean authenticated;

    public DefaultSecuritySession() {
        this.authenticationResult = new AuthenticationResult();
        this.user = null;
        this.authenticated = false;
    }

    public DefaultSecuritySession(AuthenticationResult authResult) {
        this.authenticationResult = authResult;
        this.user = null;
        this.authenticated = false;
    }

    public DefaultSecuritySession(AuthenticationResult authenticationResult, User user) {
        this.authenticationResult = authenticationResult;
        this.user = user;
        this.authenticated = true;
    }

    @Override
    public AuthenticationResult getAuthenticationResult() {
        return this.authenticationResult;
    }

    @Override
    public User getUser() {
        return this.user;
    }

    @Override
    public boolean isAuthenticated() {
        return this.user != null && this.authenticated;
    }
}

