/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.redback.users.jdo.io.stax;

import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javanet.staxutils.IndentingXMLStreamWriter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.archiva.redback.users.jdo.JdoUser;
import org.apache.archiva.redback.users.jdo.UserDatabase;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public class UsersManagementStaxWriter {
    private int curId;
    private Map idMap = new HashMap();

    public void write(Writer writer, UserDatabase userDatabase) throws IOException, XMLStreamException {
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        boolean supportWindowsLineEndings = false;
        if (factory.isPropertySupported("com.ctc.wstx.outputEscapeCr")) {
            factory.setProperty("com.ctc.wstx.outputEscapeCr", Boolean.FALSE);
            supportWindowsLineEndings = true;
        }
        if (factory.isPropertySupported("org.codehaus.stax2.automaticEmptyElements")) {
            factory.setProperty("org.codehaus.stax2.automaticEmptyElements", Boolean.FALSE);
        }
        IndentingXMLStreamWriter serializer = new IndentingXMLStreamWriter(factory.createXMLStreamWriter(writer));
        if (supportWindowsLineEndings) {
            serializer.setNewLine(serializer.getLineSeparator());
        }
        serializer.writeStartDocument(userDatabase.getModelEncoding(), "1.0");
        this.writeUserDatabase(userDatabase, "userDatabase", (XMLStreamWriter)serializer);
        serializer.writeEndDocument();
    }

    public void writeDom(Xpp3Dom dom, XMLStreamWriter serializer) throws XMLStreamException {
        serializer.writeStartElement(dom.getName());
        String[] attributeNames = dom.getAttributeNames();
        for (int i = 0; i < attributeNames.length; ++i) {
            String attributeName = attributeNames[i];
            serializer.writeAttribute(attributeName, dom.getAttribute(attributeName));
        }
        Xpp3Dom[] children = dom.getChildren();
        for (int i = 0; i < children.length; ++i) {
            this.writeDom(children[i], serializer);
        }
        String value = dom.getValue();
        if (value != null) {
            serializer.writeCharacters(value);
        }
        serializer.writeEndElement();
    }

    private void writeJdoUser(JdoUser jdoUser, String tagName, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (jdoUser != null) {
            serializer.writeStartElement(tagName);
            if (jdoUser.getUsername() != null) {
                serializer.writeStartElement("username");
                serializer.writeCharacters(jdoUser.getUsername());
                serializer.writeEndElement();
            }
            if (jdoUser.getPassword() != null) {
                serializer.writeStartElement("password");
                serializer.writeCharacters(jdoUser.getPassword());
                serializer.writeEndElement();
            }
            if (jdoUser.getEncodedPassword() != null) {
                serializer.writeStartElement("encodedPassword");
                serializer.writeCharacters(jdoUser.getEncodedPassword());
                serializer.writeEndElement();
            }
            if (jdoUser.getFullName() != null) {
                serializer.writeStartElement("fullName");
                serializer.writeCharacters(jdoUser.getFullName());
                serializer.writeEndElement();
            }
            if (jdoUser.getEmail() != null) {
                serializer.writeStartElement("email");
                serializer.writeCharacters(jdoUser.getEmail());
                serializer.writeEndElement();
            }
            if (jdoUser.getLastPasswordChange() != null) {
                serializer.writeStartElement("lastPasswordChange");
                serializer.writeCharacters(Long.toString(jdoUser.getLastPasswordChange().getTime()));
                serializer.writeEndElement();
            }
            if (jdoUser.getLastLoginDate() != null) {
                serializer.writeStartElement("lastLoginDate");
                serializer.writeCharacters(Long.toString(jdoUser.getLastLoginDate().getTime()));
                serializer.writeEndElement();
            }
            if (jdoUser.getCountFailedLoginAttempts() != 0) {
                serializer.writeStartElement("countFailedLoginAttempts");
                serializer.writeCharacters(String.valueOf(jdoUser.getCountFailedLoginAttempts()));
                serializer.writeEndElement();
            }
            if (jdoUser.isLocked()) {
                serializer.writeStartElement("locked");
                serializer.writeCharacters(String.valueOf(jdoUser.isLocked()));
                serializer.writeEndElement();
            }
            if (jdoUser.isPermanent()) {
                serializer.writeStartElement("permanent");
                serializer.writeCharacters(String.valueOf(jdoUser.isPermanent()));
                serializer.writeEndElement();
            }
            if (jdoUser.isValidated()) {
                serializer.writeStartElement("validated");
                serializer.writeCharacters(String.valueOf(jdoUser.isValidated()));
                serializer.writeEndElement();
            }
            if (jdoUser.isPasswordChangeRequired()) {
                serializer.writeStartElement("passwordChangeRequired");
                serializer.writeCharacters(String.valueOf(jdoUser.isPasswordChangeRequired()));
                serializer.writeEndElement();
            }
            if (jdoUser.getPreviousEncodedPasswords() != null && jdoUser.getPreviousEncodedPasswords().size() > 0) {
                serializer.writeStartElement("previousEncodedPasswords");
                for (String previousEncodedPassword : jdoUser.getPreviousEncodedPasswords()) {
                    serializer.writeStartElement("previousEncodedPassword");
                    serializer.writeCharacters(previousEncodedPassword);
                    serializer.writeEndElement();
                }
                serializer.writeEndElement();
            }
            if (jdoUser.getAccountCreationDate() != null) {
                serializer.writeStartElement("accountCreationDate");
                serializer.writeCharacters(Long.toString(jdoUser.getAccountCreationDate().getTime()));
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
        }
    }

    private void writeUserDatabase(UserDatabase userDatabase, String tagName, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (userDatabase != null) {
            serializer.writeStartElement(tagName);
            if (userDatabase.getUsers() != null && userDatabase.getUsers().size() > 0) {
                serializer.writeStartElement("users");
                for (JdoUser o : userDatabase.getUsers()) {
                    this.writeJdoUser(o, "user", serializer);
                }
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
        }
    }
}

