/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.redback.users.jdo;

import java.util.ArrayList;
import java.util.HashSet;
import org.apache.archiva.redback.users.AbstractUserQuery;
import org.codehaus.plexus.util.StringUtils;

public class JdoUserQuery
extends AbstractUserQuery {
    public String getOrdering() {
        StringBuilder ordering = new StringBuilder();
        if ("email".equals(this.getOrderBy())) {
            ordering.append("email");
        } else if ("fullname".equals(this.getOrderBy())) {
            ordering.append("fullName");
        } else {
            ordering.append("username");
        }
        ordering.append(" ").append(this.isAscending() ? "ascending" : "descending");
        return ordering.toString();
    }

    public String getFilter() {
        HashSet<String> terms = new HashSet<String>();
        if (this.getUsername() != null) {
            terms.add("this.username.toLowerCase().indexOf(usernameKey.toLowerCase()) > -1");
        }
        if (this.getFullName() != null) {
            terms.add("this.fullName.toLowerCase().indexOf(fullNameKey.toLowerCase()) > -1");
        }
        if (this.getEmail() != null) {
            terms.add("this.email.toLowerCase().indexOf(emailKey.toLowerCase()) > -1");
        }
        return StringUtils.join(terms.iterator(), (String)" && ");
    }

    public String[] getSearchKeys() {
        ArrayList<String> keys = new ArrayList<String>();
        if (this.getUsername() != null) {
            keys.add(this.getUsername());
        }
        if (this.getFullName() != null) {
            keys.add(this.getFullName());
        }
        if (this.getEmail() != null) {
            keys.add(this.getEmail());
        }
        return keys.toArray(new String[keys.size()]);
    }

    public String getParameters() {
        ArrayList<String> params = new ArrayList<String>();
        if (this.getUsername() != null) {
            params.add("String usernameKey");
        }
        if (this.getFullName() != null) {
            params.add("String fullNameKey");
        }
        if (this.getEmail() != null) {
            params.add("String emailKey");
        }
        return StringUtils.join(params.iterator(), (String)", ");
    }
}

