/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Properties;
import java.util.TimeZone;
import org.apache.arrow.driver.jdbc.ArrowDatabaseMetadata;
import org.apache.arrow.driver.jdbc.ArrowFlightConnection;
import org.apache.arrow.driver.jdbc.ArrowFlightJdbcDriver;
import org.apache.arrow.driver.jdbc.ArrowFlightJdbcFlightStreamResultSet;
import org.apache.arrow.driver.jdbc.ArrowFlightJdbcVectorSchemaRootResultSet;
import org.apache.arrow.driver.jdbc.ArrowFlightPreparedStatement;
import org.apache.arrow.driver.jdbc.ArrowFlightStatement;
import org.apache.arrow.driver.jdbc.client.ArrowFlightSqlClientHandler;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.AvaticaConnection;
import org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.AvaticaFactory;
import org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.AvaticaResultSetMetaData;
import org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.AvaticaSpecificDatabaseMetaData;
import org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.AvaticaStatement;
import org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.Meta;
import org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.QueryState;
import org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.UnregisteredDriver;

public class ArrowFlightJdbcFactory
implements AvaticaFactory {
    private final int major;
    private final int minor;

    public ArrowFlightJdbcFactory() {
        this(4, 1);
    }

    private ArrowFlightJdbcFactory(int major, int minor) {
        this.major = major;
        this.minor = minor;
    }

    @Override
    public AvaticaConnection newConnection(UnregisteredDriver driver, AvaticaFactory factory, String url, Properties info) throws SQLException {
        return ArrowFlightConnection.createNewConnection((ArrowFlightJdbcDriver)driver, factory, url, info, new RootAllocator(Long.MAX_VALUE));
    }

    @Override
    public AvaticaStatement newStatement(AvaticaConnection connection, Meta.StatementHandle handle, int resultType, int resultSetConcurrency, int resultSetHoldability) {
        return new ArrowFlightStatement((ArrowFlightConnection)connection, handle, resultType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public ArrowFlightPreparedStatement newPreparedStatement(AvaticaConnection connection, Meta.StatementHandle statementHandle, Meta.Signature signature, int resultType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        ArrowFlightConnection flightConnection = (ArrowFlightConnection)connection;
        ArrowFlightSqlClientHandler.PreparedStatement preparedStatement = flightConnection.getMeta().getPreparedStatement(statementHandle);
        return ArrowFlightPreparedStatement.newPreparedStatement(flightConnection, preparedStatement, statementHandle, signature, resultType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public ArrowFlightJdbcVectorSchemaRootResultSet newResultSet(AvaticaStatement statement, QueryState state, Meta.Signature signature, TimeZone timeZone, Meta.Frame frame) throws SQLException {
        ResultSetMetaData metaData = this.newResultSetMetaData(statement, signature);
        return new ArrowFlightJdbcFlightStreamResultSet(statement, state, signature, metaData, timeZone, frame);
    }

    @Override
    public AvaticaSpecificDatabaseMetaData newDatabaseMetaData(AvaticaConnection connection) {
        return new ArrowDatabaseMetadata(connection);
    }

    @Override
    public ResultSetMetaData newResultSetMetaData(AvaticaStatement avaticaStatement, Meta.Signature signature) {
        return new AvaticaResultSetMetaData(avaticaStatement, null, signature);
    }

    @Override
    public int getJdbcMajorVersion() {
        return this.major;
    }

    @Override
    public int getJdbcMinorVersion() {
        return this.minor;
    }
}

