/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc;

import java.sql.Time;
import java.time.LocalTime;
import java.time.temporal.ChronoField;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.arrow.driver.jdbc.shaded.com.google.common.collect.ImmutableList;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.util.VisibleForTesting;

public class ArrowFlightJdbcTime
extends Time {
    private static final List<String> LEADING_ZEROES = ImmutableList.of("", "0", "00");
    private static final int DESIRED_MILLIS_LENGTH = 3;
    private final int millisReprValue;

    public ArrowFlightJdbcTime(long milliseconds) {
        super(milliseconds);
        this.millisReprValue = this.getMillisReprValue(milliseconds);
    }

    @VisibleForTesting
    ArrowFlightJdbcTime(LocalTime time) {
        super(time.getHour(), time.getMinute(), time.getSecond());
        this.millisReprValue = time.get(ChronoField.MILLI_OF_SECOND);
    }

    private int getMillisReprValue(long milliseconds) {
        if (milliseconds >= 86400000L) {
            milliseconds %= 86400000L;
        } else if (milliseconds < 0L) {
            milliseconds -= (milliseconds / 86400000L - 1L) * 86400000L;
        }
        return LocalTime.ofNanoOfDay(TimeUnit.MILLISECONDS.toNanos(milliseconds)).get(ChronoField.MILLI_OF_SECOND);
    }

    @Override
    public String toString() {
        StringBuilder time = new StringBuilder().append(super.toString());
        if (this.millisReprValue > 0) {
            String millisString = Integer.toString(this.millisReprValue);
            time.append(".");
            int millisLength = millisString.length();
            if (millisLength < 3) {
                time.append(LEADING_ZEROES.get(3 - millisLength));
            }
            time.append(millisString);
        }
        return time.toString();
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.millisReprValue);
    }
}

