/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.shaded.io.grpc.internal;

import java.util.Map;
import org.apache.arrow.driver.jdbc.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.arrow.driver.jdbc.shaded.io.grpc.LoadBalancer;
import org.apache.arrow.driver.jdbc.shaded.io.grpc.LoadBalancerProvider;
import org.apache.arrow.driver.jdbc.shaded.io.grpc.NameResolver;
import org.apache.arrow.driver.jdbc.shaded.io.grpc.Status;
import org.apache.arrow.driver.jdbc.shaded.io.grpc.internal.GrpcUtil;
import org.apache.arrow.driver.jdbc.shaded.io.grpc.internal.JsonUtil;
import org.apache.arrow.driver.jdbc.shaded.io.grpc.internal.PickFirstLeafLoadBalancer;
import org.apache.arrow.driver.jdbc.shaded.io.grpc.internal.PickFirstLoadBalancer;

public final class PickFirstLoadBalancerProvider
extends LoadBalancerProvider {
    private static final String SHUFFLE_ADDRESS_LIST_KEY = "shuffleAddressList";
    static boolean enableNewPickFirst = GrpcUtil.getFlag("GRPC_EXPERIMENTAL_ENABLE_NEW_PICK_FIRST", true);

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public int getPriority() {
        return 5;
    }

    @Override
    public String getPolicyName() {
        return "pick_first";
    }

    @Override
    public LoadBalancer newLoadBalancer(LoadBalancer.Helper helper) {
        if (enableNewPickFirst) {
            return new PickFirstLeafLoadBalancer(helper);
        }
        return new PickFirstLoadBalancer(helper);
    }

    @Override
    public NameResolver.ConfigOrError parseLoadBalancingPolicyConfig(Map<String, ?> rawLbPolicyConfig) {
        try {
            Object config = PickFirstLoadBalancerProvider.getLbPolicyConfig(rawLbPolicyConfig);
            return NameResolver.ConfigOrError.fromConfig(config);
        }
        catch (RuntimeException e) {
            return NameResolver.ConfigOrError.fromError(Status.UNAVAILABLE.withCause(e).withDescription("Failed parsing configuration for " + this.getPolicyName()));
        }
    }

    private static Object getLbPolicyConfig(Map<String, ?> rawLbPolicyConfig) {
        Boolean shuffleAddressList = JsonUtil.getBoolean(rawLbPolicyConfig, SHUFFLE_ADDRESS_LIST_KEY);
        if (enableNewPickFirst) {
            return new PickFirstLeafLoadBalancer.PickFirstLeafLoadBalancerConfig(shuffleAddressList);
        }
        return new PickFirstLoadBalancer.PickFirstLoadBalancerConfig(shuffleAddressList);
    }

    @VisibleForTesting
    public static boolean isEnabledNewPickFirst() {
        return enableNewPickFirst;
    }
}

