/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.auth;

import org.apache.arrow.driver.jdbc.shaded.io.grpc.CallOptions;
import org.apache.arrow.driver.jdbc.shaded.io.grpc.Channel;
import org.apache.arrow.driver.jdbc.shaded.io.grpc.ClientCall;
import org.apache.arrow.driver.jdbc.shaded.io.grpc.ClientInterceptor;
import org.apache.arrow.driver.jdbc.shaded.io.grpc.ForwardingClientCall;
import org.apache.arrow.driver.jdbc.shaded.io.grpc.Metadata;
import org.apache.arrow.driver.jdbc.shaded.io.grpc.MethodDescriptor;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.auth.AuthConstants;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.auth.ClientAuthHandler;

public class ClientAuthInterceptor
implements ClientInterceptor {
    private volatile ClientAuthHandler authHandler = null;

    public void setAuthHandler(ClientAuthHandler authHandler) {
        this.authHandler = authHandler;
    }

    public boolean hasAuthHandler() {
        return this.authHandler != null;
    }

    @Override
    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> methodDescriptor, CallOptions callOptions, Channel next) {
        ClientCall<ReqT, RespT> call = next.newCall(methodDescriptor, callOptions);
        if (this.authHandler != null) {
            call = new HeaderAttachingClientCall(call);
        }
        return call;
    }

    private final class HeaderAttachingClientCall<ReqT, RespT>
    extends ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT> {
        private HeaderAttachingClientCall(ClientCall<ReqT, RespT> call) {
            super(call);
        }

        @Override
        public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
            Metadata authHeaders = new Metadata();
            authHeaders.put(AuthConstants.TOKEN_KEY, ClientAuthInterceptor.this.authHandler.getCallToken());
            headers.merge(authHeaders);
            super.start(responseListener, headers);
        }
    }
}

