/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.arrow.driver.jdbc.shaded.com.fasterxml.jackson.databind.util.ByteBufferBackedInputStream;
import org.apache.arrow.driver.jdbc.shaded.com.google.protobuf.ByteString;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.FlightDescriptor;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.FlightEndpoint;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.impl.Flight;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.ipc.ReadChannel;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.ipc.WriteChannel;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.ipc.message.IpcOption;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.ipc.message.MessageSerializer;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.types.pojo.Schema;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.validate.MetadataV4UnionChecker;

public class FlightInfo {
    private final Schema schema;
    private final FlightDescriptor descriptor;
    private final List<FlightEndpoint> endpoints;
    private final long bytes;
    private final long records;
    private final boolean ordered;
    private final IpcOption option;
    private final byte[] appMetadata;

    public FlightInfo(Schema schema, FlightDescriptor descriptor, List<FlightEndpoint> endpoints, long bytes, long records) {
        this(schema, descriptor, endpoints, bytes, records, false, IpcOption.DEFAULT);
    }

    public FlightInfo(Schema schema, FlightDescriptor descriptor, List<FlightEndpoint> endpoints, long bytes, long records, IpcOption option) {
        this(schema, descriptor, endpoints, bytes, records, false, option);
    }

    public FlightInfo(Schema schema, FlightDescriptor descriptor, List<FlightEndpoint> endpoints, long bytes, long records, boolean ordered, IpcOption option) {
        this(schema, descriptor, endpoints, bytes, records, ordered, option, null);
    }

    public FlightInfo(Schema schema, FlightDescriptor descriptor, List<FlightEndpoint> endpoints, long bytes, long records, boolean ordered, IpcOption option, byte[] appMetadata) {
        Objects.requireNonNull(descriptor);
        Objects.requireNonNull(endpoints);
        if (schema != null) {
            MetadataV4UnionChecker.checkForUnion(schema.getFields().iterator(), option.metadataVersion);
        }
        this.schema = schema;
        this.descriptor = descriptor;
        this.endpoints = endpoints;
        this.bytes = bytes;
        this.records = records;
        this.ordered = ordered;
        this.option = option;
        this.appMetadata = appMetadata;
    }

    FlightInfo(Flight.FlightInfo pbFlightInfo) throws URISyntaxException {
        try {
            ByteBuffer schemaBuf = pbFlightInfo.getSchema().asReadOnlyByteBuffer();
            this.schema = pbFlightInfo.getSchema().size() > 0 ? MessageSerializer.deserializeSchema(new ReadChannel(Channels.newChannel(new ByteBufferBackedInputStream(schemaBuf)))) : null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.descriptor = new FlightDescriptor(pbFlightInfo.getFlightDescriptor());
        this.endpoints = new ArrayList<FlightEndpoint>();
        for (Flight.FlightEndpoint endpoint : pbFlightInfo.getEndpointList()) {
            this.endpoints.add(new FlightEndpoint(endpoint));
        }
        this.bytes = pbFlightInfo.getTotalBytes();
        this.records = pbFlightInfo.getTotalRecords();
        this.ordered = pbFlightInfo.getOrdered();
        this.appMetadata = pbFlightInfo.getAppMetadata().size() == 0 ? null : pbFlightInfo.getAppMetadata().toByteArray();
        this.option = IpcOption.DEFAULT;
    }

    public Optional<Schema> getSchemaOptional() {
        return Optional.ofNullable(this.schema);
    }

    @Deprecated
    public Schema getSchema() {
        return this.schema != null ? this.schema : new Schema(Collections.emptyList());
    }

    public long getBytes() {
        return this.bytes;
    }

    public long getRecords() {
        return this.records;
    }

    public FlightDescriptor getDescriptor() {
        return this.descriptor;
    }

    public List<FlightEndpoint> getEndpoints() {
        return this.endpoints;
    }

    public boolean getOrdered() {
        return this.ordered;
    }

    public byte[] getAppMetadata() {
        return this.appMetadata;
    }

    Flight.FlightInfo toProtocol() {
        Flight.FlightInfo.Builder builder = Flight.FlightInfo.newBuilder().addAllEndpoint(this.endpoints.stream().map(t -> t.toProtocol()).collect(Collectors.toList())).setFlightDescriptor(this.descriptor.toProtocol()).setTotalBytes(this.bytes).setTotalRecords(this.records).setOrdered(this.ordered);
        if (this.schema != null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                MessageSerializer.serialize(new WriteChannel(Channels.newChannel(baos)), this.schema, this.option);
                builder.setSchema(ByteString.copyFrom(baos.toByteArray()));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.appMetadata != null) {
            builder.setAppMetadata(ByteString.copyFrom(this.appMetadata));
        }
        return builder.build();
    }

    public ByteBuffer serialize() {
        return ByteBuffer.wrap(this.toProtocol().toByteArray());
    }

    public static FlightInfo deserialize(ByteBuffer serialized) throws IOException, URISyntaxException {
        return new FlightInfo(Flight.FlightInfo.parseFrom(serialized));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FlightInfo)) {
            return false;
        }
        FlightInfo that = (FlightInfo)o;
        return this.bytes == that.bytes && this.records == that.records && this.schema.equals(that.schema) && this.descriptor.equals(that.descriptor) && this.endpoints.equals(that.endpoints) && this.ordered == that.ordered && Arrays.equals(this.appMetadata, that.appMetadata);
    }

    public int hashCode() {
        return Objects.hash(this.schema, this.descriptor, this.endpoints, this.bytes, this.records, this.ordered, Arrays.hashCode(this.appMetadata));
    }

    public String toString() {
        return "FlightInfo{schema=" + this.schema + ", descriptor=" + this.descriptor + ", endpoints=" + this.endpoints + ", bytes=" + this.bytes + ", records=" + this.records + ", ordered=" + this.ordered + ", appMetadata=" + (this.appMetadata == null ? "(none)" : Base64.getEncoder().encodeToString(this.appMetadata)) + '}';
    }

    public static Builder builder(Schema schema, FlightDescriptor descriptor, List<FlightEndpoint> endpoints) {
        return new Builder(schema, descriptor, endpoints);
    }

    public static final class Builder {
        private final Schema schema;
        private final FlightDescriptor descriptor;
        private final List<FlightEndpoint> endpoints;
        private long bytes = -1L;
        private long records = -1L;
        private boolean ordered = false;
        private IpcOption option = IpcOption.DEFAULT;
        private byte[] appMetadata = null;

        private Builder(Schema schema, FlightDescriptor descriptor, List<FlightEndpoint> endpoints) {
            this.schema = schema;
            this.descriptor = descriptor;
            this.endpoints = endpoints;
        }

        public Builder setBytes(long bytes) {
            this.bytes = bytes;
            return this;
        }

        public Builder setRecords(long records) {
            this.records = records;
            return this;
        }

        public Builder setOrdered(boolean ordered) {
            this.ordered = ordered;
            return this;
        }

        public Builder setOption(IpcOption option) {
            this.option = option;
            return this;
        }

        public Builder setAppMetadata(byte[] appMetadata) {
            this.appMetadata = appMetadata;
            return this;
        }

        public FlightInfo build() {
            return new FlightInfo(this.schema, this.descriptor, this.endpoints, this.bytes, this.records, this.ordered, this.option, this.appMetadata);
        }
    }
}

