/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight;

import org.apache.arrow.driver.jdbc.shaded.io.grpc.stub.CallStreamObserver;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.ArrowMessage;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.CallStatus;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.DictionaryUtils;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.FlightDescriptor;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.OutboundStreamListener;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.grpc.StatusUtils;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.util.Preconditions;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.VectorUnloader;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.dictionary.DictionaryProvider;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.ipc.message.IpcOption;

abstract class OutboundStreamListenerImpl
implements OutboundStreamListener {
    private final FlightDescriptor descriptor;
    protected final CallStreamObserver<ArrowMessage> responseObserver;
    protected volatile VectorUnloader unloader;
    protected IpcOption option;
    protected boolean tryZeroCopy = ArrowMessage.ENABLE_ZERO_COPY_WRITE;

    OutboundStreamListenerImpl(FlightDescriptor descriptor, CallStreamObserver<ArrowMessage> responseObserver) {
        Preconditions.checkNotNull(responseObserver, "responseObserver must be provided");
        this.descriptor = descriptor;
        this.responseObserver = responseObserver;
        this.unloader = null;
    }

    @Override
    public boolean isReady() {
        return this.responseObserver.isReady();
    }

    @Override
    public void setOnReadyHandler(Runnable handler) {
        this.responseObserver.setOnReadyHandler(handler);
    }

    @Override
    public void start(VectorSchemaRoot root, DictionaryProvider dictionaries, IpcOption option) {
        this.option = option;
        try {
            DictionaryUtils.generateSchemaMessages(root.getSchema(), this.descriptor, dictionaries, option, this.responseObserver::onNext);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not generate and send all schema messages", e);
        }
        this.unloader = new VectorUnloader(root, true, true);
    }

    @Override
    public void putNext() {
        this.putNext(null);
    }

    protected abstract void waitUntilStreamReady();

    @Override
    public void putNext(ArrowBuf metadata) {
        if (this.unloader == null) {
            throw CallStatus.INTERNAL.withDescription("Stream was not started, call start()").toRuntimeException();
        }
        this.waitUntilStreamReady();
        try (ArrowMessage message = new ArrowMessage(this.unloader.getRecordBatch(), metadata, this.tryZeroCopy, this.option);){
            this.responseObserver.onNext(message);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not free ArrowMessage", e);
        }
    }

    @Override
    public void putMetadata(ArrowBuf metadata) {
        this.waitUntilStreamReady();
        try (ArrowMessage message = new ArrowMessage(metadata);){
            this.responseObserver.onNext(message);
        }
        catch (Exception e) {
            throw StatusUtils.fromThrowable(e);
        }
    }

    @Override
    public void error(Throwable ex) {
        this.responseObserver.onError(StatusUtils.toGrpcException(ex));
    }

    @Override
    public void completed() {
        this.responseObserver.onCompleted();
    }

    @Override
    public void setUseZeroCopy(boolean enabled) {
        this.tryZeroCopy = enabled;
    }
}

