/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.auth2;

import java.nio.ByteBuffer;
import java.util.Base64;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.arrow.driver.jdbc.shaded.com.google.common.base.Strings;
import org.apache.arrow.driver.jdbc.shaded.com.google.common.cache.Cache;
import org.apache.arrow.driver.jdbc.shaded.com.google.common.cache.CacheBuilder;
import org.apache.arrow.driver.jdbc.shaded.io.grpc.Metadata;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.CallHeaders;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.CallStatus;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.auth2.AuthUtilities;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.auth2.BearerTokenAuthenticator;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.auth2.CallHeaderAuthenticator;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.grpc.MetadataAdapter;

public class GeneratedBearerTokenAuthenticator
extends BearerTokenAuthenticator {
    private final Cache<String, String> bearerToIdentityCache;

    public GeneratedBearerTokenAuthenticator(CallHeaderAuthenticator authenticator) {
        this(authenticator, CacheBuilder.newBuilder().expireAfterAccess(2L, TimeUnit.HOURS));
    }

    public GeneratedBearerTokenAuthenticator(CallHeaderAuthenticator authenticator, int timeoutMinutes) {
        this(authenticator, CacheBuilder.newBuilder().expireAfterAccess(timeoutMinutes, TimeUnit.MINUTES));
    }

    public GeneratedBearerTokenAuthenticator(CallHeaderAuthenticator authenticator, CacheBuilder<Object, Object> cacheBuilder) {
        super(authenticator);
        this.bearerToIdentityCache = cacheBuilder.build();
    }

    @Override
    protected CallHeaderAuthenticator.AuthResult validateBearer(final String bearerToken) {
        final String peerIdentity = this.bearerToIdentityCache.getIfPresent(bearerToken);
        if (peerIdentity == null) {
            throw CallStatus.UNAUTHENTICATED.toRuntimeException();
        }
        return new CallHeaderAuthenticator.AuthResult(){

            @Override
            public String getPeerIdentity() {
                return peerIdentity;
            }

            @Override
            public void appendToOutgoingHeaders(CallHeaders outgoingHeaders) {
                if (null == AuthUtilities.getValueFromAuthHeader(outgoingHeaders, "Bearer ")) {
                    outgoingHeaders.insert("Authorization", "Bearer " + bearerToken);
                }
            }
        };
    }

    @Override
    protected CallHeaderAuthenticator.AuthResult getAuthResultWithBearerToken(final CallHeaderAuthenticator.AuthResult authResult) {
        CallHeaderAuthenticator.AuthResult authResultWithBearerToken;
        MetadataAdapter dummyHeaders = new MetadataAdapter(new Metadata());
        authResult.appendToOutgoingHeaders(dummyHeaders);
        String bearerToken = AuthUtilities.getValueFromAuthHeader(dummyHeaders, "Bearer ");
        if (Strings.isNullOrEmpty(bearerToken)) {
            String newToken;
            UUID uuid = UUID.randomUUID();
            ByteBuffer byteBuffer = ByteBuffer.wrap(new byte[16]);
            byteBuffer.putLong(uuid.getMostSignificantBits());
            byteBuffer.putLong(uuid.getLeastSignificantBits());
            bearerToken = newToken = Base64.getEncoder().encodeToString(byteBuffer.array());
            authResultWithBearerToken = new CallHeaderAuthenticator.AuthResult(){

                @Override
                public String getPeerIdentity() {
                    return authResult.getPeerIdentity();
                }

                @Override
                public void appendToOutgoingHeaders(CallHeaders outgoingHeaders) {
                    authResult.appendToOutgoingHeaders(outgoingHeaders);
                    outgoingHeaders.insert("Authorization", "Bearer " + newToken);
                }
            };
        } else {
            authResultWithBearerToken = authResult;
        }
        this.bearerToIdentityCache.put(bearerToken, authResult.getPeerIdentity());
        return authResultWithBearerToken;
    }
}

