/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.asn1.cmp;

import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.asn1.ASN1Choice;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.asn1.ASN1Encodable;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.asn1.ASN1Object;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.asn1.ASN1Primitive;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.asn1.ASN1TaggedObject;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.asn1.ASN1Util;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.asn1.DERTaggedObject;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.asn1.cmp.CMPCertificate;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.asn1.crmf.EncryptedKey;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.asn1.crmf.EncryptedValue;

public class CertOrEncCert
extends ASN1Object
implements ASN1Choice {
    private CMPCertificate certificate;
    private EncryptedKey encryptedCert;

    private CertOrEncCert(ASN1TaggedObject aSN1TaggedObject) {
        if (aSN1TaggedObject.hasContextTag(0)) {
            this.certificate = CMPCertificate.getInstance(aSN1TaggedObject.getExplicitBaseObject());
        } else if (aSN1TaggedObject.hasContextTag(1)) {
            this.encryptedCert = EncryptedKey.getInstance(aSN1TaggedObject.getExplicitBaseObject());
        } else {
            throw new IllegalArgumentException("unknown tag: " + ASN1Util.getTagText(aSN1TaggedObject));
        }
    }

    public CertOrEncCert(CMPCertificate cMPCertificate) {
        if (cMPCertificate == null) {
            throw new IllegalArgumentException("'certificate' cannot be null");
        }
        this.certificate = cMPCertificate;
    }

    public CertOrEncCert(EncryptedValue encryptedValue) {
        if (encryptedValue == null) {
            throw new IllegalArgumentException("'encryptedCert' cannot be null");
        }
        this.encryptedCert = new EncryptedKey(encryptedValue);
    }

    public CertOrEncCert(EncryptedKey encryptedKey) {
        if (encryptedKey == null) {
            throw new IllegalArgumentException("'encryptedCert' cannot be null");
        }
        this.encryptedCert = encryptedKey;
    }

    public static CertOrEncCert getInstance(Object object) {
        if (object instanceof CertOrEncCert) {
            return (CertOrEncCert)object;
        }
        if (object instanceof ASN1TaggedObject) {
            return new CertOrEncCert(ASN1TaggedObject.getInstance(object, 128));
        }
        return null;
    }

    public boolean hasEncryptedCertificate() {
        return this.encryptedCert != null;
    }

    public CMPCertificate getCertificate() {
        return this.certificate;
    }

    public EncryptedKey getEncryptedCert() {
        return this.encryptedCert;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        if (this.certificate != null) {
            return new DERTaggedObject(true, 0, (ASN1Encodable)this.certificate);
        }
        return new DERTaggedObject(true, 1, (ASN1Encodable)this.encryptedCert);
    }
}

