/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.utils;

import java.time.Duration;
import java.time.Period;

public final class IntervalStringUtils {
    private IntervalStringUtils() {
    }

    public static String formatIntervalYear(Period p) {
        long months = p.toTotalMonths();
        boolean neg = false;
        if (months < 0L) {
            months = -months;
            neg = true;
        }
        int years = (int)(months / 12L);
        return String.format("%c%03d-%02d", Character.valueOf(neg ? (char)'-' : '+'), years, months %= 12L);
    }

    public static String formatIntervalDay(Duration d) {
        long millis = d.toMillis();
        boolean neg = false;
        if (millis < 0L) {
            millis = -millis;
            neg = true;
        }
        int days = (int)(millis / 86400000L);
        int hours = (int)((millis %= 86400000L) / 3600000L);
        int minutes = (int)((millis %= 3600000L) / 60000L);
        int seconds = (int)((millis %= 60000L) / 1000L);
        return String.format("%c%03d %02d:%02d:%02d.%03d", Character.valueOf(neg ? (char)'-' : '+'), days, hours, minutes, seconds, millis %= 1000L);
    }
}

