/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.handlers.addressing;

import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.RolePlayer;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.AddressingConstants;
import org.apache.axis2.addressing.AddressingFaultsHelper;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.addressing.EndpointReferenceHelper;
import org.apache.axis2.addressing.RelatesTo;
import org.apache.axis2.client.Options;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.HandlerDescription;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.handlers.AbstractHandler;
import org.apache.axis2.util.JavaUtils;
import org.apache.axis2.util.LoggingControl;
import org.apache.axis2.util.Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AddressingInHandler
extends AbstractHandler
implements AddressingConstants {
    private static final int TO_FLAG = 1;
    private static final int FROM_FLAG = 2;
    private static final int REPLYTO_FLAG = 3;
    private static final int FAULTO_FLAG = 4;
    private static final int MESSAGEID_FLAG = 6;
    private static final int ACTION_FLAG = 0;
    private static final Log log = LogFactory.getLog(AddressingInHandler.class);
    private boolean disableRefparamExtract = false;
    private AxisConfiguration configuration = null;
    private RolePlayer rolePlayer = null;

    public void init(HandlerDescription handlerdesc) {
        super.init(handlerdesc);
        Parameter param = handlerdesc.getParameter("disableRefParamExtract");
        String value = Utils.getParameterValue((Parameter)param);
        this.disableRefparamExtract = JavaUtils.isTrueExplicitly((String)value);
        if (LoggingControl.debugLoggingAllowed && log.isDebugEnabled()) {
            log.debug((Object)("disableRefparamExtract=" + this.disableRefparamExtract));
        }
    }

    public Handler.InvocationResponse invoke(MessageContext msgContext) throws AxisFault {
        msgContext.setProperty("disableAddressingForOutMessages", (Object)Boolean.TRUE);
        msgContext.setProperty("IsAddressingProcessed", (Object)Boolean.FALSE);
        Parameter disableParam = msgContext.getParameter("disableAddressingForInMessages");
        String value = Utils.getParameterValue((Parameter)disableParam);
        if (JavaUtils.isTrueExplicitly((String)value)) {
            if (LoggingControl.debugLoggingAllowed && log.isDebugEnabled()) {
                log.debug((Object)"The AddressingInHandler has been disabled. No further processing will take place.");
            }
            return Handler.InvocationResponse.CONTINUE;
        }
        SOAPHeader header = msgContext.getEnvelope().getHeader();
        if (header == null) {
            return Handler.InvocationResponse.CONTINUE;
        }
        if (this.configuration == null) {
            AxisConfiguration conf = msgContext.getConfigurationContext().getAxisConfiguration();
            this.rolePlayer = (RolePlayer)conf.getParameterValue("rolePlayer");
            this.configuration = conf;
        }
        Iterator iterator = null;
        String namespace = (String)msgContext.getProperty("WSAddressingVersion");
        if (namespace == null) {
            Parameter namespaceParam = msgContext.getParameter("WSAddressingVersion");
            namespace = Utils.getParameterValue((Parameter)namespaceParam);
        }
        if (namespace == null) {
            namespace = "http://www.w3.org/2005/08/addressing";
            iterator = header.getHeadersToProcess(this.rolePlayer, namespace);
            if (!iterator.hasNext()) {
                if (LoggingControl.debugLoggingAllowed && log.isDebugEnabled()) {
                    log.debug((Object)("No headers present corresponding to " + namespace));
                }
                namespace = "http://schemas.xmlsoap.org/ws/2004/08/addressing";
                iterator = header.getHeadersToProcess(this.rolePlayer, namespace);
            }
        } else if ("http://www.w3.org/2005/08/addressing".equals(namespace) || "http://schemas.xmlsoap.org/ws/2004/08/addressing".equals(namespace)) {
            iterator = header.getHeadersToProcess(this.rolePlayer, namespace);
            if (LoggingControl.debugLoggingAllowed && log.isDebugEnabled()) {
                log.debug((Object)("The preconfigured namespace is, , " + namespace));
            }
        } else {
            if (LoggingControl.debugLoggingAllowed && log.isDebugEnabled()) {
                log.debug((Object)("The specified namespace is not supported by this handler, " + namespace));
            }
            return Handler.InvocationResponse.CONTINUE;
        }
        if (iterator.hasNext()) {
            if (LoggingControl.debugLoggingAllowed && log.isDebugEnabled()) {
                log.debug((Object)(namespace + " headers present in the SOAP message. Starting to process ..."));
            }
            msgContext.setProperty("WSAddressingVersion", (Object)namespace);
            msgContext.setProperty("disableAddressingForOutMessages", (Object)Boolean.FALSE);
            this.extractAddressingInformation(msgContext, iterator, namespace);
            if (!this.disableRefparamExtract) {
                this.extractToEprReferenceParameters(msgContext.getTo(), header, namespace);
            }
            msgContext.setProperty("IsAddressingProcessed", (Object)Boolean.TRUE);
        } else if (LoggingControl.debugLoggingAllowed && log.isDebugEnabled()) {
            log.debug((Object)("No headers present corresponding to " + namespace));
        }
        return Handler.InvocationResponse.CONTINUE;
    }

    private void extractAddressingInformation(MessageContext messageContext, Iterator headers, String namespace) throws AxisFault {
        Options messageContextOptions = messageContext.getOptions();
        ArrayList duplicateHeaderNames = new ArrayList(1);
        ArrayList<SOAPHeaderBlock> relatesToHeaders = null;
        SOAPHeaderBlock actionBlock = null;
        SOAPHeaderBlock toBlock = null;
        SOAPHeaderBlock messageIDBlock = null;
        SOAPHeaderBlock replyToBlock = null;
        SOAPHeaderBlock faultToBlock = null;
        SOAPHeaderBlock fromBlock = null;
        boolean[] ignoreHeaders = new boolean[7];
        boolean[] checkedHeaderNames = new boolean[7];
        while (headers.hasNext()) {
            SOAPHeaderBlock soapHeaderBlock = (SOAPHeaderBlock)headers.next();
            String localName = soapHeaderBlock.getLocalName();
            if ("Action".equals(localName)) {
                actionBlock = soapHeaderBlock;
                this.checkDuplicateHeaders("Action", 0, checkedHeaderNames, ignoreHeaders, duplicateHeaderNames);
                continue;
            }
            if ("To".equals(localName)) {
                toBlock = soapHeaderBlock;
                this.checkDuplicateHeaders("To", 1, checkedHeaderNames, ignoreHeaders, duplicateHeaderNames);
                continue;
            }
            if ("MessageID".equals(localName)) {
                messageIDBlock = soapHeaderBlock;
                this.checkDuplicateHeaders("MessageID", 6, checkedHeaderNames, ignoreHeaders, duplicateHeaderNames);
                continue;
            }
            if ("ReplyTo".equals(localName)) {
                replyToBlock = soapHeaderBlock;
                this.checkDuplicateHeaders("ReplyTo", 3, checkedHeaderNames, ignoreHeaders, duplicateHeaderNames);
                continue;
            }
            if ("FaultTo".equals(localName)) {
                faultToBlock = soapHeaderBlock;
                this.checkDuplicateHeaders("FaultTo", 4, checkedHeaderNames, ignoreHeaders, duplicateHeaderNames);
                continue;
            }
            if ("From".equals(localName)) {
                fromBlock = soapHeaderBlock;
                this.checkDuplicateHeaders("From", 2, checkedHeaderNames, ignoreHeaders, duplicateHeaderNames);
                continue;
            }
            if (!"RelatesTo".equals(localName)) continue;
            if (relatesToHeaders == null) {
                relatesToHeaders = new ArrayList<SOAPHeaderBlock>(1);
            }
            relatesToHeaders.add(soapHeaderBlock);
        }
        if (actionBlock != null && !ignoreHeaders[0]) {
            this.extractActionInformation(actionBlock, messageContext);
        }
        if (toBlock != null && !ignoreHeaders[1]) {
            this.extractToEPRInformation(toBlock, messageContextOptions, namespace);
        }
        if (messageIDBlock != null && !ignoreHeaders[6]) {
            this.extractMessageIDInformation(messageIDBlock, messageContext);
        }
        if (relatesToHeaders != null) {
            for (int i = 0; i < relatesToHeaders.size(); ++i) {
                this.extractRelatesToInformation((SOAPHeaderBlock)relatesToHeaders.get(i), messageContextOptions);
            }
        }
        if (replyToBlock != null && !ignoreHeaders[3]) {
            this.extractReplyToEPRInformation(replyToBlock, namespace, messageContext);
        }
        if (faultToBlock != null && !ignoreHeaders[4]) {
            this.extractFaultToEPRInformation(faultToBlock, namespace, messageContext);
        }
        if (fromBlock != null && !ignoreHeaders[2]) {
            this.extractFromEPRInformation(fromBlock, namespace, messageContext);
        }
        if (!duplicateHeaderNames.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Duplicate header names found:" + duplicateHeaderNames.get(0)));
            }
            AddressingFaultsHelper.triggerInvalidCardinalityFault((MessageContext)messageContext, (String)((String)duplicateHeaderNames.get(0)));
        }
        this.checkForMandatoryHeaders(checkedHeaderNames, messageContext, namespace);
        this.setDefaults(checkedHeaderNames, messageContext, namespace);
    }

    private void checkForMandatoryHeaders(boolean[] alreadyFoundAddrHeader, MessageContext messageContext, String namespace) throws AxisFault {
        if ("http://www.w3.org/2005/08/addressing".equals(namespace)) {
            if (!alreadyFoundAddrHeader[0]) {
                AddressingFaultsHelper.triggerMessageAddressingRequiredFault((MessageContext)messageContext, (String)"Action");
            }
        } else {
            if (!alreadyFoundAddrHeader[1]) {
                AddressingFaultsHelper.triggerMessageAddressingRequiredFault((MessageContext)messageContext, (String)"To");
            }
            if (!alreadyFoundAddrHeader[0]) {
                AddressingFaultsHelper.triggerMessageAddressingRequiredFault((MessageContext)messageContext, (String)"Action");
            }
            if ((alreadyFoundAddrHeader[3] || alreadyFoundAddrHeader[4]) && !alreadyFoundAddrHeader[6]) {
                AddressingFaultsHelper.triggerMessageAddressingRequiredFault((MessageContext)messageContext, (String)"MessageID");
            }
        }
    }

    private void setDefaults(boolean[] alreadyFoundAddrHeader, MessageContext messageContext, String namespace) {
        if ("http://www.w3.org/2005/08/addressing".equals(namespace)) {
            if (!alreadyFoundAddrHeader[1] && !messageContext.isServerSide()) {
                if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
                    log.trace((Object)(messageContext.getLogIDString() + " setDefaults: Setting WS-Addressing default value for the To property."));
                }
                messageContext.setTo(new EndpointReference("http://www.w3.org/2005/08/addressing/anonymous"));
            }
            if (!alreadyFoundAddrHeader[3]) {
                messageContext.setReplyTo(new EndpointReference("http://www.w3.org/2005/08/addressing/anonymous"));
                if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
                    log.trace((Object)(messageContext.getLogIDString() + " setDefaults: Setting WS-Addressing default value for the ReplyTo property."));
                }
            }
        } else if (!alreadyFoundAddrHeader[3]) {
            messageContext.setReplyTo(new EndpointReference("http://www.w3.org/2005/08/addressing/none"));
            if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
                log.trace((Object)"setDefaults: Setting WS-Addressing default value for the ReplyTo property.");
            }
        }
    }

    private void checkDuplicateHeaders(String addressingHeaderName, int headerFlag, boolean[] checkedHeaderNames, boolean[] ignoreHeaders, ArrayList duplicateHeaderNames) {
        ignoreHeaders[headerFlag] = checkedHeaderNames[headerFlag];
        if (ignoreHeaders[headerFlag]) {
            duplicateHeaderNames.add(addressingHeaderName);
        } else {
            checkedHeaderNames[headerFlag] = true;
        }
        if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
            log.trace((Object)("checkDuplicateHeaders: addressingHeaderName=" + addressingHeaderName + " isDuplicate=" + ignoreHeaders[headerFlag]));
        }
    }

    private void extractRelatesToInformation(SOAPHeaderBlock soapHeaderBlock, Options messageContextOptions) {
        String relationshipTypeString;
        String address = soapHeaderBlock.getText();
        OMAttribute relationshipType = soapHeaderBlock.getAttribute(new QName("RelationshipType"));
        String string = relationshipTypeString = relationshipType == null ? null : relationshipType.getAttributeValue();
        if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
            log.trace((Object)("extractRelatesToInformation: Extracted Relationship. Value=" + address + " RelationshipType=" + relationshipTypeString));
        }
        RelatesTo relatesTo = new RelatesTo(address, relationshipTypeString);
        ArrayList attributes = this.extractAttributesFromSOAPHeaderBlock(soapHeaderBlock);
        relatesTo.setExtensibilityAttributes(attributes);
        messageContextOptions.addRelatesTo(relatesTo);
        soapHeaderBlock.setProcessed();
    }

    private void extractFaultToEPRInformation(SOAPHeaderBlock soapHeaderBlock, String addressingNamespace, MessageContext messageContext) throws AxisFault {
        Options messageContextOptions = messageContext.getOptions();
        EndpointReference epr = messageContextOptions.getFaultTo();
        if (epr == null) {
            epr = new EndpointReference("");
            messageContextOptions.setFaultTo(epr);
        }
        this.extractEPRInformation(soapHeaderBlock, epr, addressingNamespace, messageContext);
        if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
            log.trace((Object)("extractFaultToEPRInformation: Extracted FaultTo EPR: " + epr));
        }
        soapHeaderBlock.setProcessed();
    }

    private void extractReplyToEPRInformation(SOAPHeaderBlock soapHeaderBlock, String addressingNamespace, MessageContext messageContext) throws AxisFault {
        Options messageContextOptions = messageContext.getOptions();
        EndpointReference epr = messageContextOptions.getReplyTo();
        if (epr == null) {
            epr = new EndpointReference("");
            messageContextOptions.setReplyTo(epr);
        }
        this.extractEPRInformation(soapHeaderBlock, epr, addressingNamespace, messageContext);
        if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
            log.trace((Object)("extractReplyToEPRInformation: Extracted ReplyTo EPR: " + epr));
        }
        soapHeaderBlock.setProcessed();
    }

    private void extractFromEPRInformation(SOAPHeaderBlock soapHeaderBlock, String addressingNamespace, MessageContext messageContext) throws AxisFault {
        Options messageContextOptions = messageContext.getOptions();
        EndpointReference epr = messageContextOptions.getFrom();
        if (epr == null) {
            epr = new EndpointReference("");
            messageContextOptions.setFrom(epr);
        }
        this.extractEPRInformation(soapHeaderBlock, epr, addressingNamespace, messageContext);
        if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
            log.trace((Object)("extractFromEPRInformation: Extracted From EPR: " + epr));
        }
        soapHeaderBlock.setProcessed();
    }

    private void extractToEPRInformation(SOAPHeaderBlock soapHeaderBlock, Options messageContextOptions, String namespace) {
        EndpointReference epr = new EndpointReference(soapHeaderBlock.getText());
        messageContextOptions.setTo(epr);
        Iterator addressAttributes = soapHeaderBlock.getAllAttributes();
        if (addressAttributes != null && addressAttributes.hasNext()) {
            ArrayList<OMAttribute> attributes = new ArrayList<OMAttribute>();
            while (addressAttributes.hasNext()) {
                OMAttribute attr = (OMAttribute)addressAttributes.next();
                attributes.add(attr);
            }
            epr.setAddressAttributes(attributes);
        }
        soapHeaderBlock.setProcessed();
        if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
            log.trace((Object)("extractToEPRInformation: Extracted To EPR: " + epr));
        }
    }

    private void extractToEprReferenceParameters(EndpointReference toEPR, SOAPHeader header, String namespace) {
        if ("http://www.w3.org/2005/08/addressing".equals(namespace)) {
            Iterator headerBlocks = header.getChildElements();
            while (headerBlocks.hasNext()) {
                OMElement headerElement = (OMElement)headerBlocks.next();
                OMAttribute isRefParamAttr = headerElement.getAttribute(new QName(namespace, "IsReferenceParameter"));
                if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
                    log.trace((Object)("extractToEprReferenceParameters: Checking header: " + headerElement.getQName()));
                }
                if (isRefParamAttr == null || !"true".equals(isRefParamAttr.getAttributeValue())) continue;
                toEPR.addReferenceParameter(headerElement);
                if (!LoggingControl.debugLoggingAllowed || !log.isTraceEnabled()) continue;
                log.trace((Object)("extractToEprReferenceParameters: Header: " + headerElement.getQName() + " has IsReferenceParameter attribute. Adding to toEPR."));
            }
        }
    }

    private void extractActionInformation(SOAPHeaderBlock soapHeaderBlock, MessageContext messageContext) throws AxisFault {
        ArrayList attributes;
        Options messageContextOptions = messageContext.getOptions();
        String soapAction = messageContextOptions.getAction();
        String wsaAction = soapHeaderBlock.getText();
        if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
            log.trace((Object)("extractActionInformation: HTTP soapAction or action ='" + soapAction + "' wsa:Action='" + wsaAction + "'"));
        }
        if (wsaAction == null || "".equals(wsaAction.trim())) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"The wsa:Action header is present but its contents are empty.  This violates rules in the WS-A specification.  The SOAP node that sent this message must be changed.");
            }
            AddressingFaultsHelper.triggerActionNotSupportedFault((MessageContext)messageContext, (String)wsaAction);
        }
        if (soapAction != null && !"".equals(soapAction) && messageContext.isServerSide()) {
            if (!soapAction.equals(wsaAction)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("The wsa:Action header is (" + wsaAction + ") which conflicts with the HTTP soapAction or action " + "(" + soapAction + ").  This is a violation of the WS-A specification.  The SOAP node that sent this message " + " must be changed."));
                }
                AddressingFaultsHelper.triggerActionMismatchFault((MessageContext)messageContext, (String)soapAction, (String)wsaAction);
            }
        } else {
            messageContextOptions.setAction(wsaAction);
        }
        if ((attributes = this.extractAttributesFromSOAPHeaderBlock(soapHeaderBlock)) != null) {
            messageContext.setProperty("actionAttributes", (Object)attributes);
        }
        soapHeaderBlock.setProcessed();
    }

    private void extractMessageIDInformation(SOAPHeaderBlock soapHeaderBlock, MessageContext messageContext) throws AxisFault {
        messageContext.getOptions().setMessageId(soapHeaderBlock.getText());
        ArrayList attributes = this.extractAttributesFromSOAPHeaderBlock(soapHeaderBlock);
        if (attributes != null) {
            messageContext.setProperty("messageidAttributes", (Object)attributes);
        }
        soapHeaderBlock.setProcessed();
    }

    private void extractEPRInformation(SOAPHeaderBlock headerBlock, EndpointReference epr, String addressingNamespace, MessageContext messageContext) throws AxisFault {
        String namespace = null;
        try {
            namespace = EndpointReferenceHelper.fromOM((EndpointReference)epr, (OMElement)headerBlock);
        }
        catch (AxisFault af) {
            if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
                log.trace((Object)"extractEPRInformation: Exception occurred deserialising an EndpointReference.", (Throwable)af);
            }
            AddressingFaultsHelper.triggerMissingAddressInEPRFault((MessageContext)messageContext, (String)headerBlock.getLocalName());
        }
        if (!namespace.equals(addressingNamespace)) {
            if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
                log.trace((Object)("extractEPRInformation: Addressing namespace = " + addressingNamespace + ", EPR namespace = " + namespace));
            }
            AddressingFaultsHelper.triggerInvalidEPRFault((MessageContext)messageContext, (String)headerBlock.getLocalName());
        }
    }

    private ArrayList extractAttributesFromSOAPHeaderBlock(SOAPHeaderBlock soapHeaderBlock) {
        Iterator actionAttributes = soapHeaderBlock.getAllAttributes();
        if (actionAttributes != null && actionAttributes.hasNext()) {
            ArrayList<OMAttribute> attributes = new ArrayList<OMAttribute>();
            while (actionAttributes.hasNext()) {
                OMAttribute attr = (OMAttribute)actionAttributes.next();
                attributes.add(attr);
            }
            return attributes;
        }
        return null;
    }
}

