/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.schema.writer;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.schema.BeanWriterMetaInfoHolder;
import org.apache.axis2.schema.CompilerOptions;
import org.apache.axis2.schema.SchemaCompilationException;
import org.apache.axis2.schema.i18n.SchemaCompilerMessages;
import org.apache.axis2.schema.typemap.JavaTypeMap;
import org.apache.axis2.schema.util.PrimitiveTypeFinder;
import org.apache.axis2.schema.util.PrimitiveTypeWrapper;
import org.apache.axis2.schema.util.SchemaPropertyLoader;
import org.apache.axis2.schema.writer.BeanWriter;
import org.apache.axis2.util.FileWriter;
import org.apache.axis2.util.JavaUtils;
import org.apache.axis2.util.PrettyPrinter;
import org.apache.axis2.util.URLProcessor;
import org.apache.axis2.util.XSLTTemplateProcessor;
import org.apache.axis2.util.XSLTUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaSimpleType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaBeanWriter
implements BeanWriter {
    private static final Log log = LogFactory.getLog(JavaBeanWriter.class);
    public static final String WRAPPED_DATABINDING_CLASS_NAME = "WrappedDatabinder";
    private String javaBeanTemplateName = null;
    private boolean templateLoaded = false;
    private Templates templateCache;
    private List<String> nameList;
    private Map<String, List<String>> packageNameToClassNamesMap;
    private static int count = 0;
    private boolean wrapClasses = false;
    private boolean writeClasses = false;
    private boolean isUseWrapperClasses = false;
    private String packageName = null;
    private File rootDir;
    private Document globalWrappedDocument;
    private Map modelMap = new HashMap();
    private static final String DEFAULT_PACKAGE = "adb";
    private Map baseTypeMap = new JavaTypeMap().getTypeMap();
    private Map<String, String> ns2packageNameMap = new HashMap<String, String>();
    private boolean isHelperMode = false;
    private boolean isSuppressPrefixesMode = false;
    private String mappingClassPackage = null;
    public static final String EXTENSION_MAPPER_CLASSNAME = "ExtensionMapper";
    public static final String DEFAULT_CLASS_NAME = OMElement.class.getName();
    public static final String DEFAULT_CLASS_ARRAY_NAME = "org.apache.axiom.om.OMElement[]";
    public static final String DEFAULT_ATTRIB_CLASS_NAME = OMAttribute.class.getName();
    public static final String DEFAULT_ATTRIB_ARRAY_CLASS_NAME = "org.apache.axiom.om.OMAttribute[]";
    private int lastPrefixIndex = 1;
    HashMap<String, String> mapURItoPrefix = new HashMap();
    HashMap<String, String> mapPrefixtoURI = new HashMap();

    @Override
    public Map getModelMap() {
        return this.modelMap;
    }

    @Override
    public String getDefaultClassName() {
        return DEFAULT_CLASS_NAME;
    }

    @Override
    public String getDefaultClassArrayName() {
        return DEFAULT_CLASS_ARRAY_NAME;
    }

    @Override
    public String getDefaultAttribClassName() {
        return DEFAULT_ATTRIB_CLASS_NAME;
    }

    @Override
    public String getDefaultAttribArrayClassName() {
        return DEFAULT_ATTRIB_ARRAY_CLASS_NAME;
    }

    @Override
    public void init(CompilerOptions options) throws SchemaCompilationException {
        try {
            this.modelMap = new HashMap();
            this.ns2packageNameMap = new HashMap<String, String>();
            this.mappingClassPackage = null;
            this.initWithFile(options.getOutputLocation());
            this.packageName = options.getPackageName();
            this.writeClasses = options.isWriteOutput();
            this.isUseWrapperClasses = options.isUseWrapperClasses();
            this.wrapClasses = !this.writeClasses ? false : options.isWrapClasses();
            if (options.isWrapClasses()) {
                this.globalWrappedDocument = XSLTUtils.getDocument();
                Element rootElement = XSLTUtils.getElement((Document)this.globalWrappedDocument, (String)"beans");
                this.globalWrappedDocument.appendChild(rootElement);
                XSLTUtils.addAttribute((Document)this.globalWrappedDocument, (String)"name", (String)WRAPPED_DATABINDING_CLASS_NAME, (Element)rootElement);
                String tempPackageName = this.packageName != null && this.packageName.endsWith(".") ? this.packageName.substring(0, this.packageName.lastIndexOf(".")) : DEFAULT_PACKAGE;
                XSLTUtils.addAttribute((Document)this.globalWrappedDocument, (String)"package", (String)tempPackageName, (Element)rootElement);
            }
            this.ns2packageNameMap = options.getNs2PackageMap();
            this.isHelperMode = options.isHelperMode();
            this.isSuppressPrefixesMode = options.isSuppressPrefixesMode();
            if (options.isMapperClassPackagePresent()) {
                this.mappingClassPackage = options.getMapperClassPackage();
            }
        }
        catch (IOException e) {
            throw new SchemaCompilationException(e);
        }
        catch (ParserConfigurationException e) {
            throw new SchemaCompilationException(e);
        }
    }

    @Override
    public String write(XmlSchemaElement element, Map<QName, String> typeMap, Map<QName, String> groupTypeMap, BeanWriterMetaInfoHolder metainf) throws SchemaCompilationException {
        try {
            QName qName = element.getQName();
            return this.process(qName, metainf, typeMap, groupTypeMap, true, false);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SchemaCompilationException(e);
        }
    }

    @Override
    public String write(QName qName, Map<QName, String> typeMap, Map<QName, String> groupTypeMap, BeanWriterMetaInfoHolder metainf, boolean isAbstract) throws SchemaCompilationException {
        try {
            return this.process(qName, metainf, typeMap, groupTypeMap, false, isAbstract);
        }
        catch (SchemaCompilationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SchemaCompilationException(e);
        }
    }

    @Override
    public void writeBatch() throws SchemaCompilationException {
        try {
            if (this.wrapClasses) {
                String tempPackage = this.packageName == null ? DEFAULT_PACKAGE : this.packageName;
                File out = this.createOutFile(tempPackage, WRAPPED_DATABINDING_CLASS_NAME);
                this.parse(this.globalWrappedDocument, out);
            }
        }
        catch (Exception e) {
            throw new SchemaCompilationException(e);
        }
    }

    @Override
    public String write(XmlSchemaSimpleType simpleType, Map<QName, String> typeMap, Map<QName, String> groupTypeMap, BeanWriterMetaInfoHolder metainf) throws SchemaCompilationException {
        try {
            QName qName = simpleType.getQName();
            if (qName == null) {
                qName = (QName)simpleType.getMetaInfoMap().get("Q_NAME");
            }
            metainf.addtStatus(qName, 64);
            return this.process(qName, metainf, typeMap, groupTypeMap, true, false);
        }
        catch (Exception e) {
            throw new SchemaCompilationException(e);
        }
    }

    private void initWithFile(File rootDir) throws IOException {
        if (rootDir == null) {
            this.rootDir = new File(".");
        } else {
            if (!rootDir.isDirectory()) {
                throw new IOException(SchemaCompilerMessages.getMessage("schema.rootnotfolderexception"));
            }
            this.rootDir = rootDir;
        }
        this.nameList = new ArrayList<String>();
        this.packageNameToClassNamesMap = new HashMap<String, List<String>>();
        this.javaBeanTemplateName = SchemaPropertyLoader.getBeanTemplate();
    }

    @Override
    public String makeFullyQualifiedClassName(QName qName) {
        String namespaceURI = qName.getNamespaceURI();
        String packageName = this.getPackage(namespaceURI);
        String originalName = qName.getLocalPart();
        String className = null;
        if (!this.wrapClasses && !this.writeClasses) {
            className = this.makeUniqueJavaClassName(this.nameList, originalName);
        } else {
            if (!this.packageNameToClassNamesMap.containsKey(packageName)) {
                this.packageNameToClassNamesMap.put(packageName, new ArrayList());
            }
            className = this.makeUniqueJavaClassName(this.packageNameToClassNamesMap.get(packageName), originalName);
        }
        String packagePrefix = null;
        if (this.wrapClasses) {
            packagePrefix = (this.packageName == null ? "adb." : this.packageName) + WRAPPED_DATABINDING_CLASS_NAME;
        } else if (this.writeClasses) {
            packagePrefix = packageName;
        }
        String fullyqualifiedClassName = packagePrefix != null ? packagePrefix + (packagePrefix.endsWith(".") ? "" : ".") + className : className;
        return fullyqualifiedClassName;
    }

    private String getPackage(String namespaceURI) {
        String basePackageName = this.ns2packageNameMap != null && this.ns2packageNameMap.containsKey(namespaceURI) ? this.ns2packageNameMap.get(namespaceURI) : URLProcessor.makePackageName((String)namespaceURI);
        return this.packageName == null ? basePackageName : this.packageName + basePackageName;
    }

    private String process(QName qName, BeanWriterMetaInfoHolder metainf, Map<QName, String> typeMap, Map<QName, String> groupTypeMap, boolean isElement, boolean isAbstract) throws Exception {
        String fullyQualifiedClassName = metainf.getOwnClassName();
        if (fullyQualifiedClassName == null) {
            fullyQualifiedClassName = this.makeFullyQualifiedClassName(qName);
        }
        String className = fullyQualifiedClassName.substring(1 + fullyQualifiedClassName.lastIndexOf(46));
        String basePackageName = fullyQualifiedClassName.lastIndexOf(46) == -1 ? "" : fullyQualifiedClassName.substring(0, fullyQualifiedClassName.lastIndexOf(46));
        String originalName = qName == null ? "" : qName.getLocalPart();
        ArrayList<String> propertyNames = new ArrayList<String>();
        if (!this.templateLoaded) {
            this.loadTemplate();
        }
        if (this.wrapClasses) {
            this.globalWrappedDocument.getDocumentElement().appendChild(this.getBeanElement(this.globalWrappedDocument, className, originalName, basePackageName, qName, isElement, isAbstract, metainf, propertyNames, typeMap, groupTypeMap));
        } else {
            Document model = XSLTUtils.getDocument();
            model.appendChild(this.getBeanElement(model, className, originalName, basePackageName, qName, isElement, isAbstract, metainf, propertyNames, typeMap, groupTypeMap));
            if (this.writeClasses) {
                File out = this.createOutFile(basePackageName, className);
                if (this.isHelperMode) {
                    XSLTUtils.addAttribute((Document)model, (String)"helperMode", (String)"yes", (Element)model.getDocumentElement());
                    this.parse(model, out);
                    out = this.createOutFile(basePackageName, className + "Helper");
                    XSLTUtils.addAttribute((Document)model, (String)"helper", (String)"yes", (Element)model.getDocumentElement());
                    this.parse(model, out);
                } else {
                    this.parse(model, out);
                }
            }
            this.modelMap.put(new QName(qName.getNamespaceURI(), className), model);
        }
        return fullyQualifiedClassName;
    }

    private Element getBeanElement(Document model, String className, String originalName, String packageName, QName qName, boolean isElement, boolean isAbstract, BeanWriterMetaInfoHolder metainf, ArrayList<String> propertyNames, Map<QName, String> typeMap, Map<QName, String> groupTypeMap) throws SchemaCompilationException {
        Element rootElt = XSLTUtils.getElement((Document)model, (String)"bean");
        XSLTUtils.addAttribute((Document)model, (String)"name", (String)className, (Element)rootElt);
        XSLTUtils.addAttribute((Document)model, (String)"originalName", (String)originalName, (Element)rootElt);
        XSLTUtils.addAttribute((Document)model, (String)"package", (String)packageName, (Element)rootElt);
        XSLTUtils.addAttribute((Document)model, (String)"nsuri", (String)qName.getNamespaceURI(), (Element)rootElt);
        XSLTUtils.addAttribute((Document)model, (String)"nsprefix", (String)(this.isSuppressPrefixesMode ? "" : this.getPrefixForURI(qName.getNamespaceURI(), qName.getPrefix())), (Element)rootElt);
        if (!this.wrapClasses) {
            XSLTUtils.addAttribute((Document)model, (String)"unwrapped", (String)"yes", (Element)rootElt);
        }
        if (isAbstract) {
            XSLTUtils.addAttribute((Document)model, (String)"isAbstract", (String)"yes", (Element)rootElt);
        }
        if (!this.writeClasses) {
            XSLTUtils.addAttribute((Document)model, (String)"skip-write", (String)"yes", (Element)rootElt);
        }
        if (!isElement) {
            XSLTUtils.addAttribute((Document)model, (String)"type", (String)"yes", (Element)rootElt);
        }
        if (metainf.isAnonymous()) {
            XSLTUtils.addAttribute((Document)model, (String)"anon", (String)"yes", (Element)rootElt);
        }
        if (this.isUseWrapperClasses) {
            XSLTUtils.addAttribute((Document)model, (String)"usewrapperclasses", (String)"yes", (Element)rootElt);
        }
        if (metainf.isExtension()) {
            XSLTUtils.addAttribute((Document)model, (String)"extension", (String)metainf.getExtensionClassName(), (Element)rootElt);
        }
        if (metainf.isRestriction()) {
            XSLTUtils.addAttribute((Document)model, (String)"restriction", (String)metainf.getRestrictionClassName(), (Element)rootElt);
        }
        XSLTUtils.addAttribute((Document)model, (String)"mapperClass", (String)this.getFullyQualifiedMapperClassName(), (Element)rootElt);
        if (metainf.isChoice()) {
            XSLTUtils.addAttribute((Document)model, (String)"choice", (String)"yes", (Element)rootElt);
        }
        if (metainf.isSimple()) {
            XSLTUtils.addAttribute((Document)model, (String)"simple", (String)"yes", (Element)rootElt);
        }
        if (metainf.isUnion()) {
            XSLTUtils.addAttribute((Document)model, (String)"union", (String)"yes", (Element)rootElt);
        }
        if (metainf.isList()) {
            XSLTUtils.addAttribute((Document)model, (String)"list", (String)"yes", (Element)rootElt);
        }
        if (metainf.isOrdered()) {
            XSLTUtils.addAttribute((Document)model, (String)"ordered", (String)"yes", (Element)rootElt);
        }
        if (isElement && metainf.isNillable(qName)) {
            XSLTUtils.addAttribute((Document)model, (String)"nillable", (String)"yes", (Element)rootElt);
        }
        if (metainf.isParticleClass()) {
            XSLTUtils.addAttribute((Document)model, (String)"particleClass", (String)"yes", (Element)rootElt);
        }
        if (metainf.isHasParticleType()) {
            XSLTUtils.addAttribute((Document)model, (String)"hasParticleType", (String)"yes", (Element)rootElt);
        }
        this.populateInfo(metainf, model, rootElt, propertyNames, typeMap, groupTypeMap, false);
        if (metainf.isSimple() && metainf.isUnion()) {
            this.populateMemberInfo(metainf, model, rootElt, typeMap);
        }
        if (metainf.isSimple() && metainf.isList()) {
            this.populateListInfo(metainf, model, rootElt, typeMap, groupTypeMap);
        }
        return rootElt;
    }

    protected void populateListInfo(BeanWriterMetaInfoHolder metainf, Document model, Element rootElement, Map<QName, String> typeMap, Map<QName, String> groupTypeMap) {
        String javaName = this.makeUniqueJavaClassName(new ArrayList<String>(), metainf.getItemTypeQName().getLocalPart());
        Element itemType = XSLTUtils.addChildElement((Document)model, (String)"itemtype", (Node)rootElement);
        XSLTUtils.addAttribute((Document)model, (String)"type", (String)metainf.getItemTypeClassName(), (Element)itemType);
        XSLTUtils.addAttribute((Document)model, (String)"nsuri", (String)metainf.getItemTypeQName().getNamespaceURI(), (Element)itemType);
        XSLTUtils.addAttribute((Document)model, (String)"originalName", (String)metainf.getItemTypeQName().getLocalPart(), (Element)itemType);
        XSLTUtils.addAttribute((Document)model, (String)"javaname", (String)javaName, (Element)itemType);
        if (typeMap.containsKey(metainf.getItemTypeQName()) || groupTypeMap.containsKey(metainf.getItemTypeClassName())) {
            XSLTUtils.addAttribute((Document)model, (String)"ours", (String)"true", (Element)itemType);
        }
        if (PrimitiveTypeFinder.isPrimitive(metainf.getItemTypeClassName())) {
            XSLTUtils.addAttribute((Document)model, (String)"primitive", (String)"yes", (Element)itemType);
        }
        String shortTypeName = this.getShortTypeName(metainf.getItemTypeClassName());
        XSLTUtils.addAttribute((Document)model, (String)"shorttypename", (String)shortTypeName, (Element)itemType);
    }

    protected void populateMemberInfo(BeanWriterMetaInfoHolder metainf, Document model, Element rootElement, Map<QName, String> typeMap) {
        Map<QName, String> memberTypes = metainf.getMemberTypes();
        for (QName memberQName : metainf.getMemberTypesKeys()) {
            String memberClass = memberTypes.get(memberQName);
            if (PrimitiveTypeFinder.isPrimitive(memberClass)) {
                memberClass = PrimitiveTypeWrapper.getWrapper(memberClass);
            }
            Element memberType = XSLTUtils.addChildElement((Document)model, (String)"memberType", (Node)rootElement);
            XSLTUtils.addAttribute((Document)model, (String)"type", (String)memberClass, (Element)memberType);
            XSLTUtils.addAttribute((Document)model, (String)"nsuri", (String)memberQName.getNamespaceURI(), (Element)memberType);
            XSLTUtils.addAttribute((Document)model, (String)"originalName", (String)memberQName.getLocalPart(), (Element)memberType);
            if (typeMap.containsKey(memberQName)) {
                XSLTUtils.addAttribute((Document)model, (String)"ours", (String)"true", (Element)memberType);
            }
            String shortTypeName = this.getShortTypeName(memberClass);
            XSLTUtils.addAttribute((Document)model, (String)"shorttypename", (String)shortTypeName, (Element)memberType);
        }
    }

    private void populateInfo(BeanWriterMetaInfoHolder metainf, Document model, Element rootElt, ArrayList<String> propertyNames, Map<QName, String> typeMap, Map<QName, String> groupTypeMap, boolean isInherited) throws SchemaCompilationException {
        if (metainf.getParent() != null && (!metainf.isRestriction() || metainf.isRestriction() && metainf.isSimple())) {
            BeanWriterMetaInfoHolder parent = metainf.getParent();
            if (metainf.isRestriction()) {
                this.mergeBeanWriterMetaInfoHolderForRestriction(metainf, parent);
            }
            this.populateInfo(parent, model, rootElt, propertyNames, typeMap, groupTypeMap, true);
        }
        this.addPropertyEntries(metainf, model, rootElt, propertyNames, typeMap, groupTypeMap, isInherited);
    }

    private void addPropertyEntries(BeanWriterMetaInfoHolder metainf, Document model, Element rootElt, ArrayList<String> propertyNames, Map<QName, String> typeMap, Map<QName, String> groupTypeMap, boolean isInherited) throws SchemaCompilationException {
        ArrayList<QName> missingQNames = new ArrayList<QName>();
        ArrayList<QName> qNames = new ArrayList<QName>();
        BeanWriterMetaInfoHolder parentMetaInf = metainf.getParent();
        QName[] qName = metainf.isOrdered() ? metainf.getOrderedQNameArray() : metainf.getQNameArray();
        for (int i = 0; i < qName.length; ++i) {
            qNames.add(qName[i]);
        }
        if (metainf.isRestriction() && !metainf.isSimple()) {
            this.addMissingQNames(metainf, qNames, missingQNames);
        }
        ArrayList<BeanWriterMetaInfoHolder> parents = new ArrayList<BeanWriterMetaInfoHolder>();
        for (BeanWriterMetaInfoHolder immediateParent = metainf.getParent(); immediateParent != null; immediateParent = immediateParent.getParent()) {
            parents.add(immediateParent);
        }
        for (QName name : qNames) {
            QName schemaQName;
            String javaName;
            Element property = XSLTUtils.addChildElement((Document)model, (String)"property", (Node)rootElt);
            String xmlName = name.getLocalPart();
            String xmlNameNew = this.identifyUniqueNameForQName(parents, xmlName, metainf, name, name);
            while (!xmlName.equalsIgnoreCase(xmlNameNew)) {
                xmlName = xmlNameNew;
                xmlNameNew = this.identifyUniqueNameForQName(parents, xmlNameNew, metainf, name, new QName(xmlNameNew));
            }
            XSLTUtils.addAttribute((Document)model, (String)"name", (String)xmlName, (Element)property);
            XSLTUtils.addAttribute((Document)model, (String)"nsuri", (String)name.getNamespaceURI(), (Element)property);
            if (metainf.isJavaNameMappingAvailable(xmlName)) {
                javaName = metainf.getJavaName(xmlName);
            } else {
                javaName = this.makeUniqueJavaClassName(propertyNames, xmlName);
                if (parentMetaInf != null && metainf.isRestriction() && !missingQNames.contains(name) && parentMetaInf.getArrayStatusForQName(name) && !metainf.getArrayStatusForQName(name)) {
                    javaName = this.makeUniqueJavaClassName(propertyNames, xmlName);
                }
                metainf.addXmlNameJavaNameMapping(xmlName, javaName);
            }
            XSLTUtils.addAttribute((Document)model, (String)"javaname", (String)javaName, (Element)property);
            String javaClassNameForElement = parentMetaInf != null && metainf.isRestriction() && missingQNames.contains(name) ? parentMetaInf.getClassNameForQName(name) : metainf.getClassNameForQName(name);
            if (javaClassNameForElement == null) {
                javaClassNameForElement = this.getDefaultClassName();
                log.warn((Object)SchemaCompilerMessages.getMessage("schema.typeMissing", name.toString()));
            }
            if (metainf.isRestriction() && this.typeChanged(name, missingQNames, metainf)) {
                XSLTUtils.addAttribute((Document)model, (String)"typeChanged", (String)"yes", (Element)property);
            }
            long minOccurs = metainf.getMinOccurs(name);
            if (PrimitiveTypeFinder.isPrimitive(javaClassNameForElement) && this.isUseWrapperClasses && (minOccurs == 0L || metainf.isNillable(name))) {
                javaClassNameForElement = PrimitiveTypeWrapper.getWrapper(javaClassNameForElement);
            }
            XSLTUtils.addAttribute((Document)model, (String)"type", (String)javaClassNameForElement, (Element)property);
            if (PrimitiveTypeFinder.isPrimitive(javaClassNameForElement)) {
                XSLTUtils.addAttribute((Document)model, (String)"primitive", (String)"yes", (Element)property);
            }
            if (metainf.isDefaultValueAvailable(name) && this.baseTypeMap.containsKey(schemaQName = metainf.getSchemaQNameForQName(name))) {
                XSLTUtils.addAttribute((Document)model, (String)"defaultValue", (String)metainf.getDefaultValueForQName(name), (Element)property);
            }
            if (parentMetaInf != null && metainf.isRestriction() && !missingQNames.contains(name) && parentMetaInf.getArrayStatusForQName(name) && !metainf.getArrayStatusForQName(name)) {
                XSLTUtils.addAttribute((Document)model, (String)"rewrite", (String)"yes", (Element)property);
                XSLTUtils.addAttribute((Document)model, (String)"occuranceChanged", (String)"yes", (Element)property);
            } else if (metainf.isRestriction() && !missingQNames.contains(name) && (this.minOccursChanged(name, missingQNames, metainf) || this.maxOccursChanged(name, missingQNames, metainf))) {
                XSLTUtils.addAttribute((Document)model, (String)"restricted", (String)"yes", (Element)property);
                XSLTUtils.addAttribute((Document)model, (String)"occuranceChanged", (String)"yes", (Element)property);
            }
            if (metainf.getParticleTypeStatusForQName(name)) {
                XSLTUtils.addAttribute((Document)model, (String)"particleClassType", (String)"yes", (Element)property);
            }
            if (metainf.isHasParticleType()) {
                XSLTUtils.addAttribute((Document)model, (String)"hasParticleType", (String)"yes", (Element)rootElt);
            }
            if (metainf.isRestriction() && missingQNames.contains(name) && !metainf.isSimple()) {
                XSLTUtils.addAttribute((Document)model, (String)"removed", (String)"yes", (Element)property);
            }
            if (isInherited) {
                XSLTUtils.addAttribute((Document)model, (String)"inherited", (String)"yes", (Element)property);
            }
            if (metainf.getInnerChoiceStatusForQName(name)) {
                XSLTUtils.addAttribute((Document)model, (String)"innerchoice", (String)"yes", (Element)property);
            }
            if (metainf.isFixed()) {
                XSLTUtils.addAttribute((Document)model, (String)"fixed", (String)"yes", (Element)property);
            }
            if (parentMetaInf != null && metainf.isRestriction() && missingQNames.contains(name)) {
                this.addAttributesToProperty(parentMetaInf, name, model, property, typeMap, groupTypeMap, javaClassNameForElement);
                continue;
            }
            this.addAttributesToProperty(metainf, name, model, property, typeMap, groupTypeMap, javaClassNameForElement);
        }
    }

    private void addAttributesToProperty(BeanWriterMetaInfoHolder metainf, QName name, Document model, Element property, Map<QName, String> typeMap, Map<QName, String> groupTypeMap, String javaClassNameForElement) {
        if (metainf.getDefaultStatusForQName(name)) {
            XSLTUtils.addAttribute((Document)model, (String)"default", (String)"yes", (Element)property);
        }
        if (typeMap.containsKey(metainf.getSchemaQNameForQName(name)) || groupTypeMap.containsKey(metainf.getSchemaQNameForQName(name))) {
            XSLTUtils.addAttribute((Document)model, (String)"ours", (String)"yes", (Element)property);
        }
        if (metainf.getAttributeStatusForQName(name)) {
            XSLTUtils.addAttribute((Document)model, (String)"attribute", (String)"yes", (Element)property);
        }
        if (metainf.isNillable(name)) {
            XSLTUtils.addAttribute((Document)model, (String)"nillable", (String)"yes", (Element)property);
        }
        if (metainf.getOptionalAttributeStatusForQName(name)) {
            XSLTUtils.addAttribute((Document)model, (String)"optional", (String)"yes", (Element)property);
        }
        String shortTypeName = metainf.getSchemaQNameForQName(name) != null ? (this.baseTypeMap.containsKey(metainf.getSchemaQNameForQName(name)) ? metainf.getSchemaQNameForQName(name).getLocalPart() : this.getShortTypeName(javaClassNameForElement)) : this.getShortTypeName(javaClassNameForElement);
        XSLTUtils.addAttribute((Document)model, (String)"shorttypename", (String)shortTypeName, (Element)property);
        if (metainf.getAnyStatusForQName(name)) {
            XSLTUtils.addAttribute((Document)model, (String)"any", (String)"yes", (Element)property);
        }
        if (metainf.getBinaryStatusForQName(name)) {
            XSLTUtils.addAttribute((Document)model, (String)"binary", (String)"yes", (Element)property);
        }
        if (metainf.isSimple() || metainf.getSimpleStatusForQName(name)) {
            XSLTUtils.addAttribute((Document)model, (String)"simple", (String)"yes", (Element)property);
        }
        long minOccurs = metainf.getMinOccurs(name);
        XSLTUtils.addAttribute((Document)model, (String)"minOccurs", (String)(minOccurs + ""), (Element)property);
        if (metainf.getArrayStatusForQName(name)) {
            XSLTUtils.addAttribute((Document)model, (String)"array", (String)"yes", (Element)property);
            int endIndex = javaClassNameForElement.indexOf("[");
            if (endIndex >= 0) {
                XSLTUtils.addAttribute((Document)model, (String)"arrayBaseType", (String)javaClassNameForElement.substring(0, endIndex), (Element)property);
            } else {
                XSLTUtils.addAttribute((Document)model, (String)"arrayBaseType", (String)javaClassNameForElement, (Element)property);
            }
            long maxOccurs = metainf.getMaxOccurs(name);
            if (maxOccurs == Long.MAX_VALUE) {
                XSLTUtils.addAttribute((Document)model, (String)"unbound", (String)"yes", (Element)property);
            } else {
                XSLTUtils.addAttribute((Document)model, (String)"maxOccurs", (String)(maxOccurs + ""), (Element)property);
            }
        }
        if (metainf.isRestrictionBaseType(name)) {
            XSLTUtils.addAttribute((Document)model, (String)"restrictionBaseType", (String)"yes", (Element)property);
        }
        if (metainf.isExtensionBaseType(name)) {
            XSLTUtils.addAttribute((Document)model, (String)"extensionBaseType", (String)"yes", (Element)property);
        }
        if (metainf.isRestrictionBaseType(name) && metainf.getLengthFacet() != -1L) {
            XSLTUtils.addAttribute((Document)model, (String)"lenFacet", (String)(metainf.getLengthFacet() + ""), (Element)property);
        }
        if (metainf.isRestrictionBaseType(name) && metainf.getMaxLengthFacet() != -1L) {
            XSLTUtils.addAttribute((Document)model, (String)"maxLenFacet", (String)(metainf.getMaxLengthFacet() + ""), (Element)property);
        }
        if (metainf.isRestrictionBaseType(name) && metainf.getMinLengthFacet() != -1L) {
            XSLTUtils.addAttribute((Document)model, (String)"minLenFacet", (String)(metainf.getMinLengthFacet() + ""), (Element)property);
        }
        if (metainf.isRestrictionBaseType(name) && metainf.getTotalDigitsFacet() != null) {
            XSLTUtils.addAttribute((Document)model, (String)"totalDigitsFacet", (String)(metainf.getTotalDigitsFacet() + ""), (Element)property);
        }
        if (metainf.isRestrictionBaseType(name) && metainf.getMaxExclusiveFacet() != null) {
            XSLTUtils.addAttribute((Document)model, (String)"maxExFacet", (String)(metainf.getMaxExclusiveFacet() + ""), (Element)property);
        }
        if (metainf.isRestrictionBaseType(name) && metainf.getMinExclusiveFacet() != null) {
            XSLTUtils.addAttribute((Document)model, (String)"minExFacet", (String)(metainf.getMinExclusiveFacet() + ""), (Element)property);
        }
        if (metainf.isRestrictionBaseType(name) && metainf.getMaxInclusiveFacet() != null) {
            XSLTUtils.addAttribute((Document)model, (String)"maxInFacet", (String)(metainf.getMaxInclusiveFacet() + ""), (Element)property);
        }
        if (metainf.isRestrictionBaseType(name) && metainf.getMinInclusiveFacet() != null) {
            XSLTUtils.addAttribute((Document)model, (String)"minInFacet", (String)(metainf.getMinInclusiveFacet() + ""), (Element)property);
        }
        if (!metainf.getEnumFacet().isEmpty()) {
            boolean validJava = true;
            for (String value : metainf.getEnumFacet()) {
                if (JavaUtils.isJavaId((String)value)) continue;
                validJava = false;
            }
            int id = 0;
            for (String attribValue : metainf.getEnumFacet()) {
                Element enumFacet = XSLTUtils.addChildElement((Document)model, (String)"enumFacet", (Node)property);
                XSLTUtils.addAttribute((Document)model, (String)"value", (String)attribValue, (Element)enumFacet);
                if (validJava) {
                    XSLTUtils.addAttribute((Document)model, (String)"id", (String)attribValue, (Element)enumFacet);
                    continue;
                }
                XSLTUtils.addAttribute((Document)model, (String)"id", (String)("value" + ++id), (Element)enumFacet);
            }
        }
        if (metainf.isRestrictionBaseType(name) && metainf.getPatternFacet() != null) {
            XSLTUtils.addAttribute((Document)model, (String)"patternFacet", (String)metainf.getPatternFacet(), (Element)property);
        }
    }

    private void addMissingQNames(BeanWriterMetaInfoHolder metainf, ArrayList<QName> qName, ArrayList<QName> missingQNames) {
        int i;
        QName[] qNames = null;
        QName[] pQNames = null;
        BeanWriterMetaInfoHolder parentMetaInf = metainf.getParent();
        qNames = metainf.isOrdered() ? metainf.getOrderedQNameArray() : metainf.getQNameArray();
        if (parentMetaInf != null) {
            pQNames = parentMetaInf.isOrdered() ? parentMetaInf.getOrderedQNameArray() : parentMetaInf.getQNameArray();
        }
        for (i = 0; pQNames != null && i < pQNames.length; ++i) {
            if (!this.qNameNotFound(pQNames[i], metainf)) continue;
            missingQNames.add(pQNames[i]);
        }
        if (!missingQNames.isEmpty()) {
            for (i = 0; i < missingQNames.size(); ++i) {
                qName.add(missingQNames.get(i));
            }
        }
    }

    private boolean qNameNotFound(QName qname, BeanWriterMetaInfoHolder metainf) {
        boolean found = false;
        QName[] qNames = metainf.isOrdered() ? metainf.getOrderedQNameArray() : metainf.getQNameArray();
        for (int j = 0; j < qNames.length; ++j) {
            if (!qname.getLocalPart().equals(qNames[j].getLocalPart())) continue;
            found = true;
        }
        return !found;
    }

    private boolean typeChanged(QName qname, ArrayList<QName> missingQNames, BeanWriterMetaInfoHolder metainf) {
        boolean typeChanged = false;
        BeanWriterMetaInfoHolder parentMetainf = metainf.getParent();
        if (parentMetainf != null && !missingQNames.contains(qname)) {
            QName[] pQNames = parentMetainf.isOrdered() ? parentMetainf.getOrderedQNameArray() : parentMetainf.getQNameArray();
            for (int j = 0; j < pQNames.length; ++j) {
                String javaClassForElement;
                String javaClassForParentElement;
                if (!qname.getLocalPart().equals(pQNames[j].getLocalPart()) || (javaClassForParentElement = parentMetainf.getClassNameForQName(pQNames[j])).equals(javaClassForElement = metainf.getClassNameForQName(qname))) continue;
                if (javaClassForParentElement.endsWith("[]")) {
                    if (!javaClassForParentElement.substring(0, javaClassForParentElement.indexOf(91)).equals(javaClassForElement)) continue;
                    continue;
                }
                if (javaClassForElement.endsWith("[]")) {
                    if (!javaClassForElement.substring(0, javaClassForElement.indexOf(91)).equals(javaClassForParentElement)) continue;
                    continue;
                }
                typeChanged = true;
            }
        }
        return typeChanged;
    }

    private boolean minOccursChanged(QName qname, ArrayList<QName> missingQNames, BeanWriterMetaInfoHolder metainf) throws SchemaCompilationException {
        boolean minChanged = false;
        BeanWriterMetaInfoHolder parentMetainf = metainf.getParent();
        if (parentMetainf != null && !missingQNames.contains(qname)) {
            QName[] pQNames = parentMetainf.isOrdered() ? parentMetainf.getOrderedQNameArray() : parentMetainf.getQNameArray();
            for (int j = 0; j < pQNames.length; ++j) {
                if (!qname.getLocalPart().equals(pQNames[j].getLocalPart())) continue;
                if (metainf.getMinOccurs(qname) > parentMetainf.getMinOccurs(pQNames[j])) {
                    minChanged = true;
                    continue;
                }
                if (metainf.getMinOccurs(qname) >= parentMetainf.getMinOccurs(pQNames[j])) continue;
                throw new SchemaCompilationException(SchemaCompilerMessages.getMessage("minOccurs Wrong!"));
            }
        }
        return minChanged;
    }

    private boolean maxOccursChanged(QName qname, ArrayList<QName> missingQNames, BeanWriterMetaInfoHolder metainf) throws SchemaCompilationException {
        boolean maxChanged = false;
        BeanWriterMetaInfoHolder parentMetainf = metainf.getParent();
        if (parentMetainf != null && !missingQNames.contains(qname)) {
            QName[] pQNames = parentMetainf.isOrdered() ? parentMetainf.getOrderedQNameArray() : parentMetainf.getQNameArray();
            for (int j = 0; j < pQNames.length; ++j) {
                if (!qname.getLocalPart().equals(pQNames[j].getLocalPart())) continue;
                if (metainf.getMaxOccurs(qname) < parentMetainf.getMaxOccurs(pQNames[j])) {
                    maxChanged = true;
                    continue;
                }
                if (metainf.getMaxOccurs(qname) <= parentMetainf.getMaxOccurs(pQNames[j])) continue;
                throw new SchemaCompilationException(SchemaCompilerMessages.getMessage("maxOccurs Wrong!"));
            }
        }
        return maxChanged;
    }

    private boolean isDefault(String javaClassNameForElement) {
        return this.getDefaultClassName().equals(javaClassNameForElement) || this.getDefaultClassArrayName().equals(javaClassNameForElement);
    }

    private String makeUniqueJavaClassName(List<String> listOfNames, String xmlName) {
        String javaName = JavaUtils.isJavaKeyword((String)xmlName) ? JavaUtils.makeNonJavaKeyword((String)xmlName) : JavaUtils.capitalizeFirstChar((String)JavaUtils.xmlNameToJava((String)xmlName));
        while (listOfNames.contains(javaName.toLowerCase())) {
            if (!listOfNames.contains((javaName + "E").toLowerCase())) {
                javaName = javaName + "E";
                continue;
            }
            javaName = javaName + count++;
        }
        listOfNames.add(javaName.toLowerCase());
        return javaName;
    }

    private void loadTemplate() throws SchemaCompilationException {
        Class<?> clazz = this.getClass();
        String templateName = this.javaBeanTemplateName;
        if (templateName != null) {
            try {
                URL xsl = clazz.getResource(templateName);
                this.templateCache = TransformerFactory.newInstance().newTemplates(new StreamSource(xsl.toExternalForm()));
                this.templateLoaded = true;
            }
            catch (TransformerConfigurationException e) {
                throw new SchemaCompilationException(SchemaCompilerMessages.getMessage("schema.templateLoadException"), e);
            }
        } else {
            throw new SchemaCompilationException(SchemaCompilerMessages.getMessage("schema.templateNotFoundException"));
        }
    }

    private File createOutFile(String packageName, String fileName) throws Exception {
        return FileWriter.createClassFile((File)this.rootDir, (String)packageName, (String)fileName, (String)".java");
    }

    private void parse(Document doc, File outputFile) throws Exception {
        FileOutputStream outStream = new FileOutputStream(outputFile);
        XSLTTemplateProcessor.parse((OutputStream)outStream, (Document)doc, (Transformer)this.getTransformer());
        outStream.flush();
        ((OutputStream)outStream).close();
        PrettyPrinter.prettify((File)outputFile);
    }

    private Transformer getTransformer() throws TransformerConfigurationException, SchemaCompilationException {
        try {
            return this.templateCache.newTransformer();
        }
        catch (Exception e) {
            this.loadTemplate();
            return this.templateCache.newTransformer();
        }
    }

    public String getPrefixForURI(String uri) {
        return this.getPrefixForURI(uri, null);
    }

    public String getPrefixForURI(String uri, String defaultPrefix) {
        if (uri == null || uri.length() == 0) {
            return null;
        }
        String prefix = this.mapURItoPrefix.get(uri);
        if (prefix == null) {
            if (defaultPrefix == null || defaultPrefix.length() == 0) {
                prefix = "ns" + this.lastPrefixIndex++;
                while (this.mapPrefixtoURI.get(prefix) != null) {
                    prefix = "ns" + this.lastPrefixIndex++;
                }
            } else {
                prefix = defaultPrefix;
            }
            this.mapPrefixtoURI.put(prefix, uri);
            this.mapURItoPrefix.put(uri, prefix);
        }
        return prefix;
    }

    private String getShortTypeName(String typeClassName) {
        if (typeClassName.endsWith("[]")) {
            typeClassName = typeClassName.substring(0, typeClassName.lastIndexOf("["));
        }
        return typeClassName.substring(typeClassName.lastIndexOf(".") + 1, typeClassName.length());
    }

    private String getFullyQualifiedMapperClassName() {
        if (this.wrapClasses || !this.writeClasses || this.mappingClassPackage == null) {
            return EXTENSION_MAPPER_CLASSNAME;
        }
        return this.mappingClassPackage + "." + EXTENSION_MAPPER_CLASSNAME;
    }

    @Override
    public String getExtensionMapperPackageName() {
        return this.mappingClassPackage;
    }

    @Override
    public void registerExtensionMapperPackageName(String mapperPackageName) {
        this.mappingClassPackage = mapperPackageName;
    }

    @Override
    public void writeExtensionMapper(BeanWriterMetaInfoHolder[] metainfArray) throws SchemaCompilationException {
        try {
            String mapperClassName = this.getFullyQualifiedMapperClassName();
            Document model = XSLTUtils.getDocument();
            Element rootElt = XSLTUtils.getElement((Document)model, (String)"mapper");
            String mapperName = mapperClassName.substring(mapperClassName.lastIndexOf(".") + 1);
            XSLTUtils.addAttribute((Document)model, (String)"name", (String)mapperName, (Element)rootElt);
            String basePackageName = "";
            if (mapperClassName.indexOf(".") != -1) {
                basePackageName = mapperClassName.substring(0, mapperClassName.lastIndexOf("."));
                XSLTUtils.addAttribute((Document)model, (String)"package", (String)basePackageName, (Element)rootElt);
            } else {
                XSLTUtils.addAttribute((Document)model, (String)"package", (String)"", (Element)rootElt);
            }
            if (!this.wrapClasses) {
                XSLTUtils.addAttribute((Document)model, (String)"unwrapped", (String)"yes", (Element)rootElt);
            }
            if (!this.writeClasses) {
                XSLTUtils.addAttribute((Document)model, (String)"skip-write", (String)"yes", (Element)rootElt);
            }
            if (this.isHelperMode) {
                XSLTUtils.addAttribute((Document)model, (String)"helpermode", (String)"yes", (Element)rootElt);
            }
            for (int i = 0; i < metainfArray.length; ++i) {
                QName ownQname = metainfArray[i].getOwnQname();
                String className = metainfArray[i].getOwnClassName();
                if (ownQname == null) continue;
                Element typeChild = XSLTUtils.addChildElement((Document)model, (String)"type", (Node)rootElt);
                XSLTUtils.addAttribute((Document)model, (String)"nsuri", (String)ownQname.getNamespaceURI(), (Element)typeChild);
                XSLTUtils.addAttribute((Document)model, (String)"classname", (String)(className == null ? "" : className), (Element)typeChild);
                XSLTUtils.addAttribute((Document)model, (String)"shortname", (String)(ownQname == null ? "" : ownQname.getLocalPart()), (Element)typeChild);
            }
            model.appendChild(rootElt);
            if (!this.templateLoaded) {
                this.loadTemplate();
            }
            if (this.wrapClasses) {
                rootElt = (Element)this.globalWrappedDocument.importNode(rootElt, true);
                this.globalWrappedDocument.getDocumentElement().appendChild(rootElt);
            } else {
                if (this.writeClasses) {
                    File out = this.createOutFile(basePackageName, mapperName);
                    this.parse(model, out);
                }
                this.modelMap.put(new QName(mapperName), model);
            }
        }
        catch (ParserConfigurationException e) {
            throw new SchemaCompilationException(SchemaCompilerMessages.getMessage("schema.docuement.error"), e);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SchemaCompilationException(e);
        }
    }

    private String identifyUniqueNameForQName(List<BeanWriterMetaInfoHolder> parents, String xmlName, BeanWriterMetaInfoHolder metainf, QName original, QName modified) {
        int count = 0;
        for (BeanWriterMetaInfoHolder beanWriterMetaInfoHolder : parents) {
            QName[] pQNmame = null;
            pQNmame = beanWriterMetaInfoHolder.isOrdered() ? beanWriterMetaInfoHolder.getOrderedQNameArray() : beanWriterMetaInfoHolder.getQNameArray();
            List<QName> pQNameList = null;
            if (pQNmame != null) {
                pQNameList = Arrays.asList(pQNmame);
            }
            if (pQNameList != null && pQNameList.contains(modified) && metainf.getClassNameForQName(original) != null && !metainf.getClassNameForQName(original).equalsIgnoreCase(beanWriterMetaInfoHolder.getClassNameForQName(modified))) {
                xmlName = xmlName + count;
                break;
            }
            ++count;
        }
        return xmlName;
    }

    private void mergeBeanWriterMetaInfoHolderForRestriction(BeanWriterMetaInfoHolder metainf, BeanWriterMetaInfoHolder parent) {
        parent.setRestriction(true);
        if (metainf.getPatternFacet() != null) {
            parent.setPatternFacet(metainf.getPatternFacet());
        }
        if (metainf.getMaxExclusiveFacet() != null) {
            parent.setMaxExclusiveFacet(metainf.getMaxExclusiveFacet());
        }
        if (metainf.getMinExclusiveFacet() != null) {
            parent.setMinExclusiveFacet(metainf.getMinExclusiveFacet());
        }
        if (metainf.getMinInclusiveFacet() != null) {
            parent.setMinInclusiveFacet(metainf.getMinInclusiveFacet());
        }
        if (metainf.getMaxInclusiveFacet() != null) {
            parent.setMaxInclusiveFacet(metainf.getMaxInclusiveFacet());
        }
        if (metainf.getLengthFacet() != -1L) {
            parent.setLengthFacet(metainf.getLengthFacet());
        }
        if (metainf.getMaxLengthFacet() != -1L) {
            parent.setMaxLengthFacet(metainf.getMaxLengthFacet());
        }
        if (metainf.getMinLengthFacet() != -1L) {
            parent.setMinLengthFacet(metainf.getMinLengthFacet());
        }
        if (metainf.getTotalDigitsFacet() != null) {
            parent.setTotalDigitsFacet(metainf.getTotalDigitsFacet());
        }
        if (metainf.getTotalDigitsFacet() != null) {
            parent.setTotalDigitsFacet(metainf.getTotalDigitsFacet());
        }
        if (metainf.getEnumFacet() != null && metainf.getEnumFacet().size() > 0) {
            parent.getEnumFacet().addAll(metainf.getEnumFacet());
        }
    }
}

