/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.clustering.tribes;

import org.apache.axis2.clustering.MembershipListener;
import org.apache.axis2.clustering.tribes.TribesUtil;
import org.apache.catalina.tribes.Member;
import org.apache.catalina.tribes.group.interceptors.NonBlockingCoordinator;

public class Axis2Coordinator
extends NonBlockingCoordinator {
    private final MembershipListener membershipListener;

    public Axis2Coordinator(MembershipListener membershipListener) {
        this.membershipListener = membershipListener;
    }

    public void memberAdded(Member member) {
        super.memberAdded(member);
        if (this.membershipListener != null && TribesUtil.areInSameDomain(this.getLocalMember(true), member)) {
            this.membershipListener.memberAdded(TribesUtil.toAxis2Member(member), this.isCoordinator());
        }
    }

    public void memberDisappeared(Member member) {
        super.memberDisappeared(member);
        if (!TribesUtil.areInSameDomain(this.getLocalMember(true), member)) {
            return;
        }
        if (this.isCoordinator() && TribesUtil.toAxis2Member(member).isActive() && TribesUtil.toAxis2Member(this.getLocalMember(true)).isActive()) {
            Member[] members;
            for (Member aMember : members = this.getMembers()) {
                if (TribesUtil.toAxis2Member(member).isActive()) continue;
            }
        }
        if (this.membershipListener != null) {
            this.membershipListener.memberDisappeared(TribesUtil.toAxis2Member(member), this.isCoordinator());
        }
    }
}

