/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.wsdl.codegen.extension;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.AxisMessage;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.wsdl.WSDLUtil;
import org.apache.axis2.wsdl.codegen.CodeGenConfiguration;
import org.apache.axis2.wsdl.codegen.CodeGenerationException;
import org.apache.axis2.wsdl.codegen.extension.AbstractCodeGenerationExtension;
import org.apache.axis2.wsdl.i18n.CodegenMessages;
import org.apache.axis2.wsdl.util.ConfigPropertyFileLoader;
import org.apache.axis2.wsdl.util.MessagePartInformationHolder;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaAll;
import org.apache.ws.commons.schema.XmlSchemaAny;
import org.apache.ws.commons.schema.XmlSchemaAttribute;
import org.apache.ws.commons.schema.XmlSchemaChoice;
import org.apache.ws.commons.schema.XmlSchemaComplexContent;
import org.apache.ws.commons.schema.XmlSchemaComplexContentExtension;
import org.apache.ws.commons.schema.XmlSchemaComplexType;
import org.apache.ws.commons.schema.XmlSchemaContent;
import org.apache.ws.commons.schema.XmlSchemaContentModel;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaImport;
import org.apache.ws.commons.schema.XmlSchemaInclude;
import org.apache.ws.commons.schema.XmlSchemaObject;
import org.apache.ws.commons.schema.XmlSchemaObjectCollection;
import org.apache.ws.commons.schema.XmlSchemaParticle;
import org.apache.ws.commons.schema.XmlSchemaSequence;
import org.apache.ws.commons.schema.XmlSchemaSimpleType;
import org.apache.ws.commons.schema.XmlSchemaType;

public class SchemaUnwrapperExtension
extends AbstractCodeGenerationExtension {
    private CodeGenConfiguration codeGenConfiguration;

    @Override
    public void engage(CodeGenConfiguration configuration) throws CodeGenerationException {
        this.codeGenConfiguration = configuration;
        if (!configuration.isParametersWrapped() && !this.codeGenConfiguration.getOutputLanguage().equals("jax-ws")) {
            if (!ConfigPropertyFileLoader.getUnwrapSupportedFrameworkNames().contains(configuration.getDatabindingType())) {
                throw new CodeGenerationException(CodegenMessages.getMessage("extension.unsupportedforunwrapping"));
            }
            if (!ConfigPropertyFileLoader.getUnwrapDirectFrameworkNames().contains(configuration.getDatabindingType())) {
                List<AxisService> services = configuration.getAxisServices();
                for (AxisService axisService : services) {
                    Iterator operations = axisService.getOperations();
                    while (operations.hasNext()) {
                        AxisOperation op = (AxisOperation)operations.next();
                        if (WSDLUtil.isInputPresentForMEP((String)op.getMessageExchangePattern())) {
                            this.walkSchema(op.getMessage("In"), "_input");
                        }
                        if (!configuration.getDatabindingType().equals("adb") || !WSDLUtil.isOutputPresentForMEP((String)op.getMessageExchangePattern())) continue;
                        this.walkSchema(op.getMessage("Out"), "_output");
                    }
                }
            }
        }
    }

    public void walkSchema(AxisMessage message, String qnameSuffix) throws CodeGenerationException {
        if (message.getSchemaElement() == null) {
            return;
        }
        LinkedList<QName> partNameList = new LinkedList<QName>();
        XmlSchemaElement schemaElement = message.getSchemaElement();
        XmlSchemaType schemaType = schemaElement.getSchemaType();
        QName schemaTypeQname = schemaElement.getSchemaTypeName();
        if (schemaType == null && schemaTypeQname != null) {
            AxisService axisService = message.getAxisOperation().getAxisService();
            ArrayList schemasList = axisService.getSchema();
            XmlSchema schema = null;
            Iterator iter = schemasList.iterator();
            while (iter.hasNext() && (schemaType = this.getSchemaType(schema = (XmlSchema)iter.next(), schemaTypeQname)) == null) {
            }
        }
        if (schemaType instanceof XmlSchemaComplexType) {
            this.handleAllCasesOfComplexTypes(schemaType, message, partNameList, qnameSuffix);
        } else if (schemaType instanceof XmlSchemaSimpleType || schemaTypeQname != null && schemaTypeQname.equals(new QName("http://www.w3.org/2001/XMLSchema", "anyType"))) {
            QName opName = message.getAxisOperation().getName();
            partNameList.add(WSDLUtil.getPartQName((String)opName.getLocalPart(), (String)qnameSuffix, (String)schemaElement.getQName().getLocalPart()));
        } else {
            if (schemaType == null) {
                throw new CodeGenerationException("Can not determine the schema type for the " + schemaElement.getName());
            }
            throw new CodeGenerationException(CodegenMessages.getMessage("extension.unsupportedSchemaFormat", schemaType.getName(), "complexType"));
        }
        try {
            message.addParameter(this.getParameter("UnWrapped", Boolean.TRUE));
            MessagePartInformationHolder infoHolder = new MessagePartInformationHolder();
            infoHolder.setOperationName(message.getAxisOperation().getName());
            infoHolder.setPartsList(partNameList);
            message.addParameter(this.getParameter("UnWrapped_details", infoHolder));
        }
        catch (AxisFault axisFault) {
            throw new CodeGenerationException(axisFault);
        }
    }

    private void handleAllCasesOfComplexTypes(XmlSchemaType schemaType, AxisMessage message, List partNameList, String qnameSuffix) throws CodeGenerationException {
        if (schemaType instanceof XmlSchemaComplexType) {
            XmlSchemaComplexType cmplxType = (XmlSchemaComplexType)schemaType;
            if (cmplxType.getContentModel() == null) {
                if (cmplxType.getParticle() != null) {
                    this.processXMLSchemaSequence(cmplxType.getParticle(), message, partNameList, qnameSuffix);
                }
            } else {
                this.processComplexContentModel(cmplxType, message, partNameList, qnameSuffix);
            }
            this.processAttributes(cmplxType, message, partNameList, qnameSuffix);
        }
    }

    private void processAttributes(XmlSchemaComplexType complexType, AxisMessage message, List partNameList, String qnameSuffix) {
        QName opName = message.getAxisOperation().getName();
        XmlSchemaObjectCollection xmlObjectCollection = complexType.getAttributes();
        Iterator iter = xmlObjectCollection.getIterator();
        while (iter.hasNext()) {
            XmlSchemaObject item = (XmlSchemaObject)iter.next();
            if (!(item instanceof XmlSchemaAttribute)) continue;
            XmlSchemaAttribute xmlSchemaAttribute = (XmlSchemaAttribute)item;
            String partName = xmlSchemaAttribute.getName();
            partNameList.add(WSDLUtil.getPartQName((String)opName.getLocalPart(), (String)qnameSuffix, (String)partName));
        }
    }

    private void processComplexContentModel(XmlSchemaComplexType cmplxType, AxisMessage message, List partNameList, String qnameSuffix) throws CodeGenerationException {
        XmlSchemaComplexContent xmlSchemaComplexContent;
        XmlSchemaContent content;
        XmlSchemaContentModel contentModel = cmplxType.getContentModel();
        if (contentModel instanceof XmlSchemaComplexContent && (content = (xmlSchemaComplexContent = (XmlSchemaComplexContent)contentModel).getContent()) instanceof XmlSchemaComplexContentExtension) {
            XmlSchemaComplexContentExtension schemaExtension = (XmlSchemaComplexContentExtension)content;
            if (schemaExtension.getParticle() != null) {
                this.processXMLSchemaSequence(schemaExtension.getParticle(), message, partNameList, qnameSuffix);
            }
            AxisService axisService = message.getAxisOperation().getAxisService();
            ArrayList schemasList = axisService.getSchema();
            Object parentSchema = null;
            XmlSchema schema = null;
            XmlSchemaType extensionSchemaType = null;
            Iterator iter = schemasList.iterator();
            while (iter.hasNext() && (extensionSchemaType = this.getSchemaType(schema = (XmlSchema)iter.next(), schemaExtension.getBaseTypeName())) == null) {
            }
            this.handleAllCasesOfComplexTypes(extensionSchemaType, message, partNameList, qnameSuffix);
        }
    }

    private XmlSchemaType getSchemaType(XmlSchema schema, QName typeName) {
        XmlSchemaObjectCollection includes;
        XmlSchemaType xmlSchemaType = null;
        if (schema != null && (xmlSchemaType = schema.getTypeByName(typeName)) == null && (includes = schema.getIncludes()) != null) {
            Iterator includesIter = includes.getIterator();
            Object object = null;
            while (includesIter.hasNext()) {
                XmlSchema schema1;
                object = includesIter.next();
                if (object instanceof XmlSchemaImport) {
                    schema1 = ((XmlSchemaImport)object).getSchema();
                    xmlSchemaType = this.getSchemaType(schema1, typeName);
                }
                if (object instanceof XmlSchemaInclude) {
                    schema1 = ((XmlSchemaInclude)object).getSchema();
                    xmlSchemaType = this.getSchemaType(schema1, typeName);
                }
                if (xmlSchemaType == null) continue;
                break;
            }
        }
        return xmlSchemaType;
    }

    private void processXMLSchemaSequence(XmlSchemaParticle schemaParticle, AxisMessage message, List partNameList, String qnameSuffix) throws CodeGenerationException {
        if (schemaParticle instanceof XmlSchemaSequence) {
            QName opName = message.getAxisOperation().getName();
            XmlSchemaSequence sequence = (XmlSchemaSequence)schemaParticle;
            XmlSchemaObjectCollection items = sequence.getItems();
            if (items.getCount() == 0) {
                return;
            }
            Iterator i = items.getIterator();
            while (i.hasNext()) {
                Object item = i.next();
                if (item instanceof XmlSchemaElement) {
                    XmlSchemaElement xmlSchemaElement = (XmlSchemaElement)item;
                    XmlSchemaType schemaType = xmlSchemaElement.getSchemaType();
                    String partName = null;
                    partName = xmlSchemaElement.getRefName() != null ? xmlSchemaElement.getRefName().getLocalPart() : xmlSchemaElement.getName();
                    partNameList.add(WSDLUtil.getPartQName((String)opName.getLocalPart(), (String)qnameSuffix, (String)partName));
                    continue;
                }
                if (item instanceof XmlSchemaAny) {
                    XmlSchemaAny xmlSchemaAny = (XmlSchemaAny)item;
                    partNameList.add(WSDLUtil.getPartQName((String)opName.getLocalPart(), (String)qnameSuffix, (String)"extraElement"));
                    continue;
                }
                throw new CodeGenerationException(CodegenMessages.getMessage("extension.unsupportedSchemaFormat", "unknown type", "Element"));
            }
        } else {
            if (schemaParticle instanceof XmlSchemaChoice) {
                throw new CodeGenerationException(CodegenMessages.getMessage("extension.unsupportedSchemaFormat", "choice", "sequence"));
            }
            if (schemaParticle instanceof XmlSchemaAll) {
                throw new CodeGenerationException(CodegenMessages.getMessage("extension.unsupportedSchemaFormat", "all", "sequence"));
            }
            throw new CodeGenerationException(CodegenMessages.getMessage("extension.unsupportedSchemaFormat", "unknown", "sequence"));
        }
    }

    private Parameter getParameter(String key, Object value) {
        Parameter myParameter = new Parameter();
        myParameter.setName(key);
        myParameter.setValue(value);
        return myParameter;
    }
}

