/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.tools.component;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.apache.axis2.tools.component.CancelAction;
import org.apache.axis2.tools.component.FinishAction;
import org.apache.axis2.tools.component.WizardComponents;
import org.apache.axis2.tools.component.WizardPanel;

public class DefaultWizardComponents
implements WizardComponents {
    private JButton backButton;
    private JButton nextButton;
    private JButton finishButton;
    private JButton cancelButton;
    FinishAction finishAction;
    CancelAction cancelAction;
    List panelList;
    int currentIndex;
    JPanel wizardPanelsContainer;
    PropertyChangeSupport propertyChangeListeners;

    public DefaultWizardComponents() {
        try {
            this.init();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addWizardPanel(WizardPanel panel) {
        this.getWizardPanelList().add(panel);
        this.wizardPanelsContainer.add((Component)panel, this.getWizardPanelList().size() - 1 + "");
    }

    public void addWizardPanel(int index, WizardPanel panel) {
        this.getWizardPanelList().add(index, panel);
        this.wizardPanelsContainer.add(panel, index + "", index);
        if (index < this.getWizardPanelList().size() - 1) {
            for (int i = index + 1; i < this.getWizardPanelList().size(); ++i) {
                this.wizardPanelsContainer.add((Component)((WizardPanel)this.getWizardPanelList().get(i)), i + "");
            }
        }
    }

    public void addWizardPanelAfter(WizardPanel panelToBePlacedAfter, WizardPanel panel) {
        this.addWizardPanel(this.getWizardPanelList().indexOf(panelToBePlacedAfter) + 1, panel);
    }

    public void addWizardPanelBefore(WizardPanel panelToBePlacedBefore, WizardPanel panel) {
        this.addWizardPanel(this.getWizardPanelList().indexOf(panelToBePlacedBefore) - 1, panel);
    }

    public void addWizardPanelAfterCurrent(WizardPanel panel) {
        this.addWizardPanel(this.getCurrentIndex() + 1, panel);
    }

    public WizardPanel removeWizardPanel(WizardPanel panel) {
        int index = this.getWizardPanelList().indexOf(panel);
        this.getWizardPanelList().remove(panel);
        this.wizardPanelsContainer.remove(panel);
        for (int i = index; i < this.getWizardPanelList().size(); ++i) {
            this.wizardPanelsContainer.add((Component)((WizardPanel)this.getWizardPanelList().get(i)), i + "");
        }
        return panel;
    }

    public WizardPanel removeWizardPanel(int index) {
        this.wizardPanelsContainer.remove(index);
        WizardPanel panel = (WizardPanel)this.getWizardPanelList().remove(index);
        for (int i = index; i < this.getWizardPanelList().size(); ++i) {
            this.wizardPanelsContainer.add((Component)((WizardPanel)this.getWizardPanelList().get(i)), i + "");
        }
        return panel;
    }

    public WizardPanel removeWizardPanelAfter(WizardPanel panel) {
        return this.removeWizardPanel(this.getWizardPanelList().indexOf(panel) + 1);
    }

    public WizardPanel removeWizardPanelBefore(WizardPanel panel) {
        return this.removeWizardPanel(this.getWizardPanelList().indexOf(panel) - 1);
    }

    public WizardPanel getWizardPanel(int index) {
        return (WizardPanel)this.getWizardPanelList().get(index);
    }

    public int getIndexOfPanel(WizardPanel panel) {
        return this.getWizardPanelList().indexOf(panel);
    }

    public boolean onLastPanel() {
        return this.getCurrentIndex() == this.getWizardPanelList().size() - 1;
    }

    private void init() throws Exception {
        this.propertyChangeListeners = new PropertyChangeSupport(this);
        this.backButton = new JButton();
        this.nextButton = new JButton();
        this.finishButton = new JButton();
        this.cancelButton = new JButton();
        this.panelList = new ArrayList();
        this.currentIndex = 0;
        this.wizardPanelsContainer = new JPanel();
        this.backButton.setText("< Back");
        this.backButton.setMnemonic("B".charAt(0));
        this.backButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DefaultWizardComponents.this.backButton_actionPerformed(e);
            }
        });
        this.nextButton.setText("Next >");
        this.nextButton.setMnemonic("N".charAt(0));
        this.nextButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DefaultWizardComponents.this.nextButton_actionPerformed(e);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.setMnemonic("C".charAt(0));
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DefaultWizardComponents.this.cancelButton_actionPerformed(e);
            }
        });
        this.finishButton.setText("Finish");
        this.finishButton.setMnemonic("F".charAt(0));
        this.finishButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DefaultWizardComponents.this.finishButton_actionPerformed(e);
            }
        });
        this.wizardPanelsContainer.setLayout(new CardLayout());
    }

    void cancelButton_actionPerformed(ActionEvent e) {
        this.getCancelAction().performAction();
    }

    void finishButton_actionPerformed(ActionEvent e) {
        this.getFinishAction().performAction();
    }

    void nextButton_actionPerformed(ActionEvent e) {
        try {
            if (this.getCurrentPanel().isPageComplete()) {
                this.getCurrentPanel().next();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void backButton_actionPerformed(ActionEvent e) {
        try {
            this.getCurrentPanel().back();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public WizardPanel getCurrentPanel() throws Exception {
        if (this.getWizardPanelList().get(this.currentIndex) != null) {
            return (WizardPanel)this.getWizardPanelList().get(this.currentIndex);
        }
        throw new Exception("No panels in panelList");
    }

    public void updateComponents() {
        try {
            CardLayout cl = (CardLayout)this.wizardPanelsContainer.getLayout();
            cl.show(this.wizardPanelsContainer, this.currentIndex + "");
            if (this.currentIndex == 0) {
                this.backButton.setEnabled(false);
            } else {
                this.backButton.setEnabled(true);
            }
            if (this.onLastPanel()) {
                this.nextButton.setEnabled(false);
                this.finishButton.setEnabled(true);
            } else {
                this.finishButton.setEnabled(false);
                this.nextButton.setEnabled(true);
            }
            this.getCurrentPanel().update();
            PropertyChangeEvent event = new PropertyChangeEvent(this, "currentPanel", null, this.getCurrentPanel());
            this.propertyChangeListeners.firePropertyChange(event);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List getWizardPanelList() {
        return this.panelList;
    }

    public void setWizardPanelList(ArrayList panelList) {
        this.panelList = panelList;
    }

    public FinishAction getFinishAction() {
        return this.finishAction;
    }

    public void setFinishAction(FinishAction aFinishAction) {
        this.finishAction = aFinishAction;
    }

    public CancelAction getCancelAction() {
        return this.cancelAction;
    }

    public void setCancelAction(CancelAction aCancelAction) {
        this.cancelAction = aCancelAction;
    }

    public int getCurrentIndex() {
        return this.currentIndex;
    }

    public void setCurrentIndex(int aCurrentIndex) {
        this.currentIndex = aCurrentIndex;
    }

    public JPanel getWizardPanelsContainer() {
        return this.wizardPanelsContainer;
    }

    public void setWizardPanelsContainer(JPanel aWizardPanelsContainer) {
        this.wizardPanelsContainer = aWizardPanelsContainer;
    }

    public JButton getBackButton() {
        return this.backButton;
    }

    public void setBackButton(JButton aBackButton) {
        this.backButton = aBackButton;
    }

    public JButton getNextButton() {
        return this.nextButton;
    }

    public void setNextButton(JButton aNextButton) {
        this.nextButton = aNextButton;
    }

    public JButton getCancelButton() {
        return this.cancelButton;
    }

    public void setCancelButton(JButton aCancelButton) {
        this.cancelButton = aCancelButton;
    }

    public JButton getFinishButton() {
        return this.finishButton;
    }

    public void setFinishButton(JButton button) {
        this.finishButton = button;
    }

    public void setWizardPanelList(List panelList) {
        this.panelList = panelList;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeListeners.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeListeners.removePropertyChangeListener(listener);
    }
}

