/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.tools.java2wsdl;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.apache.axis2.tools.bean.ClassLoadingTestBean;
import org.apache.axis2.tools.bean.NamespaceFinder;
import org.apache.axis2.tools.bean.WsdlgenBean;
import org.apache.axis2.tools.component.WizardComponents;
import org.apache.axis2.tools.component.WizardPanel;
import org.apache.axis2.tools.java2wsdl.JarFileFilter;

public class MiddlePanel
extends WizardPanel {
    private JTextField txtClass;
    private JButton btnFolder;
    private JButton btnJar;
    private JButton btnRemove;
    private JButton btnTest;
    private JButton btnHint;
    private JTextArea txaHint;
    private boolean flag = false;
    private JList listPathDisply;
    private DefaultListModel listModel;
    private JLabel lblTest;
    private String hint = "Please give the fully qualified class name, example :com.foo.BarService Then add the folder or the jar file which contains that class file. Finally check whether the class file can be loaded from the plugin.  If the class that you are going to load contains any dependencies  on other axis2 libraries ( for example like axiom*.jar), please add those libraries as well and try to load the class.";
    final JFileChooser FileChooser = new JFileChooser();
    final JFileChooser DirChooser = new JFileChooser();
    private WsdlgenBean wsdlgenBean;

    public MiddlePanel(WizardComponents wizardComponents, WsdlgenBean wsdlgenBean) {
        super(wizardComponents, "Axis2 Idea Plugin Java2WSDL Wizards");
        this.setPanelTopTitle("Java source / classpath selection");
        this.setPanelBottomTitle("Select the classes and the libraries");
        this.wsdlgenBean = wsdlgenBean;
        this.init();
    }

    private void init() {
        this.txaHint = new JTextArea();
        this.txaHint.setBorder(null);
        this.txaHint.setFocusable(false);
        this.txaHint.setLineWrap(true);
        this.txaHint.setWrapStyleWord(true);
        this.txaHint.setOpaque(false);
        this.btnHint = new JButton("Hint >>");
        this.btnHint.setBorder(new EmptyBorder(new Insets(0, 0, 0, 0)));
        this.btnFolder = new JButton("Add Folder");
        this.btnJar = new JButton("Add Jar");
        this.btnRemove = new JButton("Remove");
        this.btnTest = new JButton("Test Class Loading");
        this.txtClass = new JTextField();
        this.lblTest = new JLabel();
        this.listModel = new DefaultListModel();
        this.listPathDisply = new JList(this.listModel);
        this.listPathDisply.setAutoscrolls(true);
        this.listPathDisply.setOpaque(false);
        this.listPathDisply.setBorder(BorderFactory.createBevelBorder(1));
        this.listPathDisply.setFocusable(false);
        this.setBackButtonEnabled(true);
        this.setNextButtonEnabled(false);
        this.setFinishButtonEnabled(false);
        this.setPageComplete(false);
        this.setLayout(new GridBagLayout());
        this.add((Component)new JLabel("Fully Qualified Class Name :"), new GridBagConstraints(0, 0, 1, 1, 0.1, 0.0, 17, 0, new Insets(5, 10, 0, 10), 0, 0));
        this.add((Component)this.txtClass, new GridBagConstraints(1, 0, 0, 1, 1.0, 0.0, 10, 2, new Insets(5, 1, 0, 10), 0, 0));
        this.add((Component)new JLabel("java class path Entries.select either folders or jar files "), new GridBagConstraints(0, 1, 0, 1, 0.0, 0.0, 17, 2, new Insets(5, 10, 0, 10), 0, 0));
        this.add((Component)this.btnFolder, new GridBagConstraints(0, 2, 1, 1, 0.1, 0.0, 10, 2, new Insets(5, 10, 1, 1), 0, 0));
        this.btnFolder.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MiddlePanel.this.DirChooser.setFileSelectionMode(1);
                int returnVal = MiddlePanel.this.DirChooser.showOpenDialog(MiddlePanel.this.btnFolder);
                if (returnVal == 0) {
                    MiddlePanel.this.DirChooser.setFileSelectionMode(0);
                    File newfile = MiddlePanel.this.DirChooser.getSelectedFile();
                    MiddlePanel.this.listModel.addElement(newfile.getAbsolutePath());
                    MiddlePanel.this.setDefaultPathAndName(newfile);
                    MiddlePanel.this.updateStatusTextField(false, "");
                }
                MiddlePanel.this.update();
            }
        });
        this.add((Component)this.btnJar, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 1, 1, 1), 0, 0));
        this.btnJar.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MiddlePanel.this.FileChooser.setFileFilter(new JarFileFilter());
                int returnVal = MiddlePanel.this.FileChooser.showOpenDialog(MiddlePanel.this.btnJar);
                if (returnVal == 0) {
                    File file = MiddlePanel.this.FileChooser.getSelectedFile();
                    MiddlePanel.this.listModel.addElement(file.getAbsolutePath());
                    MiddlePanel.this.setDefaultPathAndName(file);
                    MiddlePanel.this.updateStatusTextField(false, "");
                }
                MiddlePanel.this.update();
            }
        });
        this.add((Component)this.btnRemove, new GridBagConstraints(2, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 1, 1, 10), 0, 0));
        this.btnRemove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MiddlePanel.this.handleRemove();
                MiddlePanel.this.update();
            }
        });
        this.add((Component)new JScrollPane(this.listPathDisply), new GridBagConstraints(0, 3, 0, 1, 0.1, 0.0, 17, 2, new Insets(5, 10, 1, 10), 0, 0));
        this.add((Component)this.btnTest, new GridBagConstraints(0, 4, 1, 1, 0.1, 0.0, 10, 2, new Insets(5, 10, 1, 1), 0, 0));
        this.btnTest.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (!MiddlePanel.this.testLoading()) {
                    MiddlePanel.this.setBackButtonEnabled(true);
                    MiddlePanel.this.setNextButtonEnabled(false);
                    MiddlePanel.this.setFinishButtonEnabled(false);
                } else {
                    MiddlePanel.this.setBackButtonEnabled(true);
                    MiddlePanel.this.setNextButtonEnabled(true);
                    MiddlePanel.this.setFinishButtonEnabled(false);
                    MiddlePanel.this.wsdlgenBean.setClassPathList(MiddlePanel.this.getClassPathlist());
                    MiddlePanel.this.wsdlgenBean.setClassName(MiddlePanel.this.txtClass.getText().trim());
                    MiddlePanel.this.setPageComplete(true);
                }
                MiddlePanel.this.update();
            }
        });
        this.add((Component)this.lblTest, new GridBagConstraints(1, 4, 0, 1, 1.0, 0.0, 10, 2, new Insets(5, 1, 1, 10), 0, 0));
        this.add((Component)new JSeparator(), new GridBagConstraints(0, 5, 0, 1, 0.0, 0.0, 17, 2, new Insets(5, 1, 1, 1), 0, 0));
        this.add((Component)this.btnHint, new GridBagConstraints(0, 6, 1, 1, 0.1, 0.0, 17, 0, new Insets(5, 10, 0, 10), 0, 0));
        this.btnHint.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (MiddlePanel.this.flag) {
                    MiddlePanel.this.btnHint.setText("Hint >>");
                    MiddlePanel.this.txaHint.setText("");
                    MiddlePanel.this.flag = false;
                } else {
                    MiddlePanel.this.btnHint.setText("Hint <<");
                    MiddlePanel.this.txaHint.setText(MiddlePanel.this.hint);
                    MiddlePanel.this.flag = true;
                }
                MiddlePanel.this.update();
            }
        });
        this.add((Component)this.txaHint, new GridBagConstraints(0, 7, 0, 1, 0.1, 1.0, 10, 1, new Insets(5, 10, 10, 10), 0, 0));
    }

    public void next() {
        if (this.txtClass.getText() != null && this.isPageComplete()) {
            this.switchPanel(4);
        } else {
            this.switchPanel(2);
            this.setNextButtonEnabled(false);
        }
    }

    public void back() {
        this.switchPanel(0);
    }

    public void update() {
    }

    private void setDefaultPathAndName(File file) {
        if (file.getParent() != null) {
            this.wsdlgenBean.setOutputLocation(file.getParent());
            this.wsdlgenBean.setOutputWSDLName("Services.wsdl");
        }
    }

    public void updateStatusTextField(boolean success, String text) {
        if (success) {
            this.wsdlgenBean.setServiceName(NamespaceFinder.getServiceNameText(this.txtClass.getText()));
            this.wsdlgenBean.setTargetNamespace(NamespaceFinder.getTargetNamespaceFromClass(this.txtClass.getText()));
            this.wsdlgenBean.setTargetNamespacePrefix(NamespaceFinder.getDefaultNamespacePrefix());
            this.wsdlgenBean.setSchemaTargetNamespace(NamespaceFinder.getSchemaTargetNamespaceFromClass(this.txtClass.getText()));
            this.wsdlgenBean.setSchemaTargetNamespacePrefix(NamespaceFinder.getDefaultSchemaNamespacePrefix());
        }
        this.lblTest.setText(text);
    }

    private void handleRemove() {
        int[] selectionIndices = this.listPathDisply.getSelectedIndices();
        for (int i = 0; i < selectionIndices.length; ++i) {
            this.listModel.remove(selectionIndices[i]);
        }
        this.updateStatusTextField(false, "");
        this.update();
    }

    public String[] getClassPathlist() {
        Object[] listObject = this.listModel.toArray();
        String[] listString = new String[listObject.length];
        for (int i = 0; i < listObject.length; ++i) {
            listString[i] = listObject[i].toString();
        }
        return listString;
    }

    public boolean testLoading() {
        ArrayList errorListener = new ArrayList();
        String[] listString = this.getClassPathlist();
        if (!ClassLoadingTestBean.tryLoadingClass(this.txtClass.getText(), listString, errorListener)) {
            Iterator it = errorListener.iterator();
            while (it.hasNext()) {
                Object nextObject = it.next();
                String errorMessage = nextObject == null ? "Unknown error!" : nextObject.toString();
                this.lblTest.setText(errorMessage);
                this.updateStatusTextField(false, errorMessage);
                this.update();
            }
            return false;
        }
        this.updateStatusTextField(true, "Class file loaded successfully");
        return true;
    }

    public int getPageType() {
        return 2;
    }
}

