/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ideaplugin.frames;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.apache.axis2.tools.component.WizardComponents;
import org.apache.axis2.tools.component.WizardPanel;
import org.apache.ideaplugin.bean.ArchiveBean;
import org.apache.ideaplugin.bean.XmlFileFilter;

public class ServiceXMLFileSelectionPage
extends WizardPanel {
    private JLabel lblXmlLocation;
    private JTextField txtServiceXml;
    private JButton butSelect;
    private JCheckBox chkBoxIncludeXml;
    private JButton btnHint;
    private JTextArea txaHint;
    private boolean flag = false;
    private String hint = "";
    private final JFileChooser fileChooser = new JFileChooser();
    private ArchiveBean archiveBean;
    private String value;

    public ServiceXMLFileSelectionPage(WizardComponents wizardComponents, ArchiveBean archiveBean) {
        super(wizardComponents, "Axis2 Idea Plugin Service Archiver Creator Wizards");
        this.setPanelTopTitle("Service Archiver");
        this.setPanelBottomTitle("Select the service.xml file");
        this.archiveBean = archiveBean;
        this.init();
    }

    private void init() {
        this.txaHint = new JTextArea();
        this.txaHint.setBorder(null);
        this.txaHint.setFocusable(false);
        this.txaHint.setLineWrap(true);
        this.txaHint.setWrapStyleWord(true);
        this.txaHint.setOpaque(false);
        this.btnHint = new JButton("Hint >>");
        this.btnHint.setBorder(new EmptyBorder(new Insets(0, 0, 0, 0)));
        this.lblXmlLocation = new JLabel("set the Service XML file");
        this.lblXmlLocation.setEnabled(false);
        this.txtServiceXml = new JTextField();
        this.txtServiceXml.setEnabled(false);
        this.butSelect = new JButton("Browse..");
        this.butSelect.setEnabled(false);
        this.chkBoxIncludeXml = new JCheckBox("Generate service xml automatically", true);
        this.setBackButtonEnabled(true);
        this.setNextButtonEnabled(false);
        this.setFinishButtonEnabled(false);
        this.setPageComplete(false);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.chkBoxIncludeXml, new GridBagConstraints(0, 0, 0, 1, 0.0, 0.0, 10, 2, new Insets(5, 1, 1, 1), 0, 0));
        this.chkBoxIncludeXml.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ServiceXMLFileSelectionPage.this.setChangeEnabled();
                ServiceXMLFileSelectionPage.this.update();
            }
        });
        this.add((Component)this.lblXmlLocation, new GridBagConstraints(0, 1, 1, 1, 0.1, 0.0, 17, 0, new Insets(5, 10, 0, 0), 0, 0));
        this.add((Component)this.txtServiceXml, new GridBagConstraints(1, 1, -1, 1, 1.0, 0.0, 17, 2, new Insets(5, 1, 0, 0), 0, 0));
        this.txtServiceXml.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ServiceXMLFileSelectionPage.this.update();
            }
        });
        this.add((Component)this.butSelect, new GridBagConstraints(2, 1, 1, 1, 0.1, 0.0, 10, 0, new Insets(5, 0, 1, 10), 0, 0));
        this.butSelect.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ServiceXMLFileSelectionPage.this.browseXmlFile();
                ServiceXMLFileSelectionPage.this.setNextButtonEnabled(true);
                ServiceXMLFileSelectionPage.this.setPageComplete(true);
                ServiceXMLFileSelectionPage.this.update();
            }
        });
        this.add((Component)this.btnHint, new GridBagConstraints(0, 2, 0, 1, 0.1, 0.0, 17, 0, new Insets(5, 10, 0, 10), 0, 0));
        this.btnHint.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (ServiceXMLFileSelectionPage.this.flag) {
                    ServiceXMLFileSelectionPage.this.btnHint.setText("Hint >>");
                    ServiceXMLFileSelectionPage.this.txaHint.setText("");
                    ServiceXMLFileSelectionPage.this.flag = false;
                } else {
                    ServiceXMLFileSelectionPage.this.btnHint.setText("Hint <<");
                    ServiceXMLFileSelectionPage.this.txaHint.setText(ServiceXMLFileSelectionPage.this.hint);
                    ServiceXMLFileSelectionPage.this.flag = true;
                }
                ServiceXMLFileSelectionPage.this.update();
            }
        });
        this.add((Component)this.txaHint, new GridBagConstraints(0, 3, 0, 1, 0.1, 1.0, 10, 1, new Insets(5, 10, 10, 10), 0, 0));
    }

    public void next() {
        if (!this.chkBoxIncludeXml.isSelected()) {
            this.switchPanel(13);
        } else {
            this.switchPanel(11);
        }
        this.setNextButtonEnabled(false);
    }

    public void back() {
        this.switchPanel(9);
    }

    public void update() {
        this.fillBean();
        this.setPageComplete(true);
        this.setNextButtonEnabled(true);
    }

    public int getPageType() {
        return 3;
    }

    private void browseXmlFile() {
        this.fileChooser.setFileFilter(new XmlFileFilter());
        this.fileChooser.setCurrentDirectory(this.archiveBean.getClassLoc());
        int returnVal = this.fileChooser.showOpenDialog(this.butSelect);
        if (returnVal == 0) {
            File xmlfile = this.fileChooser.getSelectedFile();
            this.txtServiceXml.setText(xmlfile.getAbsolutePath());
            byte[] buf = new byte[1024];
            try {
                int read;
                FileInputStream in = new FileInputStream(xmlfile);
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                while ((read = in.read(buf)) > 0) {
                    out.write(buf, 0, read);
                }
                in.close();
                this.value = new String(out.toByteArray());
            }
            catch (IOException e1) {}
        } else {
            this.txtServiceXml.setText("");
        }
    }

    private void setChangeEnabled() {
        if (this.chkBoxIncludeXml.isSelected()) {
            this.lblXmlLocation.setEnabled(false);
            this.txtServiceXml.setEnabled(false);
            this.butSelect.setEnabled(false);
        } else {
            this.lblXmlLocation.setEnabled(true);
            this.txtServiceXml.setEnabled(true);
            this.butSelect.setEnabled(true);
        }
    }

    private void fillBean() {
        if (!this.chkBoxIncludeXml.isSelected() && this.value != null) {
            this.archiveBean.setServiceXML(this.value);
        }
    }

    public boolean isIncludeXml() {
        return this.chkBoxIncludeXml.isSelected();
    }
}

