/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxbri;

import com.sun.xml.bind.v2.runtime.JAXBContextImpl;
import com.sun.xml.bind.v2.runtime.JaxBeanInfo;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.SchemaOutputResolver;
import javax.xml.namespace.QName;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMResult;
import org.apache.axis2.deployment.util.BeanExcludeInfo;
import org.apache.axis2.description.java2wsdl.DefaultSchemaGenerator;
import org.apache.axis2.util.Loader;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaComplexContent;
import org.apache.ws.commons.schema.XmlSchemaComplexContentExtension;
import org.apache.ws.commons.schema.XmlSchemaComplexType;
import org.apache.ws.commons.schema.XmlSchemaContent;
import org.apache.ws.commons.schema.XmlSchemaContentModel;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaImport;
import org.apache.ws.commons.schema.XmlSchemaObject;
import org.apache.ws.commons.schema.XmlSchemaParticle;
import org.apache.ws.commons.schema.XmlSchemaSequence;
import org.apache.ws.commons.schema.utils.NamespaceMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaxbSchemaGenerator
extends DefaultSchemaGenerator {
    public JaxbSchemaGenerator(ClassLoader loader, String className, String schematargetNamespace, String schematargetNamespacePrefix) throws Exception {
        super(loader, className, schematargetNamespace, schematargetNamespacePrefix, null);
    }

    public Collection generateSchema() throws Exception {
        this.generateSchemaForParameters();
        return super.generateSchema();
    }

    public void generateSchemaForParameters() throws Exception {
        HashSet classes = new HashSet();
        classes.addAll(this.processJaxBeMethods(this.serviceClass.getMethods()));
        if (this.extraClasses != null) {
            for (String extraClass : this.extraClasses) {
                classes.add(Loader.loadClass((ClassLoader)this.classLoader, (String)extraClass));
            }
        }
        String jaxbNamespace = null;
        if (this.isUseWSDLTypesNamespace()) {
            jaxbNamespace = (String)this.pkg2nsmap.get("all");
        }
        if (jaxbNamespace == null) {
            jaxbNamespace = this.getSchemaTargetNameSpace();
        }
        JAXBContextImpl context = (JAXBContextImpl)JaxbSchemaGenerator.createJAXBContext(classes, jaxbNamespace);
        for (DOMResult r : this.generateJaxbSchemas((JAXBContext)context)) {
            Document d = (Document)r.getNode();
            String targetNamespace = d.getDocumentElement().getAttribute("targetNamespace");
            if ("".equals(targetNamespace)) {
                targetNamespace = this.getSchemaTargetNameSpace();
                d.getDocumentElement().setAttribute("targetNamespace", targetNamespace);
            }
            NodeList nodes = d.getDocumentElement().getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                Element element;
                Node n = nodes.item(i);
                if (!(n instanceof Element) || !(element = (Element)n).getLocalName().equals("import")) continue;
                d.getDocumentElement().removeChild(element);
            }
            XmlSchema xmlSchema = this.xmlSchemaCollection.read(d.getDocumentElement());
            for (Class clazz : classes) {
                JaxBeanInfo beanInfo = context.getBeanInfo(clazz);
                QName qName = this.getTypeName(beanInfo);
                if (qName == null) continue;
                this.typeTable.addComplexSchema(clazz.getName(), qName);
            }
            this.schemaMap.put(targetNamespace, xmlSchema);
        }
    }

    private QName getTypeName(JaxBeanInfo<?> beanInfo) {
        Iterator itr = beanInfo.getTypeNames().iterator();
        if (!itr.hasNext()) {
            return null;
        }
        return (QName)itr.next();
    }

    protected List<Class<?>> processJaxBeMethods(Method[] declaredMethods) throws Exception {
        ArrayList list = new ArrayList();
        for (int i = 0; i < declaredMethods.length; ++i) {
            int j;
            Method jMethod = declaredMethods[i];
            if (jMethod.getExceptionTypes().length > 0) {
                Class<?>[] extypes = jMethod.getExceptionTypes();
                for (j = 0; j < extypes.length; ++j) {
                    Class<?> extype = extypes[j];
                    if (!extype.getName().startsWith("java") || extype.getName().startsWith("javax.")) {
                        list.add(extype);
                    }
                    this.generateSchemaForType(list, extype);
                }
            }
            Class<?>[] paras = jMethod.getParameterTypes();
            for (j = 0; j < paras.length; ++j) {
                Class<?> paraType = paras[j];
                this.generateSchemaForType(list, paraType);
            }
            Class<?> returnType = jMethod.getReturnType();
            if (returnType == Void.TYPE) continue;
            this.generateSchemaForType(list, returnType);
        }
        return list;
    }

    private void generateSchemaForType(List<Class<?>> list, Class type) throws Exception {
        QName schemaTypeName;
        boolean isArrayType = false;
        if (type != null) {
            isArrayType = type.isArray();
        }
        if (isArrayType) {
            type = type.getComponentType();
        }
        String classTypeName = type == null ? "java.lang.Object" : type.getName();
        if (isArrayType && "byte".equals(classTypeName)) {
            classTypeName = "base64Binary";
            isArrayType = false;
        }
        if ("javax.activation.DataHandler".equals(classTypeName)) {
            classTypeName = "base64Binary";
        }
        if ((schemaTypeName = this.typeTable.getSimpleSchemaTypeName(classTypeName)) == null) {
            list.add(type);
        }
        this.addImport(this.getXmlSchema(this.schemaTargetNameSpace), schemaTypeName);
    }

    protected List<DOMResult> generateJaxbSchemas(JAXBContext context) throws IOException {
        final ArrayList<DOMResult> results = new ArrayList<DOMResult>();
        context.generateSchema(new SchemaOutputResolver(){

            public Result createOutput(String ns, String file) throws IOException {
                DOMResult result = new DOMResult();
                result.setSystemId(file);
                results.add(result);
                return result;
            }
        });
        return results;
    }

    protected static JAXBContext createJAXBContext(Set<Class<?>> classes, String defaultNs) throws JAXBException {
        Iterator<Class<?>> it = classes.iterator();
        String className = "";
        while (it.hasNext()) {
            Class<?> remoteExceptionObject = it.next();
            className = ((Object)remoteExceptionObject).toString();
            if ("".equals(className) || !className.contains("RemoteException")) continue;
            it.remove();
        }
        for (Class<?> cls : classes) {
            if (!cls.getName().endsWith("ObjectFactory")) continue;
            defaultNs = null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        if (defaultNs != null) {
            map.put("com.sun.xml.bind.defaultNamespaceRemap", defaultNs);
        }
        for (Class<?> cls : classes) {
            System.out.println(">>>> :" + cls);
        }
        return JAXBContext.newInstance((Class[])classes.toArray(new Class[classes.size()]), map);
    }

    protected QName generateSchema(Class javaType) throws Exception {
        String name = this.getClassName(javaType);
        QName schemaTypeName = this.typeTable.getComplexSchemaType(name);
        if (schemaTypeName == null) {
            String simpleName = javaType.getSimpleName();
            String packageName = this.getQualifiedName(javaType.getPackage());
            String targetNameSpace = this.resolveSchemaNamespace(packageName);
            XmlSchema xmlSchema = this.getXmlSchema(targetNameSpace);
            String targetNamespacePrefix = (String)this.targetNamespacePrefixMap.get(targetNameSpace);
            if (targetNamespacePrefix == null) {
                targetNamespacePrefix = this.generatePrefix();
                this.targetNamespacePrefixMap.put(targetNameSpace, targetNamespacePrefix);
            }
            XmlSchemaComplexType complexType = new XmlSchemaComplexType(xmlSchema);
            XmlSchemaSequence sequence = new XmlSchemaSequence();
            XmlSchemaComplexContentExtension complexExtension = new XmlSchemaComplexContentExtension();
            XmlSchemaElement eltOuter = new XmlSchemaElement();
            schemaTypeName = new QName(targetNameSpace, simpleName, targetNamespacePrefix);
            eltOuter.setName(simpleName);
            eltOuter.setQName(schemaTypeName);
            Class sup = javaType.getSuperclass();
            if (sup != null && "java.lang.Object".compareTo(sup.getName()) != 0 && this.getQualifiedName(sup.getPackage()).indexOf("org.apache.axis2") <= 0 && this.getQualifiedName(sup.getPackage()).indexOf("java.util") <= 0) {
                String tgtNamespacepfx;
                String tgtNamespace;
                String superClassName = sup.getName();
                String superclassname = sup.getSimpleName();
                QName qName = this.typeTable.getSimpleSchemaTypeName(superClassName);
                if (qName != null) {
                    tgtNamespace = qName.getNamespaceURI();
                    tgtNamespacepfx = qName.getPrefix();
                } else {
                    tgtNamespace = this.resolveSchemaNamespace(this.getQualifiedName(sup.getPackage()));
                    tgtNamespacepfx = (String)this.targetNamespacePrefixMap.get(tgtNamespace);
                    QName superClassQname = this.generateSchema(sup);
                    if (superClassQname != null) {
                        tgtNamespacepfx = superClassQname.getPrefix();
                        tgtNamespace = superClassQname.getNamespaceURI();
                    }
                }
                if (tgtNamespacepfx == null) {
                    tgtNamespacepfx = this.generatePrefix();
                    this.targetNamespacePrefixMap.put(tgtNamespace, tgtNamespacepfx);
                }
                if (!((NamespaceMap)xmlSchema.getNamespaceContext()).values().contains(tgtNamespace)) {
                    XmlSchemaImport importElement = new XmlSchemaImport();
                    importElement.setNamespace(tgtNamespace);
                    xmlSchema.getItems().add((XmlSchemaObject)importElement);
                    ((NamespaceMap)xmlSchema.getNamespaceContext()).put((Object)this.generatePrefix(), (Object)tgtNamespace);
                }
                QName basetype = new QName(tgtNamespace, superclassname, tgtNamespacepfx);
                complexExtension.setBaseTypeName(basetype);
                complexExtension.setParticle((XmlSchemaParticle)sequence);
                XmlSchemaComplexContent contentModel = new XmlSchemaComplexContent();
                contentModel.setContent((XmlSchemaContent)complexExtension);
                complexType.setContentModel((XmlSchemaContentModel)contentModel);
            } else {
                complexType.setParticle((XmlSchemaParticle)sequence);
            }
            complexType.setName(simpleName);
            xmlSchema.getElements().add(schemaTypeName, (XmlSchemaObject)eltOuter);
            eltOuter.setSchemaTypeName(complexType.getQName());
            xmlSchema.getItems().add((XmlSchemaObject)complexType);
            xmlSchema.getSchemaTypes().add(schemaTypeName, (XmlSchemaObject)complexType);
            this.typeTable.addComplexSchema(name, eltOuter.getQName());
            this.typeTable.addComplexSchema(this.getQualifiedName(javaType.getPackage()), eltOuter.getQName());
            BeanExcludeInfo beanExcludeInfo = null;
            if (this.service.getExcludeInfo() != null) {
                beanExcludeInfo = this.service.getExcludeInfo().getBeanExcludeInfoForClass(this.getClassName(javaType));
            }
            BeanInfo beanInfo = Introspector.getBeanInfo(javaType, javaType.getSuperclass());
            PropertyDescriptor[] properties = beanInfo.getPropertyDescriptors();
            for (int i = 0; i < properties.length; ++i) {
                PropertyDescriptor property = properties[i];
                String propertyName = property.getName();
                if (property.getName().equals("class") || property.getPropertyType() == null || beanExcludeInfo != null && beanExcludeInfo.isExcludedProperty(propertyName)) continue;
                this.generateSchemaforFieldsandProperties(xmlSchema, sequence, property.getPropertyType(), propertyName, property.getPropertyType().isArray());
            }
        }
        return schemaTypeName;
    }
}

