/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws;

import java.util.Hashtable;
import java.util.Map;
import javax.xml.ws.Binding;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.binding.SOAPBinding;
import org.apache.axis2.jaxws.client.PropertyValidator;
import org.apache.axis2.jaxws.core.InvocationContext;
import org.apache.axis2.jaxws.core.MessageContext;
import org.apache.axis2.jaxws.description.EndpointDescription;
import org.apache.axis2.jaxws.handler.HandlerResolverImpl;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.axis2.jaxws.spi.ServiceDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BindingProvider
implements org.apache.axis2.jaxws.spi.BindingProvider {
    protected Map<String, Object> requestContext;
    protected Map<String, Object> responseContext;
    protected EndpointDescription endpointDesc;
    protected ServiceDelegate serviceDelegate;
    private Binding binding;

    public BindingProvider(ServiceDelegate svcDelegate, EndpointDescription epDesc) {
        this.endpointDesc = epDesc;
        this.serviceDelegate = svcDelegate;
        this.initialize();
    }

    private void initialize() {
        this.requestContext = new ValidatingClientContext();
        this.responseContext = new ValidatingClientContext();
        this.requestContext.put("javax.xml.ws.session.maintain", new Boolean(false));
        this.requestContext.put("javax.xml.ws.soap.http.soapaction.use", new Boolean(true));
        String endpointAddress = this.endpointDesc.getEndpointAddress();
        if (endpointAddress != null) {
            this.requestContext.put("javax.xml.ws.service.endpoint.address", endpointAddress);
        }
    }

    @Override
    public ServiceDelegate getServiceDelegate() {
        return this.serviceDelegate;
    }

    @Override
    public EndpointDescription getEndpointDescription() {
        return this.endpointDesc;
    }

    public Binding getBinding() {
        if (this.binding == null) {
            this.binding = new SOAPBinding(this.endpointDesc);
            HandlerResolverImpl handlerResolver = this.serviceDelegate.getHandlerResolver() != null ? this.serviceDelegate.getHandlerResolver() : new HandlerResolverImpl(this.endpointDesc);
            this.binding.setHandlerChain(handlerResolver.getHandlerChain(this.endpointDesc.getPortInfo()));
        }
        return this.binding;
    }

    public Map<String, Object> getRequestContext() {
        return this.requestContext;
    }

    public Map<String, Object> getResponseContext() {
        return this.responseContext;
    }

    protected void checkMaintainSessionState(MessageContext mc, InvocationContext ic) {
        Map properties = ic.getServiceClient().getServiceContext().getProperties();
        boolean bValue = false;
        if (properties != null && properties.containsKey("javax.xml.ws.session.maintain")) {
            bValue = (Boolean)properties.get("javax.xml.ws.session.maintain");
        }
        if (mc.isMaintainSession() || bValue) {
            this.setupSessionContext(properties);
        }
    }

    protected void setupSessionContext(Map<String, Object> properties) {
        String sessionKey = null;
        String sessionValue = null;
        if (properties == null) {
            return;
        }
        if (properties.containsKey("Location")) {
            sessionKey = "Location";
            sessionValue = (String)properties.get(sessionKey);
            if (sessionValue != null && !"".equals(sessionValue)) {
                this.requestContext.put("javax.xml.ws.service.endpoint.address", sessionValue);
            }
        } else if (properties.containsKey("Cookie")) {
            sessionKey = "Cookie";
            sessionValue = (String)properties.get(sessionKey);
            if (sessionValue != null && !"".equals(sessionValue)) {
                this.requestContext.put("Cookie", sessionValue);
            }
        } else if (properties.containsKey("Cookie2")) {
            sessionKey = "Cookie2";
            sessionValue = (String)properties.get(sessionKey);
            if (sessionValue != null && !"".equals(sessionValue)) {
                this.requestContext.put("Cookie", sessionValue);
            }
        } else {
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"NoMaintainSessionProperty"));
        }
        if (sessionValue == null) {
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"NullValueForMaintainSessionProperty", (String)sessionKey));
        }
    }

    protected boolean useSoapAction() {
        Boolean use = (Boolean)this.requestContext.get("javax.xml.ws.soap.http.soapaction.use");
        if (use != null) {
            return use != false;
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ValidatingClientContext
    extends Hashtable<String, Object> {
        ValidatingClientContext() {
        }

        @Override
        public synchronized Object put(String key, Object value) {
            if (PropertyValidator.validate(key, value)) {
                return super.put(key, value);
            }
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"invalidPropValue", (String)key, (String)value.getClass().getName(), (String)PropertyValidator.getExpectedValue(key).getName()));
        }
    }
}

