/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.core.controller;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.Future;
import javax.xml.namespace.QName;
import javax.xml.ws.AsyncHandler;
import javax.xml.ws.Response;
import javax.xml.ws.WebServiceException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.OperationClient;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.client.async.Callback;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.client.ClientUtils;
import org.apache.axis2.jaxws.client.async.AsyncResponse;
import org.apache.axis2.jaxws.client.async.CallbackFuture;
import org.apache.axis2.jaxws.client.async.PollingFuture;
import org.apache.axis2.jaxws.core.InvocationContext;
import org.apache.axis2.jaxws.core.MessageContext;
import org.apache.axis2.jaxws.core.controller.InvocationController;
import org.apache.axis2.jaxws.description.OperationDescription;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.axis2.jaxws.message.Message;
import org.apache.axis2.jaxws.message.factory.MessageFactory;
import org.apache.axis2.jaxws.message.util.MessageUtils;
import org.apache.axis2.jaxws.registry.FactoryRegistry;
import org.apache.axis2.jaxws.util.Constants;
import org.apache.axis2.jaxws.utility.ClassUtils;
import org.apache.axis2.transport.http.HttpTransportProperties;
import org.apache.axis2.util.CallbackReceiver;
import org.apache.axis2.util.ThreadContextMigratorUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AxisInvocationController
extends InvocationController {
    private static Log log = LogFactory.getLog(AxisInvocationController.class);

    @Override
    public MessageContext doInvoke(MessageContext request) {
        AxisFault faultexception;
        MessageContext response;
        org.apache.axis2.context.MessageContext axisResponseMsgCtx;
        OperationClient opClient;
        block5: {
            QName operationName = AxisInvocationController.getOperationNameToUse(request, ServiceClient.ANON_OUT_IN_OP);
            InvocationContext ic = request.getInvocationContext();
            ServiceClient svcClient = ic.getServiceClient();
            opClient = this.createOperationClient(svcClient, operationName);
            this.initOperationClient(opClient, request);
            org.apache.axis2.context.MessageContext axisRequestMsgCtx = request.getAxisMessageContext();
            axisResponseMsgCtx = null;
            response = null;
            faultexception = null;
            try {
                this.execute(opClient, true, axisRequestMsgCtx);
            }
            catch (AxisFault af) {
                faultexception = af;
                if (!log.isDebugEnabled()) break block5;
                log.debug((Object)(axisRequestMsgCtx.getLogIDString() + " AxisFault received from client: " + af.getMessage()));
            }
        }
        try {
            axisResponseMsgCtx = opClient.getMessageContext("In");
            response = new MessageContext(axisResponseMsgCtx);
            if (!(faultexception == null || response.getMessage() != null && response.getMessage().isFault())) {
                MessageFactory factory = (MessageFactory)FactoryRegistry.getFactory(MessageFactory.class);
                Message message = factory.create(request.getMessage().getProtocol());
                response.setLocalException(faultexception);
                response.setMessage(message);
            }
            ThreadContextMigratorUtil.performMigrationToThread((String)"JAXWS-ThreadContextMigrator-List", (org.apache.axis2.context.MessageContext)axisResponseMsgCtx);
        }
        catch (Exception e) {
            throw ExceptionFactory.makeWebServiceException((Throwable)e);
        }
        return response;
    }

    @Override
    public void doInvokeOneWay(MessageContext request) throws WebServiceException {
        QName operationName = AxisInvocationController.getOperationNameToUse(request, ServiceClient.ANON_OUT_ONLY_OP);
        InvocationContext ic = request.getInvocationContext();
        ServiceClient svcClient = ic.getServiceClient();
        OperationClient opClient = this.createOperationClient(svcClient, operationName);
        this.initOperationClient(opClient, request);
        org.apache.axis2.context.MessageContext axisRequestMsgCtx = request.getAxisMessageContext();
        try {
            this.execute(opClient, true, axisRequestMsgCtx);
        }
        catch (AxisFault af) {
            if (log.isDebugEnabled()) {
                log.debug((Object)(axisRequestMsgCtx.getLogIDString() + " AxisFault received from client: " + af.getMessage()));
            }
            throw ExceptionFactory.makeWebServiceException((Throwable)ClassUtils.getRootCause(af));
        }
    }

    @Override
    public Future<?> doInvokeAsync(MessageContext request, AsyncHandler callback) {
        QName operationName = AxisInvocationController.getOperationNameToUse(request, ServiceClient.ANON_OUT_IN_OP);
        InvocationContext ic = request.getInvocationContext();
        ServiceClient svcClient = ic.getServiceClient();
        OperationClient opClient = this.createOperationClient(svcClient, operationName);
        this.initOperationClient(opClient, request);
        Boolean useAsyncMep = (Boolean)request.getProperties().get(Constants.USE_ASYNC_MEP);
        if (useAsyncMep != null && useAsyncMep.booleanValue() || opClient.getOptions().isUseSeparateListener()) {
            this.configureAsyncListener(opClient, request.getAxisMessageContext());
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"Asynchronous message exchange not enabled.  The invocation will be synchronous.");
        }
        CallbackFuture cbf = null;
        if (callback == null) {
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"ICErr4"));
        }
        cbf = new CallbackFuture(ic, callback);
        opClient.setCallback((Callback)cbf);
        org.apache.axis2.context.MessageContext axisRequestMsgCtx = request.getAxisMessageContext();
        try {
            this.execute(opClient, false, axisRequestMsgCtx);
        }
        catch (AxisFault af) {
            if (log.isDebugEnabled()) {
                log.debug((Object)(axisRequestMsgCtx.getLogIDString() + " AxisFault received from client: " + af.getMessage()));
            }
            cbf.onError((Exception)((Object)af));
        }
        return cbf.getFutureTask();
    }

    @Override
    public Response doInvokeAsync(MessageContext request) {
        QName operationName = AxisInvocationController.getOperationNameToUse(request, ServiceClient.ANON_OUT_IN_OP);
        InvocationContext ic = request.getInvocationContext();
        ServiceClient svcClient = ic.getServiceClient();
        OperationClient opClient = this.createOperationClient(svcClient, operationName);
        this.initOperationClient(opClient, request);
        Boolean useAsyncMep = (Boolean)request.getProperties().get(Constants.USE_ASYNC_MEP);
        if (useAsyncMep != null && useAsyncMep.booleanValue() || opClient.getOptions().isUseSeparateListener()) {
            this.configureAsyncListener(opClient, request.getAxisMessageContext());
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"Asynchronous message exchange not enabled.  The invocation will be synchronous.");
        }
        AsyncResponse resp = ic.getAsyncResponseListener();
        PollingFuture pf = new PollingFuture(ic);
        opClient.setCallback((Callback)pf);
        org.apache.axis2.context.MessageContext axisRequestMsgCtx = request.getAxisMessageContext();
        try {
            this.execute(opClient, false, axisRequestMsgCtx);
        }
        catch (AxisFault af) {
            if (log.isDebugEnabled()) {
                log.debug((Object)(axisRequestMsgCtx.getLogIDString() + " AxisFault received from client: " + af.getMessage()));
            }
            pf.onError((Exception)((Object)af));
        }
        return resp;
    }

    @Override
    protected void prepareRequest(MessageContext requestMsgCtx) {
        try {
            if (requestMsgCtx == null) {
                // empty if block
            }
            org.apache.axis2.context.MessageContext axisRequestMsgCtx = requestMsgCtx.getAxisMessageContext();
            MessageUtils.putMessageOnMessageContext(requestMsgCtx.getMessage(), axisRequestMsgCtx);
            axisRequestMsgCtx.setProperty("CopyProperties", (Object)Boolean.TRUE);
            Map props = axisRequestMsgCtx.getOptions().getProperties();
            props.putAll(requestMsgCtx.getProperties());
            axisRequestMsgCtx.getOptions().setProperties(props);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Properties: " + axisRequestMsgCtx.getProperties().toString()));
            }
        }
        catch (WebServiceException e) {
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"prepareRequestFail"));
        }
        catch (AxisFault e) {
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"prepareRequestFail"), (Throwable)e);
        }
    }

    @Override
    protected void prepareResponse(MessageContext responseMsgCtx) {
    }

    private void initOperationClient(OperationClient opClient, MessageContext requestMsgCtx) {
        org.apache.axis2.context.MessageContext axisRequest = requestMsgCtx.getAxisMessageContext();
        this.setupProperties(requestMsgCtx, axisRequest.getOptions());
        Options options = opClient.getOptions();
        if (opClient != null) {
            String targetUrl = (String)requestMsgCtx.getProperties().get("javax.xml.ws.service.endpoint.address");
            EndpointReference toEPR = new EndpointReference(targetUrl);
            options.setTo(toEPR);
            String soapAction = ClientUtils.findSOAPAction(requestMsgCtx);
            options.setAction(soapAction);
            try {
                OperationContext opContext = opClient.getOperationContext();
                ServiceContext svcContext = opContext.getServiceContext();
                axisRequest.setServiceContext(svcContext);
                opClient.addMessageContext(axisRequest);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    private OperationClient createOperationClient(ServiceClient sc, QName operation) {
        if (sc == null) {
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"ICCreateOpClientErr1"));
        }
        if (operation == null) {
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"ICCreateOpClientErr2"));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating OperationClient for operation: " + operation));
        }
        try {
            OperationClient client = sc.createClient(operation);
            return client;
        }
        catch (AxisFault e) {
            throw ExceptionFactory.makeWebServiceException((Throwable)e);
        }
    }

    private void configureAsyncListener(OperationClient client, org.apache.axis2.context.MessageContext mc) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enabling asynchronous message exchange.  An asynchronous listener will be establish.");
        }
        client.getOptions().setUseSeparateListener(true);
        mc.getOptions().setUseSeparateListener(true);
        AxisOperation op = client.getOperationContext().getAxisOperation();
        MessageReceiver messageReceiver = op.getMessageReceiver();
        if (messageReceiver == null || !(messageReceiver instanceof CallbackReceiver)) {
            op.setMessageReceiver((MessageReceiver)new CallbackReceiver());
        }
    }

    private void setupProperties(MessageContext mc, Options ops) {
        Map<String, Object> properties = mc.getProperties();
        for (String key : properties.keySet()) {
            Object value = properties.get(key);
            ops.setProperty(key, value);
        }
        Message msg = mc.getMessage();
        if (msg.isMTOMEnabled()) {
            ops.setProperty("enableMTOM", (Object)"true");
        }
        if (mc.isMaintainSession()) {
            ops.setManageSession(true);
        }
        if (properties.containsKey("javax.xml.ws.security.auth.username") && properties.containsKey("javax.xml.ws.security.auth.password")) {
            String userId = (String)properties.get("javax.xml.ws.security.auth.username");
            if (userId == null || userId == "") {
                throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"checkUserName"));
            }
            String password = (String)properties.get("javax.xml.ws.security.auth.password");
            if (password == null || password == "") {
                throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"checkPassword"));
            }
            URL url = null;
            try {
                url = new URL((String)mc.getProperties().get("javax.xml.ws.service.endpoint.address"));
            }
            catch (MalformedURLException e) {
                throw ExceptionFactory.makeWebServiceException((Throwable)e);
            }
            HttpTransportProperties.Authenticator basicAuthentication = new HttpTransportProperties.Authenticator();
            basicAuthentication.setUsername(userId);
            basicAuthentication.setPassword(password);
            basicAuthentication.setHost(url.getHost());
            basicAuthentication.setPort(url.getPort());
            ops.setProperty("_NTLM_DIGEST_BASIC_AUTHENTICATION_", (Object)basicAuthentication);
        } else if (!properties.containsKey("javax.xml.ws.security.auth.username") && properties.containsKey("javax.xml.ws.security.auth.password") || properties.containsKey("javax.xml.ws.security.auth.username") && !properties.containsKey("javax.xml.ws.security.auth.password")) {
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"checkUsernameAndPassword"));
        }
    }

    private static QName getOperationNameToUse(MessageContext requestMsgCtx, QName defaultOpName) {
        QName operationName = null;
        OperationDescription opDesc = requestMsgCtx.getOperationDescription();
        operationName = opDesc != null && opDesc.getAxisOperation() != null ? opDesc.getName() : defaultOpName;
        return operationName;
    }

    private void execute(OperationClient opClient, boolean block, org.apache.axis2.context.MessageContext msgContext) throws AxisFault {
        try {
            this.preExecute(opClient, block, msgContext);
            opClient.execute(block);
        }
        catch (Throwable e) {
            throw AxisFault.makeFault((Exception)((Object)ExceptionFactory.makeWebServiceException((Throwable)e)));
        }
        finally {
            this.postExecute(opClient, block, msgContext);
        }
    }

    private void preExecute(OperationClient opClient, boolean block, org.apache.axis2.context.MessageContext msgContext) throws AxisFault {
        ThreadContextMigratorUtil.performMigrationToContext((String)"JAXWS-ThreadContextMigrator-List", (org.apache.axis2.context.MessageContext)msgContext);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Start OperationClient.execute(" + block + ")"));
        }
    }

    private void postExecute(OperationClient opClient, boolean block, org.apache.axis2.context.MessageContext msgContext) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("End OperationClient.execute(" + block + ")"));
        }
        ThreadContextMigratorUtil.performContextCleanup((String)"JAXWS-ThreadContextMigrator-List", (org.apache.axis2.context.MessageContext)msgContext);
    }
}

