/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.handler;

import java.util.ArrayList;
import java.util.List;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.ProtocolException;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.handler.LogicalHandler;
import javax.xml.ws.handler.soap.SOAPHandler;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.context.factory.MessageContextFactory;
import org.apache.axis2.jaxws.core.MessageContext;
import org.apache.axis2.jaxws.handler.LogicalMessageContext;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.axis2.jaxws.marshaller.impl.alt.MethodMarshallerUtils;
import org.apache.axis2.jaxws.message.Protocol;
import org.apache.axis2.jaxws.message.XMLFault;
import org.apache.axis2.jaxws.message.factory.MessageFactory;
import org.apache.axis2.jaxws.message.util.XMLFaultUtils;
import org.apache.axis2.jaxws.registry.FactoryRegistry;
import org.apache.axis2.jaxws.utility.SAAJFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HandlerChainProcessor {
    private javax.xml.ws.handler.MessageContext currentMC;
    private MessageContext mc;
    private List<Handler> handlers = null;
    private int logicalLength = 0;
    private static final int SUCCESSFUL = 0;
    private static final int FAILED = 1;
    private static final int PROTOCOL_EXCEPTION = 2;
    private static final int OTHER_EXCEPTION = 3;
    private RuntimeException savedException;
    private Protocol proto;

    public HandlerChainProcessor(List<Handler> chain, Protocol proto) {
        this.handlers = chain == null ? new ArrayList<Handler>() : chain;
        this.proto = proto;
    }

    private void sortChain() throws WebServiceException {
        ArrayList<LogicalHandler> logicalHandlers = new ArrayList<LogicalHandler>();
        ArrayList<SOAPHandler> protocolHandlers = new ArrayList<SOAPHandler>();
        for (Handler handler : this.handlers) {
            if (LogicalHandler.class.isAssignableFrom(handler.getClass())) {
                logicalHandlers.add((LogicalHandler)handler);
                continue;
            }
            if (SOAPHandler.class.isAssignableFrom(handler.getClass())) {
                protocolHandlers.add((SOAPHandler)handler);
                continue;
            }
            if (Handler.class.isAssignableFrom(handler.getClass())) {
                throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"handlerChainErr1", (String)handler.getClass().getName()));
            }
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"handlerChainErr2", (String)handler.getClass().getName()));
        }
        this.logicalLength = logicalHandlers.size();
        this.handlers.clear();
        this.handlers.addAll(logicalHandlers);
        this.handlers.addAll(protocolHandlers);
    }

    public boolean processChain(MessageContext mc, Direction direction, MEP mep, boolean expectResponse) {
        if (this.handlers.size() == 0) {
            return true;
        }
        this.mc = mc;
        this.sortChain();
        this.initContext(direction);
        if (direction == Direction.OUT) {
            this.currentMC.put((Object)"javax.xml.ws.handler.message.outbound", (Object)(direction == Direction.OUT ? 1 : 0));
            this.callGenericHandlers(mep, expectResponse, 0, this.handlers.size() - 1, direction);
        } else {
            this.currentMC.put((Object)"javax.xml.ws.handler.message.outbound", (Object)(direction == Direction.OUT ? 1 : 0));
            this.callGenericHandlers(mep, expectResponse, this.handlers.size() - 1, 0, direction);
        }
        return (Boolean)this.currentMC.get((Object)"javax.xml.ws.handler.message.outbound") == (direction == Direction.OUT);
    }

    private void callGenericHandlers(MEP mep, boolean expectResponse, int start, int end, Direction direction) throws RuntimeException {
        if (mep == MEP.RESPONSE) {
            expectResponse = false;
        }
        int i = start;
        int result = 0;
        int newStart = 0;
        int newStart_inclusive = 0;
        int newEnd = 0;
        Direction newDirection = direction;
        if (direction == Direction.OUT) {
            while (i <= end && result == 0) {
                result = this.handleMessage(this.handlers.get(i), direction, expectResponse);
                newStart = i - 1;
                newStart_inclusive = i++;
                newEnd = 0;
                newDirection = Direction.IN;
                if (result != 0) continue;
                this.switchContext(direction, i);
            }
        } else {
            while (i >= end && result == 0) {
                result = this.handleMessage(this.handlers.get(i), direction, expectResponse);
                newStart = i + 1;
                newStart_inclusive = i--;
                newEnd = this.handlers.size() - 1;
                newDirection = Direction.OUT;
                if (result != 0) continue;
                this.switchContext(direction, i);
            }
        }
        if (newDirection == direction) {
            return;
        }
        if (expectResponse) {
            if (result == 1) {
                this.callGenericHandlers_avoidRecursion(newStart, newEnd, newDirection);
                this.callCloseHandlers(newStart_inclusive, newEnd, newDirection);
            } else if (result == 2) {
                try {
                    this.callGenericHandleFault(newStart, newEnd, newDirection);
                    this.callCloseHandlers(newStart_inclusive, newEnd, newDirection);
                }
                catch (RuntimeException re) {
                    this.callCloseHandlers(newStart_inclusive, newEnd, newDirection);
                    throw re;
                }
            } else if (result == 3) {
                this.callCloseHandlers(newStart_inclusive, newEnd, newDirection);
                throw this.savedException;
            }
        } else if (mep.equals((Object)MEP.REQUEST)) {
            this.callCloseHandlers(newStart_inclusive, newEnd, newDirection);
        } else if (direction.equals((Object)Direction.IN)) {
            this.callCloseHandlers(this.handlers.size() - 1, 0, direction);
        } else {
            this.callCloseHandlers(0, this.handlers.size() - 1, direction);
        }
    }

    private void callGenericHandlers_avoidRecursion(int start, int end, Direction direction) {
        int i;
        if (direction == Direction.OUT) {
            for (i = start; i <= end; ++i) {
                this.switchContext(direction, i);
                this.handlers.get(i).handleMessage(this.currentMC);
            }
        } else {
            while (i >= end) {
                this.switchContext(direction, i);
                this.handlers.get(i).handleMessage(this.currentMC);
                --i;
            }
        }
    }

    private int handleMessage(Handler handler, Direction direction, boolean expectResponse) throws RuntimeException {
        try {
            boolean success = handler.handleMessage(this.currentMC);
            if (success) {
                return 0;
            }
            if (expectResponse) {
                this.currentMC.put((Object)"javax.xml.ws.handler.message.outbound", (Object)(direction != Direction.OUT ? 1 : 0));
            }
            return 1;
        }
        catch (RuntimeException re) {
            this.savedException = re;
            if (expectResponse) {
                this.currentMC.put((Object)"javax.xml.ws.handler.message.outbound", (Object)(direction != Direction.OUT ? 1 : 0));
            }
            if (ProtocolException.class.isAssignableFrom(re.getClass())) {
                HandlerChainProcessor.convertToFaultMessage(this.mc, re, this.proto);
                this.reInitContext();
                return 2;
            }
            return 3;
        }
    }

    private void callCloseHandlers(int start, int end, Direction direction) {
        int i;
        if (direction == Direction.OUT) {
            for (i = start; i <= end; ++i) {
                try {
                    this.switchContext(direction, i);
                    this.handlers.get(i).close(this.currentMC);
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        } else {
            while (i >= end) {
                try {
                    this.switchContext(direction, i);
                    this.handlers.get(i).close(this.currentMC);
                }
                catch (Exception e) {
                    // empty catch block
                }
                --i;
            }
        }
    }

    public void processFault(MessageContext mc, Direction direction) {
        if (this.handlers.size() == 0) {
            return;
        }
        this.mc = mc;
        this.sortChain();
        this.initContext(direction);
        this.currentMC.put((Object)"javax.xml.ws.handler.message.outbound", (Object)(direction == Direction.OUT ? 1 : 0));
        try {
            if (direction == Direction.OUT) {
                this.callGenericHandleFault(0, this.handlers.size() - 1, direction);
            } else {
                this.callGenericHandleFault(this.handlers.size() - 1, 0, direction);
            }
        }
        catch (RuntimeException re) {
            throw re;
        }
        finally {
            if (direction == Direction.OUT) {
                this.initContext(Direction.IN);
                this.callCloseHandlers(this.handlers.size() - 1, 0, Direction.IN);
            } else {
                this.initContext(Direction.IN);
                this.callCloseHandlers(0, this.handlers.size() - 1, Direction.OUT);
            }
        }
    }

    private void callGenericHandleFault(int start, int end, Direction direction) throws RuntimeException {
        int i;
        this.switchContext(direction, i);
        if (direction == Direction.OUT) {
            for (i = start; i <= end && this.handlers.get(i).handleFault(this.currentMC); ++i) {
                this.switchContext(direction, i + 1);
            }
        } else {
            while (i >= end && this.handlers.get(i).handleFault(this.currentMC)) {
                this.switchContext(direction, i - 1);
                --i;
            }
        }
    }

    public static void convertToFaultMessage(MessageContext mc, Exception e, Protocol protocol) {
        try {
            if (protocol != Protocol.soap11 && protocol != Protocol.soap12) {
                throw ExceptionFactory.makeWebServiceException((String)"We only support SOAP11 and SOAP12 for JAXWS handlers");
            }
            String protocolNS = protocol == Protocol.soap11 ? "http://schemas.xmlsoap.org/soap/envelope/" : "http://www.w3.org/2003/05/soap-envelope";
            XMLFault xmlFault = MethodMarshallerUtils.createXMLFaultFromSystemException(e);
            javax.xml.soap.MessageFactory mf = SAAJFactory.createMessageFactory(protocolNS);
            SOAPMessage message = mf.createMessage();
            SOAPBody body = message.getSOAPBody();
            SOAPFault soapFault = XMLFaultUtils.createSAAJFault(xmlFault, body);
            mc.setMessage(((MessageFactory)FactoryRegistry.getFactory(MessageFactory.class)).createFrom(message));
        }
        catch (Exception ex) {
            throw ExceptionFactory.makeWebServiceException((Throwable)ex);
        }
    }

    private void reInitContext() {
        this.currentMC = this.currentMC.getClass().isAssignableFrom(LogicalMessageContext.class) ? MessageContextFactory.createLogicalMessageContext(this.mc) : MessageContextFactory.createSoapMessageContext(this.mc);
    }

    private void initContext(Direction direction) {
        this.currentMC = direction == Direction.OUT ? (this.logicalLength == 0 && this.handlers.size() > 0 ? MessageContextFactory.createSoapMessageContext(this.mc) : MessageContextFactory.createLogicalMessageContext(this.mc)) : (this.logicalLength == this.handlers.size() && this.handlers.size() > 0 ? MessageContextFactory.createLogicalMessageContext(this.mc) : MessageContextFactory.createSoapMessageContext(this.mc));
    }

    private void switchContext(Direction direction, int index) {
        if (this.logicalLength == this.handlers.size() || this.logicalLength == 0) {
            return;
        }
        if (direction == Direction.OUT && index == this.logicalLength || direction == Direction.IN && index == this.logicalLength - 1) {
            this.currentMC = this.currentMC.getClass().isAssignableFrom(LogicalMessageContext.class) ? MessageContextFactory.createSoapMessageContext(this.mc) : MessageContextFactory.createLogicalMessageContext(this.mc);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MEP {
        REQUEST,
        RESPONSE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Direction {
        IN,
        OUT;

    }
}

