/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.marshaller.factory;

import javax.jws.soap.SOAPBinding;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.ws.Holder;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.description.OperationDescription;
import org.apache.axis2.jaxws.description.ParameterDescription;
import org.apache.axis2.jaxws.description.ServiceDescription;
import org.apache.axis2.jaxws.marshaller.MethodMarshaller;
import org.apache.axis2.jaxws.marshaller.impl.alt.DocLitBareMethodMarshaller;
import org.apache.axis2.jaxws.marshaller.impl.alt.DocLitBareMinimalMethodMarshaller;
import org.apache.axis2.jaxws.marshaller.impl.alt.DocLitWrappedMethodMarshaller;
import org.apache.axis2.jaxws.marshaller.impl.alt.DocLitWrappedMinimalMethodMarshaller;
import org.apache.axis2.jaxws.marshaller.impl.alt.DocLitWrappedPlusMethodMarshaller;
import org.apache.axis2.jaxws.marshaller.impl.alt.RPCLitMethodMarshaller;
import org.apache.axis2.jaxws.message.databinding.JAXBUtils;
import org.apache.axis2.jaxws.runtime.description.marshal.MarshalServiceRuntimeDescription;
import org.apache.axis2.jaxws.runtime.description.marshal.MarshalServiceRuntimeDescriptionFactory;

public class MethodMarshallerFactory {
    private MethodMarshallerFactory() {
    }

    private static MethodMarshaller createMethodMarshaller(SOAPBinding.Style style, SOAPBinding.ParameterStyle paramStyle, SUBTYPE subType, boolean isClient) {
        if (style == SOAPBinding.Style.RPC) {
            return new RPCLitMethodMarshaller();
        }
        if (paramStyle == SOAPBinding.ParameterStyle.WRAPPED) {
            if (subType == SUBTYPE.PLUS) {
                return new DocLitWrappedPlusMethodMarshaller();
            }
            if (subType == SUBTYPE.MINIMAL) {
                return new DocLitWrappedMinimalMethodMarshaller();
            }
            return new DocLitWrappedMethodMarshaller();
        }
        if (paramStyle == SOAPBinding.ParameterStyle.BARE) {
            if (subType == SUBTYPE.MINIMAL) {
                return new DocLitBareMinimalMethodMarshaller();
            }
            return new DocLitBareMethodMarshaller();
        }
        return null;
    }

    public static MethodMarshaller getMarshaller(OperationDescription op, boolean isClient) {
        MethodMarshaller marshaller = null;
        if (isClient) {
            if (op.getSoapBindingStyle() == SOAPBinding.Style.DOCUMENT) {
                marshaller = MethodMarshallerFactory.createDocLitMethodMarshaller(op, isClient);
            } else if (op.getSoapBindingStyle() == SOAPBinding.Style.RPC) {
                marshaller = MethodMarshallerFactory.createRPCLitMethodMarshaller(isClient);
            }
        } else if (op.getSoapBindingStyle() == SOAPBinding.Style.DOCUMENT) {
            marshaller = MethodMarshallerFactory.createDocLitMethodMarshaller(op, isClient);
        } else if (op.getSoapBindingStyle() == SOAPBinding.Style.RPC) {
            marshaller = MethodMarshallerFactory.createRPCLitMethodMarshaller(isClient);
        }
        return marshaller;
    }

    private static MethodMarshaller createDocLitMethodMarshaller(OperationDescription op, boolean isClient) {
        SOAPBinding.ParameterStyle parameterStyle = null;
        SUBTYPE subType = SUBTYPE.NORMAL;
        if (MethodMarshallerFactory.isDocLitBare(op)) {
            if (MethodMarshallerFactory.isDocLitBareMinimal(op)) {
                subType = SUBTYPE.MINIMAL;
            }
            parameterStyle = SOAPBinding.ParameterStyle.BARE;
        } else {
            if (MethodMarshallerFactory.isDocLitWrappedMinimal(op)) {
                subType = SUBTYPE.MINIMAL;
            } else if (MethodMarshallerFactory.isDocLitWrappedPlus(op)) {
                subType = SUBTYPE.PLUS;
            }
            parameterStyle = SOAPBinding.ParameterStyle.WRAPPED;
        }
        return MethodMarshallerFactory.createMethodMarshaller(SOAPBinding.Style.DOCUMENT, parameterStyle, subType, isClient);
    }

    private static MethodMarshaller createRPCLitMethodMarshaller(boolean isClient) {
        return MethodMarshallerFactory.createMethodMarshaller(SOAPBinding.Style.RPC, SOAPBinding.ParameterStyle.WRAPPED, SUBTYPE.NORMAL, isClient);
    }

    protected static boolean isDocLitBare(OperationDescription op) {
        SOAPBinding.ParameterStyle methodParamStyle = op.getSoapBindingParameterStyle();
        if (methodParamStyle != null) {
            return methodParamStyle == SOAPBinding.ParameterStyle.BARE;
        }
        SOAPBinding.ParameterStyle SEIParamStyle = op.getEndpointInterfaceDescription().getSoapBindingParameterStyle();
        return SEIParamStyle == SOAPBinding.ParameterStyle.BARE;
    }

    protected static boolean isDocLitWrapped(OperationDescription op) {
        SOAPBinding.ParameterStyle methodParamStyle = op.getSoapBindingParameterStyle();
        if (methodParamStyle != null) {
            return methodParamStyle == SOAPBinding.ParameterStyle.WRAPPED;
        }
        SOAPBinding.ParameterStyle SEIParamStyle = op.getEndpointInterfaceDescription().getSoapBindingParameterStyle();
        return SEIParamStyle == SOAPBinding.ParameterStyle.WRAPPED;
    }

    protected static boolean isDocLitWrappedPlus(OperationDescription op) {
        if (MethodMarshallerFactory.isDocLitWrapped(op)) {
            if (MethodMarshallerFactory.isContextPathConstruction(op)) {
                return true;
            }
            if (op.isResultHeader()) {
                return true;
            }
            ParameterDescription[] pds = op.getParameterDescriptions();
            for (int i = 0; i < pds.length; ++i) {
                if (!pds[i].isHeader()) continue;
                return true;
            }
        }
        return false;
    }

    protected static boolean isDocLitBareMinimal(OperationDescription op) {
        return MethodMarshallerFactory.isDocLitBare(op) && !MethodMarshallerFactory.isContextPathConstruction(op);
    }

    private static boolean isContextPathConstruction(OperationDescription op) {
        ServiceDescription serviceDesc = op.getEndpointInterfaceDescription().getEndpointDescription().getServiceDescription();
        MarshalServiceRuntimeDescription marshalDesc = MarshalServiceRuntimeDescriptionFactory.get(serviceDesc);
        Holder holder = new Holder();
        try {
            JAXBContext context = JAXBUtils.getJAXBContext(marshalDesc.getPackages(), (Holder<JAXBUtils.CONSTRUCTION_TYPE>)holder, marshalDesc.getPackagesKey());
        }
        catch (JAXBException e) {
            throw ExceptionFactory.makeWebServiceException((Throwable)e);
        }
        return holder.value == JAXBUtils.CONSTRUCTION_TYPE.BY_CONTEXT_PATH;
    }

    protected static boolean isDocLitWrappedMinimal(OperationDescription op) {
        if (MethodMarshallerFactory.isDocLitWrapped(op)) {
            ServiceDescription serviceDesc = op.getEndpointInterfaceDescription().getEndpointDescription().getServiceDescription();
            MarshalServiceRuntimeDescription marshalDesc = MarshalServiceRuntimeDescriptionFactory.get(serviceDesc);
            String requestWrapper = marshalDesc.getRequestWrapperClassName(op);
            if (!MethodMarshallerFactory.exists(requestWrapper)) {
                return true;
            }
            String responseWrapper = marshalDesc.getRequestWrapperClassName(op);
            if (!MethodMarshallerFactory.exists(responseWrapper)) {
                return true;
            }
        }
        return false;
    }

    private static boolean exists(String className) {
        return className != null && className.length() != 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum SUBTYPE {
        NORMAL,
        PLUS,
        MINIMAL;

    }
}

