/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.message;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Protocol {
    soap11,
    soap12,
    rest,
    unknown;

    private static final Log log;
    private static final String SOAP11_WSDL_BINDING = "http://schemas.xmlsoap.org/wsdl/soap";
    private static final String SOAP12_WSDL_BINDING = "http://schemas.xmlsoap.org/wsdl/soap12";

    public static Protocol getProtocolForBinding(String url) {
        boolean debug = log.isDebugEnabled();
        if (debug) {
            log.debug((Object)("Configuring message protocol for binding [" + url + "]"));
        }
        if (Protocol.namespaceEquals(SOAP11_WSDL_BINDING, url) || Protocol.namespaceEquals("http://schemas.xmlsoap.org/wsdl/soap/http", url) || Protocol.namespaceEquals("http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true", url)) {
            if (debug) {
                log.debug((Object)"SOAP 1.1 protocol configured for message");
            }
            return soap11;
        }
        if (Protocol.namespaceEquals(SOAP12_WSDL_BINDING, url) || Protocol.namespaceEquals("http://www.w3.org/2003/05/soap/bindings/HTTP/", url) || Protocol.namespaceEquals("http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true", url)) {
            if (debug) {
                log.debug((Object)"SOAP 1.2 protocol configured for message");
            }
            return soap12;
        }
        if (Protocol.namespaceEquals("http://www.w3.org/2004/08/wsdl/http", url)) {
            if (debug) {
                log.debug((Object)"XML/HTTP protocol configured for message");
            }
            return rest;
        }
        if (debug) {
            log.debug((Object)("Protocol was not found for:" + url));
        }
        return null;
    }

    private static boolean namespaceEquals(String target, String input) {
        if (target.equals(input)) {
            return true;
        }
        return (target + "/").equals(input);
    }

    static {
        log = LogFactory.getLog(Protocol.class);
    }
}

