/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.message;

import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum XMLFaultCode {
    SENDER,
    RECEIVER,
    MUSTUNDERSTAND,
    DATAENCODINGUNKNOWN,
    VERSIONMISMATCH;


    public QName toQName(String namespace) {
        String localPart = null;
        if (namespace.equals("http://www.w3.org/2003/05/soap-envelope")) {
            switch (this) {
                case SENDER: {
                    localPart = "Sender";
                    break;
                }
                case RECEIVER: {
                    localPart = "Receiver";
                    break;
                }
                case MUSTUNDERSTAND: {
                    localPart = "MustUnderstand";
                    break;
                }
                case DATAENCODINGUNKNOWN: {
                    localPart = "DataEncodingUnknown";
                    break;
                }
                case VERSIONMISMATCH: {
                    localPart = "VersionMismatch";
                }
            }
        } else {
            switch (this) {
                case SENDER: {
                    localPart = "Client";
                    break;
                }
                case RECEIVER: {
                    localPart = "Server";
                    break;
                }
                case MUSTUNDERSTAND: {
                    localPart = "MustUnderstand";
                    break;
                }
                case DATAENCODINGUNKNOWN: {
                    localPart = "Server";
                    break;
                }
                case VERSIONMISMATCH: {
                    localPart = "VersionMismatch";
                }
            }
        }
        return new QName(namespace, localPart);
    }

    public static XMLFaultCode fromQName(QName qName) {
        if (qName == null) {
            return RECEIVER;
        }
        String namespace = qName.getNamespaceURI();
        String localPart = qName.getLocalPart();
        XMLFaultCode xmlFaultCode = RECEIVER;
        if (localPart.equalsIgnoreCase("Sender")) {
            xmlFaultCode = SENDER;
        } else if (localPart.equalsIgnoreCase("Receiver")) {
            xmlFaultCode = RECEIVER;
        } else if (localPart.equalsIgnoreCase("Client")) {
            xmlFaultCode = SENDER;
        } else if (localPart.equalsIgnoreCase("Server")) {
            xmlFaultCode = RECEIVER;
        } else if (localPart.equalsIgnoreCase("MustUnderstand")) {
            xmlFaultCode = MUSTUNDERSTAND;
        } else if (localPart.equalsIgnoreCase("DataEncodingUnknown")) {
            xmlFaultCode = DATAENCODINGUNKNOWN;
        } else if (localPart.equalsIgnoreCase("VersionMismatch")) {
            xmlFaultCode = VERSIONMISMATCH;
        }
        return xmlFaultCode;
    }
}

