/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.spi;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Iterator;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import javax.activation.DataSource;
import javax.xml.bind.JAXBContext;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.Source;
import javax.xml.ws.Dispatch;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.handler.HandlerResolver;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.java.security.AccessController;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.client.PropertyMigrator;
import org.apache.axis2.jaxws.client.dispatch.JAXBDispatch;
import org.apache.axis2.jaxws.client.dispatch.XMLDispatch;
import org.apache.axis2.jaxws.client.proxy.JAXWSProxyHandler;
import org.apache.axis2.jaxws.description.DescriptionFactory;
import org.apache.axis2.jaxws.description.EndpointDescription;
import org.apache.axis2.jaxws.description.ServiceDescription;
import org.apache.axis2.jaxws.description.ServiceDescriptionWSDL;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.axis2.jaxws.spi.BindingProvider;
import org.apache.axis2.jaxws.spi.JAXWSThreadFactory;
import org.apache.axis2.jaxws.spi.migrator.ApplicationContextMigratorUtil;
import org.apache.axis2.jaxws.util.WSDLWrapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceDelegate
extends javax.xml.ws.spi.ServiceDelegate {
    private static final Log log = LogFactory.getLog(ServiceDelegate.class);
    private Executor executor;
    private ServiceDescription serviceDescription;
    private QName serviceQname;
    private ServiceClient serviceClient = null;
    private HandlerResolver handlerResolver = null;

    public ServiceDelegate(URL url, QName qname, Class clazz) throws WebServiceException {
        this.serviceQname = qname;
        if (!this.isValidServiceName()) {
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"serviceDelegateConstruct0", (String)""));
        }
        this.serviceDescription = DescriptionFactory.createServiceDescription((URL)url, (QName)this.serviceQname, (Class)clazz);
        if (this.isValidWSDLLocation() && !this.isServiceDefined(this.serviceQname)) {
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"serviceDelegateConstruct0", (String)this.serviceQname.toString(), (String)url.toString()));
        }
        ApplicationContextMigratorUtil.addApplicationContextMigrator(this.serviceDescription.getAxisConfigContext(), "org.apache.axis2.jaxws.spi.ApplicationContextMigrators", new PropertyMigrator());
    }

    public void addPort(QName portName, String bindingId, String endpointAddress) throws WebServiceException {
        if (endpointAddress != null && endpointAddress.trim().length() == 0) {
            ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"addPortErr1", (String)(portName != null ? portName.getLocalPart() : ""), (String)endpointAddress));
        }
        EndpointDescription endpointDesc = DescriptionFactory.updateEndpoint((ServiceDescription)this.serviceDescription, null, (QName)portName, (DescriptionFactory.UpdateType)DescriptionFactory.UpdateType.ADD_PORT);
        endpointDesc.setEndpointAddress(endpointAddress);
        endpointDesc.setClientBindingID(bindingId);
    }

    public <T> Dispatch<T> createDispatch(QName qname, Class<T> clazz, Service.Mode mode) throws WebServiceException {
        if (qname == null) {
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"createDispatchFail0"));
        }
        if (!this.isValidDispatchType(clazz)) {
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"dispatchInvalidType"));
        }
        EndpointDescription endpointDesc = DescriptionFactory.updateEndpoint((ServiceDescription)this.serviceDescription, null, (QName)qname, (DescriptionFactory.UpdateType)DescriptionFactory.UpdateType.CREATE_DISPATCH);
        if (endpointDesc == null) {
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"createDispatchFail2", (String)qname.toString()));
        }
        this.addBinding(endpointDesc.getClientBindingID());
        XMLDispatch dispatch = new XMLDispatch(this, endpointDesc);
        if (mode != null) {
            dispatch.setMode(mode);
        } else {
            dispatch.setMode(Service.Mode.PAYLOAD);
        }
        if (this.serviceClient == null) {
            this.serviceClient = this.getServiceClient(qname);
        }
        dispatch.setServiceClient(this.serviceClient);
        dispatch.setType(clazz);
        return dispatch;
    }

    public Dispatch<Object> createDispatch(QName qname, JAXBContext context, Service.Mode mode) {
        if (qname == null) {
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"createDispatchFail0"));
        }
        EndpointDescription endpointDesc = DescriptionFactory.updateEndpoint((ServiceDescription)this.serviceDescription, null, (QName)qname, (DescriptionFactory.UpdateType)DescriptionFactory.UpdateType.CREATE_DISPATCH);
        if (endpointDesc == null) {
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"createDispatchFail2", (String)qname.toString()));
        }
        this.addBinding(endpointDesc.getClientBindingID());
        JAXBDispatch dispatch = new JAXBDispatch(this, endpointDesc);
        if (mode != null) {
            dispatch.setMode(mode);
        } else {
            dispatch.setMode(Service.Mode.PAYLOAD);
        }
        if (this.serviceClient == null) {
            this.serviceClient = this.getServiceClient(qname);
        }
        dispatch.setJAXBContext(context);
        dispatch.setServiceClient(this.serviceClient);
        return dispatch;
    }

    public <T> T getPort(Class<T> sei) throws WebServiceException {
        return this.getPort(null, sei);
    }

    public <T> T getPort(QName portName, Class<T> sei) throws WebServiceException {
        if (!this.isValidWSDLLocation()) {
            // empty if block
        }
        if (sei == null) {
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"getPortInvalidSEI", (String)portName.toString(), (String)"null"));
        }
        EndpointDescription endpointDesc = DescriptionFactory.updateEndpoint((ServiceDescription)this.serviceDescription, sei, (QName)portName, (DescriptionFactory.UpdateType)DescriptionFactory.UpdateType.GET_PORT);
        if (endpointDesc == null) {
            throw ExceptionFactory.makeWebServiceException((String)("Unable to getPort for port QName " + portName.toString()));
        }
        JAXWSProxyHandler proxyHandler = new JAXWSProxyHandler(this, sei, endpointDesc);
        Class[] seiClazz = new Class[]{sei, BindingProvider.class};
        Object proxyClass = Proxy.newProxyInstance(ServiceDelegate.getClassLoader(sei), seiClazz, (InvocationHandler)proxyHandler);
        return sei.cast(proxyClass);
    }

    public Executor getExecutor() {
        if (this.executor == null) {
            this.executor = this.getDefaultExecutor();
        }
        return this.executor;
    }

    public HandlerResolver getHandlerResolver() {
        return this.handlerResolver;
    }

    public Iterator<QName> getPorts() {
        return this.getServiceDescription().getPorts().iterator();
    }

    public QName getServiceName() {
        return this.serviceQname;
    }

    public URL getWSDLDocumentLocation() {
        return ((ServiceDescriptionWSDL)this.serviceDescription).getWSDLLocation();
    }

    public void setExecutor(Executor e) {
        if (e == null) {
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"cannotSetExcutorToNull"));
        }
        this.executor = e;
    }

    public void setHandlerResolver(HandlerResolver handlerresolver) {
        this.handlerResolver = handlerresolver;
    }

    public ServiceDescription getServiceDescription() {
        return this.serviceDescription;
    }

    public ServiceClient getServiceClient(QName portQName) throws WebServiceException {
        return this.serviceDescription.getServiceClient(portQName);
    }

    private Executor getDefaultExecutor() {
        return Executors.newFixedThreadPool(20, new JAXWSThreadFactory());
    }

    private boolean isValidServiceName() {
        return this.serviceQname != null && !"".equals(this.serviceQname.toString().trim());
    }

    private boolean isValidWSDLLocation() {
        URL wsdlLocation = this.getWSDLDocumentLocation();
        return wsdlLocation != null && !"".equals(wsdlLocation.toString().trim());
    }

    private WSDLWrapper getWSDLWrapper() {
        return ((ServiceDescriptionWSDL)this.serviceDescription).getWSDLWrapper();
    }

    private boolean isServiceDefined(QName serviceName) {
        return this.getWSDLWrapper().getService(serviceName) != null;
    }

    private void addBinding(String bindingId) {
        if (bindingId != null) {
            if (bindingId.equals("http://schemas.xmlsoap.org/wsdl/soap/http")) {
                // empty if block
            }
            if (bindingId.equals("http://www.w3.org/2003/05/soap/bindings/HTTP/")) {
                // empty if block
            }
            if (bindingId.equals("http://www.w3.org/2004/08/wsdl/http")) {
                // empty if block
            }
        }
    }

    private boolean isValidDispatchType(Class clazz) {
        return clazz != null && (clazz == String.class || clazz == Source.class || clazz == DataSource.class || clazz == SOAPMessage.class);
    }

    private static ClassLoader getClassLoader(final Class cls) {
        ClassLoader cl = null;
        try {
            cl = (ClassLoader)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws ClassNotFoundException {
                    return cls.getClassLoader();
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Exception thrown from AccessController: " + e));
            }
            throw ExceptionFactory.makeWebServiceException((Throwable)e.getException());
        }
        return cl;
    }
}

