/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.utility;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.axis2.jaxws.utility.JavaUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConvertUtils {
    private static final Log log = LogFactory.getLog(ConvertUtils.class);

    public static boolean isConvertable(Object obj, Class dest) {
        Class<?> src = null;
        if (obj != null) {
            src = obj instanceof Class ? (Class<?>)obj : obj.getClass();
        }
        if (dest == null) {
            return false;
        }
        if (src == null) {
            return true;
        }
        if (dest.isAssignableFrom(src)) {
            return true;
        }
        if (JavaUtils.getWrapperClass(src) == dest) {
            return true;
        }
        if (JavaUtils.getWrapperClass((Class)dest) == src) {
            return true;
        }
        if ((Collection.class.isAssignableFrom(src) || src.isArray()) && (Collection.class.isAssignableFrom(dest) || dest.isArray())) {
            return true;
        }
        if (src == HashMap.class && dest == Hashtable.class) {
            return true;
        }
        if (Calendar.class.isAssignableFrom(src) && dest == Date.class) {
            return true;
        }
        if (src.isPrimitive()) {
            return ConvertUtils.isConvertable(JavaUtils.getWrapperClass(src), dest);
        }
        return false;
    }

    public static Object convert(Object arg, Class destClass) {
        if (destClass == null) {
            return arg;
        }
        if (arg != null && destClass.isAssignableFrom(arg.getClass())) {
            return arg;
        }
        if (log.isDebugEnabled()) {
            String clsName = "null";
            if (arg != null) {
                clsName = arg.getClass().getName();
            }
            log.debug((Object)("Converting an object of type " + clsName + " to an object of type " + destClass.getName()));
        }
        if (arg instanceof Calendar && destClass == Date.class) {
            return ((Calendar)arg).getTime();
        }
        if (arg instanceof HashMap && destClass == Hashtable.class) {
            return new Hashtable((HashMap)arg);
        }
        if (!(arg instanceof Collection || arg != null && arg.getClass().isArray())) {
            return arg;
        }
        if (arg == null) {
            return arg;
        }
        Object destValue = null;
        int length = 0;
        length = arg.getClass().isArray() ? Array.getLength(arg) : ((Collection)arg).size();
        if (destClass.isArray()) {
            if (destClass.getComponentType().isPrimitive()) {
                Object array = Array.newInstance(destClass.getComponentType(), length);
                if (arg.getClass().isArray()) {
                    for (int i = 0; i < length; ++i) {
                        Array.set(array, i, Array.get(arg, i));
                    }
                } else {
                    int idx = 0;
                    Iterator i = ((Collection)arg).iterator();
                    while (i.hasNext()) {
                        Array.set(array, idx++, i.next());
                    }
                }
                destValue = array;
            } else {
                Object[] array;
                try {
                    array = (Object[])Array.newInstance(destClass.getComponentType(), length);
                }
                catch (Exception e) {
                    return arg;
                }
                if (arg.getClass().isArray()) {
                    for (int i = 0; i < length; ++i) {
                        array[i] = ConvertUtils.convert(Array.get(arg, i), destClass.getComponentType());
                    }
                } else {
                    int idx = 0;
                    Iterator i = ((Collection)arg).iterator();
                    while (i.hasNext()) {
                        array[idx++] = ConvertUtils.convert(i.next(), destClass.getComponentType());
                    }
                }
                destValue = array;
            }
        } else if (Collection.class.isAssignableFrom(destClass)) {
            Collection newList = null;
            try {
                newList = destClass == Collection.class || destClass == List.class ? new ArrayList() : (destClass == Set.class ? new HashSet() : (Collection)destClass.newInstance());
            }
            catch (Exception e) {
                return arg;
            }
            if (arg.getClass().isArray()) {
                for (int j = 0; j < length; ++j) {
                    newList.add(Array.get(arg, j));
                }
            } else {
                Iterator j = ((Collection)arg).iterator();
                while (j.hasNext()) {
                    newList.add(j.next());
                }
            }
            destValue = newList;
        } else {
            destValue = arg;
        }
        return destValue;
    }
}

