/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.handler;

import java.util.List;
import javax.xml.ws.handler.Handler;
import org.apache.axis2.jaxws.core.MessageContext;
import org.apache.axis2.jaxws.description.EndpointDescription;
import org.apache.axis2.jaxws.handler.HandlerChainProcessor;
import org.apache.axis2.jaxws.message.Protocol;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HandlerInvokerUtils {
    public static boolean invokeInboundHandlers(MessageContext msgCtx, List<Handler> handlers, EndpointDescription endpointDesc, HandlerChainProcessor.MEP mep, boolean isOneWay) {
        String bindingProto = null;
        bindingProto = mep.equals((Object)HandlerChainProcessor.MEP.REQUEST) ? endpointDesc.getBindingType() : endpointDesc.getClientBindingID();
        Protocol proto = Protocol.getProtocolForBinding(bindingProto);
        HandlerChainProcessor processor = new HandlerChainProcessor(handlers, proto);
        boolean success = true;
        try {
            if (msgCtx.getMessage().isFault()) {
                processor.processFault(msgCtx, HandlerChainProcessor.Direction.IN);
            } else {
                success = processor.processChain(msgCtx, HandlerChainProcessor.Direction.IN, mep, !isOneWay);
            }
        }
        catch (RuntimeException re) {
            HandlerChainProcessor.convertToFaultMessage(msgCtx, re, proto);
            return false;
        }
        return success || !mep.equals((Object)HandlerChainProcessor.MEP.REQUEST);
    }

    public static boolean invokeOutboundHandlers(MessageContext msgCtx, List<Handler> handlers, EndpointDescription endpointDesc, HandlerChainProcessor.MEP mep, boolean isOneWay) {
        if (handlers == null) {
            return true;
        }
        String bindingProto = null;
        bindingProto = mep.equals((Object)HandlerChainProcessor.MEP.REQUEST) ? endpointDesc.getClientBindingID() : endpointDesc.getBindingType();
        Protocol proto = Protocol.getProtocolForBinding(bindingProto);
        HandlerChainProcessor processor = new HandlerChainProcessor(handlers, proto);
        boolean success = true;
        try {
            if (msgCtx.getMessage().isFault()) {
                processor.processFault(msgCtx, HandlerChainProcessor.Direction.OUT);
            } else {
                success = processor.processChain(msgCtx, HandlerChainProcessor.Direction.OUT, mep, !isOneWay);
            }
        }
        catch (RuntimeException re) {
            HandlerChainProcessor.convertToFaultMessage(msgCtx, re, proto);
            return false;
        }
        return success || !mep.equals((Object)HandlerChainProcessor.MEP.REQUEST);
    }
}

