/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.message.databinding.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.xml.bind.util.JAXBSource;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.ws.WebServiceException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.axis2.java.security.AccessController;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.axis2.jaxws.message.databinding.SourceBlock;
import org.apache.axis2.jaxws.message.factory.BlockFactory;
import org.apache.axis2.jaxws.message.impl.BlockImpl;
import org.apache.axis2.jaxws.message.util.Reader2Writer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SourceBlockImpl
extends BlockImpl
implements SourceBlock {
    private static final Log log = LogFactory.getLog(SourceBlockImpl.class);
    private static Class staxSource = null;

    SourceBlockImpl(Source busObject, QName qName, BlockFactory factory) throws WebServiceException {
        super(busObject, null, qName, factory);
        if (!(busObject instanceof DOMSource || busObject instanceof SAXSource || busObject instanceof StreamSource || busObject.getClass().equals(staxSource) || busObject instanceof JAXBSource)) {
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"SourceNotSupported", (String)busObject.getClass().getName()));
        }
    }

    public SourceBlockImpl(OMElement omElement, QName qName, BlockFactory factory) {
        super(omElement, (Object)null, qName, factory);
    }

    protected Object _getBOFromReader(XMLStreamReader reader, Object busContext) throws XMLStreamException {
        if (staxSource != null) {
            try {
                Constructor c = staxSource.getDeclaredConstructor(XMLStreamReader.class);
                return c.newInstance(reader);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        Reader2Writer r2w = new Reader2Writer(reader);
        String text = r2w.getAsString();
        StringReader sr = new StringReader(text);
        return new StreamSource(sr);
    }

    protected XMLStreamReader _getReaderFromBO(Object busObj, Object busContext) throws XMLStreamException, WebServiceException {
        try {
            if (busObj instanceof StreamSource) {
                XMLInputFactory f = StAXUtils.getXMLInputFactory();
                XMLStreamReader reader = f.createXMLStreamReader((Source)busObj);
                StAXUtils.releaseXMLInputFactory((XMLInputFactory)f);
                return reader;
            }
            return this._slow_getReaderFromSource((Source)busObj);
        }
        catch (Exception e) {
            String className = busObj == null ? "none" : busObj.getClass().getName();
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"SourceReadErr", (String)className), (Throwable)e);
        }
    }

    private XMLStreamReader _slow_getReaderFromSource(Source src) throws XMLStreamException {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(out);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.transform(src, result);
            ByteArrayInputStream bytes = new ByteArrayInputStream(out.toByteArray());
            return StAXUtils.createXMLStreamReader((InputStream)bytes);
        }
        catch (TransformerException e) {
            throw new XMLStreamException(e);
        }
    }

    protected void _outputFromBO(Object busObject, Object busContext, XMLStreamWriter writer) throws XMLStreamException, WebServiceException {
        XMLStreamReader reader = this._getReaderFromBO(busObject, busContext);
        this._outputFromReader(reader, writer);
    }

    protected Object _getBOFromBO(Object busObject, Object busContext, boolean consume) {
        if (consume) {
            return busObject;
        }
        throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"SourceMissingSupport", (String)busObject.getClass().getName()));
    }

    public boolean isElementData() {
        return false;
    }

    private static Class forName(final String className) throws ClassNotFoundException {
        Class cl = null;
        try {
            cl = (Class)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws ClassNotFoundException {
                    return Class.forName(className);
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Exception thrown from AccessController: " + e));
            }
            throw (ClassNotFoundException)e.getException();
        }
        return cl;
    }

    static {
        try {
            staxSource = SourceBlockImpl.forName("javax.xml.transform.stax.StAXSource");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

