/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.datasource;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.axiom.om.OMDataSourceExt;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.ds.OMDataSourceExtBase;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SourceDataSource
extends OMDataSourceExtBase {
    private static final Log log = LogFactory.getLog(SourceDataSource.class);
    Source data;

    public SourceDataSource(Source data) {
        this.data = data;
    }

    public void close() {
    }

    public OMDataSourceExt copy() {
        return null;
    }

    public Object getObject() {
        return this.data;
    }

    public XMLStreamReader getReader() throws XMLStreamException {
        try {
            String encoding = "utf-8";
            ByteArrayInputStream is = new ByteArrayInputStream(this.getXMLBytes(encoding));
            return StAXUtils.createXMLStreamReader((InputStream)is, (String)encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new XMLStreamException(e);
        }
    }

    public byte[] getXMLBytes(String encoding) throws UnsupportedEncodingException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Start getXMLBytes");
        }
        byte[] bytes = null;
        try {
            bytes = null;
            if (this.data instanceof StreamSource) {
                InputStream is = ((StreamSource)this.data).getInputStream();
                if (is != null) {
                    bytes = SourceDataSource.getBytesFromStream(is);
                }
            } else {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                StreamResult result = new StreamResult(out);
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                transformer.transform(this.data, result);
                bytes = out.toByteArray();
            }
        }
        catch (OMException e) {
            throw e;
        }
        catch (UnsupportedEncodingException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new OMException(e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"End getXMLBytes");
        }
        return bytes;
    }

    public boolean isDestructiveRead() {
        return false;
    }

    public boolean isDestructiveWrite() {
        return false;
    }

    private static byte[] getBytesFromStream(InputStream is) throws IOException {
        byte[] bytes = new byte[is.available()];
        is.read(bytes);
        return bytes;
    }
}

