/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.datasource.jaxb;

import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.PrivilegedAction;
import java.text.ParseException;
import java.util.TreeSet;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.attachment.AttachmentMarshaller;
import javax.xml.bind.attachment.AttachmentUnmarshaller;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.ws.Holder;
import javax.xml.ws.WebServiceException;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.impl.MTOMXMLStreamWriter;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.datasource.jaxb.JAXBAttachmentMarshaller;
import org.apache.axis2.datasource.jaxb.JAXBAttachmentUnmarshaller;
import org.apache.axis2.datasource.jaxb.XSDListUtils;
import org.apache.axis2.java.security.AccessController;
import org.apache.axis2.jaxws.message.databinding.JAXBUtils;
import org.apache.axis2.jaxws.message.util.XMLStreamWriterWithOS;
import org.apache.axis2.jaxws.utility.XMLRootElementUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXBDSContext {
    private static final Log log = LogFactory.getLog(JAXBDSContext.class);
    public static final boolean DEBUG_ENABLED = log.isDebugEnabled();
    private TreeSet<String> contextPackages;
    private String contextPackagesKey;
    private JAXBContext jaxbContext = null;
    private JAXBUtils.CONSTRUCTION_TYPE constructionType = JAXBUtils.CONSTRUCTION_TYPE.UNKNOWN;
    private MessageContext msgContext;
    private Class processType = null;
    private boolean isxmlList = false;

    public JAXBDSContext(TreeSet<String> packages, String packagesKey) {
        this.contextPackages = packages;
        this.contextPackagesKey = packagesKey;
    }

    public JAXBDSContext(TreeSet<String> packages) {
        this(packages, packages.toString());
    }

    public JAXBDSContext(String contextPackage) {
        this.contextPackages = new TreeSet();
        this.contextPackages.add(contextPackage);
        this.contextPackagesKey = this.contextPackages.toString();
    }

    public JAXBDSContext(JAXBContext jaxbContext) {
        this.jaxbContext = jaxbContext;
    }

    public TreeSet<String> getContextPackages() {
        return this.contextPackages;
    }

    public JAXBContext getJAXBContext() throws JAXBException {
        return this.getJAXBContext(null);
    }

    public JAXBContext getJAXBContext(ClassLoader cl) throws JAXBException {
        if (this.jaxbContext == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"A JAXBContext did not exist, creating a new one with the context packages.");
            }
            Holder constructType = new Holder();
            this.jaxbContext = JAXBUtils.getJAXBContext(this.contextPackages, (Holder<JAXBUtils.CONSTRUCTION_TYPE>)constructType, this.contextPackagesKey, cl);
            this.constructionType = (JAXBUtils.CONSTRUCTION_TYPE)((Object)constructType.value);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"Using an existing JAXBContext");
        }
        return this.jaxbContext;
    }

    public Class getProcessType() {
        return this.processType;
    }

    public void setProcessType(Class type) {
        this.processType = type;
    }

    public JAXBUtils.CONSTRUCTION_TYPE getConstructionType() {
        return this.constructionType;
    }

    public boolean isxmlList() {
        return this.isxmlList;
    }

    public void setIsxmlList(boolean isxmlList) {
        this.isxmlList = isxmlList;
    }

    public MessageContext getMessageContext() {
        return this.msgContext;
    }

    public void setMessageContext(MessageContext messageContext) {
        this.msgContext = messageContext;
    }

    public ClassLoader getClassLoader() {
        MessageContext context = this.getMessageContext();
        if (context != null) {
            return (ClassLoader)context.getProperty("CACHE_CLASSLOADER");
        }
        return null;
    }

    protected AttachmentMarshaller createAttachmentMarshaller(XMLStreamWriter writer) {
        return new JAXBAttachmentMarshaller(this.getMessageContext(), writer);
    }

    protected AttachmentUnmarshaller createAttachmentUnmarshaller() {
        return new JAXBAttachmentUnmarshaller(this.getMessageContext());
    }

    public Object unmarshal(XMLStreamReader reader) throws JAXBException {
        ClassLoader cl = this.getClassLoader();
        Unmarshaller u = JAXBUtils.getJAXBUnmarshaller(this.getJAXBContext(cl));
        AttachmentUnmarshaller aum = this.createAttachmentUnmarshaller();
        if (aum != null) {
            if (DEBUG_ENABLED) {
                log.debug((Object)"Adding JAXBAttachmentUnmarshaller to Unmarshaller");
            }
            u.setAttachmentUnmarshaller(aum);
        }
        Object jaxb = null;
        jaxb = this.getProcessType() == null ? JAXBDSContext.unmarshalByElement(u, reader) : JAXBDSContext.unmarshalByType(u, reader, this.getProcessType(), this.isxmlList(), this.getConstructionType());
        JAXBUtils.releaseJAXBUnmarshaller(this.getJAXBContext(cl), u);
        return jaxb;
    }

    public void marshal(Object obj, XMLStreamWriter writer) throws JAXBException {
        ClassLoader cl = this.getClassLoader();
        Marshaller m = JAXBUtils.getJAXBMarshaller(this.getJAXBContext(cl));
        AttachmentMarshaller am = this.createAttachmentMarshaller(writer);
        if (am != null) {
            if (DEBUG_ENABLED) {
                log.debug((Object)"Adding JAXBAttachmentMarshaller to Marshaller");
            }
            m.setAttachmentMarshaller(am);
        }
        if (this.getProcessType() == null) {
            JAXBDSContext.marshalByElement(obj, m, writer, !am.isXOPPackage());
        } else {
            JAXBDSContext.marshalByType(obj, m, writer, this.getProcessType(), this.isxmlList(), this.getConstructionType());
        }
        JAXBUtils.releaseJAXBMarshaller(this.getJAXBContext(cl), m);
    }

    private static void marshalByElement(final Object b, final Marshaller m, final XMLStreamWriter writer, final boolean optimize) {
        AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                try {
                    OutputStream os;
                    OutputStream outputStream = os = optimize ? JAXBDSContext.getOutputStream(writer) : null;
                    if (os != null) {
                        if (DEBUG_ENABLED) {
                            log.debug((Object)("Invoking marshalByElement.  Marshaling to an OutputStream. Object is " + JAXBDSContext.getDebugName(b)));
                        }
                        writer.flush();
                        m.marshal(b, os);
                    } else {
                        if (DEBUG_ENABLED) {
                            log.debug((Object)("Invoking marshalByElement.  Marshaling to an XMLStreamWriter. Object is " + JAXBDSContext.getDebugName(b)));
                        }
                        m.marshal(b, writer);
                    }
                }
                catch (OMException e) {
                    throw e;
                }
                catch (Throwable t) {
                    throw new OMException(t);
                }
                return null;
            }
        });
    }

    private static String getDebugName(Object o) {
        return o == null ? "null" : o.getClass().getCanonicalName();
    }

    private static OutputStream getOutputStream(XMLStreamWriter writer) throws XMLStreamException {
        if (writer.getClass() == MTOMXMLStreamWriter.class) {
            return ((MTOMXMLStreamWriter)writer).getOutputStream();
        }
        if (writer.getClass() == XMLStreamWriterWithOS.class) {
            return ((XMLStreamWriterWithOS)writer).getOutputStream();
        }
        return null;
    }

    public static Object unmarshalByType(final Unmarshaller u, final XMLStreamReader reader, final Class type, final boolean isList, final JAXBUtils.CONSTRUCTION_TYPE ctype) throws WebServiceException {
        if (DEBUG_ENABLED) {
            log.debug((Object)"Invoking unmarshalByType.");
        }
        return AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                try {
                    Object jaxb;
                    if (!isList) {
                        if (type.isArray()) {
                            jaxb = ctype == JAXBUtils.CONSTRUCTION_TYPE.BY_CONTEXT_PATH ? u.unmarshal(reader, type) : (ctype == JAXBUtils.CONSTRUCTION_TYPE.BY_CLASS_ARRAY ? JAXBDSContext.unmarshalArray(reader, u, type) : u.unmarshal(reader, type));
                        } else if (type.isEnum()) {
                            JAXBElement enumValue;
                            if (DEBUG_ENABLED) {
                                log.debug((Object)("unmarshalByType. Unmarshalling " + type.getName() + " as Enum"));
                            }
                            if ((enumValue = u.unmarshal(reader, String.class)) != null) {
                                Method m = type.getMethod("fromValue", String.class);
                                jaxb = m.invoke(null, enumValue.getValue());
                            } else {
                                jaxb = null;
                            }
                        } else {
                            jaxb = u.unmarshal(reader, type);
                        }
                    } else {
                        jaxb = JAXBDSContext.unmarshalAsListOrArray(reader, u, type);
                    }
                    return jaxb;
                }
                catch (OMException e) {
                    throw e;
                }
                catch (Throwable t) {
                    throw new OMException(t);
                }
            }
        });
    }

    private static Object unmarshalArray(XMLStreamReader reader, Unmarshaller u, Class type) throws Exception {
        JAXBElement jaxb = u.unmarshal(reader, String[].class);
        Object typeObj = JAXBDSContext.getTypeEnabledObject(jaxb);
        if (typeObj instanceof String[]) {
            String[] strArray = (String[])typeObj;
            Object obj = XSDListUtils.fromStringArray(strArray, type);
            QName qName = XMLRootElementUtil.getXmlRootElementQNameFromObject(jaxb);
            jaxb = new JAXBElement(qName, type, obj);
        }
        return jaxb;
    }

    public static Object unmarshalAsListOrArray(XMLStreamReader reader, Unmarshaller u, Class type) throws IllegalAccessException, ParseException, NoSuchMethodException, InstantiationException, DatatypeConfigurationException, InvocationTargetException, JAXBException {
        JAXBElement jaxb = u.unmarshal(reader, String.class);
        if (JAXBDSContext.getTypeEnabledObject(jaxb) instanceof String) {
            QName qName = XMLRootElementUtil.getXmlRootElementQNameFromObject(jaxb);
            Object obj = XSDListUtils.fromXSDListString((String)JAXBDSContext.getTypeEnabledObject(jaxb), type);
            return new JAXBElement(qName, type, obj);
        }
        return jaxb;
    }

    static Object getTypeEnabledObject(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof JAXBElement) {
            return ((JAXBElement)obj).getValue();
        }
        return obj;
    }

    private static void marshalByType(final Object b, final Marshaller m, final XMLStreamWriter writer, final Class type, final boolean isList, final JAXBUtils.CONSTRUCTION_TYPE ctype) throws WebServiceException {
        AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                try {
                    Object jbo = b;
                    if (isList) {
                        String text;
                        QName qName;
                        if (DEBUG_ENABLED) {
                            log.debug((Object)"marshalling type which is a List or Array");
                        }
                        if (ctype == JAXBUtils.CONSTRUCTION_TYPE.BY_CONTEXT_PATH) {
                            qName = XMLRootElementUtil.getXmlRootElementQNameFromObject(b);
                            text = XSDListUtils.toXSDListString(JAXBDSContext.getTypeEnabledObject(b));
                            if (DEBUG_ENABLED) {
                                log.debug((Object)("marshalling [context path approach] with xmllist text = " + text));
                            }
                            jbo = new JAXBElement(qName, String.class, (Object)text);
                        } else if (ctype == JAXBUtils.CONSTRUCTION_TYPE.BY_CLASS_ARRAY) {
                            qName = XMLRootElementUtil.getXmlRootElementQNameFromObject(b);
                            text = XSDListUtils.toXSDListString(JAXBDSContext.getTypeEnabledObject(b));
                            if (DEBUG_ENABLED) {
                                log.debug((Object)("marshalling [class array approach] with xmllist text = " + text));
                            }
                            jbo = new JAXBElement(qName, String.class, (Object)text);
                        }
                    }
                    if (type.isEnum() && b != null) {
                        if (DEBUG_ENABLED) {
                            log.debug((Object)("marshalByType. Marshaling " + type.getName() + " as Enum"));
                        }
                        JAXBElement jbe = (JAXBElement)b;
                        String value = XMLRootElementUtil.getEnumValue((Enum)jbe.getValue());
                        jbo = new JAXBElement(jbe.getName(), String.class, (Object)value);
                    }
                    if (DEBUG_ENABLED) {
                        log.debug((Object)("Invoking marshalByType.  Marshaling to an XMLStreamWriter. Object is " + JAXBDSContext.getDebugName(b)));
                    }
                    m.marshal(jbo, writer);
                }
                catch (OMException e) {
                    throw e;
                }
                catch (Throwable t) {
                    throw new OMException(t);
                }
                return null;
            }
        });
    }

    public static Object unmarshalByElement(final Unmarshaller u, final XMLStreamReader reader) throws WebServiceException {
        try {
            if (DEBUG_ENABLED) {
                log.debug((Object)"Invoking unMarshalByElement");
            }
            return AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                public Object run() {
                    try {
                        return u.unmarshal(reader);
                    }
                    catch (OMException e) {
                        throw e;
                    }
                    catch (Throwable t) {
                        throw new OMException(t);
                    }
                }
            });
        }
        catch (OMException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new OMException(t);
        }
    }
}

